/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.internal.measurement.zzaa;
import com.google.android.gms.internal.measurement.zzek;
import com.google.android.gms.internal.measurement.zzem;
import com.google.android.gms.internal.measurement.zzer;
import com.google.android.gms.internal.measurement.zzet;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.internal.measurement.zzfp;
import com.google.android.gms.internal.measurement.zzfr;
import com.google.android.gms.internal.measurement.zzfs;
import com.google.android.gms.internal.measurement.zzft;
import com.google.android.gms.internal.measurement.zzfw;
import com.google.android.gms.internal.measurement.zzfx;
import com.google.android.gms.internal.measurement.zzgb;
import com.google.android.gms.internal.measurement.zzgc;
import com.google.android.gms.internal.measurement.zzgd;
import com.google.android.gms.internal.measurement.zzgi;
import com.google.android.gms.internal.measurement.zzgk;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzgm;
import com.google.android.gms.internal.measurement.zzkn;
import com.google.android.gms.internal.measurement.zzll;
import com.google.android.gms.internal.measurement.zzmh;
import com.google.android.gms.internal.measurement.zzpz;
import com.google.android.gms.internal.measurement.zzqu;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzeg;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzku;
import com.google.android.gms.measurement.internal.zzlh;
import com.google.android.gms.measurement.internal.zzlp;
import com.google.android.gms.measurement.internal.zzq;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public final class zzlj
extends zzku {
    static int zza(zzgc zzgc2, String string) {
        for (int i = 0; i < zzgc2.zzb(); ++i) {
            if (!string.equals(zzgc2.zzap(i).zzf())) continue;
            return i;
        }
        return -1;
    }

    final long zzd(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return 0L;
        }
        return this.zzf(string.getBytes(Charset.forName("UTF-8")));
    }

    @WorkerThread
    final long zzf(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        this.zzt.zzv().zzg();
        MessageDigest messageDigest = zzlp.zzF();
        if (messageDigest == null) {
            this.zzt.zzaA().zzd().zza("Failed to get MD5");
            return 0L;
        }
        return zzlp.zzp((byte[])messageDigest.digest(byArray));
    }

    final Bundle zzh(Map map, boolean bl) {
        Bundle bundle = new Bundle();
        for (String string : map.keySet()) {
            Object v = map.get(string);
            if (v == null) {
                bundle.putString(string, null);
                continue;
            }
            if (v instanceof Long) {
                bundle.putLong(string, ((Long)v).longValue());
                continue;
            }
            if (v instanceof Double) {
                bundle.putDouble(string, ((Double)v).doubleValue());
                continue;
            }
            if (v instanceof ArrayList) {
                if (!bl) continue;
                ArrayList arrayList = (ArrayList)v;
                ArrayList<Bundle> arrayList2 = new ArrayList<Bundle>();
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    arrayList2.add(this.zzh((Map)arrayList.get(i), false));
                }
                bundle.putParcelableArray(string, arrayList2.toArray(new Parcelable[0]));
                continue;
            }
            bundle.putString(string, v.toString());
        }
        return bundle;
    }

    final Parcelable zzi(byte[] byArray, Parcelable.Creator creator) {
        zzlj zzlj2;
        if (byArray == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcel.unmarshall(byArray, 0, byArray.length);
            parcel.setDataPosition(0);
            zzlj2 = (Parcelable)creator.createFromParcel(parcel);
        }
        catch (SafeParcelReader.ParseException parseException) {
            try {
                zzlj2 = zzlj2.zzt.zzaA();
                zzlj2.zzd().zza("Failed to load parcelable from buffer");
            }
            catch (Throwable throwable) {
                parcel.recycle();
                throw throwable;
            }
        }
        parcel.recycle();
        return zzlj2;
        parcel.recycle();
        return null;
    }

    final zzau zzj(zzaa zzaa2) {
        Object object;
        Bundle bundle = object2.zzh(zzaa2.zze(), true);
        Object object2 = "app";
        if (bundle.containsKey("_o") && (object = bundle.get("_o")) != null) {
            object2 = object.toString();
        }
        if ((object = zzhc.zzb((String)zzaa2.zzd())) == null) {
            object = zzaa2.zzd();
        }
        return new zzau((String)object, new zzas(bundle), (String)object2, zzaa2.zza());
    }

    final zzft zzl(zzap zzap2) {
        zzfs zzfs2 = zzft.zze();
        zzfs2.zzl(zzap2.zze);
        Object object = zzap2.zzf;
        zzar zzar2 = new zzar(object);
        while (zzar2.hasNext()) {
            object = zzar2.zza();
            zzfw zzfw2 = zzfx.zze();
            zzfw2.zzj((String)object);
            Object object2 = zzap2.zzf.zzf((String)object);
            Preconditions.checkNotNull((Object)object2);
            this.zzu(zzfw2, object2);
            zzfs2.zze(zzfw2);
        }
        return (zzft)zzfs2.zzaD();
    }

    static zzmh zzm(zzmh zzmh2, byte[] byArray) throws zzll {
        zzkn zzkn2 = zzkn.zza();
        if (zzkn2 != null) {
            return zzmh2.zzaz(byArray, zzkn2);
        }
        return zzmh2.zzay(byArray);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    final String zzo(zzgb var1_1) {
        if (var1_1 == null) {
            return "";
        }
        var2_2 = new StringBuilder();
        var2_2.append("\nbatch {\n");
        var3_3 = var1_1.zzd().iterator();
        block0: while (true) {
            if (!var3_3.hasNext()) {
                var2_2.append("}\n");
                return var2_2.toString();
            }
            var4_4 = (zzgd)var3_3.next();
            if (var4_4 == null) continue;
            zzlj.zzG(var2_2, 1);
            var2_2.append("bundle {\n");
            if (var4_4.zzbl()) {
                var1_1 = var4_4.zzd();
                zzlj.zzJ(var2_2, 1, "protocol_version", var1_1);
            }
            zzqu.zzc();
            if (this.zzt.zzf().zzs(var4_4.zzy(), zzeg.zzao) && var4_4.zzbo()) {
                var1_1 = var4_4.zzL();
                zzlj.zzJ(var2_2, 1, "session_stitching_token", var1_1);
            }
            var1_1 = var4_4.zzJ();
            zzlj.zzJ(var2_2, 1, "platform", var1_1);
            if (var4_4.zzbh()) {
                var1_1 = var4_4.zzm();
                zzlj.zzJ(var2_2, 1, "gmp_version", var1_1);
            }
            if (var4_4.zzbt()) {
                var1_1 = var4_4.zzs();
                zzlj.zzJ(var2_2, 1, "uploading_gmp_version", var1_1);
            }
            if (var4_4.zzbf()) {
                var1_1 = var4_4.zzj();
                zzlj.zzJ(var2_2, 1, "dynamite_version", var1_1);
            }
            if (var4_4.zzbc()) {
                var1_1 = var4_4.zzh();
                zzlj.zzJ(var2_2, 1, "config_version", var1_1);
            }
            var1_1 = var4_4.zzG();
            zzlj.zzJ(var2_2, 1, "gmp_app_id", var1_1);
            var1_1 = var4_4.zzx();
            zzlj.zzJ(var2_2, 1, "admob_app_id", var1_1);
            var1_1 = var4_4.zzy();
            zzlj.zzJ(var2_2, 1, "app_id", var1_1);
            var1_1 = var4_4.zzB();
            zzlj.zzJ(var2_2, 1, "app_version", var1_1);
            if (var4_4.zzba()) {
                var1_1 = var4_4.zza();
                zzlj.zzJ(var2_2, 1, "app_version_major", var1_1);
            }
            var1_1 = var4_4.zzF();
            zzlj.zzJ(var2_2, 1, "firebase_instance_id", var1_1);
            if (var4_4.zzbe()) {
                var1_1 = var4_4.zzi();
                zzlj.zzJ(var2_2, 1, "dev_cert_hash", var1_1);
            }
            var1_1 = var4_4.zzA();
            zzlj.zzJ(var2_2, 1, "app_store", var1_1);
            if (var4_4.zzbs()) {
                var1_1 = var4_4.zzr();
                zzlj.zzJ(var2_2, 1, "upload_timestamp_millis", var1_1);
            }
            if (var4_4.zzbp()) {
                var1_1 = var4_4.zzp();
                zzlj.zzJ(var2_2, 1, "start_timestamp_millis", var1_1);
            }
            if (var4_4.zzbg()) {
                var1_1 = var4_4.zzk();
                zzlj.zzJ(var2_2, 1, "end_timestamp_millis", var1_1);
            }
            if (var4_4.zzbk()) {
                var1_1 = var4_4.zzo();
                zzlj.zzJ(var2_2, 1, "previous_bundle_start_timestamp_millis", var1_1);
            }
            if (var4_4.zzbj()) {
                var1_1 = var4_4.zzn();
                zzlj.zzJ(var2_2, 1, "previous_bundle_end_timestamp_millis", var1_1);
            }
            var1_1 = var4_4.zzz();
            zzlj.zzJ(var2_2, 1, "app_instance_id", var1_1);
            var1_1 = var4_4.zzK();
            zzlj.zzJ(var2_2, 1, "resettable_device_id", var1_1);
            var1_1 = var4_4.zzE();
            zzlj.zzJ(var2_2, 1, "ds_id", var1_1);
            if (var4_4.zzbi()) {
                var1_1 = var4_4.zzaY();
                zzlj.zzJ(var2_2, 1, "limited_ad_tracking", var1_1);
            }
            var1_1 = var4_4.zzI();
            zzlj.zzJ(var2_2, 1, "os_version", var1_1);
            var1_1 = var4_4.zzD();
            zzlj.zzJ(var2_2, 1, "device_model", var1_1);
            var1_1 = var4_4.zzM();
            zzlj.zzJ(var2_2, 1, "user_default_language", var1_1);
            if (var4_4.zzbr()) {
                var1_1 = var4_4.zzf();
                zzlj.zzJ(var2_2, 1, "time_zone_offset_minutes", var1_1);
            }
            if (var4_4.zzbb()) {
                var1_1 = var4_4.zzb();
                zzlj.zzJ(var2_2, 1, "bundle_sequential_index", var1_1);
            }
            if (var4_4.zzbn()) {
                var1_1 = var4_4.zzaZ();
                zzlj.zzJ(var2_2, 1, "service_upload", var1_1);
            }
            var1_1 = var4_4.zzH();
            zzlj.zzJ(var2_2, 1, "health_monitor", var1_1);
            if (var4_4.zzbm()) {
                var1_1 = var4_4.zze();
                zzlj.zzJ(var2_2, 1, "retry_counter", var1_1);
            }
            if (var4_4.zzbd()) {
                var1_1 = var4_4.zzC();
                zzlj.zzJ(var2_2, 1, "consent_signals", var1_1);
            }
            zzpz.zzc();
            if (this.zzt.zzf().zzs(null, zzeg.zzaE) && var4_4.zzbq()) {
                var1_1 = var4_4.zzq();
                zzlj.zzJ(var2_2, 1, "target_os_version", var1_1);
            }
            if ((var1_1 = var4_4.zzP()) == null) ** GOTO lbl113
            var5_5 /* !! */  = var1_1.iterator();
            while (true) {
                block38: {
                    if (var5_5 /* !! */ .hasNext()) break block38;
lbl113:
                    // 2 sources

                    if ((var1_1 = var4_4.zzN()) != null) {
                        var1_1 = var1_1.iterator();
                        while (var1_1.hasNext()) {
                            var5_5 /* !! */  = (zzfp)var1_1.next();
                            if (var5_5 /* !! */  == null) continue;
                            zzlj.zzG(var2_2, 2);
                            var2_2.append("audience_membership {\n");
                            if (var5_5 /* !! */ .zzk()) {
                                var6_6 /* !! */  = Integer.valueOf(var5_5 /* !! */ .zza());
                                zzlj.zzJ(var2_2, 2, "audience_id", (Object)var6_6 /* !! */ );
                            }
                            if (var5_5 /* !! */ .zzm()) {
                                var6_6 /* !! */  = Boolean.valueOf(var5_5 /* !! */ .zzj());
                                zzlj.zzJ(var2_2, 2, "new_audience", (Object)var6_6 /* !! */ );
                            }
                            var6_6 /* !! */  = var5_5 /* !! */ .zzd();
                            zzlj.zzI(var2_2, 2, "current_data", (zzgi)var6_6 /* !! */ );
                            if (var5_5 /* !! */ .zzn()) {
                                var5_5 /* !! */  = var5_5 /* !! */ .zze();
                                zzlj.zzI(var2_2, 2, "previous_data", var5_5 /* !! */ );
                            }
                            zzlj.zzG(var2_2, 2);
                            var2_2.append("}\n");
                        }
                    }
                    if ((var1_1 = var4_4.zzO()) != null) {
                        var1_1 = var1_1.iterator();
                        while (var1_1.hasNext()) {
                            var4_4 = (zzft)var1_1.next();
                            if (var4_4 == null) continue;
                            zzlj.zzG(var2_2, 2);
                            var2_2.append("event {\n");
                            var5_5 /* !! */  = this.zzt.zzj().zzd(var4_4.zzh());
                            zzlj.zzJ(var2_2, 2, "name", var5_5 /* !! */ );
                            if (var4_4.zzu()) {
                                var5_5 /* !! */  = var4_4.zzd();
                                zzlj.zzJ(var2_2, 2, "timestamp_millis", var5_5 /* !! */ );
                            }
                            if (var4_4.zzt()) {
                                var5_5 /* !! */  = var4_4.zzc();
                                zzlj.zzJ(var2_2, 2, "previous_timestamp_millis", var5_5 /* !! */ );
                            }
                            if (var4_4.zzs()) {
                                var5_5 /* !! */  = var4_4.zza();
                                zzlj.zzJ(var2_2, 2, "count", var5_5 /* !! */ );
                            }
                            if (var4_4.zzb() != 0) {
                                this.zzE(var2_2, 2, var4_4.zzi());
                            }
                            zzlj.zzG(var2_2, 2);
                            var2_2.append("}\n");
                        }
                    }
                    zzlj.zzG(var2_2, 1);
                    var2_2.append("}\n");
                    continue block0;
                }
                var6_6 /* !! */  = (zzgm)var5_5 /* !! */ .next();
                if (var6_6 /* !! */  == null) continue;
                zzlj.zzG(var2_2, 2);
                var2_2.append("user_property {\n");
                var1_1 = var6_6 /* !! */ .zzs() != false ? Long.valueOf(var6_6 /* !! */ .zzc()) : null;
                zzlj.zzJ(var2_2, 2, "set_timestamp_millis", var1_1);
                var1_1 = this.zzt.zzj().zzf(var6_6 /* !! */ .zzf());
                zzlj.zzJ(var2_2, 2, "name", var1_1);
                var1_1 = var6_6 /* !! */ .zzg();
                zzlj.zzJ(var2_2, 2, "string_value", var1_1);
                var1_1 = var6_6 /* !! */ .zzr() != false ? Long.valueOf(var6_6 /* !! */ .zzb()) : null;
                zzlj.zzJ(var2_2, 2, "int_value", var1_1);
                var1_1 = var6_6 /* !! */ .zzq() != false ? Double.valueOf(var6_6 /* !! */ .zza()) : null;
                zzlj.zzJ(var2_2, 2, "double_value", var1_1);
                zzlj.zzG(var2_2, 2);
                var2_2.append("}\n");
            }
            break;
        }
    }

    final String zzp(zzek object) {
        Object object2;
        if (object == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nevent_filter {\n");
        if (((zzek)((Object)object)).zzp()) {
            object2 = ((zzek)((Object)object)).zzb();
            zzlj.zzJ(stringBuilder, 0, "filter_id", object2);
        }
        object2 = this.zzt.zzj().zzd(((zzek)((Object)object)).zzg());
        zzlj.zzJ(stringBuilder, 0, "event_name", object2);
        object2 = zzlj.zzH(((zzek)((Object)object)).zzk(), ((zzek)((Object)object)).zzm(), ((zzek)((Object)object)).zzn());
        if (!((String)object2).isEmpty()) {
            zzlj.zzJ(stringBuilder, 0, "filter_type", object2);
        }
        if (((zzek)((Object)object)).zzo()) {
            object2 = ((zzek)((Object)object)).zzf();
            zzlj.zzK(stringBuilder, 1, "event_count_filter", (zzer)((Object)object2));
        }
        if (((zzek)((Object)object)).zza() > 0) {
            stringBuilder.append("  filters {\n");
            object = ((zzek)((Object)object)).zzh().iterator();
            while (object.hasNext()) {
                this.zzF(stringBuilder, 2, (zzem)((Object)object.next()));
            }
        }
        zzlj.zzG(stringBuilder, 1);
        stringBuilder.append("}\n}\n");
        return stringBuilder.toString();
    }

    final String zzq(zzet zzet2) {
        Object object;
        if (zzet2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nproperty_filter {\n");
        if (zzet2.zzj()) {
            object = zzet2.zza();
            zzlj.zzJ(stringBuilder, 0, "filter_id", object);
        }
        object = this.zzt.zzj().zzf(zzet2.zze());
        zzlj.zzJ(stringBuilder, 0, "property_name", object);
        object = zzlj.zzH(zzet2.zzg(), zzet2.zzh(), zzet2.zzi());
        if (!((String)object).isEmpty()) {
            zzlj.zzJ(stringBuilder, 0, "filter_type", object);
        }
        this.zzF(stringBuilder, 1, zzet2.zzb());
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    final List zzr(List object, List object2) {
        ArrayList<Long> arrayList = new ArrayList<Long>((Collection<Long>)object);
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = (Integer)object.next();
            if ((Integer)object2 < 0) {
                this.zzt.zzaA().zzk().zzb("Ignoring negative bit index to be cleared", object2);
                continue;
            }
            int n = (Integer)object2 / 64;
            if (n >= arrayList.size()) {
                Integer n2 = arrayList.size();
                this.zzt.zzaA().zzk().zzc("Ignoring bit index greater than bitSet size", object2, (Object)n2);
                continue;
            }
            ArrayList<Long> arrayList2 = arrayList;
            int n3 = n;
            arrayList2.set(n3, (Long)arrayList2.get(n3) & (1L << (Integer)object2 % 64 ^ 0xFFFFFFFFFFFFFFFFL));
        }
        int n = arrayList.size();
        int n4 = arrayList.size() + -1;
        while (n4 >= 0 && (Long)arrayList.get(n4) == 0L) {
            n = n4;
            n4 += -1;
        }
        return arrayList.subList(0, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    static List zzs(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        int n2 = 0;
        block0: while (n2 < n) {
            long l = 0L;
            int n3 = 0;
            while (true) {
                int n4;
                int n5;
                if (n3 >= 64 || (n5 = n2 * 64 + n3) >= (n4 = bitSet.length())) {
                    arrayList.add(l);
                    ++n2;
                    continue block0;
                }
                long l2 = bitSet.get(n5) ? l | 1L << n3 : l;
                l = l2;
                ++n3;
            }
            break;
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    final Map zzt(Bundle bundle, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = bundle.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = bundle.get(string);
            boolean bl2 = object instanceof Parcelable[];
            if (bl2 || object instanceof ArrayList || object instanceof Bundle) {
                if (!bl) continue;
                ArrayList<Map> arrayList = new ArrayList<Map>();
                if (bl2) {
                    for (Parcelable parcelable : (Parcelable[])object) {
                        if (!(parcelable instanceof Bundle)) continue;
                        arrayList.add(this.zzt((Bundle)parcelable, false));
                    }
                } else if (object instanceof ArrayList) {
                    ArrayList arrayList2 = (ArrayList)object;
                    int n = arrayList2.size();
                    for (int i = 0; i < n; ++i) {
                        Object e = arrayList2.get(i);
                        if (!(e instanceof Bundle)) continue;
                        arrayList.add(this.zzt((Bundle)e, false));
                    }
                } else if (object instanceof Bundle) {
                    arrayList.add(this.zzt((Bundle)object, false));
                }
                hashMap.put(string, arrayList);
                continue;
            }
            if (object == null) continue;
            hashMap.put(string, object);
        }
        return hashMap;
    }

    zzlj(zzlh zzlh2) {
        super(zzlh2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzE(StringBuilder stringBuilder, int n, List iterator) {
        if (iterator == null) {
            return;
        }
        int n2 = n + 1;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            zzfx zzfx2 = (zzfx)((Object)iterator.next());
            if (zzfx2 == null) continue;
            zzlj.zzG(stringBuilder, n2);
            stringBuilder.append("param {\n");
            Object object = zzfx2.zzx() ? this.zzt.zzj().zze(zzfx2.zzg()) : null;
            zzlj.zzJ(stringBuilder, n2, "name", object);
            object = zzfx2.zzy() ? zzfx2.zzh() : null;
            zzlj.zzJ(stringBuilder, n2, "string_value", object);
            object = zzfx2.zzw() ? Long.valueOf(zzfx2.zzd()) : null;
            zzlj.zzJ(stringBuilder, n2, "int_value", object);
            object = zzfx2.zzu() ? Double.valueOf(zzfx2.zza()) : null;
            zzlj.zzJ(stringBuilder, n2, "double_value", object);
            if (zzfx2.zzc() > 0) {
                this.zzE(stringBuilder, n2, zzfx2.zzi());
            }
            zzlj.zzG(stringBuilder, n2);
            stringBuilder.append("}\n");
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzF(StringBuilder stringBuilder, int n, zzem zzem2) {
        Object object;
        if (zzem2 == null) {
            return;
        }
        zzlj.zzG(stringBuilder, n);
        stringBuilder.append("filter {\n");
        if (zzem2.zzh()) {
            Boolean bl = zzem2.zzg();
            zzlj.zzJ(stringBuilder, n, "complement", bl);
        }
        if (zzem2.zzj()) {
            object = ((zzgw)object).zzt.zzj().zze(zzem2.zze());
            zzlj.zzJ(stringBuilder, n, "param_name", object);
        }
        if (zzem2.zzk()) {
            int n2 = n + 1;
            zzey zzey2 = zzem2.zzd();
            if (zzey2 != null) {
                zzlj.zzG(stringBuilder, n2);
                stringBuilder.append("string_filter {\n");
                if (zzey2.zzi()) {
                    switch (zzey2.zzj()) {
                        default: {
                            object = "IN_LIST";
                            break;
                        }
                        case 1: {
                            object = "UNKNOWN_MATCH_TYPE";
                            break;
                        }
                        case 6: {
                            object = "EXACT";
                            break;
                        }
                        case 5: {
                            object = "PARTIAL";
                            break;
                        }
                        case 4: {
                            object = "ENDS_WITH";
                            break;
                        }
                        case 3: {
                            object = "BEGINS_WITH";
                            break;
                        }
                        case 2: {
                            object = "REGEXP";
                        }
                    }
                    zzlj.zzJ(stringBuilder, n2, "match_type", object);
                }
                if (zzey2.zzh()) {
                    object = zzey2.zzd();
                    zzlj.zzJ(stringBuilder, n2, "expression", object);
                }
                if (zzey2.zzg()) {
                    object = zzey2.zzf();
                    zzlj.zzJ(stringBuilder, n2, "case_sensitive", object);
                }
                if (zzey2.zza() > 0) {
                    zzlj.zzG(stringBuilder, n2 + 1);
                    stringBuilder.append("expression_list {\n");
                    object = zzey2.zze().iterator();
                    while (object.hasNext()) {
                        StringBuilder stringBuilder2 = stringBuilder;
                        zzlj.zzG(stringBuilder2, n2 + 2);
                        stringBuilder2.append((String)object.next());
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append("}\n");
                }
                zzlj.zzG(stringBuilder, n2);
                stringBuilder.append("}\n");
            }
        }
        if (zzem2.zzi()) {
            object = zzem2.zzc();
            zzlj.zzK(stringBuilder, n + 1, "number_filter", (zzer)((Object)object));
        }
        zzlj.zzG(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    /*
     * Unable to fully structure code
     */
    final void zzu(zzfw var1_2, Object var2_3) {
        block9: {
            Preconditions.checkNotNull((Object)var2_3);
            var1_2.zzg();
            var1_2.zze();
            var1_2.zzd();
            var1_2.zzf();
            if (var2_3 instanceof String) {
                var1_2.zzk((String)var2_3);
                return;
            }
            if (var2_3 instanceof Long) {
                var1_2.zzi((Long)var2_3);
                return;
            }
            if (var2_3 instanceof Double) {
                var1_2.zzh((Double)var2_3);
                return;
            }
            if (!(var2_3 instanceof Bundle[])) break block9;
            var2_3 = var2_3;
            var3_4 = new ArrayList<zzfx>();
            block0: for (Bundle var5_6 : var2_3) {
                if (var5_6 == null) lbl-1000:
                // 3 sources

                {
                    continue block0;
                }
                var6_7 = zzfx.zze();
                block2: for (Object var8_9 : var5_6.keySet()) {
                    block10: {
                        var9_10 = zzfx.zze();
                        var9_10.zzj((String)var8_9);
                        var8_9 = var5_6.get((String)var8_9);
                        if (var8_9 instanceof Long) {
                            var9_10.zzi((Long)var8_9);
lbl39:
                            // 3 sources

                            while (true) {
                                var6_7.zzc(var9_10);
                                continue block2;
                                break;
                            }
                        }
                        if (!(var8_9 instanceof String)) break block10;
                        var9_10.zzk((String)var8_9);
                        ** GOTO lbl39
                    }
                    if (!(var8_9 instanceof Double)) continue;
                    var9_10.zzh((Double)var8_9);
                    ** continue;
                }
                if (var6_7.zza() <= 0) ** GOTO lbl-1000
                var3_4.add((zzfx)var6_7.zzaD());
                ** continue;
            }
            var1_2.zzb(var3_4);
            return;
        }
        this.zzt.zzaA().zzd().zzb("Ignoring invalid (type) event param value", (Object)var2_3);
    }

    final void zzv(zzgl zzgl2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zzgl2.zzc();
        zzgl2.zzb();
        zzgl2.zza();
        if (object instanceof String) {
            zzgl2.zzh((String)object);
            return;
        }
        if (object instanceof Long) {
            zzgl2.zze((Long)object);
            return;
        }
        if (object instanceof Double) {
            zzgl2.zzd((Double)object);
            return;
        }
        this.zzt.zzaA().zzd().zzb("Ignoring invalid (type) user attribute value", object);
    }

    static boolean zzw(List list, int n) {
        return n < list.size() * 64 && ((Long)list.get(n / 64) & 1L << n % 64) != 0L;
    }

    final boolean zzx(long l, long l2) {
        return l == 0L || l2 <= 0L || Math.abs(this.zzt.zzax().currentTimeMillis() - l) > l2;
    }

    static boolean zzy(String string) {
        return string != null && string.matches("([+-])?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    @Override
    protected final boolean zzb() {
        return false;
    }

    final byte[] zzz(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            Object object = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            object.zzt.zzaA().zzd().zzb("Failed to gzip content", (Object)iOException);
            throw iOException;
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    static final void zzA(zzfs zzfs2, String string, Object object) {
        int n;
        Object object2;
        block4: {
            object2 = zzfs2.zzp();
            for (n = 0; n < object2.size(); ++n) {
                if (!string.equals(((zzfx)((Object)object2.get(n))).zzg())) {
                    continue;
                }
                break block4;
            }
            n = -1;
        }
        object2 = zzfx.zze();
        ((zzfw)((Object)object2)).zzj(string);
        if (object instanceof Long) {
            ((zzfw)((Object)object2)).zzi((Long)object);
        }
        if (n >= 0) {
            zzfs2.zzj(n, (zzfw)((Object)object2));
            return;
        }
        zzfs2.zze((zzfw)((Object)object2));
    }

    private static final void zzG(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    @WorkerThread
    static final boolean zzB(zzau zzau2, zzq zzq2) {
        Preconditions.checkNotNull((Object)zzau2);
        Preconditions.checkNotNull((Object)zzq2);
        return !TextUtils.isEmpty((CharSequence)zzq2.zzb) || !TextUtils.isEmpty((CharSequence)zzq2.zzq);
    }

    static final zzfx zzC(zzft object, String string) {
        for (zzfx zzfx2 : ((zzft)((Object)object)).zzi()) {
            if (!zzfx2.zzg().equals(string)) continue;
            return zzfx2;
        }
        return null;
    }

    private static final String zzH(boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("Dynamic ");
        }
        if (bl2) {
            stringBuilder.append("Sequence ");
        }
        if (bl3) {
            stringBuilder.append("Session-Scoped ");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final void zzI(StringBuilder stringBuilder, int n, String iterator, zzgi object) {
        void var5_27;
        Object object2;
        Iterator iterator2;
        Object object3;
        if (object3 == null) {
            return;
        }
        zzlj.zzG(stringBuilder, 3);
        stringBuilder.append((String)((Object)iterator2));
        stringBuilder.append(" {\n");
        if (((zzgi)((Object)object3)).zzb() != 0) {
            zzlj.zzG(stringBuilder, 4);
            stringBuilder.append("results: ");
            iterator2 = ((zzgi)((Object)object3)).zzi().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                void var1_3;
                object2 = (Long)iterator2.next();
                var5_27 = var1_3 + true;
                if (var1_3 != false) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object2);
                var1_3 = var5_27;
            }
            stringBuilder.append('\n');
        }
        if (((zzgi)((Object)object3)).zzd() != 0) {
            zzlj.zzG(stringBuilder, 4);
            stringBuilder.append("status: ");
            iterator2 = ((zzgi)((Object)object3)).zzk().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                void var1_5;
                object2 = (Long)iterator2.next();
                var5_27 = var1_5 + true;
                if (var1_5 != false) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object2);
                var1_5 = var5_27;
            }
            stringBuilder.append('\n');
        }
        if (((zzgi)((Object)object3)).zza() != 0) {
            zzlj.zzG(stringBuilder, 4);
            stringBuilder.append("dynamic_filter_timestamps: {");
            iterator2 = ((zzgi)((Object)object3)).zzh().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                void var1_11;
                void var1_9;
                void var1_7;
                object2 = (zzfr)((Object)iterator2.next());
                var5_27 = var1_7 + true;
                if (var1_7 != false) {
                    stringBuilder.append(", ");
                }
                if (((zzfr)((Object)object2)).zzh()) {
                    Integer n2 = ((zzfr)((Object)object2)).zza();
                } else {
                    Object var1_14 = null;
                }
                stringBuilder.append(var1_9);
                stringBuilder.append(":");
                if (((zzfr)((Object)object2)).zzg()) {
                    Long l = ((zzfr)((Object)object2)).zzb();
                } else {
                    Object var1_13 = null;
                }
                stringBuilder.append(var1_11);
                void var1_12 = var5_27;
            }
            stringBuilder.append("}\n");
        }
        if (((zzgi)((Object)object3)).zzc() != 0) {
            zzlj.zzG(stringBuilder, 4);
            stringBuilder.append("sequence_filter_timestamps: {");
            iterator2 = ((zzgi)((Object)object3)).zzj().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                void var1_18;
                void var1_16;
                object3 = (zzgk)((Object)iterator2.next());
                void var4_26 = var1_16 + true;
                if (var1_16 != false) {
                    stringBuilder.append(", ");
                }
                if (((zzgk)((Object)object3)).zzi()) {
                    Integer n3 = ((zzgk)((Object)object3)).zzb();
                } else {
                    Object var1_22 = null;
                }
                stringBuilder.append(var1_18);
                stringBuilder.append(": [");
                object3 = ((zzgk)((Object)object3)).zzf().iterator();
                boolean bl2 = false;
                while (object3.hasNext()) {
                    void var1_20;
                    long l = (Long)object3.next();
                    var5_27 = var1_20 + true;
                    if (var1_20 != false) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(l);
                    var1_20 = var5_27;
                }
                stringBuilder.append("]");
                void var1_21 = var4_26;
            }
            stringBuilder.append("}\n");
        }
        zzlj.zzG(stringBuilder, 3);
        stringBuilder.append("}\n");
    }

    private static final void zzJ(StringBuilder stringBuilder, int n, String string, Object object) {
        if (object == null) {
            return;
        }
        zzlj.zzG(stringBuilder, n + 1);
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }

    static final Object zzD(zzft object, String object2) {
        if ((object = zzlj.zzC((zzft)((Object)object), (String)object2)) != null) {
            if (((zzfx)((Object)object)).zzy()) {
                return ((zzfx)((Object)object)).zzh();
            }
            if (((zzfx)((Object)object)).zzw()) {
                return ((zzfx)((Object)object)).zzd();
            }
            if (((zzfx)((Object)object)).zzu()) {
                return ((zzfx)((Object)object)).zza();
            }
            if (((zzfx)((Object)object)).zzc() > 0) {
                List list = ((zzfx)((Object)object)).zzi();
                object = new ArrayList();
                for (Object object3 : list) {
                    if (object3 == null) continue;
                    Bundle bundle = new Bundle();
                    object3 = object3.zzi().iterator();
                    while (object3.hasNext()) {
                        zzfx zzfx2 = (zzfx)((Object)object3.next());
                        if (zzfx2.zzy()) {
                            bundle.putString(zzfx2.zzg(), zzfx2.zzh());
                            continue;
                        }
                        if (zzfx2.zzw()) {
                            bundle.putLong(zzfx2.zzg(), zzfx2.zzd());
                            continue;
                        }
                        if (!zzfx2.zzu()) continue;
                        bundle.putDouble(zzfx2.zzg(), zzfx2.zza());
                    }
                    if (bundle.isEmpty()) continue;
                    object.add(bundle);
                }
                Object object4 = object;
                return object4.toArray(new Bundle[object4.size()]);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void zzK(StringBuilder stringBuilder, int n, String object, zzer zzer2) {
        if (zzer2 == null) {
            return;
        }
        zzlj.zzG(stringBuilder, n);
        stringBuilder.append((String)object);
        stringBuilder.append(" {\n");
        if (zzer2.zzg()) {
            switch (zzer2.zzm()) {
                default: {
                    object = "BETWEEN";
                    break;
                }
                case 1: {
                    object = "UNKNOWN_COMPARISON_TYPE";
                    break;
                }
                case 4: {
                    object = "EQUAL";
                    break;
                }
                case 3: {
                    object = "GREATER_THAN";
                    break;
                }
                case 2: {
                    object = "LESS_THAN";
                }
            }
            zzlj.zzJ(stringBuilder, n, "comparison_type", object);
        }
        if (zzer2.zzi()) {
            object = zzer2.zzf();
            zzlj.zzJ(stringBuilder, n, "match_as_float", object);
        }
        if (zzer2.zzh()) {
            object = zzer2.zzc();
            zzlj.zzJ(stringBuilder, n, "comparison_value", object);
        }
        if (zzer2.zzk()) {
            object = zzer2.zze();
            zzlj.zzJ(stringBuilder, n, "min_comparison_value", object);
        }
        if (zzer2.zzj()) {
            object = zzer2.zzd();
            zzlj.zzJ(stringBuilder, n, "max_comparison_value", object);
        }
        zzlj.zzG(stringBuilder, n);
        stringBuilder.append("}\n");
    }
}

