/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.internal.measurement.zzad;
import com.google.android.gms.internal.measurement.zzb;
import com.google.android.gms.internal.measurement.zzc;
import com.google.android.gms.internal.measurement.zzns;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzbe;
import com.google.android.gms.measurement.internal.zzfh;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzhg;
import com.google.android.gms.measurement.internal.zzhi;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzhk;
import com.google.android.gms.measurement.internal.zzhl;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzhn;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzhp;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zzhr;
import com.google.android.gms.measurement.internal.zzhs;
import com.google.android.gms.measurement.internal.zzht;
import com.google.android.gms.measurement.internal.zzhu;
import com.google.android.gms.measurement.internal.zzhv;
import com.google.android.gms.measurement.internal.zzhw;
import com.google.android.gms.measurement.internal.zzhx;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzhz;
import com.google.android.gms.measurement.internal.zzig;
import com.google.android.gms.measurement.internal.zzmh;
import com.google.android.gms.measurement.internal.zzmo;
import com.google.android.gms.measurement.internal.zzmp;
import com.google.android.gms.measurement.internal.zzmz;
import com.google.android.gms.measurement.internal.zznb;
import com.google.android.gms.measurement.internal.zznd;
import com.google.android.gms.measurement.internal.zzng;
import com.google.android.gms.measurement.internal.zzo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzhh
extends zzfh {
    private final zzmp zza;
    private Boolean zzb;
    private @Nullable String zzc;

    @BinderThread
    public final zzaj zza(zzo zzo2) {
        this.zzb(zzo2, false);
        Preconditions.checkNotEmpty((String)zzo2.zza);
        if (zzns.zza()) {
            Future future = this.zza.zzl().zzb((Callable)new zzhs(this, zzo2));
            try {
                return (zzaj)future.get(10000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                this.zza.zzj().zzg().zza("Failed to get consent. appId", zzfp.zza((String)zzo2.zza), (Object)exception);
                return new zzaj(null);
            }
        }
        return new zzaj(null);
    }

    @VisibleForTesting
    final zzbe zzb(zzbe zzbe2, zzo zzo2) {
        String string;
        zzbe zzbe3 = zzbe2;
        if (!"_cmp".equals(zzbe3.zza) || zzbe3.zzb == null || zzbe3.zzb.zza() == 0 ? false : "referrer broadcast".equals(string = zzbe3.zzb.zzd("_cis")) || "referrer API".equals(string)) {
            this.zza.zzj().zzn().zza("Event has been filtered ", (Object)zzbe2.toString());
            return new zzbe("_cmpx", zzbe2.zzb, zzbe2.zzc, zzbe2.zzd);
        }
        return zzbe2;
    }

    static /* bridge */ /* synthetic */ zzmp zza(zzhh zzhh2) {
        return zzhh2.zza;
    }

    @BinderThread
    public final @Nullable String zzb(zzo zzo2) {
        this.zzb(zzo2, false);
        return this.zza.zzb(zzo2);
    }

    @BinderThread
    public final List<zzmh> zza(zzo zzo2, Bundle bundle) {
        this.zzb(zzo2, false);
        Preconditions.checkNotNull((Object)zzo2.zza);
        Future future = this.zza.zzl().zza((Callable)new zzhz(this, zzo2, bundle));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get trigger URIs. appId", zzfp.zza((String)zzo2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final @Nullable List<zznb> zza(zzo zzo2, boolean bl) {
        this.zzb(zzo2, false);
        String string = zzo2.zza;
        Preconditions.checkNotNull((Object)string);
        Future future = this.zza.zzl().zza((Callable)new zzhy(this, string));
        try {
            List list = (List)future.get();
            ArrayList<zznb> arrayList = new ArrayList<zznb>(list.size());
            for (zznd zznd2 : list) {
                if (!bl && zzng.zzg((String)zznd2.zzc)) continue;
                arrayList.add(new zznb(zznd2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get user properties. appId", zzfp.zza((String)zzo2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final List<zzae> zza(@Nullable String string, @Nullable String string2, zzo zzo2) {
        this.zzb(zzo2, false);
        String string3 = zzo2.zza;
        Preconditions.checkNotNull((Object)string3);
        Future future = this.zza.zzl().zza((Callable)new zzho(this, string3, string, string2));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzae> zza(String string, @Nullable String string2, @Nullable String string3) {
        this.zza(string, true);
        Future future = this.zza.zzl().zza((Callable)new zzhr(this, string, string2, string3));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get conditional user properties as", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zznb> zza(@Nullable String string, @Nullable String string2, boolean bl, zzo zzo2) {
        this.zzb(zzo2, false);
        String string3 = zzo2.zza;
        Preconditions.checkNotNull((Object)string3);
        Future future = this.zza.zzl().zza((Callable)new zzhm(this, string3, string, string2));
        try {
            List list = (List)future.get();
            ArrayList<zznb> arrayList = new ArrayList<zznb>(list.size());
            for (zznd zznd2 : list) {
                if (!bl && zzng.zzg((String)zznd2.zzc)) continue;
                arrayList.add(new zznb(zznd2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to query user properties. appId", zzfp.zza((String)zzo2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zznb> zza(String string, @Nullable String string2, @Nullable String string3, boolean bl) {
        this.zza(string, true);
        Future future = this.zza.zzl().zza((Callable)new zzhp(this, string, string2, string3));
        try {
            List list = (List)future.get();
            ArrayList<zznb> arrayList = new ArrayList<zznb>(list.size());
            for (zznd zznd2 : list) {
                if (!bl && zzng.zzg((String)zznd2.zzc)) continue;
                arrayList.add(new zznb(zznd2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get user properties as. appId", zzfp.zza((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    public zzhh(zzmp zzmp2) {
        this(zzmp2, null);
    }

    private zzhh(zzmp zzmp2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zzmp2);
        this.zza = zzmp2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzc(zzo zzo2) {
        this.zzb(zzo2, false);
        this.zza(new zzhi(this, zzo2));
    }

    @BinderThread
    private final void zzb(zzo zzo2, boolean bl) {
        Preconditions.checkNotNull((Object)zzo2);
        Preconditions.checkNotEmpty((String)zzo2.zza);
        this.zza(zzo2.zza, false);
        this.zza.zzq().zza(zzo2.zzb, zzo2.zzp);
    }

    @BinderThread
    private final void zza(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zza.zzj().zzg().zza("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzhh zzhh2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzhh2 = this;
                    if (!bl2) break block9;
                    if (zzhh2.zzb == null) {
                        zzhh2.zzb = "com.google.android.gms".equals(zzhh2.zzc) || UidVerifier.isGooglePlayServicesUid((Context)zzhh2.zza.zza(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzhh2.zza.zza()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzhh2.zzb.booleanValue()) break block10;
                }
                if (zzhh2.zzc == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzhh2.zza.zza(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzhh2.zzc = string2;
                }
                if (!string2.equals(zzhh2.zzc)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zza.zzj().zzg().zza("Measurement Service called with invalid calling package. appId", zzfp.zza((String)string));
            throw securityException;
        }
    }

    final void zzc(zzbe zzbe2, zzo zzo2) {
        if (!this.zza.zzi().zzl(zzo2.zza)) {
            this.zzd(zzbe2, zzo2);
            return;
        }
        this.zza.zzj().zzp().zza("EES config found for", (Object)zzo2.zza);
        String string = zzo2.zza;
        zzmo zzmo2 = this.zza.zzi();
        zzb zzb2 = TextUtils.isEmpty((CharSequence)string) ? null : (zzb)((zzgn)zzmo2).zza.get((Object)string);
        if (zzb2 == null) {
            this.zza.zzj().zzp().zza("EES not loaded for", (Object)zzo2.zza);
            this.zzd(zzbe2, zzo2);
            return;
        }
        boolean bl = false;
        try {
            string = zzbe2;
            zzmo2 = this.zza.zzp();
            Bundle bundle = ((zzbe)string).zzb.zzb();
            Map<String, Object> map = ((zzmz)zzmo2).zza(bundle, true);
            String string2 = zzig.zza((String)((zzbe)string).zza);
            if (string2 == null) {
                string2 = ((zzbe)string).zza;
            }
            bl = zzb2.zza(new zzad(string2, ((zzbe)string).zzd, map));
        }
        catch (zzc zzc2) {
            this.zza.zzj().zzg().zza("EES error. appId, eventName", (Object)zzo2.zzb, (Object)zzbe2.zza);
        }
        if (!bl) {
            this.zza.zzj().zzp().zza("EES was not applied to event", (Object)zzbe2.zza);
            this.zzd(zzbe2, zzo2);
            return;
        }
        if (zzb2.zzd()) {
            this.zza.zzj().zzp().zza("EES edited event", (Object)zzbe2.zza);
            this.zzd(this.zza.zzp().zza(zzb2.zza().zzb()), zzo2);
        } else {
            this.zzd(zzbe2, zzo2);
        }
        if (zzb2.zzc()) {
            for (zzad zzad2 : zzb2.zza().zzc()) {
                this.zza.zzj().zzp().zza("EES logging created event", (Object)zzad2.zzb());
                this.zzd(this.zza.zzp().zza(zzad2), zzo2);
            }
        }
    }

    final /* synthetic */ void zza(String string, Bundle bundle) {
        this.zza.zzf().zza(string, bundle);
    }

    @BinderThread
    public final void zza(zzbe zzbe2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzbe2);
        this.zzb(zzo2, false);
        this.zza(new zzhv(this, zzbe2, zzo2));
    }

    @BinderThread
    public final void zza(zzbe zzbe2, String string, @Nullable String string2) {
        Preconditions.checkNotNull((Object)zzbe2);
        Preconditions.checkNotEmpty((String)string);
        this.zza(string, true);
        this.zza(new zzhu(this, zzbe2, string));
    }

    private final void zzd(zzbe zzbe2, zzo zzo2) {
        this.zza.zzr();
        this.zza.zza(zzbe2, zzo2);
    }

    @BinderThread
    public final void zzd(zzo zzo2) {
        Preconditions.checkNotEmpty((String)zzo2.zza);
        this.zza(zzo2.zza, false);
        this.zza(new zzhq(this, zzo2));
    }

    @VisibleForTesting
    private final void zza(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzl().zzg()) {
            runnable.run();
            return;
        }
        this.zza.zzl().zzb(runnable);
    }

    @BinderThread
    public final void zza(zzae zzae2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzae2);
        Preconditions.checkNotNull((Object)zzae2.zzc);
        this.zzb(zzo2, false);
        zzae zzae3 = new zzae(zzae2);
        new zzae(zzae2).zza = zzo2.zza;
        this.zza(new zzhk(this, zzae3, zzo2));
    }

    @BinderThread
    public final void zza(zzae zzae2) {
        Preconditions.checkNotNull((Object)zzae2);
        Preconditions.checkNotNull((Object)zzae2.zzc);
        Preconditions.checkNotEmpty((String)zzae2.zza);
        this.zza(zzae2.zza, true);
        zzae zzae3 = new zzae(zzae2);
        this.zza(new zzhn(this, zzae3));
    }

    @BinderThread
    public final void zze(zzo zzo2) {
        Preconditions.checkNotEmpty((String)zzo2.zza);
        Preconditions.checkNotNull((Object)zzo2.zzt);
        zzht zzht2 = new zzht(this, zzo2);
        zzhh zzhh2 = this;
        Preconditions.checkNotNull((Object)zzht2);
        if (zzhh2.zza.zzl().zzg()) {
            zzht2.run();
            return;
        }
        zzhh2.zza.zzl().zzc((Runnable)zzht2);
    }

    @BinderThread
    public final void zza(long l, @Nullable String string, @Nullable String string2, String string3) {
        this.zza(new zzhl(this, string2, string3, string, l));
    }

    @BinderThread
    public final void zza(Bundle bundle, zzo zzo2) {
        this.zzb(zzo2, false);
        String string = zzo2.zza;
        Preconditions.checkNotNull((Object)string);
        Bundle bundle2 = bundle;
        String string2 = string;
        zzhh zzhh2 = this;
        this.zza(new zzhg(zzhh2, string2, bundle2));
    }

    @BinderThread
    public final void zzf(zzo zzo2) {
        this.zzb(zzo2, false);
        this.zza(new zzhj(this, zzo2));
    }

    @BinderThread
    public final void zza(zznb zznb2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zznb2);
        this.zzb(zzo2, false);
        this.zza(new zzhw(this, zznb2, zzo2));
    }

    @BinderThread
    public final byte @Nullable [] zza(zzbe zzbe2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzbe2);
        this.zza(string, true);
        this.zza.zzj().zzc().zza("Log and bundle. event", (Object)this.zza.zzg().zza(zzbe2.zza));
        long l = this.zza.zzb().nanoTime() / 1000000L;
        Future future = this.zza.zzl().zzb((Callable)new zzhx(this, zzbe2, string));
        try {
            byte[] byArray = (byte[])future.get();
            if (byArray == null) {
                this.zza.zzj().zzg().zza("Log and bundle returned null. appId", zzfp.zza((String)string));
                byArray = new byte[]{};
            }
            long l2 = this.zza.zzb().nanoTime() / 1000000L;
            this.zza.zzj().zzc().zza("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzg().zza(zzbe2.zza), (Object)byArray.length, (Object)(l2 - l));
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to log and bundle. appId, event, error", zzfp.zza((String)string), (Object)this.zza.zzg().zza(zzbe2.zza), (Object)exception);
            return null;
        }
    }
}

