/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.internal.measurement.zzad;
import com.google.android.gms.internal.measurement.zzfh;
import com.google.android.gms.internal.measurement.zzft;
import com.google.android.gms.internal.measurement.zzjg;
import com.google.android.gms.internal.measurement.zzjt;
import com.google.android.gms.internal.measurement.zzkb;
import com.google.android.gms.internal.measurement.zzlf;
import com.google.android.gms.internal.measurement.zzoi;
import com.google.android.gms.internal.measurement.zzon;
import com.google.android.gms.internal.measurement.zzpy;
import com.google.android.gms.internal.measurement.zzqk;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzay;
import com.google.android.gms.measurement.internal.zzba;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zziq;
import com.google.android.gms.measurement.internal.zzit;
import com.google.android.gms.measurement.internal.zzmv;
import com.google.android.gms.measurement.internal.zzmy;
import com.google.android.gms.measurement.internal.zzmz;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zznd;
import com.google.android.gms.measurement.internal.zznp;
import com.google.android.gms.measurement.internal.zznt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zznm
extends zzmy {
    static int zza(zzft.zzj.zza zza2, String string) {
        if (zza2 == null) {
            return -1;
        }
        for (int i = 0; i < zza2.zzd(); ++i) {
            if (!string.equals(zza2.zzk(i).zzg())) continue;
            return i;
        }
        return -1;
    }

    final long zza(@Nullable String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return 0L;
        }
        return this.zza(string.getBytes(Charset.forName("UTF-8")));
    }

    @WorkerThread
    final long zza(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        this.zzq().zzt();
        MessageDigest messageDigest = zznt.zzu();
        if (messageDigest == null) {
            this.zzj().zzg().zza("Failed to get MD5");
            return 0L;
        }
        return zznt.zza((byte[])messageDigest.digest(byArray));
    }

    private static Bundle zzb(List<zzft.zzg> list) {
        Bundle bundle = new Bundle();
        for (zzft.zzg zzg2 : list) {
            String string = zzg2.zzg();
            if (zzg2.zzj()) {
                bundle.putString(string, String.valueOf(zzg2.zza()));
                continue;
            }
            if (zzg2.zzk()) {
                bundle.putString(string, String.valueOf(zzg2.zzb()));
                continue;
            }
            if (zzg2.zzn()) {
                bundle.putString(string, zzg2.zzh());
                continue;
            }
            if (!zzg2.zzl()) continue;
            bundle.putString(string, String.valueOf(zzg2.zzd()));
        }
        return bundle;
    }

    static Bundle zza(List<zzft.zzg> list) {
        Bundle bundle = new Bundle();
        for (zzft.zzg zzg2 : list) {
            String string = zzg2.zzg();
            if (zzg2.zzj()) {
                bundle.putDouble(string, zzg2.zza());
                continue;
            }
            if (zzg2.zzk()) {
                bundle.putFloat(string, zzg2.zzb());
                continue;
            }
            if (zzg2.zzn()) {
                bundle.putString(string, zzg2.zzh());
                continue;
            }
            if (!zzg2.zzl()) continue;
            bundle.putLong(string, zzg2.zzd());
        }
        return bundle;
    }

    private final Bundle zza(Map<String, Object> map, boolean bl) {
        Bundle bundle = new Bundle();
        for (String string : map.keySet()) {
            Object object = map.get(string);
            if (object == null) {
                bundle.putString(string, null);
                continue;
            }
            if (object instanceof Long) {
                bundle.putLong(string, ((Long)object).longValue());
                continue;
            }
            if (object instanceof Double) {
                bundle.putDouble(string, ((Double)object).doubleValue());
                continue;
            }
            if (object instanceof ArrayList) {
                if (!bl) continue;
                ArrayList arrayList = (ArrayList)object;
                zznm zznm2 = this;
                ArrayList<Bundle> arrayList2 = new ArrayList<Bundle>();
                ArrayList arrayList3 = arrayList;
                int n = arrayList3.size();
                for (int i = 0; i < n; ++i) {
                    Object e = arrayList3.get(i);
                    Map map2 = (Map)e;
                    Bundle bundle2 = zznm2.zza(map2, false);
                    arrayList2.add(bundle2);
                }
                bundle.putParcelableArray(string, arrayList2.toArray(new Parcelable[0]));
                continue;
            }
            bundle.putString(string, object.toString());
        }
        return bundle;
    }

    private static Bundle zzc(List<zzft.zzn> list) {
        Bundle bundle = new Bundle();
        for (zzft.zzn zzn2 : list) {
            String string = zzn2.zzg();
            if (zzn2.zzi()) {
                bundle.putString(string, String.valueOf(zzn2.zza()));
                continue;
            }
            if (zzn2.zzj()) {
                bundle.putString(string, String.valueOf(zzn2.zzb()));
                continue;
            }
            if (zzn2.zzm()) {
                bundle.putString(string, zzn2.zzh());
                continue;
            }
            if (!zzn2.zzk()) continue;
            bundle.putString(string, String.valueOf(zzn2.zzc()));
        }
        return bundle;
    }

    final <T extends Parcelable> @Nullable T zza(byte[] byArray, Parcelable.Creator<T> creator) {
        if (byArray == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcel.unmarshall(byArray, 0, byArray.length);
            parcel.setDataPosition(0);
            Parcelable parcelable = (Parcelable)creator.createFromParcel(parcel);
            return (T)parcelable;
        }
        catch (SafeParcelReader.ParseException parseException) {
            this.zzj().zzg().zza("Failed to load parcelable from buffer");
            return null;
        }
        finally {
            parcel.recycle();
        }
    }

    final zzbf zza(zzad zzad2) {
        Object object;
        Bundle bundle = this.zza(zzad2.zzc(), true);
        String string = "app";
        if (bundle.containsKey("_o") && (object = bundle.get("_o")) != null) {
            string = object.toString();
        }
        if ((object = zzit.zzb((String)zzad2.zzb())) == null) {
            object = zzad2.zzb();
        }
        return new zzbf((String)object, new zzba(bundle), string, zzad2.zza());
    }

    @TargetApi(value=30)
    final @Nullable zzmv zza(String string, zzft.zzj.zza zza2, zzft.zze.zza zza3, @Nullable String string2) {
        if (!zzpy.zza() || !this.zze().zze(string, zzbh.zzcg)) {
            return null;
        }
        long l = this.zzb().currentTimeMillis();
        Set set = zznp.zza(this.zze().zzd(string, zzbh.zzbd).split(","));
        Uri.Builder builder = ((zzmz)this).zzo().zza(string);
        zznm.zza(builder, "gmp_app_id", zza2.zzx(), (Set<String>)set);
        zznm.zza(builder, "gmp_version", "87000", (Set<String>)set);
        String string3 = zza2.zzu();
        if (this.zze().zze(string, zzbh.zzcj) && ((zzmz)this).zzm().zzp(string)) {
            string3 = "";
        }
        zznm.zza(builder, "app_instance_id", string3, (Set<String>)set);
        zznm.zza(builder, "rdid", zza2.zzz(), (Set<String>)set);
        zznm.zza(builder, "bundle_id", zza2.zzt(), (Set<String>)set);
        String string4 = zza3.zze();
        String string5 = zzit.zza((String)string4);
        if (!TextUtils.isEmpty((CharSequence)string5)) {
            string4 = string5;
        }
        zznm.zza(builder, "app_event_name", string4, (Set<String>)set);
        zznm.zza(builder, "app_version", String.valueOf(zza2.zzb()), (Set<String>)set);
        String string6 = zza2.zzy();
        if (this.zze().zze(string, zzbh.zzcj) && ((zzmz)this).zzm().zzt(string)) {
            if (this.zze().zze(string, zzbh.zzbw)) {
                int n;
                if (!TextUtils.isEmpty((CharSequence)string6) && (n = string6.indexOf(".")) != -1) {
                    string6 = string6.substring(0, n);
                }
            } else {
                string6 = "";
            }
        }
        zznm.zza(builder, "os_version", string6, (Set<String>)set);
        zznm.zza(builder, "timestamp", String.valueOf(zza3.zzc()), (Set<String>)set);
        if (zza2.zzad()) {
            zznm.zza(builder, "lat", "1", (Set<String>)set);
        }
        zznm.zza(builder, "privacy_sandbox_version", String.valueOf(zza2.zza()), (Set<String>)set);
        zznm.zza(builder, "trigger_uri_source", "1", (Set<String>)set);
        zznm.zza(builder, "trigger_uri_timestamp", String.valueOf(l), (Set<String>)set);
        zznm.zza(builder, "request_uuid", string2, (Set<String>)set);
        Bundle bundle = zznm.zzb(zza3.zzf());
        String[] stringArray = this.zze().zzd(string, zzbh.zzbc).split("\\|");
        zznm.zza(builder, stringArray, bundle, (Set<String>)set);
        Bundle bundle2 = zznm.zzc(zza2.zzab());
        String[] stringArray2 = this.zze().zzd(string, zzbh.zzbb).split("\\|");
        zznm.zza(builder, stringArray2, bundle2, (Set<String>)set);
        if (this.zze().zza(zzbh.zzco)) {
            zznm.zza(builder, "dma", zza2.zzac() ? "1" : "0", (Set<String>)set);
            if (!zza2.zzw().isEmpty()) {
                zznm.zza(builder, "dma_cps", zza2.zzw(), (Set<String>)set);
            }
        }
        return new zzmv(builder.build().toString(), l, 1);
    }

    @TargetApi(value=30)
    final @Nullable zzmv zza(String string, zzft.zzj zzj2, zzft.zze.zza zza2, @Nullable String string2) {
        if (!zzpy.zza() || !this.zze().zze(string, zzbh.zzcg)) {
            return null;
        }
        long l = this.zzb().currentTimeMillis();
        Set set = zznp.zza(this.zze().zzd(string, zzbh.zzbd).split(","));
        Uri.Builder builder = ((zzmz)this).zzo().zza(string);
        zznm.zza(builder, "gmp_app_id", zzj2.zzah(), (Set<String>)set);
        zznm.zza(builder, "gmp_version", "87000", (Set<String>)set);
        String string3 = zzj2.zzy();
        if (this.zze().zze(string, zzbh.zzcj) && ((zzmz)this).zzm().zzp(string)) {
            string3 = "";
        }
        zznm.zza(builder, "app_instance_id", string3, (Set<String>)set);
        zznm.zza(builder, "rdid", zzj2.zzal(), (Set<String>)set);
        zznm.zza(builder, "bundle_id", zzj2.zzx(), (Set<String>)set);
        String string4 = zza2.zze();
        String string5 = zzit.zza((String)string4);
        if (!TextUtils.isEmpty((CharSequence)string5)) {
            string4 = string5;
        }
        zznm.zza(builder, "app_event_name", string4, (Set<String>)set);
        zznm.zza(builder, "app_version", String.valueOf(zzj2.zzb()), (Set<String>)set);
        String string6 = zzj2.h_();
        if (this.zze().zze(string, zzbh.zzcj) && ((zzmz)this).zzm().zzt(string)) {
            if (this.zze().zze(string, zzbh.zzbw)) {
                int n;
                if (!TextUtils.isEmpty((CharSequence)string6) && (n = string6.indexOf(".")) != -1) {
                    string6 = string6.substring(0, n);
                }
            } else {
                string6 = "";
            }
        }
        zznm.zza(builder, "os_version", string6, (Set<String>)set);
        zznm.zza(builder, "timestamp", String.valueOf(zza2.zzc()), (Set<String>)set);
        if (zzj2.zzat()) {
            zznm.zza(builder, "lat", "1", (Set<String>)set);
        }
        zznm.zza(builder, "privacy_sandbox_version", String.valueOf(zzj2.zza()), (Set<String>)set);
        zznm.zza(builder, "trigger_uri_source", "1", (Set<String>)set);
        zznm.zza(builder, "trigger_uri_timestamp", String.valueOf(l), (Set<String>)set);
        zznm.zza(builder, "request_uuid", string2, (Set<String>)set);
        Bundle bundle = zznm.zzb(zza2.zzf());
        String[] stringArray = this.zze().zzd(string, zzbh.zzbc).split("\\|");
        zznm.zza(builder, stringArray, bundle, (Set<String>)set);
        Bundle bundle2 = zznm.zzc(zzj2.zzaq());
        String[] stringArray2 = this.zze().zzd(string, zzbh.zzbb).split("\\|");
        zznm.zza(builder, stringArray2, bundle2, (Set<String>)set);
        if (this.zze().zza(zzbh.zzco)) {
            zznm.zza(builder, "dma", zzj2.zzas() ? "1" : "0", (Set<String>)set);
            if (!zzj2.zzad().isEmpty()) {
                zznm.zza(builder, "dma_cps", zzj2.zzad(), (Set<String>)set);
            }
        }
        return new zzmv(builder.build().toString(), l, 1);
    }

    final zzft.zze zza(zzay zzay2) {
        zzft.zze.zza zza2 = zzft.zze.zze().zza(zzay2.zzd);
        for (String string : zzay2.zze) {
            zzft.zzg.zza zza3 = zzft.zzg.zze().zza(string);
            Object object = zzay2.zze.zzc(string);
            Preconditions.checkNotNull((Object)object);
            this.zza(zza3, object);
            zza2.zza(zza3);
        }
        return (zzft.zze)((zzjt)zza2.zzah());
    }

    static @Nullable zzft.zzg zza(zzft.zze zze2, String string) {
        for (zzft.zzg zzg2 : zze2.zzh()) {
            if (!zzg2.zzg().equals(string)) continue;
            return zzg2;
        }
        return null;
    }

    static <BuilderT extends zzlf> BuilderT zza(BuilderT BuilderT, byte[] byArray) throws zzkb {
        zzjg zzjg2 = zzjg.zza();
        if (zzjg2 != null) {
            return (BuilderT)BuilderT.zza(byArray, zzjg2);
        }
        return (BuilderT)BuilderT.zza(byArray);
    }

    static @Nullable Object zzb(zzft.zze zze2, String string) {
        zzft.zzg zzg2 = zznm.zza(zze2, string);
        if (zzg2 != null) {
            if (zzg2.zzn()) {
                return zzg2.zzh();
            }
            if (zzg2.zzl()) {
                return zzg2.zzd();
            }
            if (zzg2.zzj()) {
                return zzg2.zza();
            }
            if (zzg2.zzc() > 0) {
                List<zzft.zzg> list = zzg2.zzi();
                ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
                for (zzft.zzg zzg3 : list) {
                    if (zzg3 == null) continue;
                    Bundle bundle = new Bundle();
                    for (zzft.zzg zzg4 : zzg3.zzi()) {
                        if (zzg4.zzn()) {
                            bundle.putString(zzg4.zzg(), zzg4.zzh());
                            continue;
                        }
                        if (zzg4.zzl()) {
                            bundle.putLong(zzg4.zzg(), zzg4.zzd());
                            continue;
                        }
                        if (!zzg4.zzj()) continue;
                        bundle.putDouble(zzg4.zzg(), zzg4.zza());
                    }
                    if (bundle.isEmpty()) continue;
                    arrayList.add(bundle);
                }
                return arrayList.toArray(new Bundle[arrayList.size()]);
            }
        }
        return null;
    }

    final String zza(zzft.zzi zzi2) {
        if (zzi2 == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nbatch {\n");
        Iterator<zzft.zzj> iterator = zzi2.zzd().iterator();
        while (iterator.hasNext()) {
            Object object;
            Iterator<zzft.zzn> iterator2;
            StringBuilder stringBuilder2;
            int n;
            Object object2;
            zzft.zzj zzj2;
            zzft.zzj zzj3 = zzj2 = iterator.next();
            StringBuilder stringBuilder3 = stringBuilder;
            zznm zznm2 = this;
            if (zzj3 == null) continue;
            zznm.zza(stringBuilder3, 1);
            stringBuilder3.append("bundle {\n");
            if (zzj3.zzbk()) {
                zznm.zza(stringBuilder3, 1, "protocol_version", zzj3.zze());
            }
            if (zzqk.zza() && zznm2.zze().zze(zzj3.zzx(), zzbh.zzbs) && zzj3.zzbn()) {
                zznm.zza(stringBuilder3, 1, "session_stitching_token", zzj3.zzam());
            }
            zznm.zza(stringBuilder3, 1, "platform", zzj3.zzak());
            if (zzj3.zzbf()) {
                zznm.zza(stringBuilder3, 1, "gmp_version", zzj3.zzm());
            }
            if (zzj3.zzbs()) {
                zznm.zza(stringBuilder3, 1, "uploading_gmp_version", zzj3.zzs());
            }
            if (zzj3.zzbd()) {
                zznm.zza(stringBuilder3, 1, "dynamite_version", zzj3.zzk());
            }
            if (zzj3.zzay()) {
                zznm.zza(stringBuilder3, 1, "config_version", zzj3.zzi());
            }
            zznm.zza(stringBuilder3, 1, "gmp_app_id", zzj3.zzah());
            zznm.zza(stringBuilder3, 1, "admob_app_id", zzj3.zzw());
            zznm.zza(stringBuilder3, 1, "app_id", zzj3.zzx());
            zznm.zza(stringBuilder3, 1, "app_version", zzj3.zzaa());
            if (zzj3.zzav()) {
                zznm.zza(stringBuilder3, 1, "app_version_major", zzj3.zzb());
            }
            zznm.zza(stringBuilder3, 1, "firebase_instance_id", zzj3.zzag());
            if (zzj3.zzbc()) {
                zznm.zza(stringBuilder3, 1, "dev_cert_hash", zzj3.zzj());
            }
            zznm.zza(stringBuilder3, 1, "app_store", zzj3.zzz());
            if (zzj3.zzbr()) {
                zznm.zza(stringBuilder3, 1, "upload_timestamp_millis", zzj3.zzr());
            }
            if (zzj3.zzbo()) {
                zznm.zza(stringBuilder3, 1, "start_timestamp_millis", zzj3.zzp());
            }
            if (zzj3.zzbe()) {
                zznm.zza(stringBuilder3, 1, "end_timestamp_millis", zzj3.zzl());
            }
            if (zzj3.zzbj()) {
                zznm.zza(stringBuilder3, 1, "previous_bundle_start_timestamp_millis", zzj3.zzo());
            }
            if (zzj3.zzbi()) {
                zznm.zza(stringBuilder3, 1, "previous_bundle_end_timestamp_millis", zzj3.zzn());
            }
            zznm.zza(stringBuilder3, 1, "app_instance_id", zzj3.zzy());
            zznm.zza(stringBuilder3, 1, "resettable_device_id", zzj3.zzal());
            zznm.zza(stringBuilder3, 1, "ds_id", zzj3.zzaf());
            if (zzj3.zzbh()) {
                zznm.zza(stringBuilder3, 1, "limited_ad_tracking", zzj3.zzat());
            }
            zznm.zza(stringBuilder3, 1, "os_version", zzj3.h_());
            zznm.zza(stringBuilder3, 1, "device_model", zzj3.zzae());
            zznm.zza(stringBuilder3, 1, "user_default_language", zzj3.zzan());
            if (zzj3.zzbq()) {
                zznm.zza(stringBuilder3, 1, "time_zone_offset_minutes", zzj3.zzg());
            }
            if (zzj3.zzax()) {
                zznm.zza(stringBuilder3, 1, "bundle_sequential_index", zzj3.zzc());
            }
            if (zzj3.zzbm()) {
                zznm.zza(stringBuilder3, 1, "service_upload", zzj3.zzau());
            }
            zznm.zza(stringBuilder3, 1, "health_monitor", zzj3.zzai());
            if (zzj3.zzbl()) {
                zznm.zza(stringBuilder3, 1, "retry_counter", zzj3.zzf());
            }
            if (zzj3.zzba()) {
                zznm.zza(stringBuilder3, 1, "consent_signals", zzj3.zzac());
            }
            if (zzj3.zzbg()) {
                zznm.zza(stringBuilder3, 1, "is_dma_region", zzj3.zzas());
            }
            if (zzj3.zzbb()) {
                zznm.zza(stringBuilder3, 1, "core_platform_services", zzj3.zzad());
            }
            if (zzj3.zzaz()) {
                zznm.zza(stringBuilder3, 1, "consent_diagnostics", zzj3.zzab());
            }
            if (zzj3.zzbp()) {
                zznm.zza(stringBuilder3, 1, "target_os_version", zzj3.zzq());
            }
            if (zzpy.zza() && zznm2.zze().zze(zzj3.zzx(), zzbh.zzcg)) {
                zznm.zza(stringBuilder3, 1, "ad_services_version", zzj3.zza());
                if (zzj3.zzaw()) {
                    object2 = zzj3.zzt();
                    n = 1;
                    stringBuilder2 = stringBuilder3;
                    if (object2 != null) {
                        ++n;
                        zznm.zza(stringBuilder2, 2);
                        stringBuilder2.append("attribution_eligibility_status {\n");
                        zznm.zza(stringBuilder2, 2, "eligible", ((zzft.zzb)((Object)object2)).zzf());
                        zznm.zza(stringBuilder2, 2, "no_access_adservices_attribution_permission", ((zzft.zzb)((Object)object2)).zzh());
                        zznm.zza(stringBuilder2, 2, "pre_r", ((zzft.zzb)((Object)object2)).zzi());
                        zznm.zza(stringBuilder2, 2, "r_extensions_too_old", ((zzft.zzb)((Object)object2)).zzj());
                        zznm.zza(stringBuilder2, 2, "adservices_extension_too_old", ((zzft.zzb)((Object)object2)).zze());
                        zznm.zza(stringBuilder2, 2, "ad_storage_not_allowed", ((zzft.zzb)((Object)object2)).zzd());
                        zznm.zza(stringBuilder2, 2, "measurement_manager_disabled", ((zzft.zzb)((Object)object2)).zzg());
                        zznm.zza(stringBuilder2, 2);
                        stringBuilder2.append("}\n");
                    }
                }
            }
            object2 = zzj3.zzaq();
            n = 1;
            stringBuilder2 = stringBuilder3;
            zznm zznm3 = zznm2;
            if (object2 != null) {
                ++n;
                iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    object = iterator2.next();
                    if (object == null) continue;
                    zznm.zza(stringBuilder2, 2);
                    stringBuilder2.append("user_property {\n");
                    zznm.zza(stringBuilder2, 2, "set_timestamp_millis", object.zzl() ? Long.valueOf(object.zzd()) : null);
                    zznm.zza(stringBuilder2, 2, "name", zznm3.zzi().zzc(object.zzg()));
                    zznm.zza(stringBuilder2, 2, "string_value", object.zzh());
                    zznm.zza(stringBuilder2, 2, "int_value", object.zzk() ? Long.valueOf(object.zzc()) : null);
                    zznm.zza(stringBuilder2, 2, "double_value", object.zzi() ? Double.valueOf(object.zza()) : null);
                    zznm.zza(stringBuilder2, 2);
                    stringBuilder2.append("}\n");
                }
            }
            List<zzft.zzc> list = zzj3.zzao();
            zzj3.zzx();
            object2 = list;
            n = 1;
            stringBuilder2 = stringBuilder3;
            if (object2 != null) {
                ++n;
                object = object2.iterator();
                while (object.hasNext()) {
                    zzft.zzc zzc2 = (zzft.zzc)((Object)object.next());
                    if (zzc2 == null) continue;
                    zznm.zza(stringBuilder2, 2);
                    stringBuilder2.append("audience_membership {\n");
                    if (zzc2.zzg()) {
                        zznm.zza(stringBuilder2, 2, "audience_id", zzc2.zza());
                    }
                    if (zzc2.zzh()) {
                        zznm.zza(stringBuilder2, 2, "new_audience", zzc2.zzf());
                    }
                    zznm.zza(stringBuilder2, 2, "current_data", zzc2.zzd());
                    if (zzc2.zzi()) {
                        zznm.zza(stringBuilder2, 2, "previous_data", zzc2.zze());
                    }
                    zznm.zza(stringBuilder2, 2);
                    stringBuilder2.append("}\n");
                }
            }
            object2 = zzj3.zzap();
            n = 1;
            stringBuilder2 = stringBuilder3;
            zznm3 = zznm2;
            if (object2 != null) {
                ++n;
                iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    object = (zzft.zze)((Object)iterator2.next());
                    if (object == null) continue;
                    zznm.zza(stringBuilder2, 2);
                    stringBuilder2.append("event {\n");
                    zznm.zza(stringBuilder2, 2, "name", zznm3.zzi().zza(((zzft.zze)((Object)object)).zzg()));
                    if (((zzft.zze)((Object)object)).zzk()) {
                        zznm.zza(stringBuilder2, 2, "timestamp_millis", ((zzft.zze)((Object)object)).zzd());
                    }
                    if (((zzft.zze)((Object)object)).zzj()) {
                        zznm.zza(stringBuilder2, 2, "previous_timestamp_millis", ((zzft.zze)((Object)object)).zzc());
                    }
                    if (((zzft.zze)((Object)object)).zzi()) {
                        zznm.zza(stringBuilder2, 2, "count", ((zzft.zze)((Object)object)).zza());
                    }
                    if (((zzft.zze)((Object)object)).zzb() != 0) {
                        zznm3.zza(stringBuilder2, 2, ((zzft.zze)((Object)object)).zzh());
                    }
                    zznm.zza(stringBuilder2, 2);
                    stringBuilder2.append("}\n");
                }
            }
            zznm.zza(stringBuilder3, 1);
            stringBuilder3.append("}\n");
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    final String zza(zzfh.zzb zzb2) {
        if (zzb2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nevent_filter {\n");
        if (zzb2.zzl()) {
            zznm.zza(stringBuilder, 0, "filter_id", zzb2.zzb());
        }
        zznm.zza(stringBuilder, 0, "event_name", this.zzi().zza(zzb2.zzf()));
        String string = zznm.zza(zzb2.zzh(), zzb2.zzi(), zzb2.zzj());
        if (!string.isEmpty()) {
            zznm.zza(stringBuilder, 0, "filter_type", string);
        }
        if (zzb2.zzk()) {
            zznm.zza(stringBuilder, 1, "event_count_filter", zzb2.zze());
        }
        if (zzb2.zza() > 0) {
            stringBuilder.append("  filters {\n");
            for (zzfh.zzc zzc2 : zzb2.zzg()) {
                this.zza(stringBuilder, 2, zzc2);
            }
        }
        zznm.zza(stringBuilder, 1);
        stringBuilder.append("}\n}\n");
        return stringBuilder.toString();
    }

    private static String zza(boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("Dynamic ");
        }
        if (bl2) {
            stringBuilder.append("Sequence ");
        }
        if (bl3) {
            stringBuilder.append("Session-Scoped ");
        }
        return stringBuilder.toString();
    }

    final String zza(zzfh.zze zze2) {
        if (zze2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nproperty_filter {\n");
        if (zze2.zzi()) {
            zznm.zza(stringBuilder, 0, "filter_id", zze2.zza());
        }
        zznm.zza(stringBuilder, 0, "property_name", this.zzi().zzc(zze2.zze()));
        String string = zznm.zza(zze2.zzf(), zze2.zzg(), zze2.zzh());
        if (!string.isEmpty()) {
            zznm.zza(stringBuilder, 0, "filter_type", string);
        }
        this.zza(stringBuilder, 1, zze2.zzb());
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    final List<Long> zza(List<Long> list, List<Integer> list2) {
        ArrayList<Long> arrayList = new ArrayList<Long>(list);
        for (Integer n : list2) {
            if (n < 0) {
                this.zzj().zzu().zza("Ignoring negative bit index to be cleared", (Object)n);
                continue;
            }
            int n2 = n / 64;
            if (n2 >= arrayList.size()) {
                this.zzj().zzu().zza("Ignoring bit index greater than bitSet size", (Object)n, (Object)arrayList.size());
                continue;
            }
            arrayList.set(n2, arrayList.get(n2) & (1L << n % 64 ^ 0xFFFFFFFFFFFFFFFFL));
        }
        int n = arrayList.size();
        int n3 = arrayList.size() - 1;
        while (n3 >= 0 && arrayList.get(n3) == 0L) {
            n = n3--;
        }
        return arrayList.subList(0, n);
    }

    final @Nullable List<Integer> zzu() {
        Map map = zzbh.zza((Context)this.zzf.zza());
        if (map == null || map.isEmpty()) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = (Integer)zzbh.zzap.zza(null);
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getKey()).startsWith("measurement.id.")) continue;
            try {
                int n2 = Integer.parseInt((String)entry.getValue());
                if (n2 == 0) continue;
                arrayList.add(n2);
                if (arrayList.size() < n) continue;
                this.zzj().zzu().zza("Too many experiment IDs. Number of IDs", (Object)arrayList.size());
                break;
            }
            catch (NumberFormatException numberFormatException) {
                this.zzj().zzu().zza("Experiment ID NumberFormatException", (Object)numberFormatException);
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    static List<Long> zza(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        for (int i = 0; i < n; ++i) {
            long l = 0L;
            for (int j = 0; j < 64 && (i << 6) + j < bitSet.length(); ++j) {
                if (!bitSet.get((i << 6) + j)) continue;
                l |= 1L << j;
            }
            arrayList.add(l);
        }
        return arrayList;
    }

    final Map<String, Object> zza(Bundle bundle, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string : bundle.keySet()) {
            Object object;
            Object object2 = object = bundle.get(string);
            if (object instanceof Parcelable[] || object2 instanceof ArrayList || object2 instanceof Bundle) {
                if (!bl) continue;
                Object object3 = object;
                object2 = this;
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                if (object3 instanceof Parcelable[]) {
                    for (Parcelable parcelable : (Parcelable[])object3) {
                        if (!(parcelable instanceof Bundle)) continue;
                        arrayList.add(((zznm)((Object)object2)).zza((Bundle)parcelable, false));
                    }
                } else if (object3 instanceof ArrayList) {
                    ArrayList arrayList2 = (ArrayList)object3;
                    int n = arrayList2.size();
                    for (int i = 0; i < n; ++i) {
                        Object e = arrayList2.get(i);
                        Object e2 = e;
                        if (!(e instanceof Bundle)) continue;
                        arrayList.add(((zznm)((Object)object2)).zza((Bundle)e2, false));
                    }
                } else if (object3 instanceof Bundle) {
                    arrayList.add(((zznm)((Object)object2)).zza((Bundle)object3, false));
                }
                hashMap.put(string, arrayList);
                continue;
            }
            if (object == null) continue;
            hashMap.put(string, object);
        }
        return hashMap;
    }

    zznm(zznd zznd2) {
        super(zznd2);
    }

    static void zza(zzft.zze.zza zza2, String string, Object object) {
        List<zzft.zzg> list = zza2.zzf();
        int n = -1;
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(list.get(i).zzg())) continue;
            n = i;
            break;
        }
        zzft.zzg.zza zza3 = zzft.zzg.zze().zza(string);
        if (object instanceof Long) {
            zza3.zza((Long)object);
        } else if (object instanceof String) {
            zza3.zzb((String)object);
        } else if (object instanceof Double) {
            zza3.zza((Double)object);
        }
        if (n >= 0) {
            zza2.zza(n, zza3);
            return;
        }
        zza2.zza(zza3);
    }

    private static void zza(Uri.Builder builder, String[] stringArray, Bundle bundle, Set<String> set) {
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(",");
            String string = stringArray2[0];
            String string2 = stringArray2[stringArray2.length - 1];
            String string3 = bundle.getString(string);
            if (string3 == null) continue;
            zznm.zza(builder, string2, string3, set);
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzft.zzl zzl2) {
        int n2;
        if (zzl2 == null) {
            return;
        }
        ++n;
        zznm.zza(stringBuilder, 3);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzl2.zzb() != 0) {
            zznm.zza(stringBuilder, 4);
            stringBuilder.append("results: ");
            n2 = 0;
            for (Long object : zzl2.zzi()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object);
            }
            stringBuilder.append('\n');
        }
        if (zzl2.zzd() != 0) {
            zznm.zza(stringBuilder, 4);
            stringBuilder.append("status: ");
            n2 = 0;
            for (Long l : zzl2.zzk()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
        }
        if (zzl2.zza() != 0) {
            zznm.zza(stringBuilder, 4);
            stringBuilder.append("dynamic_filter_timestamps: {");
            n2 = 0;
            for (zzft.zzd zzd2 : zzl2.zzh()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(zzd2.zzf() ? Integer.valueOf(zzd2.zza()) : null).append(":").append(zzd2.zze() ? Long.valueOf(zzd2.zzb()) : null);
            }
            stringBuilder.append("}\n");
        }
        if (zzl2.zzc() != 0) {
            zznm.zza(stringBuilder, 4);
            stringBuilder.append("sequence_filter_timestamps: {");
            n2 = 0;
            for (zzft.zzm zzm2 : zzl2.zzj()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(zzm2.zzf() ? Integer.valueOf(zzm2.zzb()) : null).append(": [");
                int n3 = 0;
                for (long l : zzm2.zze()) {
                    if (n3++ != 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(l);
                }
                stringBuilder.append("]");
            }
            stringBuilder.append("}\n");
        }
        zznm.zza(stringBuilder, 3);
        stringBuilder.append("}\n");
    }

    private final void zza(StringBuilder stringBuilder, int n, List<zzft.zzg> list) {
        if (list == null) {
            return;
        }
        ++n;
        for (zzft.zzg zzg2 : list) {
            if (zzg2 == null) continue;
            zznm.zza(stringBuilder, n);
            stringBuilder.append("param {\n");
            zznm.zza(stringBuilder, n, "name", zzg2.zzm() ? this.zzi().zzb(zzg2.zzg()) : null);
            zznm.zza(stringBuilder, n, "string_value", zzg2.zzn() ? zzg2.zzh() : null);
            zznm.zza(stringBuilder, n, "int_value", zzg2.zzl() ? Long.valueOf(zzg2.zzd()) : null);
            zznm.zza(stringBuilder, n, "double_value", zzg2.zzj() ? Double.valueOf(zzg2.zza()) : null);
            if (zzg2.zzc() > 0) {
                this.zza(stringBuilder, n, zzg2.zzi());
            }
            zznm.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private final void zza(StringBuilder stringBuilder, int n, zzfh.zzc zzc2) {
        if (zzc2 == null) {
            return;
        }
        zznm.zza(stringBuilder, n);
        stringBuilder.append("filter {\n");
        if (zzc2.zzg()) {
            zznm.zza(stringBuilder, n, "complement", zzc2.zzf());
        }
        if (zzc2.zzi()) {
            zznm.zza(stringBuilder, n, "param_name", this.zzi().zzb(zzc2.zze()));
        }
        if (zzc2.zzj()) {
            zzfh.zzf zzf2 = zzc2.zzd();
            String string = "string_filter";
            int n2 = n + 1;
            StringBuilder stringBuilder2 = stringBuilder;
            if (zzf2 != null) {
                zznm.zza(stringBuilder2, n2);
                stringBuilder2.append(string);
                stringBuilder2.append(" {\n");
                if (zzf2.zzj()) {
                    zznm.zza(stringBuilder2, n2, "match_type", zzf2.zzb().name());
                }
                if (zzf2.zzi()) {
                    zznm.zza(stringBuilder2, n2, "expression", zzf2.zze());
                }
                if (zzf2.zzh()) {
                    zznm.zza(stringBuilder2, n2, "case_sensitive", zzf2.zzg());
                }
                if (zzf2.zza() > 0) {
                    zznm.zza(stringBuilder2, n2 + 1);
                    stringBuilder2.append("expression_list {\n");
                    for (String string2 : zzf2.zzf()) {
                        zznm.zza(stringBuilder2, n2 + 2);
                        stringBuilder2.append(string2);
                        stringBuilder2.append("\n");
                    }
                    stringBuilder2.append("}\n");
                }
                zznm.zza(stringBuilder2, n2);
                stringBuilder2.append("}\n");
            }
        }
        if (zzc2.zzh()) {
            zznm.zza(stringBuilder, n + 1, "number_filter", zzc2.zzc());
        }
        zznm.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzfh.zzd zzd2) {
        if (zzd2 == null) {
            return;
        }
        zznm.zza(stringBuilder, n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzd2.zzh()) {
            zznm.zza(stringBuilder, n, "comparison_type", zzd2.zza().name());
        }
        if (zzd2.zzj()) {
            zznm.zza(stringBuilder, n, "match_as_float", zzd2.zzg());
        }
        if (zzd2.zzi()) {
            zznm.zza(stringBuilder, n, "comparison_value", zzd2.zzd());
        }
        if (zzd2.zzl()) {
            zznm.zza(stringBuilder, n, "min_comparison_value", zzd2.zzf());
        }
        if (zzd2.zzk()) {
            zznm.zza(stringBuilder, n, "max_comparison_value", zzd2.zze());
        }
        zznm.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(Uri.Builder builder, String string, @Nullable String string2, Set<String> set) {
        if (set.contains(string) || TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        builder.appendQueryParameter(string, string2);
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, @Nullable Object object) {
        if (object == null) {
            return;
        }
        zznm.zza(stringBuilder, n + 1);
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }

    final void zza(zzft.zzj.zza zza2) {
        this.zzj().zzp().zza("Checking account type status for ad personalization signals");
        if (this.zzc(zza2.zzt())) {
            this.zzj().zzc().zza("Turning off ad personalization due to account type");
            zzft.zzn zzn2 = (zzft.zzn)((zzjt)zzft.zzn.zze().zza("_npa").zzb(this.zzf().zzc()).zza(1L).zzah());
            boolean bl = false;
            for (int i = 0; i < zza2.zzd(); ++i) {
                if (!"_npa".equals(zza2.zzk(i).zzg())) continue;
                zza2.zza(i, zzn2);
                bl = true;
                break;
            }
            if (!bl) {
                zza2.zza(zzn2);
            }
            if (zzon.zza() && this.zze().zza(zzbh.zzco)) {
                zzaj zzaj2 = zzaj.zza(zza2.zzv());
                zzaj2.zza(zziq.zza.zzd, zzai.zzg);
                zza2.zzf(zzaj2.toString());
            }
        }
    }

    final void zza(zzft.zzg.zza zza2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zza2.zze().zzc().zzb().zzd();
        if (object instanceof String) {
            zza2.zzb((String)object);
            return;
        }
        if (object instanceof Long) {
            zza2.zza((Long)object);
            return;
        }
        if (object instanceof Double) {
            zza2.zza((Double)object);
            return;
        }
        if (object instanceof Bundle[]) {
            Bundle[] bundleArray = (Bundle[])object;
            ArrayList<zzft.zzg> arrayList = new ArrayList<zzft.zzg>();
            Bundle[] bundleArray2 = bundleArray;
            int n = bundleArray.length;
            for (int i = 0; i < n; ++i) {
                Bundle bundle = bundleArray2[i];
                if (bundle == null) continue;
                zzft.zzg.zza zza3 = zzft.zzg.zze();
                for (String string : bundle.keySet()) {
                    zzft.zzg.zza zza4 = zzft.zzg.zze().zza(string);
                    Object object2 = bundle.get(string);
                    if (object2 instanceof Long) {
                        zza4.zza((Long)object2);
                    } else if (object2 instanceof String) {
                        zza4.zzb((String)object2);
                    } else {
                        if (!(object2 instanceof Double)) continue;
                        zza4.zza((Double)object2);
                    }
                    zza3.zza(zza4);
                }
                if (zza3.zza() <= 0) continue;
                arrayList.add((zzft.zzg)((zzjt)zza3.zzah()));
            }
            zza2.zza(arrayList);
            return;
        }
        this.zzj().zzg().zza("Ignoring invalid (type) event param value", object);
    }

    final void zza(zzft.zzn.zza zza2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zza2.zzc().zzb().zza();
        if (object instanceof String) {
            zza2.zzb((String)object);
            return;
        }
        if (object instanceof Long) {
            zza2.zza((Long)object);
            return;
        }
        if (object instanceof Double) {
            zza2.zza((Double)object);
            return;
        }
        this.zzj().zzg().zza("Ignoring invalid (type) user attribute value", object);
    }

    @WorkerThread
    static boolean zza(zzbf zzbf2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzbf2);
        Preconditions.checkNotNull((Object)zzn2);
        return !TextUtils.isEmpty((CharSequence)zzn2.zzb) || !TextUtils.isEmpty((CharSequence)zzn2.zzp);
    }

    static boolean zza(List<Long> list, int n) {
        return n < list.size() << 6 && (list.get(n / 64) & 1L << n % 64) != 0L;
    }

    final boolean zza(long l, long l2) {
        return l == 0L || l2 <= 0L || Math.abs(this.zzb().currentTimeMillis() - l) > l2;
    }

    static boolean zzb(String string) {
        return string != null && string.matches("([+-])?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    @Override
    protected final boolean zzc() {
        return false;
    }

    final boolean zzc(String string) {
        if (zzoi.zza() && this.zze().zza(zzbh.zzcx)) {
            return false;
        }
        Preconditions.checkNotNull((Object)string);
        zzf zzf2 = ((zzmz)this).zzh().zze(string);
        if (zzf2 == null) {
            return false;
        }
        return this.zzf().zzn() && zzf2.zzao() && ((zzmz)this).zzm().zzk(string);
    }

    final byte[] zzb(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to gzip content", (Object)iOException);
            throw iOException;
        }
    }

    final byte[] zzc(byte[] byArray) throws IOException {
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to ungzip content", (Object)iOException);
            throw iOException;
        }
    }
}

