/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.internal.measurement.zzad;
import com.google.android.gms.internal.measurement.zzb;
import com.google.android.gms.internal.measurement.zzc;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzbd;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzhp;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zzhr;
import com.google.android.gms.measurement.internal.zzhs;
import com.google.android.gms.measurement.internal.zzht;
import com.google.android.gms.measurement.internal.zzhu;
import com.google.android.gms.measurement.internal.zzhv;
import com.google.android.gms.measurement.internal.zzhw;
import com.google.android.gms.measurement.internal.zzhx;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzhz;
import com.google.android.gms.measurement.internal.zzia;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzie;
import com.google.android.gms.measurement.internal.zzif;
import com.google.android.gms.measurement.internal.zzig;
import com.google.android.gms.measurement.internal.zzih;
import com.google.android.gms.measurement.internal.zziq;
import com.google.android.gms.measurement.internal.zzmu;
import com.google.android.gms.measurement.internal.zzmx;
import com.google.android.gms.measurement.internal.zznc;
import com.google.android.gms.measurement.internal.zznl;
import com.google.android.gms.measurement.internal.zzno;
import com.google.android.gms.measurement.internal.zznp;
import com.google.android.gms.measurement.internal.zznq;
import com.google.android.gms.measurement.internal.zzo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzhn
extends zzfo {
    private final zznc zza;
    private Boolean zzb;
    private @Nullable String zzc;

    @BinderThread
    public final zzaj zza(zzo zzo2) {
        this.zzb(zzo2, false);
        Preconditions.checkNotEmpty((String)zzo2.zza);
        Future future = this.zza.zzl().zzb((Callable)new zzia(this, zzo2));
        try {
            return (zzaj)future.get(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zza.zzj().zzg().zza("Failed to get consent. appId", zzfw.zza((String)zzo2.zza), (Object)exception);
            return new zzaj(null);
        }
    }

    @VisibleForTesting
    final zzbd zzb(zzbd zzbd2, zzo zzo2) {
        String string;
        zzbd zzbd3 = zzbd2;
        if (!"_cmp".equals(zzbd3.zza) || zzbd3.zzb == null || zzbd3.zzb.zza() == 0 ? false : "referrer broadcast".equals(string = zzbd3.zzb.zzd("_cis")) || "referrer API".equals(string)) {
            this.zza.zzj().zzn().zza("Event has been filtered ", (Object)zzbd2.toString());
            return new zzbd("_cmpx", zzbd2.zzb, zzbd2.zzc, zzbd2.zzd);
        }
        return zzbd2;
    }

    static /* bridge */ /* synthetic */ zznc zza(zzhn zzhn2) {
        return zzhn2.zza;
    }

    @BinderThread
    public final @Nullable String zzb(zzo zzo2) {
        this.zzb(zzo2, false);
        return this.zza.zzb(zzo2);
    }

    @BinderThread
    public final List<zzmu> zza(zzo zzo2, Bundle bundle) {
        this.zzb(zzo2, false);
        Preconditions.checkNotNull((Object)zzo2.zza);
        Future future = this.zza.zzl().zza((Callable)new zzih(this, zzo2, bundle));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get trigger URIs. appId", zzfw.zza((String)zzo2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final @Nullable List<zzno> zza(zzo zzo2, boolean bl) {
        this.zzb(zzo2, false);
        String string = zzo2.zza;
        Preconditions.checkNotNull((Object)string);
        Future future = this.zza.zzl().zza((Callable)new zzig(this, string));
        try {
            List list = (List)future.get();
            ArrayList<zzno> arrayList = new ArrayList<zzno>(list.size());
            for (zznq zznq2 : list) {
                if (!bl && zznp.zzg((String)zznq2.zzc)) continue;
                arrayList.add(new zzno(zznq2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get user properties. appId", zzfw.zza((String)zzo2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final List<zzae> zza(@Nullable String string, @Nullable String string2, zzo zzo2) {
        this.zzb(zzo2, false);
        String string3 = zzo2.zza;
        Preconditions.checkNotNull((Object)string3);
        Future future = this.zza.zzl().zza((Callable)new zzhw(this, string3, string, string2));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzae> zza(String string, @Nullable String string2, @Nullable String string3) {
        this.zza(string, true);
        Future future = this.zza.zzl().zza((Callable)new zzhz(this, string, string2, string3));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get conditional user properties as", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzno> zza(@Nullable String string, @Nullable String string2, boolean bl, zzo zzo2) {
        this.zzb(zzo2, false);
        String string3 = zzo2.zza;
        Preconditions.checkNotNull((Object)string3);
        Future future = this.zza.zzl().zza((Callable)new zzhu(this, string3, string, string2));
        try {
            List list = (List)future.get();
            ArrayList<zzno> arrayList = new ArrayList<zzno>(list.size());
            for (zznq zznq2 : list) {
                if (!bl && zznp.zzg((String)zznq2.zzc)) continue;
                arrayList.add(new zzno(zznq2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to query user properties. appId", zzfw.zza((String)zzo2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzno> zza(String string, @Nullable String string2, @Nullable String string3, boolean bl) {
        this.zza(string, true);
        Future future = this.zza.zzl().zza((Callable)new zzhx(this, string, string2, string3));
        try {
            List list = (List)future.get();
            ArrayList<zzno> arrayList = new ArrayList<zzno>(list.size());
            for (zznq zznq2 : list) {
                if (!bl && zznp.zzg((String)zznq2.zzc)) continue;
                arrayList.add(new zzno(zznq2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get user properties as. appId", zzfw.zza((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    public zzhn(zznc zznc2) {
        this(zznc2, null);
    }

    private zzhn(zznc zznc2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zznc2);
        this.zza = zznc2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzc(zzo zzo2) {
        this.zzb(zzo2, false);
        this.zzb(new zzhq(this, zzo2));
    }

    @BinderThread
    private final void zzb(zzo zzo2, boolean bl) {
        Preconditions.checkNotNull((Object)zzo2);
        Preconditions.checkNotEmpty((String)zzo2.zza);
        this.zza(zzo2.zza, false);
        this.zza.zzq().zza(zzo2.zzb, zzo2.zzp);
    }

    @BinderThread
    private final void zza(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zza.zzj().zzg().zza("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzhn zzhn2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzhn2 = this;
                    if (!bl2) break block9;
                    if (zzhn2.zzb == null) {
                        zzhn2.zzb = "com.google.android.gms".equals(zzhn2.zzc) || UidVerifier.isGooglePlayServicesUid((Context)zzhn2.zza.zza(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzhn2.zza.zza()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzhn2.zzb.booleanValue()) break block10;
                }
                if (zzhn2.zzc == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzhn2.zza.zza(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzhn2.zzc = string2;
                }
                if (!string2.equals(zzhn2.zzc)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zza.zzj().zzg().zza("Measurement Service called with invalid calling package. appId", zzfw.zza((String)string));
            throw securityException;
        }
    }

    final void zzc(zzbd zzbd2, zzo zzo2) {
        if (!this.zza.zzi().zzl(zzo2.zza)) {
            this.zzd(zzbd2, zzo2);
            return;
        }
        this.zza.zzj().zzp().zza("EES config found for", (Object)zzo2.zza);
        String string = zzo2.zza;
        zzmx zzmx2 = this.zza.zzi();
        zzb zzb2 = TextUtils.isEmpty((CharSequence)string) ? null : (zzb)((zzgt)zzmx2).zza.get((Object)string);
        if (zzb2 == null) {
            this.zza.zzj().zzp().zza("EES not loaded for", (Object)zzo2.zza);
            this.zzd(zzbd2, zzo2);
            return;
        }
        boolean bl = false;
        try {
            string = zzbd2;
            zzmx2 = this.zza.zzp();
            Bundle bundle = ((zzbd)string).zzb.zzb();
            Map<String, Object> map = ((zznl)zzmx2).zza(bundle, true);
            String string2 = zziq.zza((String)((zzbd)string).zza);
            if (string2 == null) {
                string2 = ((zzbd)string).zza;
            }
            bl = zzb2.zza(new zzad(string2, ((zzbd)string).zzd, map));
        }
        catch (zzc zzc2) {
            this.zza.zzj().zzg().zza("EES error. appId, eventName", (Object)zzo2.zzb, (Object)zzbd2.zza);
        }
        if (!bl) {
            this.zza.zzj().zzp().zza("EES was not applied to event", (Object)zzbd2.zza);
            this.zzd(zzbd2, zzo2);
            return;
        }
        if (zzb2.zzd()) {
            this.zza.zzj().zzp().zza("EES edited event", (Object)zzbd2.zza);
            this.zzd(this.zza.zzp().zza(zzb2.zza().zzb()), zzo2);
        } else {
            this.zzd(zzbd2, zzo2);
        }
        if (zzb2.zzc()) {
            for (zzad zzad2 : zzb2.zza().zzc()) {
                this.zza.zzj().zzp().zza("EES logging created event", (Object)zzad2.zzb());
                this.zzd(this.zza.zzp().zza(zzad2), zzo2);
            }
        }
    }

    final /* synthetic */ void zza(String string, Bundle bundle) {
        this.zza.zzf().zza(string, bundle);
    }

    final /* synthetic */ void zzi(zzo zzo2) {
        this.zza.zzr();
        this.zza.zze(zzo2);
    }

    final /* synthetic */ void zzj(zzo zzo2) {
        this.zza.zzr();
        this.zza.zzf(zzo2);
    }

    @BinderThread
    public final void zza(zzbd zzbd2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzbd2);
        this.zzb(zzo2, false);
        this.zzb(new zzid(this, zzbd2, zzo2));
    }

    @BinderThread
    public final void zza(zzbd zzbd2, String string, @Nullable String string2) {
        Preconditions.checkNotNull((Object)zzbd2);
        Preconditions.checkNotEmpty((String)string);
        this.zza(string, true);
        this.zzb(new zzic(this, zzbd2, string));
    }

    private final void zzd(zzbd zzbd2, zzo zzo2) {
        this.zza.zzr();
        this.zza.zza(zzbd2, zzo2);
    }

    @BinderThread
    public final void zzd(zzo zzo2) {
        Preconditions.checkNotEmpty((String)zzo2.zza);
        this.zza(zzo2.zza, false);
        this.zzb(new zzhy(this, zzo2));
    }

    @VisibleForTesting
    private final void zza(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzl().zzg()) {
            runnable.run();
            return;
        }
        this.zza.zzl().zzc(runnable);
    }

    @VisibleForTesting
    private final void zzb(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzl().zzg()) {
            runnable.run();
            return;
        }
        this.zza.zzl().zzb(runnable);
    }

    @BinderThread
    public final void zza(zzae zzae2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzae2);
        Preconditions.checkNotNull((Object)zzae2.zzc);
        this.zzb(zzo2, false);
        zzae zzae3 = new zzae(zzae2);
        new zzae(zzae2).zza = zzo2.zza;
        this.zzb(new zzhs(this, zzae3, zzo2));
    }

    @BinderThread
    public final void zza(zzae zzae2) {
        Preconditions.checkNotNull((Object)zzae2);
        Preconditions.checkNotNull((Object)zzae2.zzc);
        Preconditions.checkNotEmpty((String)zzae2.zza);
        this.zza(zzae2.zza, true);
        zzae zzae3 = new zzae(zzae2);
        this.zzb(new zzhv(this, zzae3));
    }

    @BinderThread
    public final void zze(zzo zzo2) {
        Preconditions.checkNotEmpty((String)zzo2.zza);
        Preconditions.checkNotNull((Object)zzo2.zzt);
        this.zza(new zzib(this, zzo2));
    }

    @BinderThread
    public final void zza(long l, @Nullable String string, @Nullable String string2, String string3) {
        this.zzb(new zzht(this, string2, string3, string, l));
    }

    @BinderThread
    public final void zza(Bundle bundle, zzo zzo2) {
        this.zzb(zzo2, false);
        String string = zzo2.zza;
        Preconditions.checkNotNull((Object)string);
        Bundle bundle2 = bundle;
        String string2 = string;
        zzhn zzhn2 = this;
        this.zzb(new zzho(zzhn2, string2, bundle2));
    }

    @BinderThread
    public final void zzf(zzo zzo2) {
        Preconditions.checkNotEmpty((String)zzo2.zza);
        Preconditions.checkNotNull((Object)zzo2.zzt);
        zzo zzo3 = zzo2;
        zzhn zzhn2 = this;
        this.zza(new zzhp(zzhn2, zzo3));
    }

    @BinderThread
    public final void zzg(zzo zzo2) {
        this.zzb(zzo2, false);
        this.zzb(new zzhr(this, zzo2));
    }

    @BinderThread
    public final void zzh(zzo zzo2) {
        Preconditions.checkNotEmpty((String)zzo2.zza);
        Preconditions.checkNotNull((Object)zzo2.zzt);
        zzo zzo3 = zzo2;
        zzhn zzhn2 = this;
        this.zza(new zzhm(zzhn2, zzo3));
    }

    @BinderThread
    public final void zza(zzno zzno2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzno2);
        this.zzb(zzo2, false);
        this.zzb(new zzie(this, zzno2, zzo2));
    }

    @BinderThread
    public final byte @Nullable [] zza(zzbd zzbd2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzbd2);
        this.zza(string, true);
        this.zza.zzj().zzc().zza("Log and bundle. event", (Object)this.zza.zzg().zza(zzbd2.zza));
        long l = this.zza.zzb().nanoTime() / 1000000L;
        Future future = this.zza.zzl().zzb((Callable)new zzif(this, zzbd2, string));
        try {
            byte[] byArray = (byte[])future.get();
            if (byArray == null) {
                this.zza.zzj().zzg().zza("Log and bundle returned null. appId", zzfw.zza((String)string));
                byArray = new byte[]{};
            }
            long l2 = this.zza.zzb().nanoTime() / 1000000L;
            this.zza.zzj().zzc().zza("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzg().zza(zzbd2.zza), (Object)byArray.length, (Object)(l2 - l));
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to log and bundle. appId, event, error", zzfw.zza((String)string), (Object)this.zza.zzg().zza(zzbd2.zza), (Object)exception);
            return null;
        }
    }
}

