/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzcf;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzfn;
import com.google.android.gms.internal.measurement.zzjk;
import com.google.android.gms.internal.measurement.zzjs;
import com.google.android.gms.internal.measurement.zzkv;
import com.google.android.gms.internal.measurement.zznw;
import com.google.android.gms.internal.measurement.zzoj;
import com.google.android.gms.internal.measurement.zzoo;
import com.google.android.gms.internal.measurement.zzop;
import com.google.android.gms.internal.measurement.zzou;
import com.google.android.gms.internal.measurement.zzpg;
import com.google.android.gms.internal.measurement.zzph;
import com.google.android.gms.internal.measurement.zzpn;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzav;
import com.google.android.gms.measurement.internal.zzaz;
import com.google.android.gms.measurement.internal.zzba;
import com.google.android.gms.measurement.internal.zzbc;
import com.google.android.gms.measurement.internal.zzbd;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzil;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzin;
import com.google.android.gms.measurement.internal.zziq;
import com.google.android.gms.measurement.internal.zzkn;
import com.google.android.gms.measurement.internal.zzkp;
import com.google.android.gms.measurement.internal.zzmc;
import com.google.android.gms.measurement.internal.zzms;
import com.google.android.gms.measurement.internal.zzmw;
import com.google.android.gms.measurement.internal.zzmx;
import com.google.android.gms.measurement.internal.zzmz;
import com.google.android.gms.measurement.internal.zzna;
import com.google.android.gms.measurement.internal.zznb;
import com.google.android.gms.measurement.internal.zznd;
import com.google.android.gms.measurement.internal.zzne;
import com.google.android.gms.measurement.internal.zznf;
import com.google.android.gms.measurement.internal.zzng;
import com.google.android.gms.measurement.internal.zznj;
import com.google.android.gms.measurement.internal.zznk;
import com.google.android.gms.measurement.internal.zznl;
import com.google.android.gms.measurement.internal.zznm;
import com.google.android.gms.measurement.internal.zzno;
import com.google.android.gms.measurement.internal.zznp;
import com.google.android.gms.measurement.internal.zznq;
import com.google.android.gms.measurement.internal.zznr;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzu;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class zznc
implements zzil {
    private static volatile @Nullable zznc zza;
    private zzgt zzb;
    private zzfz zzc;
    private zzal zzd;
    private zzgg zze;
    private zzmw zzf;
    private zzu zzg;
    private final zznl zzh;
    private zzkn zzi;
    private zzmc zzj;
    private final zzna zzk;
    private @MonotonicNonNull zzgq zzl;
    private final zzhj zzm;
    private boolean zzn = false;
    private boolean zzo;
    @VisibleForTesting
    private long zzp;
    private @Nullable List<Runnable> zzq;
    private final Set<String> zzr = new HashSet<String>();
    private int zzs;
    private int zzt;
    private boolean zzu;
    private boolean zzv;
    private boolean zzw;
    private @Nullable FileLock zzx;
    private @Nullable FileChannel zzy;
    private @Nullable List<Long> zzz;
    private @Nullable List<Long> zzaa;
    private long zzab;
    private final Map<String, zzin> zzac;
    private final Map<String, zzav> zzad;
    private final Map<String, zzb> zzae;
    private @Nullable zzkp zzaf;
    private @Nullable String zzag;
    private final zznr zzah = new zznf(this);

    private final int zza(String string, zzah zzah2) {
        zzim zzim2;
        zzg zzg2;
        if (this.zzb.zzb(string) == null) {
            zzah2.zza(zzin.zza.zzd, zzak.zzj);
            return 1;
        }
        if (com.google.android.gms.internal.measurement.zzne.zza() && this.zze().zza(zzbf.zzcp) && (zzg2 = this.zzf().zze(string)) != null && zzgi.zza((String)zzg2.zzak()).zza() == zzim.zzb && (zzim2 = this.zzb.zza(string, zzin.zza.zzd)) != zzim.zza) {
            zzah2.zza(zzin.zza.zzd, zzak.zzi);
            if (zzim2 == zzim.zzd) {
                return 0;
            }
            return 1;
        }
        zzah2.zza(zzin.zza.zzd, zzak.zzb);
        if (this.zzb.zzc(string, zzin.zza.zzd)) {
            return 0;
        }
        return 1;
    }

    @VisibleForTesting
    @WorkerThread
    private final int zza(@Nullable FileChannel fileChannel) {
        this.zzl().zzt();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj().zzg().zza("Bad channel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzj().zzu().zza("Unexpected data length. Bytes read", (Object)n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to read from channel", (Object)iOException);
        }
        return n;
    }

    private final long zzx() {
        long l = this.zzb().currentTimeMillis();
        zzmc zzmc2 = this.zzj;
        zzmc2.zzal();
        zzmc2.zzt();
        long l2 = zzmc2.zze.zza();
        if (l2 == 0L) {
            l2 = 1L + (long)zzmc2.zzq().zzv().nextInt(86400000);
            zzmc2.zze.zza(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    public final Context zza() {
        return this.zzm.zza();
    }

    @WorkerThread
    final @Nullable Bundle zza(String string) {
        zznq zznq2;
        this.zzl().zzt();
        this.zzs();
        if (this.zzi().zzb(string) == null) {
            return null;
        }
        Bundle bundle = new Bundle();
        zzin zzin2 = this.zzb(string);
        bundle.putAll(zzin2.zzb());
        zzav zzav2 = this.zza(string, this.zzd(string), zzin2, new zzah());
        bundle.putAll(zzav2.zzb());
        int n = this.zzp().zzc(string) ? 1 : ((zznq2 = this.zzf().zze(string, "_npa")) != null ? (zznq2.zze.equals(1L) ? 1 : 0) : this.zza(string, new zzah()));
        bundle.putString("ad_personalization", n == 1 ? "denied" : "granted");
        return bundle;
    }

    public final Clock zzb(@UnknownInitialization zznc this) {
        return ((zzhj)Preconditions.checkNotNull((Object)this.zzm)).zzb();
    }

    @WorkerThread
    final zzg zza(zzo zzo2) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotNull((Object)zzo2);
        Preconditions.checkNotEmpty((String)zzo2.zza);
        if (!zzo2.zzu.isEmpty()) {
            this.zzae.put(zzo2.zza, new zzb(this, zzo2.zzu, null));
        }
        zzg zzg2 = this.zzf().zze(zzo2.zza);
        boolean bl = false;
        zzin zzin2 = this.zzb(zzo2.zza).zza(zzin.zzb((String)zzo2.zzt));
        String string = zzin2.zzi() ? this.zzj.zza(zzo2.zza, zzo2.zzn) : "";
        if (zzg2 == null) {
            zzg2 = new zzg(this.zzm, zzo2.zza);
            if (zzin2.zzj()) {
                zzg2.zzb(this.zza(zzin2));
            }
            if (zzin2.zzi()) {
                zzg2.zzh(string);
            }
        } else if (zzin2.zzi() && string != null && !string.equals(zzg2.zzaj())) {
            boolean bl2 = TextUtils.isEmpty((CharSequence)zzg2.zzaj());
            zzg2.zzh(string);
            if (zzo2.zzn && !"00000000-0000-0000-0000-000000000000".equals(this.zzj.zza((String)zzo2.zza, (zzin)zzin2).first) && !bl2) {
                if (com.google.android.gms.internal.measurement.zznk.zza() && this.zze().zza(zzbf.zzcv) && !zzin2.zzj()) {
                    bl = true;
                } else {
                    zzg2.zzb(this.zza(zzin2));
                }
                if (this.zzf().zze(zzo2.zza, "_id") != null && this.zzf().zze(zzo2.zza, "_lair") == null) {
                    long l = this.zzb().currentTimeMillis();
                    zznq zznq2 = new zznq(zzo2.zza, "auto", "_lair", l, (Object)1L);
                    this.zzf().zza(zznq2);
                }
            } else if (TextUtils.isEmpty((CharSequence)zzg2.zzad()) && zzin2.zzj()) {
                zzg2.zzb(this.zza(zzin2));
            }
        } else if (TextUtils.isEmpty((CharSequence)zzg2.zzad()) && zzin2.zzj()) {
            zzg2.zzb(this.zza(zzin2));
        }
        zzg2.zzf(zzo2.zzb);
        zzg2.zza(zzo2.zzp);
        if (!TextUtils.isEmpty((CharSequence)zzo2.zzk)) {
            zzg2.zze(zzo2.zzk);
        }
        if (zzo2.zze != 0L) {
            zzg2.zzn(zzo2.zze);
        }
        if (!TextUtils.isEmpty((CharSequence)zzo2.zzc)) {
            zzg2.zzd(zzo2.zzc);
        }
        zzg2.zzb(zzo2.zzj);
        if (zzo2.zzd != null) {
            zzg2.zzc(zzo2.zzd);
        }
        zzg2.zzk(zzo2.zzf);
        zzg2.zzb(zzo2.zzh);
        if (!TextUtils.isEmpty((CharSequence)zzo2.zzg)) {
            zzg2.zzg(zzo2.zzg);
        }
        zzg2.zza(zzo2.zzn);
        zzg2.zza(zzo2.zzq);
        zzg2.zzl(zzo2.zzr);
        zzg2.zzj(zzo2.zzv);
        if (zznw.zza() && this.zze().zza(zzbf.zzbq)) {
            zzg2.zza(zzo2.zzs);
        } else if (zznw.zza() && this.zze().zza(zzbf.zzbp)) {
            zzg2.zza((List<String>)null);
        }
        if (zzpn.zza() && this.zze().zza(zzbf.zzbs)) {
            this.zzq();
            if (zznp.zzf((String)zzg2.zzac())) {
                zzg2.zzc(zzo2.zzw);
                if (this.zze().zza(zzbf.zzbt)) {
                    zzg2.zzk(zzo2.zzac);
                }
            }
        }
        if (zzpg.zza() && this.zze().zza(zzbf.zzbz)) {
            zzg2.zza(zzo2.zzaa);
        }
        zzg2.zzt(zzo2.zzx);
        if (com.google.android.gms.internal.measurement.zzne.zza() && this.zze().zza(zzbf.zzcp)) {
            zzg2.zzi(zzo2.zzad);
        }
        if (com.google.android.gms.internal.measurement.zznk.zza() && this.zze().zza(zzbf.zzcv)) {
            if (zzg2.zzas() || bl) {
                this.zzf().zza(zzg2, bl, false);
            }
        } else if (zzg2.zzas()) {
            this.zzf().zza(zzg2, false, false);
        }
        return zzg2;
    }

    @WorkerThread
    private final @Nullable zzo zzc(String string) {
        zzg zzg2 = this.zzf().zze(string);
        if (zzg2 == null || TextUtils.isEmpty((CharSequence)zzg2.zzaf())) {
            this.zzj().zzc().zza("No app data available; dropping", (Object)string);
            return null;
        }
        Boolean bl = this.zza(zzg2);
        if (bl != null && !bl.booleanValue()) {
            this.zzj().zzg().zza("App version does not match; dropping. appId", zzfw.zza((String)string));
            return null;
        }
        return new zzo(string, zzg2.zzah(), zzg2.zzaf(), zzg2.zze(), zzg2.zzae(), zzg2.zzq(), zzg2.zzn(), null, zzg2.zzar(), false, zzg2.zzag(), zzg2.zzd(), 0L, 0, zzg2.zzaq(), false, zzg2.zzaa(), zzg2.zzx(), zzg2.zzo(), zzg2.zzan(), null, this.zzb(string).zzh(), "", null, zzg2.zzat(), zzg2.zzw(), this.zzb(string).zza(), this.zzd(string).zzf(), zzg2.zza(), zzg2.zzf(), zzg2.zzam(), zzg2.zzak());
    }

    public final zzu zzc() {
        return (zzu)zznc.zza(this.zzg);
    }

    public final zzab zzd() {
        return this.zzm.zzd();
    }

    public final zzag zze(@UnknownInitialization zznc this) {
        return ((zzhj)Preconditions.checkNotNull((Object)this.zzm)).zzf();
    }

    public final zzal zzf(@UnknownInitialization zznc this) {
        return (zzal)zznc.zza(this.zzd);
    }

    @VisibleForTesting
    @WorkerThread
    private final zzav zza(String string, zzav zzav2, zzin zzin2, zzah zzah2) {
        int n;
        if (this.zzi().zzb(string) == null) {
            int n2;
            if (zzav2.zzc() == zzim.zzc) {
                n2 = zzav2.zza();
                zzah2.zza(zzin.zza.zzc, n2);
            } else {
                n2 = 90;
                zzah2.zza(zzin.zza.zzc, zzak.zzj);
            }
            return new zzav(Boolean.valueOf(false), n2, Boolean.valueOf(true), "-");
        }
        zzim zzim2 = zzav2.zzc();
        if (zzim2 == zzim.zzd || zzim2 == zzim.zzc) {
            n = zzav2.zza();
            zzah2.zza(zzin.zza.zzc, n);
        } else {
            n = 90;
            if (com.google.android.gms.internal.measurement.zzne.zza() && this.zze().zza(zzbf.zzcp)) {
                zzin.zza zza2;
                zzin.zza zza3;
                zzah zzah3 = zzah2;
                zzin zzin3 = zzin2;
                zzim zzim3 = zzim2;
                String string2 = string;
                zznc zznc2 = this;
                if (zzim3 == zzim.zzb && (zza3 = zznc2.zzb.zza(string2, zzin.zza.zzc)) != zzim.zza) {
                    zzah3.zza(zzin.zza.zzc, zzak.zzi);
                    zza2 = zza3;
                } else {
                    boolean bl;
                    zza3 = zznc2.zzb.zzb(string2, zzin.zza.zzc);
                    zzim zzim4 = zzin3.zzc();
                    boolean bl2 = bl = zzim4 == zzim.zzd || zzim4 == zzim.zzc;
                    if (zza3 == zzin.zza.zza && bl) {
                        zzah3.zza(zzin.zza.zzc, zzak.zzc);
                        zza2 = zzim4;
                    } else {
                        zzah3.zza(zzin.zza.zzc, zzak.zzb);
                        zza2 = zznc2.zzb.zzc(string2, zzin.zza.zzc) ? zzim.zzd : zzim.zzc;
                    }
                }
                zzim2 = zza2;
            } else {
                zzah zzah4 = zzah2;
                zzin zzin4 = zzin2;
                zzim zzim5 = zzim2;
                String string3 = string;
                zznc zznc3 = this;
                Preconditions.checkArgument((zzim5 == zzim.zza || zzim5 == zzim.zzb ? 1 : 0) != 0);
                zzim zzim6 = zzim5;
                zzin.zza zza4 = zznc3.zzb.zzb(string3, zzin.zza.zzc);
                Boolean bl = zzin4.zze();
                if (zza4 == zzin.zza.zza && bl != null) {
                    zzim6 = bl != false ? zzim.zzd : zzim.zzc;
                    zzah4.zza(zzin.zza.zzc, zzak.zzc);
                }
                if (zzim6 == zzim.zza) {
                    zzim6 = zznc3.zzb.zzc(string3, zzin.zza.zzc) ? zzim.zzd : zzim.zzc;
                    zzah4.zza(zzin.zza.zzc, zzak.zzb);
                }
                zzim2 = zzim6;
            }
        }
        boolean bl = this.zzb.zzn(string);
        SortedSet<String> sortedSet = this.zzi().zzh(string);
        if (zzim2 == zzim.zzc || sortedSet.isEmpty()) {
            return new zzav(Boolean.valueOf(false), n, Boolean.valueOf(bl), "-");
        }
        return new zzav(Boolean.valueOf(true), n, Boolean.valueOf(bl), bl ? TextUtils.join((CharSequence)"", sortedSet) : "");
    }

    @WorkerThread
    private final zzav zzd(String string) {
        this.zzl().zzt();
        this.zzs();
        zzav zzav2 = this.zzad.get(string);
        if (zzav2 == null) {
            zzav2 = this.zzf().zzg(string);
            this.zzad.put(string, zzav2);
        }
        return zzav2;
    }

    public final zzfr zzg() {
        return this.zzm.zzk();
    }

    public final zzfw zzj(@UnknownInitialization zznc this) {
        return ((zzhj)Preconditions.checkNotNull((Object)this.zzm)).zzj();
    }

    public final zzfz zzh() {
        return (zzfz)zznc.zza(this.zzc);
    }

    private final zzgg zzy() {
        if (this.zze == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zze;
    }

    public final zzgt zzi() {
        return (zzgt)zznc.zza(this.zzb);
    }

    public final zzhc zzl(@UnknownInitialization zznc this) {
        return ((zzhj)Preconditions.checkNotNull((Object)this.zzm)).zzl();
    }

    static /* bridge */ /* synthetic */ zzhj zza(zznc zznc2) {
        return zznc2.zzm;
    }

    final zzhj zzk() {
        return this.zzm;
    }

    @WorkerThread
    final zzin zzb(String string) {
        this.zzl().zzt();
        this.zzs();
        zzin zzin2 = this.zzac.get(string);
        if (zzin2 == null) {
            zzin2 = this.zzf().zzi(string);
            if (zzin2 == null) {
                zzin2 = zzin.zza;
            }
            this.zza(string, zzin2);
        }
        return zzin2;
    }

    public final zzkn zzm() {
        return (zzkn)zznc.zza(this.zzi);
    }

    public final zzmc zzn() {
        return this.zzj;
    }

    private final zzmw zzz() {
        return (zzmw)zznc.zza(this.zzf);
    }

    private static zzmx zza(@Nullable zzmx zzmx2) {
        if (zzmx2 == null) {
            throw new IllegalStateException("Upload Component not created");
        }
        if (!zzmx2.zzan()) {
            String string = String.valueOf(((Object)((Object)zzmx2)).getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
        return zzmx2;
    }

    public final zzna zzo() {
        return this.zzk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zznc zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zza != null) return zza;
        Class<zznc> clazz = zznc.class;
        synchronized (zznc.class) {
            if (zza != null) return zza;
            zznm zznm2 = (zznm)Preconditions.checkNotNull((Object)new zznm(context));
            zza = new zznc(zznm2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zza;
        }
    }

    public final zznl zzp() {
        return (zznl)zznc.zza(this.zzh);
    }

    public final zznp zzq(@UnknownInitialization zznc this) {
        return ((zzhj)Preconditions.checkNotNull((Object)this.zzm)).zzt();
    }

    @WorkerThread
    private final @Nullable Boolean zza(zzg zzg2) {
        try {
            if (zzg2.zze() != Integer.MIN_VALUE) {
                int n = Wrappers.packageManager((Context)this.zzm.zza()).getPackageInfo((String)zzg2.zzac(), (int)0).versionCode;
                if (zzg2.zze() == (long)n) {
                    return true;
                }
            } else {
                String string = Wrappers.packageManager((Context)this.zzm.zza()).getPackageInfo((String)zzg2.zzac(), (int)0).versionName;
                String string2 = zzg2.zzaf();
                if (string2 != null && string2.equals(string)) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return false;
    }

    private final @Nullable Boolean zzg(zzo zzo2) {
        Boolean bl = zzo2.zzq;
        if (com.google.android.gms.internal.measurement.zzne.zza() && this.zze().zza(zzbf.zzcp) && !TextUtils.isEmpty((CharSequence)zzo2.zzad)) {
            zzim zzim2 = zzgi.zza((String)zzo2.zzad).zza();
            switch (zzim2) {
                case zzd: {
                    bl = false;
                    break;
                }
                case zzc: {
                    bl = true;
                    break;
                }
                case zzb: 
                case zza: {
                    bl = null;
                }
            }
        }
        return bl;
    }

    @WorkerThread
    private final @Nullable String zza(zzin zzin2) {
        if (zzin2.zzj()) {
            zznc zznc2 = this;
            byte[] byArray = new byte[16];
            zznc2.zzq().zzv().nextBytes(byArray);
            return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
        }
        return null;
    }

    final @Nullable String zzb(zzo zzo2) {
        Future future = this.zzl().zza((Callable)new zzng(this, zzo2));
        try {
            return (String)future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzj().zzg().zza("Failed to get app instance id. appId", zzfw.zza((String)zzo2.zza), (Object)exception);
            return null;
        }
    }

    static /* synthetic */ void zza(zznc zznc2, zznm zznm2) {
        zznc zznc3 = zznc2;
        zznc3.zzl().zzt();
        zznc zznc4 = zznc3;
        zznc3.zzl = new zzgq(zznc4);
        zznc4 = zznc3;
        zzal zzal2 = new zzal(zznc4);
        zzal2.zzam();
        zznc3.zzd = zzal2;
        zznc3.zze().zza((zzai)Preconditions.checkNotNull((Object)((Object)zznc3.zzb)));
        zznc4 = zznc3;
        zzmc zzmc2 = new zzmc(zznc4);
        zzmc2.zzam();
        zznc3.zzj = zzmc2;
        zznc4 = zznc3;
        zzu zzu2 = new zzu(zznc4);
        zzu2.zzam();
        zznc3.zzg = zzu2;
        zznc4 = zznc3;
        zzkn zzkn2 = new zzkn(zznc4);
        zzkn2.zzam();
        zznc3.zzi = zzkn2;
        zznc4 = zznc3;
        zzmw zzmw2 = new zzmw(zznc4);
        zzmw2.zzam();
        zznc3.zzf = zzmw2;
        zznc4 = zznc3;
        zznc3.zze = new zzgg(zznc4);
        if (zznc3.zzs != zznc3.zzt) {
            zznc3.zzj().zzg().zza("Not all upload components initialized", (Object)zznc3.zzs, (Object)zznc3.zzt);
        }
        zznc3.zzn = true;
    }

    private zznc(zznm zznm2) {
        this(zznm2, null);
    }

    private zznc(zznm zznm2, @Nullable zzhj zzhj2) {
        Preconditions.checkNotNull((Object)zznm2);
        this.zzm = zzhj2 = zzhj.zza((Context)zznm2.zza, null, null);
        this.zzab = -1L;
        zznc zznc2 = this;
        this.zzk = new zzna(zznc2);
        zznc2 = this;
        zznl zznl2 = new zznl(zznc2);
        zznl2.zzam();
        this.zzh = zznl2;
        zznc2 = this;
        zzfz zzfz2 = new zzfz(zznc2);
        zzfz2.zzam();
        this.zzc = zzfz2;
        zznc2 = this;
        zzgt zzgt2 = new zzgt(zznc2);
        zzgt2.zzam();
        this.zzb = zzgt2;
        this.zzac = new HashMap<String, zzin>();
        this.zzad = new HashMap<String, zzav>();
        this.zzae = new HashMap<String, zzb>();
        this.zzl().zzb((Runnable)new zznb(this, zznm2));
    }

    @WorkerThread
    final void zza(Runnable runnable) {
        this.zzl().zzt();
        if (this.zzq == null) {
            this.zzq = new ArrayList<Runnable>();
        }
        this.zzq.add(runnable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @WorkerThread
    final void zzr() {
        int n;
        this.zzl().zzt();
        this.zzs();
        if (this.zzo) return;
        this.zzo = true;
        if (!this.zzad()) return;
        int n2 = this.zza(this.zzy);
        int n3 = n = this.zzm.zzh().zzab();
        int n4 = n2;
        zznc zznc2 = this;
        zznc2.zzl().zzt();
        if (n4 > n3) {
            zznc2.zzj().zzg().zza("Panic: can't downgrade version. Previous, current version", (Object)n4, (Object)n3);
            return;
        }
        if (n4 >= n3) return;
        if (!zznc2.zza(n3, zznc2.zzy)) {
            zznc2.zzj().zzg().zza("Storage version upgrade failed. Previous, current version", (Object)n4, (Object)n3);
            return;
        }
        zznc2.zzj().zzp().zza("Storage version upgraded. Previous, current version", (Object)n4, (Object)n3);
    }

    final void zzs() {
        if (!this.zzn) {
            throw new IllegalStateException("UploadController is not initialized");
        }
    }

    private static void zza(zzfn.zzk.zza zza2, zzin zzin2) {
        if (!zzin2.zzi()) {
            zza2.zzq();
            zza2.zzn();
            zza2.zzk();
        }
        if (!zzin2.zzj()) {
            zza2.zzh();
            zza2.zzr();
        }
    }

    @WorkerThread
    private final void zzaa() {
        this.zzl().zzt();
        if (this.zzu || this.zzv || this.zzw) {
            this.zzj().zzp().zza("Not stopping services. fetch, network, upload", (Object)this.zzu, (Object)this.zzv, (Object)this.zzw);
            return;
        }
        this.zzj().zzp().zza("Stopping uploading service(s)");
        if (this.zzq == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzq.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        ((List)Preconditions.checkNotNull(this.zzq)).clear();
    }

    final void zza(String string, zzfn.zzk.zza zza2) {
        int n;
        int n2;
        String string2;
        Set<String> set = this.zzi().zzg(string);
        if (set != null) {
            zza2.zzd(set);
        }
        if (this.zzi().zzq(string)) {
            zza2.zzj();
        }
        if (this.zzi().zzt(string) && !TextUtils.isEmpty((CharSequence)(string2 = zza2.zzy())) && (n2 = string2.indexOf(".")) != -1) {
            string2 = string2.substring(0, n2);
            zza2.zzo(string2);
        }
        if (this.zzi().zzu(string) && (n = zznl.zza(zza2, "_id")) != -1) {
            zza2.zzc(n);
        }
        if (this.zzi().zzs(string)) {
            zza2.zzk();
        }
        if (this.zzi().zzp(string)) {
            zza2.zzh();
            if (!com.google.android.gms.internal.measurement.zznk.zza() || !this.zze().zza(zzbf.zzcv) || this.zzb(string).zzj()) {
                zzb zzb2 = this.zzae.get(string);
                if (zzb2 == null || zzb2.zzb + this.zze().zzc(string, zzbf.zzau) < this.zzb().elapsedRealtime()) {
                    zzb2 = new zzb(this, null);
                    this.zzae.put(string, zzb2);
                }
                zza2.zzk(zzb2.zza);
            }
        }
        if (this.zzi().zzr(string)) {
            zza2.zzr();
        }
    }

    @WorkerThread
    private final void zzb(zzg zzg2) {
        this.zzl().zzt();
        if (TextUtils.isEmpty((CharSequence)zzg2.zzah()) && TextUtils.isEmpty((CharSequence)zzg2.zzaa())) {
            this.zza((String)Preconditions.checkNotNull((Object)zzg2.zzac()), 204, null, null, null);
            return;
        }
        Object object = zzg2;
        Object object2 = new Uri.Builder();
        String string = ((zzg)object).zzah();
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = ((zzg)object).zzaa();
        }
        Object object3 = string;
        object2.scheme((String)zzbf.zze.zza(null)).encodedAuthority((String)zzbf.zzf.zza(null)).path("config/app/" + (String)object3).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", "97001").appendQueryParameter("runtime_version", "0");
        String string2 = object2.build().toString();
        try {
            String string3 = (String)Preconditions.checkNotNull((Object)zzg2.zzac());
            URL uRL = new URL(string2);
            this.zzj().zzp().zza("Fetching remote configuration", (Object)string3);
            zzfi.zzd zzd2 = this.zzi().zzc(string3);
            ArrayMap arrayMap = null;
            String string4 = this.zzi().zze(string3);
            if (zzd2 != null) {
                String string5;
                if (!TextUtils.isEmpty((CharSequence)string4)) {
                    arrayMap = new ArrayMap();
                    arrayMap.put("If-Modified-Since", string4);
                }
                if (!TextUtils.isEmpty((CharSequence)(string5 = this.zzi().zzd(string3)))) {
                    if (arrayMap == null) {
                        arrayMap = new ArrayMap();
                    }
                    arrayMap.put("If-None-Match", string5);
                }
            }
            this.zzu = true;
            object3 = new zznd(this);
            string = arrayMap;
            object2 = uRL;
            object = string3;
            zzfz zzfz2 = this.zzh();
            zzfz2.zzt();
            zzfz2.zzal();
            Preconditions.checkNotNull((Object)object2);
            Preconditions.checkNotNull((Object)object3);
            zzfz2.zzl().zza((Runnable)new zzgd(zzfz2, (String)object, (URL)object2, null, (Map)((Object)string), (zzgc)object3));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzj().zzg().zza("Failed to parse config URL. Not fetching. appId", zzfw.zza((String)zzg2.zzac()), (Object)string2);
            return;
        }
    }

    @WorkerThread
    final void zza(zzg zzg2, zzfn.zzk.zza zza2) {
        Object object7;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        this.zzl().zzt();
        this.zzs();
        zzah zzah2 = com.google.android.gms.measurement.internal.zzah.zza(zza2.zzv());
        if (com.google.android.gms.internal.measurement.zzne.zza() && this.zze().zza(zzbf.zzcp)) {
            object6 = zzah2;
            object5 = zzg2.zzac();
            object4 = this;
            ((zznc)object4).zzl().zzt();
            ((zznc)object4).zzs();
            object3 = ((zznc)object4).zzb((String)object5);
            switch (object3.zzc()) {
                case zzb: {
                    ((zzah)object6).zza(zzin.zza.zza, zzak.zzi);
                    break;
                }
                case zzd: 
                case zzc: {
                    ((zzah)object6).zza(zzin.zza.zza, object3.zza());
                    break;
                }
                default: {
                    ((zzah)object6).zza(zzin.zza.zza, zzak.zzj);
                }
            }
            switch (object3.zzd()) {
                case zzb: {
                    ((zzah)object6).zza(zzin.zza.zzb, zzak.zzi);
                    break;
                }
                case zzd: 
                case zzc: {
                    ((zzah)object6).zza(zzin.zza.zzb, object3.zza());
                    break;
                }
                default: {
                    ((zzah)object6).zza(zzin.zza.zzb, zzak.zzj);
                    break;
                }
            }
        } else {
            object3 = zzah2;
            object5 = zzg2.zzac();
            object4 = this;
            ((zznc)object4).zzl().zzt();
            ((zznc)object4).zzs();
            object2 = ((zznc)object4).zzb((String)object5);
            if (object2.zze() != null) {
                ((zzah)object3).zza(zzin.zza.zza, object2.zza());
            } else {
                ((zzah)object3).zza(zzin.zza.zza, zzak.zzj);
            }
            if (object2.zzf() != null) {
                ((zzah)object3).zza(zzin.zza.zzb, object2.zza());
            } else {
                ((zzah)object3).zza(zzin.zza.zzb, zzak.zzj);
            }
        }
        object3 = zzah2;
        object6 = zza2;
        object5 = zzg2.zzac();
        object4 = this;
        ((zznc)object4).zzl().zzt();
        ((zznc)object4).zzs();
        object2 = ((zznc)object4).zza((String)object5, ((zznc)object4).zzd((String)object5), ((zznc)object4).zzb((String)object5), (zzah)object3);
        ((zzfn.zzk.zza)((Object)object6)).zzb((Boolean)Preconditions.checkNotNull((Object)object2.zzd()));
        if (!TextUtils.isEmpty((CharSequence)object2.zze())) {
            ((zzfn.zzk.zza)((Object)object6)).zzh(object2.zze());
        }
        object3 = zzah2;
        object6 = zza2;
        object5 = zzg2;
        object4 = this;
        ((zznc)object4).zzl().zzt();
        ((zznc)object4).zzs();
        object2 = null;
        for (Object object7 : ((zzfn.zzk.zza)((Object)object6)).zzab()) {
            if (!"_npa".equals(object7.zzg())) continue;
            object2 = object7;
            break;
        }
        if (object2 != null) {
            if (((zzah)object3).zza(zzin.zza.zzd) == zzak.zza) {
                zznq zznq2 = ((zznc)object4).zzf().zze(((zzg)object5).zzac(), "_npa");
                if (zznq2 != null) {
                    if ("tcf".equals(zznq2.zzb)) {
                        ((zzah)object3).zza(zzin.zza.zzd, zzak.zzh);
                    } else if ("app".equals(zznq2.zzb)) {
                        ((zzah)object3).zza(zzin.zza.zzd, zzak.zzf);
                    } else {
                        ((zzah)object3).zza(zzin.zza.zzd, zzak.zzd);
                    }
                } else {
                    object7 = ((zzg)object5).zzx();
                    if (object7 == null || object7 == Boolean.TRUE && ((zzfn.zzo)((Object)object2)).zzc() != 1L || object7 == Boolean.FALSE && ((zzfn.zzo)((Object)object2)).zzc() != 0L) {
                        ((zzah)object3).zza(zzin.zza.zzd, zzak.zzf);
                    } else {
                        ((zzah)object3).zza(zzin.zza.zzd, zzak.zzd);
                    }
                }
            }
        } else {
            int n = ((zznc)object4).zza(((zzg)object5).zzac(), (zzah)object3);
            ((zzfn.zzk.zza)((Object)object6)).zza((zzfn.zzo)((zzjk)zzfn.zzo.zze().zza("_npa").zzb(((zznc)object4).zzb().currentTimeMillis()).zza(n).zzai()));
            ((zznc)object4).zzj().zzp().zza("Setting user property", (Object)"non_personalized_ads(_npa)", (Object)n);
        }
        zza2.zzf(zzah2.toString());
        boolean bl = this.zzb.zzn(zzg2.zzac());
        object4 = zza2;
        object3 = ((zzfn.zzk.zza)((Object)object4)).zzaa();
        for (int i = 0; i < object3.size(); ++i) {
            if (!"_tcf".equals(((zzfn.zzf)((Object)object3.get(i))).zzg())) continue;
            zzfn.zzf.zza zza3 = (zzfn.zzf.zza)((zzfn.zzf)((Object)object3.get(i))).zzcc();
            object7 = zza3.zzf();
            for (int j = 0; j < object7.size(); ++j) {
                if (!"_tcfd".equals(((zzfn.zzh)((Object)object7.get(j))).zzg())) continue;
                String string = zzms.zza((String)((zzfn.zzh)((Object)object7.get(j))).zzh(), (boolean)bl);
                zza3.zza(j, zzfn.zzh.zze().zza("_tcfd").zzb(string));
                break;
            }
            ((zzfn.zzk.zza)((Object)object4)).zza(i, zza3);
            return;
        }
    }

    @VisibleForTesting
    private static void zza(zzfn.zzf.zza zza2, int n, String string) {
        List<zzfn.zzh> list = zza2.zzf();
        for (int i = 0; i < list.size(); ++i) {
            if (!"_err".equals(list.get(i).zzg())) continue;
            return;
        }
        zzfn.zzh zzh2 = (zzfn.zzh)((zzjk)zzfn.zzh.zze().zza("_err").zza(n).zzai());
        zzfn.zzh zzh3 = (zzfn.zzh)((zzjk)zzfn.zzh.zze().zza("_ev").zzb(string).zzai());
        zza2.zza(zzh2).zza(zzh3);
    }

    @WorkerThread
    final void zza(zzbd zzbd2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzo2);
        Preconditions.checkNotEmpty((String)zzo2.zza);
        this.zzl().zzt();
        this.zzs();
        String string = zzo2.zza;
        long l = zzbd2.zzd;
        zzga zzga2 = zzga.zza((zzbd)zzbd2);
        String string2 = string;
        zzil zzil2 = this;
        zzil2.zzl().zzt();
        zznp.zza(zzil2.zzaf == null || zzil2.zzag == null || !zzil2.zzag.equals(string2) ? null : zzil2.zzaf, (Bundle)zzga2.zzb, (boolean)false);
        zzbd2 = zzga2.zza();
        this.zzp();
        if (!zznl.zza(zzbd2, zzo2)) {
            return;
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        if (zzo2.zzs != null) {
            if (zzo2.zzs.contains(zzbd2.zza)) {
                Bundle bundle = zzbd2.zzb.zzb();
                bundle.putLong("ga_safelisted", 1L);
                zzbd2 = new zzbd(zzbd2.zza, new zzbc(bundle), zzbd2.zzc, zzbd2.zzd);
            } else {
                this.zzj().zzc().zza("Dropping non-safelisted event. appId, event name, origin", (Object)string, (Object)zzbd2.zza, (Object)zzbd2.zzc);
                return;
            }
        }
        this.zzf().zzp();
        try {
            zzae zzae2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string3;
            List list3;
            long l2 = l;
            string2 = string;
            zzil2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            zzil2.zzt();
            zzil2.zzal();
            if (l2 < 0L) {
                zzil2.zzj().zzu().zza("Invalid time querying timed out conditional properties", zzfw.zza((String)string2), (Object)l2);
                list3 = Collections.emptyList();
            } else {
                string3 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string2, String.valueOf(l2)};
                list3 = zzil2.zza(string3, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzj().zzp().zza("User property timed out", (Object)((zzae)object22).zza, (Object)this.zzm.zzk().zzc(((zzae)object22).zzc.zza), ((zzae)object22).zzc.zza());
                if (((zzae)object22).zzg != null) {
                    this.zzc(new zzbd(((zzae)object22).zzg, l), zzo2);
                }
                this.zzf().zza(string, ((zzae)object22).zzc.zza);
            }
            l2 = l;
            string2 = string;
            zzil2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            zzil2.zzt();
            zzil2.zzal();
            if (l2 < 0L) {
                zzil2.zzj().zzu().zza("Invalid time querying expired conditional properties", zzfw.zza((String)string2), (Object)l2);
                list2 = Collections.emptyList();
            } else {
                string3 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string2, String.valueOf(l2)};
                list2 = zzil2.zza(string3, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzae)object4.next();
                if (object == null) continue;
                this.zzj().zzp().zza("User property expired", (Object)((zzae)object).zza, (Object)this.zzm.zzk().zzc(((zzae)object).zzc.zza), ((zzae)object).zzc.zza());
                this.zzf().zzh(string, ((zzae)object).zzc.zza);
                if (((zzae)object).zzk != null) {
                    object22.add(((zzae)object).zzk);
                }
                this.zzf().zza(string, ((zzae)object).zzc.zza);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzbd)e;
                this.zzc(new zzbd((zzbd)object, l), zzo2);
            }
            long l3 = l;
            String string4 = zzbd2.zza;
            string2 = string;
            zzil2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            Preconditions.checkNotEmpty((String)string4);
            zzil2.zzt();
            zzil2.zzal();
            if (l3 < 0L) {
                zzil2.zzj().zzu().zza("Invalid time querying triggered conditional properties", zzfw.zza((String)string2), (Object)zzil2.zzi().zza(string4), (Object)l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string2, string4, String.valueOf(l3)};
                list = zzil2.zza((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzae2 = (zzae)iterator.next();
                if (zzae2 == null) continue;
                zzno zzno2 = zzae2.zzc;
                zznq zznq2 = new zznq((String)Preconditions.checkNotNull((Object)zzae2.zza), zzae2.zzb, zzno2.zza, l, Preconditions.checkNotNull((Object)zzno2.zza()));
                if (this.zzf().zza(zznq2)) {
                    this.zzj().zzp().zza("User property triggered", (Object)zzae2.zza, (Object)this.zzm.zzk().zzc(zznq2.zzc), zznq2.zze);
                } else {
                    this.zzj().zzg().zza("Too many active user properties, ignoring", zzfw.zza((String)zzae2.zza), (Object)this.zzm.zzk().zzc(zznq2.zzc), zznq2.zze);
                }
                if (zzae2.zzi != null) {
                    object.add(zzae2.zzi);
                }
                zzae2.zzc = new zzno(zznq2);
                zzae2.zze = true;
                this.zzf().zza(zzae2);
            }
            this.zzc(zzbd2, zzo2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzae2 = (zzbd)e;
                this.zzc(new zzbd((zzbd)zzae2, l), zzo2);
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @WorkerThread
    final void zza(zzbd zzbd2, String string) {
        zzg zzg2 = this.zzf().zze(string);
        if (zzg2 == null || TextUtils.isEmpty((CharSequence)zzg2.zzaf())) {
            this.zzj().zzc().zza("No app data available; dropping event", (Object)string);
            return;
        }
        Boolean bl = this.zza(zzg2);
        if (bl == null) {
            if (!"_ui".equals(zzbd2.zza)) {
                this.zzj().zzu().zza("Could not find package. appId", zzfw.zza((String)string));
            }
        } else if (!bl.booleanValue()) {
            this.zzj().zzg().zza("App version does not match; dropping event. appId", zzfw.zza((String)string));
            return;
        }
        zzo zzo2 = new zzo(string, zzg2.zzah(), zzg2.zzaf(), zzg2.zze(), zzg2.zzae(), zzg2.zzq(), zzg2.zzn(), null, zzg2.zzar(), false, zzg2.zzag(), zzg2.zzd(), 0L, 0, zzg2.zzaq(), false, zzg2.zzaa(), zzg2.zzx(), zzg2.zzo(), zzg2.zzan(), null, this.zzb(string).zzh(), "", null, zzg2.zzat(), zzg2.zzw(), this.zzb(string).zza(), this.zzd(string).zzf(), zzg2.zza(), zzg2.zzf(), zzg2.zzam(), zzg2.zzak());
        this.zzb(zzbd2, zzo2);
    }

    @WorkerThread
    private final void zzb(zzbd zzbd2, zzo zzo2) {
        String string;
        Preconditions.checkNotEmpty((String)zzo2.zza);
        zzga zzga2 = zzga.zza((zzbd)zzbd2);
        this.zzq().zza(zzga2.zzb, this.zzf().zzd(zzo2.zza));
        this.zzq().zza(zzga2, this.zze().zzb(zzo2.zza));
        zzbd2 = zzga2.zza();
        zzo zzo3 = zzo2;
        zzbd zzbd3 = zzbd2;
        zznc zznc2 = this;
        if ("_cmp".equals(zzbd3.zza) && "referrer API v2".equals(zzbd3.zzb.zzd("_cis")) && !TextUtils.isEmpty((CharSequence)(string = zzbd3.zzb.zzd("gclid")))) {
            zzno zzno2 = new zzno("_lgclid", zzbd3.zzd, (Object)string, "auto");
            zznc2.zza(zzno2, zzo3);
        }
        this.zza(zzbd2, zzo2);
    }

    @VisibleForTesting
    private final void zza(zzfn.zzk.zza zza2, long l, boolean bl) {
        zznq zznq2;
        String string = "_lte";
        if (bl) {
            string = "_se";
        }
        zznq2 = (zznq2 = this.zzf().zze(zza2.zzt(), string)) == null || zznq2.zze == null ? new zznq(zza2.zzt(), "auto", string, this.zzb().currentTimeMillis(), (Object)l) : new zznq(zza2.zzt(), "auto", string, this.zzb().currentTimeMillis(), (Object)((Long)zznq2.zze + l));
        zzfn.zzo zzo2 = (zzfn.zzo)((zzjk)zzfn.zzo.zze().zza(string).zzb(this.zzb().currentTimeMillis()).zza((Long)zznq2.zze).zzai());
        boolean bl2 = false;
        int n = zznl.zza(zza2, string);
        if (n >= 0) {
            zza2.zza(n, zzo2);
            bl2 = true;
        }
        if (!bl2) {
            zza2.zza(zzo2);
        }
        if (l > 0L) {
            this.zzf().zza(zznq2);
            String string2 = "lifetime";
            if (bl) {
                string2 = "session-scoped";
            }
            this.zzj().zzp().zza("Updated engagement user property. scope, value", (Object)string2, zznq2.zze);
        }
    }

    final void zzt() {
        ++this.zzt;
    }

    @VisibleForTesting
    @WorkerThread
    final void zza(String string, int n, @Nullable Throwable throwable, byte @Nullable [] byArray, @Nullable Map<String, List<String>> map) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotEmpty((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzj().zzp().zza("onConfigFetched. Response size", (Object)byArray.length);
            this.zzf().zzp();
            try {
                boolean bl;
                zzg zzg2 = this.zzf().zze(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzg2 == null) {
                    this.zzj().zzu().zza("App does not exist in onConfigFetched. appId", zzfw.zza((String)string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = list != null && !list.isEmpty() ? list.get(0) : null;
                    List<String> list2 = map != null ? map.get("ETag") : null;
                    String string4 = string2 = list2 != null && !list2.isEmpty() ? list2.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzi().zzc(string) == null && !this.zzi().zza(string, null, null, null) : !this.zzi().zza(string, byArray, string3, string2)) {
                        return;
                    }
                    zzg2.zzd(this.zzb().currentTimeMillis());
                    this.zzf().zza(zzg2, false, false);
                    if (n == 404) {
                        this.zzj().zzv().zza("Config not found. Using empty config. appId", (Object)string);
                    } else {
                        this.zzj().zzp().zza("Successfully fetched config. Got network response. code, size", (Object)n, (Object)byArray.length);
                    }
                    if (this.zzh().zzu() && this.zzac()) {
                        this.zzw();
                    } else {
                        this.zzab();
                    }
                } else {
                    zzg2.zzm(this.zzb().currentTimeMillis());
                    this.zzf().zza(zzg2, false, false);
                    this.zzj().zzp().zza("Fetching config failed. code, error", (Object)n, (Object)throwable);
                    this.zzi().zzi(string);
                    this.zzj.zzd.zza(this.zzb().currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzj.zzb.zza(this.zzb().currentTimeMillis());
                    }
                    this.zzab();
                }
                this.zzf().zzw();
            }
            finally {
                this.zzf().zzu();
            }
            return;
        }
        finally {
            this.zzu = false;
            this.zzaa();
        }
    }

    final void zza(boolean bl) {
        this.zzab();
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(boolean bl, int n, @Nullable Throwable throwable, byte @Nullable [] byArray, String string) {
        this.zzl().zzt();
        this.zzs();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List list = (List)Preconditions.checkNotNull(this.zzz);
            this.zzz = null;
            if (com.google.android.gms.internal.measurement.zznl.zza() && this.zze().zza(zzbf.zzck) && !bl || (n == 200 || n == 204) && throwable == null) {
                try {
                    if (!com.google.android.gms.internal.measurement.zznl.zza() || !this.zze().zza(zzbf.zzck) || bl) {
                        this.zzj.zzc.zza(this.zzb().currentTimeMillis());
                    }
                    this.zzj.zzd.zza(0L);
                    this.zzab();
                    if (!com.google.android.gms.internal.measurement.zznl.zza() || !this.zze().zza(zzbf.zzck) || bl) {
                        this.zzj().zzp().zza("Successful upload. Got network response. code, size", (Object)n, (Object)byArray.length);
                    } else if (com.google.android.gms.internal.measurement.zznl.zza() && this.zze().zza(zzbf.zzck)) {
                        this.zzj().zzp().zza("Purged empty bundles");
                    }
                    this.zzf().zzp();
                    try {
                        for (Long l : list) {
                            try {
                                long l2 = l;
                                zzal zzal2 = this.zzf();
                                zzal2.zzt();
                                zzal2.zzal();
                                SQLiteDatabase sQLiteDatabase = zzal2.e_();
                                String[] stringArray = new String[]{String.valueOf(l2)};
                                try {
                                    if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                    throw new SQLiteException("Deleted fewer rows from queue than expected");
                                }
                                catch (SQLiteException sQLiteException) {
                                    zzal2.zzj().zzg().zza("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                    throw sQLiteException;
                                }
                            }
                            catch (SQLiteException sQLiteException) {
                                if (this.zzaa != null && this.zzaa.contains(l)) continue;
                                throw sQLiteException;
                            }
                        }
                        this.zzf().zzw();
                    }
                    finally {
                        this.zzf().zzu();
                    }
                    this.zzaa = null;
                    if (this.zzh().zzu() && this.zzac()) {
                        this.zzw();
                    } else {
                        this.zzab = -1L;
                        this.zzab();
                    }
                    this.zzp = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzj().zzg().zza("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzp = this.zzb().elapsedRealtime();
                    this.zzj().zzp().zza("Disable upload, time", (Object)this.zzp);
                }
            } else {
                this.zzj().zzp().zza("Network upload failed. Will retry later. code, error", (Object)n, (Object)throwable);
                this.zzj.zzd.zza(this.zzb().currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzj.zzb.zza(this.zzb().currentTimeMillis());
                }
                this.zzf().zza(list);
                this.zzab();
            }
            return;
        }
        finally {
            this.zzv = false;
            this.zzaa();
        }
    }

    @WorkerThread
    final void zzb(zzg zzg2, zzfn.zzk.zza zza2) {
        this.zzl().zzt();
        this.zzs();
        zzfn.zza.zza zza3 = zzfn.zza.zzc();
        byte[] byArray = zzg2.zzav();
        if (byArray != null) {
            try {
                zza3 = zznl.zza(zza3, byArray);
            }
            catch (zzjs zzjs2) {
                this.zzj().zzu().zza("Failed to parse locally stored ad campaign info. appId", zzfw.zza((String)zzg2.zzac()));
            }
        }
        for (zzfn.zzf zzf2 : zza2.zzaa()) {
            if (!zzf2.zzg().equals("_cmp")) continue;
            zzfn.zzf zzf3 = zzf2;
            zzfn.zza.zza zza4 = zza3;
            zznc zznc2 = this;
            String string = (String)zznl.zza(zzf3, "gclid", (Object)"");
            String string2 = (String)zznl.zza(zzf3, "gbraid", (Object)"");
            String string3 = (String)zznl.zza(zzf3, "gad_source", (Object)"");
            if (string.isEmpty() && string2.isEmpty() & string3.isEmpty()) continue;
            long l = (Long)zznl.zza(zzf3, "click_timestamp", (Object)0L);
            if (l <= 0L) {
                l = zzf3.zzd();
            }
            if ("referrer API v2".equals(zznl.zzb(zzf3, "_cis"))) {
                if (!(l > zza4.zzb())) continue;
                if (string.isEmpty()) {
                    zza4.zzh();
                } else {
                    zza4.zzf(string);
                }
                if (string2.isEmpty()) {
                    zza4.zzg();
                } else {
                    zza4.zze(string2);
                }
                if (string3.isEmpty()) {
                    zza4.zzf();
                } else {
                    zza4.zzd(string3);
                }
                zza4.zzb(l);
                continue;
            }
            if (!(l > zza4.zza())) continue;
            if (string.isEmpty()) {
                zza4.zze();
            } else {
                zza4.zzc(string);
            }
            if (string2.isEmpty()) {
                zza4.zzd();
            } else {
                zza4.zzb(string2);
            }
            if (string3.isEmpty()) {
                zza4.zzc();
            } else {
                zza4.zza(string3);
            }
            zza4.zza(l);
        }
        if (!((zzfn.zza)((zzjk)zza3.zzai())).equals((Object)zzfn.zza.zze())) {
            zza2.zza((zzfn.zza)((zzjk)zza3.zzai()));
        }
        zzg2.zza(((zzfn.zza)((zzjk)zza3.zzai())).zzbz());
        if (zzg2.zzas()) {
            this.zzf().zza(zzg2, false, false);
        }
    }

    @WorkerThread
    final void zzc(zzo zzo2) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotNull((Object)zzo2);
        Preconditions.checkNotEmpty((String)zzo2.zza);
        if (!zznc.zzh(zzo2)) {
            return;
        }
        zzg zzg2 = this.zzf().zze(zzo2.zza);
        if (zzg2 != null && TextUtils.isEmpty((CharSequence)zzg2.zzah()) && !TextUtils.isEmpty((CharSequence)zzo2.zzb)) {
            zzg2.zzd(0L);
            this.zzf().zza(zzg2, false, false);
            this.zzi().zzj(zzo2.zza);
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        long l = zzo2.zzl;
        if (l == 0L) {
            l = this.zzb().currentTimeMillis();
        }
        this.zzm.zzg().zzm();
        int n = zzo2.zzm;
        if (n != 0 && n != 1) {
            this.zzj().zzu().zza("Incorrect app type, assuming installed app. appId, appType", zzfw.zza((String)zzo2.zza), (Object)n);
            n = 0;
        }
        this.zzf().zzp();
        try {
            Object object;
            Bundle bundle;
            String string;
            Object object2;
            SQLiteDatabase sQLiteDatabase;
            zzal zzal2;
            String string2;
            zzno zzno2;
            zznq zznq2 = this.zzf().zze(zzo2.zza, "_npa");
            Boolean bl = this.zzg(zzo2);
            if (zznq2 == null || "auto".equals(zznq2.zzb)) {
                if (bl != null) {
                    zzno2 = new zzno("_npa", l, (Object)(bl != false ? 1L : 0L), "auto");
                    if (zznq2 == null || !zznq2.zze.equals(zzno2.zzc)) {
                        this.zza(zzno2, zzo2);
                    }
                } else if (zznq2 != null) {
                    this.zza("_npa", zzo2);
                }
            }
            long l2 = l;
            zzo zzo3 = zzo2;
            zznc zznc2 = this;
            Object object3 = zznc2.zzf().zze((String)Preconditions.checkNotNull((Object)zzo3.zza));
            if (object3 != null) {
                zznc2.zzq();
                if (zznp.zza((String)zzo3.zzb, (String)((zzg)object3).zzah(), (String)zzo3.zzp, (String)((zzg)object3).zzaa())) {
                    zznc2.zzj().zzu().zza("New GMP App Id passed in. Removing cached database data. appId", zzfw.zza((String)((zzg)object3).zzac()));
                    string2 = ((zzg)object3).zzac();
                    zzal2 = zznc2.zzf();
                    zzal2.zzal();
                    zzal2.zzt();
                    Preconditions.checkNotEmpty((String)string2);
                    try {
                        sQLiteDatabase = zzal2.e_();
                        object2 = new String[]{string2};
                        int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", object2) + sQLiteDatabase.delete("user_attributes", "app_id=?", object2) + sQLiteDatabase.delete("conditional_properties", "app_id=?", object2) + sQLiteDatabase.delete("apps", "app_id=?", object2) + sQLiteDatabase.delete("raw_events", "app_id=?", object2) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", object2) + sQLiteDatabase.delete("event_filters", "app_id=?", object2) + sQLiteDatabase.delete("property_filters", "app_id=?", object2) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", object2) + sQLiteDatabase.delete("consent_settings", "app_id=?", object2) + sQLiteDatabase.delete("default_event_params", "app_id=?", object2) + sQLiteDatabase.delete("trigger_uris", "app_id=?", object2);
                        if (n2 > 0) {
                            zzal2.zzj().zzp().zza("Deleted application data. app, records", (Object)string2, (Object)n2);
                        }
                    }
                    catch (SQLiteException sQLiteException) {
                        zzal2.zzj().zzg().zza("Error deleting application data. appId, error", zzfw.zza((String)string2), (Object)sQLiteException);
                    }
                    object3 = null;
                }
            }
            if (object3 != null) {
                boolean bl2 = ((zzg)object3).zze() != Integer.MIN_VALUE && ((zzg)object3).zze() != zzo3.zzj;
                string = ((zzg)object3).zzaf();
                if (bl2 | (((zzg)object3).zze() == Integer.MIN_VALUE && string != null && !string.equals(zzo3.zzc))) {
                    bundle = new Bundle();
                    bundle.putString("_pv", string);
                    object = new zzbd("_au", new zzbc(bundle), "auto", l2);
                    zznc2.zza((zzbd)object, zzo3);
                }
            }
            this.zza(zzo2);
            zzno2 = null;
            if (n == 0) {
                zzno2 = this.zzf().zzd(zzo2.zza, "_f");
            } else if (n == 1) {
                zzno2 = this.zzf().zzd(zzo2.zza, "_v");
            }
            if (zzno2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    zzno zzno3 = new zzno("_fot", l, (Object)l3, "auto");
                    this.zza(zzno3, zzo2);
                    zzo3 = zzo2;
                    zznc2 = this;
                    zznc2.zzl().zzt();
                    String string3 = zzo3.zza;
                    zzgq zzgq2 = (zzgq)Preconditions.checkNotNull((Object)zznc2.zzl);
                    if (string3 == null || string3.isEmpty()) {
                        zzgq2.zza.zzj().zzw().zza("Install Referrer Reporter was called with invalid app package name");
                    } else {
                        zzgq2.zza.zzl().zzt();
                        if (!zzgq2.zza()) {
                            zzgq2.zza.zzj().zzn().zza("Install Referrer Reporter is not available");
                        } else {
                            zzgp zzgp2 = new zzgp(zzgq2, string3);
                            object3 = zzgq2;
                            ((zzgq)object3).zza.zzl().zzt();
                            string = new Intent("com.google.android.finsky.BIND_GET_INSTALL_REFERRER_SERVICE");
                            string.setComponent(new ComponentName("com.android.vending", "com.google.android.finsky.externalreferrer.GetInstallReferrerService"));
                            bundle = ((zzgq)object3).zza.zza().getPackageManager();
                            if (bundle == null) {
                                ((zzgq)object3).zza.zzj().zzw().zza("Failed to obtain Package Manager to verify binding conditions for Install Referrer");
                            } else {
                                object = bundle.queryIntentServices((Intent)string, 0);
                                if (object != null && !object.isEmpty()) {
                                    zzal2 = (ResolveInfo)object.get(0);
                                    if (((ResolveInfo)zzal2).serviceInfo != null) {
                                        string2 = ((ResolveInfo)zzal2).serviceInfo.packageName;
                                        if (((ResolveInfo)zzal2).serviceInfo.name != null && "com.android.vending".equals(string2) && ((zzgq)object3).zza()) {
                                            Intent intent = new Intent((Intent)string);
                                            try {
                                                boolean bl3 = ConnectionTracker.getInstance().bindService(((zzgq)object3).zza.zza(), intent, (ServiceConnection)zzgp2, 1);
                                                ((zzgq)object3).zza.zzj().zzp().zza("Install Referrer Service is", (Object)(bl3 ? "available" : "not available"));
                                            }
                                            catch (RuntimeException runtimeException) {
                                                ((zzgq)object3).zza.zzj().zzg().zza("Exception occurred while binding to Install Referrer Service", (Object)runtimeException.getMessage());
                                            }
                                        } else {
                                            ((zzgq)object3).zza.zzj().zzu().zza("Play Store version 8.3.73 or higher required for Install Referrer");
                                        }
                                    }
                                } else {
                                    ((zzgq)object3).zza.zzj().zzn().zza("Play Service for fetching Install Referrer is unavailable on device");
                                }
                            }
                        }
                    }
                    long l4 = l;
                    zzo3 = zzo2;
                    zznc2 = this;
                    zznc2.zzl().zzt();
                    zznc2.zzs();
                    object3 = new Bundle();
                    object3.putLong("_c", 1L);
                    object3.putLong("_r", 1L);
                    object3.putLong("_uwa", 0L);
                    object3.putLong("_pfo", 0L);
                    object3.putLong("_sys", 0L);
                    object3.putLong("_sysu", 0L);
                    object3.putLong("_et", 1L);
                    if (zzo3.zzo) {
                        object3.putLong("_dac", 1L);
                    }
                    String string4 = (String)Preconditions.checkNotNull((Object)zzo3.zza);
                    object2 = string4;
                    zzal zzal3 = zznc2.zzf();
                    Preconditions.checkNotEmpty((String)object2);
                    zzal3.zzt();
                    zzal3.zzal();
                    long l5 = zzal3.zzb((String)object2, "first_open_count");
                    if (zznc2.zzm.zza().getPackageManager() == null) {
                        zznc2.zzj().zzg().zza("PackageManager is null, first open report might be inaccurate. appId", zzfw.zza((String)string4));
                    } else {
                        zzal2 = null;
                        try {
                            zzal2 = Wrappers.packageManager((Context)zznc2.zzm.zza()).getPackageInfo(string4, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zznc2.zzj().zzg().zza("Package info is null, first open report might be inaccurate. appId", zzfw.zza((String)string4), (Object)nameNotFoundException);
                        }
                        if (zzal2 != null && ((PackageInfo)zzal2).firstInstallTime != 0L) {
                            boolean bl4 = false;
                            if (((PackageInfo)zzal2).firstInstallTime != ((PackageInfo)zzal2).lastUpdateTime) {
                                if (zznc2.zze().zza(zzbf.zzbn)) {
                                    if (l5 == 0L) {
                                        object3.putLong("_uwa", 1L);
                                    }
                                } else {
                                    object3.putLong("_uwa", 1L);
                                }
                            } else {
                                bl4 = true;
                            }
                            sQLiteDatabase = new zzno("_fi", l4, (Object)(bl4 ? 1L : 0L), "auto");
                            zznc2.zza((zzno)sQLiteDatabase, zzo3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = Wrappers.packageManager((Context)zznc2.zzm.zza()).getApplicationInfo(string4, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zznc2.zzj().zzg().zza("Application info is null, first open report might be inaccurate. appId", zzfw.zza((String)string4), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                object3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                object3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    if (l5 >= 0L) {
                        object3.putLong("_pfo", l5);
                    }
                    zzal2 = new zzbd("_f", new zzbc((Bundle)object3), "auto", l4);
                    zznc2.zzb((zzbd)zzal2, zzo3);
                } else if (n == 1) {
                    zzno zzno4 = new zzno("_fvt", l, (Object)l3, "auto");
                    this.zza(zzno4, zzo2);
                    l2 = l;
                    zzo3 = zzo2;
                    zznc2 = this;
                    zznc2.zzl().zzt();
                    zznc2.zzs();
                    object3 = new Bundle();
                    object3.putLong("_c", 1L);
                    object3.putLong("_r", 1L);
                    object3.putLong("_et", 1L);
                    if (zzo3.zzo) {
                        object3.putLong("_dac", 1L);
                    }
                    zzbd zzbd2 = new zzbd("_v", new zzbc((Bundle)object3), "auto", l2);
                    zznc2.zzb(zzbd2, zzo3);
                }
            } else if (zzo2.zzi) {
                l2 = l;
                zzo3 = zzo2;
                zznc2 = this;
                object3 = new Bundle();
                zzbd zzbd3 = new zzbd("_cd", new zzbc((Bundle)object3), "auto", l2);
                zznc2.zzb(zzbd3, zzo3);
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    final void zzu() {
        ++this.zzs;
    }

    @WorkerThread
    final void zza(zzae zzae2) {
        zzo zzo2 = this.zzc((String)Preconditions.checkNotNull((Object)zzae2.zza));
        if (zzo2 != null) {
            this.zza(zzae2, zzo2);
        }
    }

    @WorkerThread
    final void zza(zzae zzae2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzae2);
        Preconditions.checkNotEmpty((String)zzae2.zza);
        Preconditions.checkNotNull((Object)zzae2.zzc);
        Preconditions.checkNotEmpty((String)zzae2.zzc.zza);
        this.zzl().zzt();
        this.zzs();
        if (!zznc.zzh(zzo2)) {
            return;
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        this.zzf().zzp();
        try {
            this.zza(zzo2);
            String string = (String)Preconditions.checkNotNull((Object)zzae2.zza);
            zzae zzae3 = this.zzf().zzc(string, zzae2.zzc.zza);
            if (zzae3 != null) {
                this.zzj().zzc().zza("Removing conditional user property", (Object)zzae2.zza, (Object)this.zzm.zzk().zzc(zzae2.zzc.zza));
                this.zzf().zza(string, zzae2.zzc.zza);
                if (zzae3.zze) {
                    this.zzf().zzh(string, zzae2.zzc.zza);
                }
                if (zzae2.zzk != null) {
                    Bundle bundle = null;
                    if (zzae2.zzk.zzb != null) {
                        bundle = zzae2.zzk.zzb.zzb();
                    }
                    zzbd zzbd2 = this.zzq().zza(string, ((zzbd)Preconditions.checkNotNull((Object)zzae2.zzk)).zza, bundle, zzae3.zzb, zzae2.zzk.zzd, true, true);
                    this.zzc((zzbd)Preconditions.checkNotNull((Object)zzbd2), zzo2);
                }
            } else {
                this.zzj().zzu().zza("Conditional user property doesn't exist", zzfw.zza((String)zzae2.zza), (Object)this.zzm.zzk().zzc(zzae2.zzc.zza));
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @VisibleForTesting
    private static void zza(zzfn.zzf.zza zza2, @NonNull String string) {
        List<zzfn.zzh> list = zza2.zzf();
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(list.get(i).zzg())) continue;
            zza2.zza(i);
            return;
        }
    }

    @WorkerThread
    final void zza(String string, zzo zzo2) {
        this.zzl().zzt();
        this.zzs();
        if (!zznc.zzh(zzo2)) {
            return;
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        Boolean bl = this.zzg(zzo2);
        if ("_npa".equals(string) && bl != null) {
            this.zzj().zzc().zza("Falling back to manifest metadata value for ad personalization");
            zzno zzno2 = new zzno("_npa", this.zzb().currentTimeMillis(), (Object)(bl != false ? 1L : 0L), "auto");
            this.zza(zzno2, zzo2);
            return;
        }
        this.zzj().zzc().zza("Removing user property", (Object)this.zzm.zzk().zzc(string));
        this.zzf().zzp();
        try {
            this.zza(zzo2);
            if ("_id".equals(string)) {
                this.zzf().zzh((String)Preconditions.checkNotNull((Object)zzo2.zza), "_lair");
            }
            this.zzf().zzh((String)Preconditions.checkNotNull((Object)zzo2.zza), string);
            this.zzf().zzw();
            this.zzj().zzc().zza("User property removed", (Object)this.zzm.zzk().zzc(string));
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @VisibleForTesting(otherwise=4)
    @WorkerThread
    final void zzd(zzo zzo2) {
        if (this.zzz != null) {
            this.zzaa = new ArrayList<Long>();
            this.zzaa.addAll(this.zzz);
        }
        String string = (String)Preconditions.checkNotNull((Object)zzo2.zza);
        zzal zzal2 = this.zzf();
        Preconditions.checkNotEmpty((String)string);
        zzal2.zzt();
        zzal2.zzal();
        try {
            SQLiteDatabase sQLiteDatabase = zzal2.e_();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("events_snapshot", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("main_event_params", "app_id=?", stringArray) + sQLiteDatabase.delete("default_event_params", "app_id=?", stringArray) + sQLiteDatabase.delete("trigger_uris", "app_id=?", stringArray);
            if (n > 0) {
                zzal2.zzj().zzp().zza("Reset analytics data. app, records", (Object)string, (Object)n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzal2.zzj().zzg().zza("Error resetting analytics data. appId, error", zzfw.zza((String)string), (Object)sQLiteException);
        }
        if (zzo2.zzh) {
            this.zzc(zzo2);
        }
    }

    @WorkerThread
    final void zze(zzo zzo2) {
        boolean bl;
        zzim zzim2;
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotEmpty((String)zzo2.zza);
        zzav zzav2 = zzav.zza((String)zzo2.zzz);
        this.zzj().zzp().zza("Setting DMA consent for package", (Object)zzo2.zza, (Object)zzav2);
        zzav zzav3 = zzav2;
        String string = zzo2.zza;
        zznc zznc2 = this;
        zznc2.zzl().zzt();
        zznc2.zzs();
        zzim zzim3 = zzav.zza((Bundle)zznc2.zza(string), (int)100).zzc();
        zznc2.zzad.put(string, zzav3);
        zznc2.zzf().zza(string, zzav3);
        zzim zzim4 = zzim2 = zzav.zza((Bundle)zznc2.zza(string), (int)100).zzc();
        zzim zzim5 = zzim3;
        String string2 = string;
        zznc zznc3 = zznc2;
        zznc3.zzl().zzt();
        zznc3.zzs();
        boolean bl2 = zzim5 == zzim.zzc && zzim4 == zzim.zzd;
        boolean bl3 = bl = zzim5 == zzim.zzd && zzim4 == zzim.zzc;
        boolean bl4 = zznc3.zze().zza(zzbf.zzci) ? bl2 || bl : bl2;
        if (bl4) {
            zznc3.zzj().zzp().zza("Generated _dcu event for", (Object)string2);
            Bundle bundle = new Bundle();
            if (zznc3.zzf().zza((long)zznc3.zzx(), (String)string2, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false).zzf < (long)zznc3.zze().zzb(string2, zzbf.zzaw)) {
                bundle.putLong("_r", 1L);
                zzaq zzaq2 = zznc3.zzf().zza(zznc3.zzx(), string2, false, false, false, false, false, true);
                zznc3.zzj().zzp().zza("_dcu realtime event count", (Object)string2, (Object)zzaq2.zzf);
            }
            zznc3.zzah.zza(string2, "_dcu", bundle);
        }
    }

    @WorkerThread
    public final void zza(String string, @Nullable zzkp zzkp2) {
        this.zzl().zzt();
        if (this.zzag == null || this.zzag.equals(string) || zzkp2 != null) {
            this.zzag = string;
            this.zzaf = zzkp2;
        }
    }

    @WorkerThread
    final void zzf(zzo zzo2) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotEmpty((String)zzo2.zza);
        int n = zzo2.zzy;
        zzin zzin2 = zzin.zza((String)zzo2.zzt, (int)n);
        zzin zzin3 = this.zzb(zzo2.zza);
        this.zzj().zzp().zza("Setting storage consent for package", (Object)zzo2.zza, (Object)zzin2);
        this.zza(zzo2.zza, zzin2);
        if (!(com.google.android.gms.internal.measurement.zznk.zza() && this.zze().zza(zzbf.zzcv) || !zzin2.zzc(zzin3))) {
            this.zzd(zzo2);
        }
    }

    @VisibleForTesting
    private final void zza(List<Long> list) {
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0);
        if (this.zzz != null) {
            this.zzj().zzg().zza("Set uploading progress before finishing the previous upload");
            return;
        }
        this.zzz = new ArrayList<Long>(list);
    }

    @WorkerThread
    protected final void zzv() {
        this.zzl().zzt();
        this.zzf().zzv();
        zzal zzal2 = this.zzf();
        zzal2.zzt();
        zzal2.zzal();
        if (zzal2.zzaa() && (Long)zzbf.zzbf.zza(null) != 0L) {
            String[] stringArray;
            SQLiteDatabase sQLiteDatabase = zzal2.e_();
            int n = sQLiteDatabase.delete("trigger_uris", "abs(timestamp_millis - ?) > cast(? as integer)", stringArray = new String[]{String.valueOf(zzal2.zzb().currentTimeMillis()), String.valueOf(zzbf.zzbf.zza(null))});
            if (n > 0) {
                zzal2.zzj().zzp().zza("Deleted stale trigger uris. rowsDeleted", (Object)n);
            }
        }
        if (this.zzj.zzc.zza() == 0L) {
            this.zzj.zzc.zza(this.zzb().currentTimeMillis());
        }
        this.zzab();
    }

    @WorkerThread
    final void zzb(zzae zzae2) {
        zzo zzo2 = this.zzc((String)Preconditions.checkNotNull((Object)zzae2.zza));
        if (zzo2 != null) {
            this.zzb(zzae2, zzo2);
        }
    }

    @WorkerThread
    final void zzb(zzae zzae2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzae2);
        Preconditions.checkNotEmpty((String)zzae2.zza);
        Preconditions.checkNotNull((Object)zzae2.zzb);
        Preconditions.checkNotNull((Object)zzae2.zzc);
        Preconditions.checkNotEmpty((String)zzae2.zzc.zza);
        this.zzl().zzt();
        this.zzs();
        if (!zznc.zzh(zzo2)) {
            return;
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        zzae zzae3 = new zzae(zzae2);
        new zzae(zzae2).zze = false;
        this.zzf().zzp();
        try {
            boolean bl = false;
            zzae zzae4 = this.zzf().zzc((String)Preconditions.checkNotNull((Object)zzae3.zza), zzae3.zzc.zza);
            if (zzae4 != null && !zzae4.zzb.equals(zzae3.zzb)) {
                this.zzj().zzu().zza("Updating a conditional user property with different origin. name, origin, origin (from DB)", (Object)this.zzm.zzk().zzc(zzae3.zzc.zza), (Object)zzae3.zzb, (Object)zzae4.zzb);
            }
            if (zzae4 != null && zzae4.zze) {
                zzae3.zzb = zzae4.zzb;
                zzae3.zzd = zzae4.zzd;
                zzae3.zzh = zzae4.zzh;
                zzae3.zzf = zzae4.zzf;
                zzae3.zzi = zzae4.zzi;
                zzae3.zze = zzae4.zze;
                zzae3.zzc = new zzno(zzae3.zzc.zza, zzae4.zzc.zzb, zzae3.zzc.zza(), zzae4.zzc.zze);
            } else if (TextUtils.isEmpty((CharSequence)zzae3.zzf)) {
                zzae3.zzc = new zzno(zzae3.zzc.zza, zzae3.zzd, zzae3.zzc.zza(), zzae3.zzc.zze);
                zzae3.zze = true;
                bl = true;
            }
            if (zzae3.zze) {
                zzno zzno2 = zzae3.zzc;
                zznq zznq2 = new zznq((String)Preconditions.checkNotNull((Object)zzae3.zza), zzae3.zzb, zzno2.zza, zzno2.zzb, Preconditions.checkNotNull((Object)zzno2.zza()));
                if (this.zzf().zza(zznq2)) {
                    this.zzj().zzc().zza("User property updated immediately", (Object)zzae3.zza, (Object)this.zzm.zzk().zzc(zznq2.zzc), zznq2.zze);
                } else {
                    this.zzj().zzg().zza("(2)Too many active user properties, ignoring", zzfw.zza((String)zzae3.zza), (Object)this.zzm.zzk().zzc(zznq2.zzc), zznq2.zze);
                }
                if (bl && zzae3.zzi != null) {
                    zzbd zzbd2 = new zzbd(zzae3.zzi, zzae3.zzd);
                    this.zzc(zzbd2, zzo2);
                }
            }
            if (this.zzf().zza(zzae3)) {
                this.zzj().zzc().zza("Conditional property added", (Object)zzae3.zza, (Object)this.zzm.zzk().zzc(zzae3.zzc.zza), zzae3.zzc.zza());
            } else {
                this.zzj().zzg().zza("Too many conditional properties, ignoring", zzfw.zza((String)zzae3.zza), (Object)this.zzm.zzk().zzc(zzae3.zzc.zza), zzae3.zzc.zza());
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @WorkerThread
    private final void zzab() {
        long l;
        long l2;
        long l3;
        block19: {
            long l4;
            this.zzl().zzt();
            this.zzs();
            if (this.zzp > 0L) {
                l3 = this.zzb().elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzp);
                if (l2 > 0L) {
                    this.zzj().zzp().zza("Upload has been suspended. Will update scheduling later in approximately ms", (Object)l2);
                    this.zzy().zzb();
                    this.zzz().zzu();
                    return;
                }
                this.zzp = 0L;
            }
            if (!this.zzm.zzaf() || !this.zzac()) {
                this.zzj().zzp().zza("Nothing to upload or uploading impossible");
                this.zzy().zzb();
                this.zzz().zzu();
                return;
            }
            zznc zznc2 = this;
            long l5 = zznc2.zzb().currentTimeMillis();
            zznc2.zze();
            long l6 = Math.max(0L, (Long)zzbf.zzaa.zza(null));
            boolean bl = zznc2.zzf().zzz() || zznc2.zzf().zzy();
            if (bl) {
                String string = zznc2.zze().zzn();
                if (!TextUtils.isEmpty((CharSequence)string) && !".none.".equals(string)) {
                    zznc2.zze();
                    l4 = Math.max(0L, (Long)zzbf.zzv.zza(null));
                } else {
                    zznc2.zze();
                    l4 = Math.max(0L, (Long)zzbf.zzu.zza(null));
                }
            } else {
                zznc2.zze();
                l4 = Math.max(0L, (Long)zzbf.zzt.zza(null));
            }
            long l7 = zznc2.zzj.zzc.zza();
            long l8 = zznc2.zzj.zzd.zza();
            long l9 = zznc2.zzf().c_();
            long l10 = zznc2.zzf().d_();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l5 - Math.abs(l11 - l5);
                l7 = l5 - Math.abs(l7 - l5);
                l8 = l5 - Math.abs(l8 - l5);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l6;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l4;
                }
                if (!zznc2.zzp().zza(l12, l4)) {
                    l13 = l12 + l4;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    int n = 0;
                    while (true) {
                        zznc2.zze();
                        if (n >= Math.min(20, Math.max(0, (Integer)zzbf.zzac.zza(null)))) break;
                        long l15 = 1L << n;
                        zznc2.zze();
                        if ((l14 += Math.max(0L, (Long)zzbf.zzab.zza(null)) * l15) > l8) {
                            l = l14;
                            break block19;
                        }
                        ++n;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzj().zzp().zza("Next upload time is 0");
            this.zzy().zzb();
            this.zzz().zzu();
            return;
        }
        if (!this.zzh().zzu()) {
            this.zzj().zzp().zza("No network");
            this.zzy().zza();
            this.zzz().zzu();
            return;
        }
        l2 = this.zzj.zzb.zza();
        this.zze();
        long l16 = Math.max(0L, (Long)zzbf.zzr.zza(null));
        if (!this.zzp().zza(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzy().zzb();
        long l17 = l3 - this.zzb().currentTimeMillis();
        if (l17 <= 0L) {
            this.zze();
            l17 = Math.max(0L, (Long)zzbf.zzw.zza(null));
            this.zzj.zzc.zza(this.zzb().currentTimeMillis());
        }
        this.zzj().zzp().zza("Upload scheduled in approximately ms", (Object)l17);
        this.zzz().zza(l17);
    }

    @WorkerThread
    private final void zza(String string, zzin zzin2) {
        this.zzl().zzt();
        this.zzs();
        this.zzac.put(string, zzin2);
        this.zzf().zzb(string, zzin2);
    }

    @WorkerThread
    private final void zza(String string, boolean bl, @Nullable Long l, @Nullable Long l2) {
        zzg zzg2 = this.zzf().zze(string);
        if (zzg2 != null) {
            zzg2.zzd(bl);
            zzg2.zza(l);
            zzg2.zzb(l2);
            if (zzg2.zzas()) {
                this.zzf().zza(zzg2, false, false);
            }
        }
    }

    @WorkerThread
    final void zza(zzno zzno2, zzo zzo2) {
        this.zzl().zzt();
        this.zzs();
        if (!zznc.zzh(zzo2)) {
            return;
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        int n = this.zzq().zzb(zzno2.zza);
        if (n != 0) {
            this.zzq();
            String string = zzno2.zza;
            this.zze();
            String string2 = zznp.zza((String)string, (int)24, (boolean)true);
            int n2 = zzno2.zza != null ? zzno2.zza.length() : 0;
            this.zzq();
            zznp.zza((zznr)this.zzah, (String)zzo2.zza, (int)n, (String)"_ev", (String)string2, (int)n2);
            return;
        }
        n = this.zzq().zza(zzno2.zza, zzno2.zza());
        if (n != 0) {
            this.zzq();
            String string = zzno2.zza;
            this.zze();
            String string3 = zznp.zza((String)string, (int)24, (boolean)true);
            Object object = zzno2.zza();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzq();
            zznp.zza((zznr)this.zzah, (String)zzo2.zza, (int)n, (String)"_ev", (String)string3, (int)n3);
            return;
        }
        Object object = this.zzq().zzc(zzno2.zza, zzno2.zza());
        if (object == null) {
            return;
        }
        if ("_sid".equals(zzno2.zza)) {
            zzaz zzaz2;
            zzo zzo3 = zzo2;
            String string = zzno2.zze;
            long l = zzno2.zzb;
            zznc zznc2 = this;
            String string4 = (String)Preconditions.checkNotNull((Object)zzo3.zza);
            long l2 = 0L;
            zznq zznq2 = zznc2.zzf().zze(string4, "_sno");
            if (zznq2 != null && zznq2.zze instanceof Long) {
                l2 = (Long)zznq2.zze;
            } else {
                if (zznq2 != null) {
                    zznc2.zzj().zzu().zza("Retrieved last session number from database does not contain a valid (long) value", zznq2.zze);
                }
                if ((zzaz2 = zznc2.zzf().zzd(string4, "_s")) != null) {
                    l2 = zzaz2.zzc;
                    zznc2.zzj().zzp().zza("Backfill the session number. Last used session number", (Object)l2);
                }
            }
            zzaz2 = new zzno("_sno", l, (Object)(++l2), string);
            zznc2.zza((zzno)zzaz2, zzo3);
        }
        zznq zznq3 = new zznq((String)Preconditions.checkNotNull((Object)zzo2.zza), (String)Preconditions.checkNotNull((Object)zzno2.zze), zzno2.zza, zzno2.zzb, object);
        this.zzj().zzp().zza("Setting user property", (Object)this.zzm.zzk().zzc(zznq3.zzc), object);
        this.zzf().zzp();
        try {
            zznq zznq4;
            if ("_id".equals(zznq3.zzc) && (zznq4 = this.zzf().zze(zzo2.zza, "_id")) != null && !zznq3.zze.equals(zznq4.zze)) {
                this.zzf().zzh(zzo2.zza, "_lair");
            }
            this.zza(zzo2);
            boolean bl = this.zzf().zza(zznq3);
            if ("_sid".equals(zzno2.zza)) {
                long l = this.zzp().zza(zzo2.zzv);
                zzg zzg2 = this.zzf().zze(zzo2.zza);
                if (zzg2 != null) {
                    zzg2.zzs(l);
                    if (zzg2.zzas()) {
                        this.zzf().zza(zzg2, false, false);
                    }
                }
            }
            this.zzf().zzw();
            if (!bl) {
                this.zzj().zzg().zza("Too many unique user properties are set. Ignoring user property", (Object)this.zzm.zzk().zzc(zznq3.zzc), zznq3.zze);
                this.zzq();
                zznp.zza((zznr)this.zzah, (String)zzo2.zza, (int)9, null, null, (int)0);
            }
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @WorkerThread
    final void zzw() {
        this.zzl().zzt();
        this.zzs();
        this.zzw = true;
        try {
            String string;
            long l;
            long l2;
            Boolean bl = this.zzm.zzr().zzab();
            if (bl == null) {
                this.zzj().zzu().zza("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzj().zzg().zza("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzp > 0L) {
                this.zzab();
                return;
            }
            zzil zzil2 = this;
            zzil2.zzl().zzt();
            if (zzil2.zzz != null) {
                this.zzj().zzp().zza("Uploading requested multiple times");
                return;
            }
            if (!this.zzh().zzu()) {
                this.zzj().zzp().zza("Network not connected, ignoring upload request");
                this.zzab();
                return;
            }
            long l3 = this.zzb().currentTimeMillis();
            int n = this.zze().zzb(null, zzbf.zzas);
            this.zze();
            long l4 = l3 - com.google.android.gms.measurement.internal.zzag.zzh();
            for (int i = 0; i < n && this.zza(null, l2 = l4); ++i) {
            }
            if (zzpg.zza()) {
                zzil2 = this;
                zzil2.zzl().zzt();
                for (String object7 : zzil2.zzr) {
                    if (!zzpg.zza() || !zzil2.zze().zze(object7, zzbf.zzbz)) continue;
                    zzil2.zzj().zzc().zza("Notifying app that trigger URIs are available. App ID", (Object)object7);
                    Intent intent = new Intent();
                    intent.setAction("com.google.android.gms.measurement.TRIGGERS_AVAILABLE");
                    intent.setPackage(object7);
                    zzil2.zzm.zza().sendBroadcast(intent);
                }
                zzil2.zzr.clear();
            }
            if ((l = this.zzj.zzc.zza()) != 0L) {
                this.zzj().zzc().zza("Uploading events. Elapsed time since last upload attempt (ms)", (Object)Math.abs(l3 - l));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzf().f_()))) {
                if (this.zzab == -1L) {
                    this.zzab = this.zzf().b_();
                }
                int n2 = this.zze().zzb(string, zzbf.zzg);
                Object object = string;
                zzil2 = this.zze();
                int n3 = Math.max(0, zzil2.zzb((String)object, zzbf.zzh));
                List<Pair<zzfn.zzk, Long>> list = this.zzf().zza(string, n2, n3);
                if (!list.isEmpty()) {
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    Object object6;
                    if (this.zzb(string).zzi()) {
                        object6 = null;
                        Iterator<Pair<zzfn.zzk, Long>> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            zzfn.zzk zzk2 = (zzfn.zzk)((Object)iterator.next().first);
                            if (zzk2.zzan().isEmpty()) continue;
                            object6 = zzk2.zzan();
                            break;
                        }
                        if (object6 != null) {
                            for (int i = 0; i < list.size(); ++i) {
                                object5 = (zzfn.zzk)((Object)list.get((int)i).first);
                                if (((zzfn.zzk)((Object)object5)).zzan().isEmpty() || ((zzfn.zzk)((Object)object5)).zzan().equals(object6)) continue;
                                list = list.subList(0, i);
                                break;
                            }
                        }
                    }
                    object6 = zzfn.zzj.zzb();
                    int n4 = list.size();
                    object5 = new ArrayList(list.size());
                    boolean bl2 = this.zze().zzj(string) && this.zzb(string).zzi();
                    boolean bl3 = this.zzb(string).zzi();
                    boolean bl4 = this.zzb(string).zzj();
                    boolean bl5 = zzph.zza() && this.zze().zze(string, zzbf.zzbr);
                    zzmz zzmz2 = this.zzk.zza(string);
                    if (zzpn.zza() && this.zze().zza(zzbf.zzbs)) {
                        this.zzq();
                        if (zznp.zzf((String)string)) {
                            String string2 = this.zzi().zzf(string);
                            if (zzmz2.zza() == 3 && !TextUtils.isEmpty((CharSequence)string2)) {
                                ((zzfn.zzj.zzb)((Object)object6)).zza(string2);
                            }
                        }
                    }
                    for (int i = 0; i < n4; ++i) {
                        object4 = (zzfn.zzk.zza)((zzfn.zzk)((Object)list.get((int)i).first)).zzcc();
                        object5.add((Long)list.get((int)i).second);
                        this.zze();
                        ((zzfn.zzk.zza)((Object)object4)).zzl(97001L).zzk(l3).zzd(false);
                        if (!bl2) {
                            ((zzfn.zzk.zza)((Object)object4)).zzk();
                        }
                        if (!bl3) {
                            ((zzfn.zzk.zza)((Object)object4)).zzq();
                            ((zzfn.zzk.zza)((Object)object4)).zzn();
                        }
                        if (!bl4) {
                            ((zzfn.zzk.zza)((Object)object4)).zzh();
                        }
                        this.zza(string, (zzfn.zzk.zza)((Object)object4));
                        if (!bl5) {
                            ((zzfn.zzk.zza)((Object)object4)).zzr();
                        }
                        if (com.google.android.gms.internal.measurement.zznk.zza() && this.zze().zza(zzbf.zzcw) && !bl4) {
                            ((zzfn.zzk.zza)((Object)object4)).zzi();
                        }
                        if (com.google.android.gms.internal.measurement.zznl.zza() && this.zze().zza(zzbf.zzck)) {
                            object = object4;
                            zzil2 = this;
                            String string3 = ((zzfn.zzk.zza)((Object)object)).zzz();
                            boolean bl6 = false;
                            if (TextUtils.isEmpty((CharSequence)string3) || string3.equals("00000000-0000-0000-0000-000000000000")) {
                                object3 = new ArrayList<zzfn.zzf>(((zzfn.zzk.zza)((Object)object)).zzaa());
                                boolean bl7 = false;
                                Iterator iterator = object3.iterator();
                                Long l5 = null;
                                Long l6 = null;
                                while (iterator.hasNext()) {
                                    zzfn.zzf zzf2 = (zzfn.zzf)((Object)iterator.next());
                                    if ("_fx".equals(zzf2.zzg())) {
                                        bl6 = true;
                                        iterator.remove();
                                        bl7 = true;
                                        continue;
                                    }
                                    if (!"_f".equals(zzf2.zzg())) continue;
                                    bl6 = true;
                                    if (!zzil2.zze().zza(zzbf.zzcs)) continue;
                                    zzil2.zzp();
                                    zzfn.zzh zzh2 = zznl.zza(zzf2, "_pfo");
                                    if (zzh2 != null) {
                                        l5 = zzh2.zzd();
                                    }
                                    zzil2.zzp();
                                    zzfn.zzh zzh3 = zznl.zza(zzf2, "_uwa");
                                    if (zzh3 == null) continue;
                                    l6 = zzh3.zzd();
                                }
                                if (bl7) {
                                    ((zzfn.zzk.zza)((Object)object)).zzl();
                                    ((zzfn.zzk.zza)((Object)object)).zzb((Iterable<? extends zzfn.zzf>)object3);
                                }
                                if (bl6) {
                                    super.zza(((zzfn.zzk.zza)((Object)object)).zzt(), true, l5, l6);
                                }
                            }
                            if (((zzfn.zzk.zza)((Object)object4)).zzc() == 0) continue;
                        }
                        if (this.zze().zze(string, zzbf.zzbh)) {
                            object2 = ((zzfn.zzk)((zzjk)object4.zzai())).zzbz();
                            ((zzfn.zzk.zza)((Object)object4)).zza(this.zzp().zza((byte[])object2));
                        }
                        if (zzpn.zza() && this.zze().zza(zzbf.zzbs)) {
                            this.zzq();
                            if (zznp.zzf((String)string) && zzmz2.zza() == 3) {
                                ((zzfn.zzk.zza)((Object)object4)).zzk();
                            }
                        }
                        ((zzfn.zzj.zzb)((Object)object6)).zza((zzfn.zzk.zza)((Object)object4));
                    }
                    if (com.google.android.gms.internal.measurement.zznl.zza() && this.zze().zza(zzbf.zzck) && ((zzfn.zzj.zzb)((Object)object6)).zza() == 0) {
                        this.zza((List<Long>)object5);
                        this.zza(false, 204, null, null, string);
                        return;
                    }
                    String string4 = null;
                    if (this.zzj().zza(2)) {
                        string4 = this.zzp().zza((zzfn.zzj)((zzjk)object6.zzai()));
                    }
                    this.zzp();
                    object4 = ((zzfn.zzj)((zzjk)object6.zzai())).zzbz();
                    try {
                        this.zza((List<Long>)object5);
                        this.zzj.zzd.zza(l3);
                        object2 = "?";
                        if (n4 > 0) {
                            object2 = ((zzfn.zzj.zzb)((Object)object6)).zza(0).zzz();
                        }
                        this.zzj().zzp().zza("Uploading data. app, uncompressed size, data", object2, (Object)((Object)object4).length, (Object)string4);
                        this.zzv = true;
                        zzne zzne2 = new zzne(this, string);
                        object3 = zzmz2.zzc();
                        Object object7 = object4;
                        URL uRL = new URL(zzmz2.zzb());
                        object = string;
                        zzil2 = this.zzh();
                        zzil2.zzt();
                        zzil2.zzal();
                        Preconditions.checkNotNull((Object)uRL);
                        Preconditions.checkNotNull((Object)object7);
                        Preconditions.checkNotNull((Object)zzne2);
                        zzil2.zzl().zza((Runnable)new zzgd((zzfz)zzil2, (String)object, uRL, (byte[])object7, (Map)object3, zzne2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzj().zzg().zza("Failed to parse upload URL. Not uploading. appId", zzfw.zza((String)string), (Object)zzmz2.zzb());
                    }
                }
            } else {
                zzg zzg2;
                this.zzab = -1L;
                zzal zzal2 = this.zzf();
                this.zze();
                String string5 = zzal2.zza(l3 - com.google.android.gms.measurement.internal.zzag.zzh());
                if (!TextUtils.isEmpty((CharSequence)string5) && (zzg2 = this.zzf().zze(string5)) != null) {
                    this.zzb(zzg2);
                }
            }
            return;
        }
        finally {
            this.zzw = false;
            this.zzaa();
        }
    }

    @VisibleForTesting
    private final void zza(String string, zzfn.zzh.zza zza2, Bundle bundle, @Nullable String string2) {
        List list = CollectionUtils.listOf((Object[])new String[]{"_o", "_sn", "_sc", "_si"});
        long l = zznp.zzg((String)zza2.zzf()) || zznp.zzg((String)string) ? (long)this.zze().zzb(string2, true) : (long)this.zze().zza(string2, true);
        long l2 = zza2.zzg().codePointCount(0, zza2.zzg().length());
        this.zzq();
        String string3 = zza2.zzf();
        this.zze();
        String string4 = zznp.zza((String)string3, (int)40, (boolean)true);
        if (l2 > l && !list.contains(zza2.zzf())) {
            if ("_ev".equals(zza2.zzf())) {
                this.zzq();
                String string5 = zznp.zza((String)zza2.zzg(), (int)this.zze().zzb(string2, true), (boolean)true);
                bundle.putString("_ev", string5);
                return;
            }
            this.zzj().zzv().zza("Param value is too long; discarded. Name, value length", (Object)string4, (Object)l2);
            if (bundle.getLong("_err") == 0L) {
                bundle.putLong("_err", 4L);
                if (bundle.getString("_ev") == null) {
                    bundle.putString("_ev", string4);
                    bundle.putLong("_el", l2);
                }
            }
            bundle.remove(zza2.zzf());
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @WorkerThread
    private final void zzc(zzbd var1_1, zzo var2_2) {
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotEmpty((String)var2_2.zza);
        var3_3 = System.nanoTime();
        this.zzl().zzt();
        this.zzs();
        var5_4 = var2_2.zza;
        this.zzp();
        if (!zznl.zza(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzh) {
            this.zza(var2_2);
            return;
        }
        if (this.zzi().zzd(var5_4, var1_1.zza)) {
            this.zzj().zzu().zza("Dropping blocked event. appId", zzfw.zza((String)var5_4), (Object)this.zzm.zzk().zza(var1_1.zza));
            var6_5 = this.zzi().zzm(var5_4) != false || this.zzi().zzo(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.zza)) {
                this.zzq();
                zznp.zza((zznr)this.zzah, (String)var5_4, (int)11, (String)"_ev", (String)var1_1.zza, (int)0);
            }
            if (var6_5 && (var7_7 = this.zzf().zze(var5_4)) != null) {
                var8_9 = Math.max(var7_7.zzp(), var7_7.zzg());
                v0 = Math.abs(this.zzb().currentTimeMillis() - var8_9);
                this.zze();
                if (v0 > (Long)zzbf.zzz.zza(null)) {
                    this.zzj().zzc().zza("Fetching config for blocked app");
                    this.zzb(var7_7);
                }
            }
            return;
        }
        var6_6 = zzga.zza((zzbd)var1_1);
        this.zzq().zza(var6_6, this.zze().zzb(var5_4));
        var7_8 = zzou.zza() != false && this.zze().zza(zzbf.zzby) != false ? this.zze().zza(var5_4, zzbf.zzaq, 10, 35) : 0;
        for (String var10_12 : new TreeSet<E>(var6_6.zzb.keySet())) {
            if (!"items".equals(var10_12)) continue;
            this.zzq().zza(var6_6.zzb.getParcelableArray(var10_12), var7_8, zzou.zza() != false && this.zze().zza(zzbf.zzby) != false);
        }
        var1_1 = var6_6.zza();
        if (this.zzj().zza(2)) {
            this.zzj().zzp().zza("Logging event", (Object)this.zzm.zzk().zza(var1_1));
        }
        if (zzoo.zza()) {
            this.zze().zza(zzbf.zzbv);
        }
        this.zzf().zzp();
        try {
            block74: {
                block75: {
                    block77: {
                        block81: {
                            block80: {
                                block78: {
                                    block79: {
                                        this.zza(var2_2);
                                        var9_11 = "ecommerce_purchase".equals(var1_1.zza) != false || "purchase".equals(var1_1.zza) != false || "refund".equals(var1_1.zza) != false;
                                        if (!("_iap".equals(var1_1.zza) != false || var9_11 != false)) break block77;
                                        var28_13 = var9_11;
                                        var27_15 = var1_1;
                                        var26_18 = var5_4;
                                        var25_19 = this;
                                        var29_20 = var27_15.zzb.zzd("currency");
                                        if (!var28_13) break block78;
                                        var32_21 = var27_15.zzb.zza("value") * 1000000.0;
                                        if (var32_21 == 0.0) {
                                            var32_21 = (double)var27_15.zzb.zzb("value").longValue() * 1000000.0;
                                        }
                                        if (!(var32_21 <= 9.223372036854776E18) || !(var32_21 >= -9.223372036854776E18)) break block79;
                                        var30_25 = Math.round(var32_21);
                                        if ("refund".equals(var27_15.zza)) {
                                            var30_25 = -var30_25;
                                        }
                                        break block80;
                                    }
                                    var25_19.zzj().zzu().zza("Data lost. Currency value is too big. appId", zzfw.zza((String)var26_18), (Object)var32_21);
                                    v1 = false;
                                    break block81;
                                }
                                var30_25 = var27_15.zzb.zzb("value");
                            }
                            if (!TextUtils.isEmpty((CharSequence)var29_20) && (var29_20 = var29_20.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                                var36_27 = var29_20;
                                var32_22 = "_ltv_" + (String)var36_27;
                                var33_29 = var25_19.zzf().zze(var26_18, var32_22);
                                if (var33_29 == null || !(var33_29.zze instanceof Long)) {
                                    var43_30 = var25_19.zze().zzb(var26_18, zzbf.zzae) - 1;
                                    var42_31 = var26_18;
                                    var41_32 = var25_19.zzf();
                                    Preconditions.checkNotEmpty((String)var42_31);
                                    var41_32.zzt();
                                    var41_32.zzal();
                                    try {
                                        var41_32.e_().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{var42_31, var42_31, String.valueOf(var43_30)});
                                    }
                                    catch (SQLiteException var44_33) {
                                        var41_32.zzj().zzg().zza("Error pruning currencies. appId", zzfw.zza((String)var42_31), (Object)var44_33);
                                    }
                                    var33_29 = new zznq(var26_18, var27_15.zzc, var32_22, var25_19.zzb().currentTimeMillis(), (Object)var30_25);
                                } else {
                                    var34_34 = (Long)var33_29.zze;
                                    var33_29 = new zznq(var26_18, var27_15.zzc, var32_22, var25_19.zzb().currentTimeMillis(), (Object)(var34_34 + var30_25));
                                }
                                if (!var25_19.zzf().zza((zznq)var33_29)) {
                                    var25_19.zzj().zzg().zza("Too many unique user properties are set. Ignoring user property. appId", zzfw.zza((String)var26_18), (Object)var25_19.zzm.zzk().zzc(var33_29.zzc), var33_29.zze);
                                    var25_19.zzq();
                                    zznp.zza((zznr)var25_19.zzah, (String)var26_18, (int)9, null, null, (int)0);
                                }
                            }
                            v1 = true;
                        }
                        if (!v1) {
                            this.zzf().zzw();
                            return;
                        }
                    }
                    var11_38 = zznp.zzh((String)var1_1.zza);
                    var12_39 = "_err".equals(var1_1.zza);
                    this.zzq();
                    var13_40 = 1L + zznp.zza((zzbc)var1_1.zzb);
                    var15_41 = this.zzf().zza(this.zzx(), var5_4, var13_40, true, var11_38, false, var12_39, false, false);
                    v2 = var15_41.zzb;
                    this.zze();
                    var16_42 = v2 - (long)((Integer)zzbf.zzk.zza(null)).intValue();
                    if (var16_42 > 0L) {
                        if (var16_42 % 1000L == 1L) {
                            this.zzj().zzg().zza("Data loss. Too many events logged. appId, count", zzfw.zza((String)var5_4), (Object)var15_41.zzb);
                        }
                        this.zzf().zzw();
                        return;
                    }
                    if (var11_38) {
                        v3 = var15_41.zza;
                        this.zze();
                        var16_42 = v3 - (long)((Integer)zzbf.zzm.zza(null)).intValue();
                        if (var16_42 > 0L) {
                            if (var16_42 % 1000L == 1L) {
                                this.zzj().zzg().zza("Data loss. Too many public events logged. appId, count", zzfw.zza((String)var5_4), (Object)var15_41.zza);
                            }
                            this.zzq();
                            zznp.zza((zznr)this.zzah, (String)var5_4, (int)16, (String)"_ev", (String)var1_1.zza, (int)0);
                            this.zzf().zzw();
                            return;
                        }
                    }
                    if (var12_39) {
                        var27_16 = this.zze().zzb(var2_2.zza, zzbf.zzl);
                        var16_42 = var15_41.zzd - (long)Math.max(0, var27_16 = Math.min(1000000, var27_16));
                        if (var16_42 > 0L) {
                            if (var16_42 == 1L) {
                                this.zzj().zzg().zza("Too many error events logged. appId, count", zzfw.zza((String)var5_4), (Object)var15_41.zzd);
                            }
                            this.zzf().zzw();
                            return;
                        }
                    }
                    var18_43 = var1_1.zzb.zzb();
                    this.zzq().zza(var18_43, "_o", (Object)var1_1.zzc);
                    if (this.zzq().zzd(var5_4, var2_2.zzac)) {
                        this.zzq().zza(var18_43, "_dbg", (Object)1L);
                        this.zzq().zza(var18_43, "_r", (Object)1L);
                    }
                    if ("_s".equals(var1_1.zza) && (var19_44 = this.zzf().zze(var2_2.zza, "_sno")) != null && var19_44.zze instanceof Long) {
                        this.zzq().zza(var18_43, "_sno", var19_44.zze);
                    }
                    if ((var19_45 = this.zzf().zza(var5_4)) > 0L) {
                        this.zzj().zzu().zza("Data lost. Too many events stored on disk, deleted. appId", zzfw.zza((String)var5_4), (Object)var19_45);
                    }
                    var21_46 = new zzba(this.zzm, var1_1.zzc, var5_4, var1_1.zza, var1_1.zzd, 0L, var18_43);
                    var22_47 = this.zzf().zzd(var5_4, var21_46.zzb);
                    if (var22_47 == null) {
                        if (this.zzf().zzc(var5_4) >= (long)this.zze().zza(var5_4) && var11_38) {
                            this.zzj().zzg().zza("Too many event names used, ignoring event. appId, name, supported count", zzfw.zza((String)var5_4), (Object)this.zzm.zzk().zza(var21_46.zzb), (Object)this.zze().zza(var5_4));
                            this.zzq();
                            zznp.zza((zznr)this.zzah, (String)var5_4, (int)8, null, null, (int)0);
                            return;
                        }
                        var23_48 = new zzaz(var5_4, var21_46.zzb, 0L, 0L, var21_46.zzc, 0L, null, null, null, null);
                    } else {
                        var21_46 = var21_46.zza(this.zzm, var22_47.zzf);
                        var23_48 = var22_47.zza(var21_46.zzc);
                    }
                    this.zzf().zza(var23_48);
                    var27_17 = var2_2;
                    var26_18 = var21_46;
                    var25_19 = this;
                    var25_19.zzl().zzt();
                    var25_19.zzs();
                    Preconditions.checkNotNull((Object)var26_18);
                    Preconditions.checkNotNull((Object)var27_17);
                    Preconditions.checkNotEmpty((String)var26_18.zza);
                    Preconditions.checkArgument((boolean)var26_18.zza.equals(var27_17.zza));
                    var28_14 = zzfn.zzk.zzw().zzh(1).zzp("android");
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zza)) {
                        var28_14.zzb(var27_17.zza);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzd)) {
                        var28_14.zzd(var27_17.zzd);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzc)) {
                        var28_14.zze(var27_17.zzc);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzv)) {
                        var28_14.zzr(var27_17.zzv);
                    }
                    if (var27_17.zzj != -2147483648L) {
                        var28_14.zze((int)var27_17.zzj);
                    }
                    var28_14.zzf(var27_17.zze);
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzb)) {
                        var28_14.zzm(var27_17.zzb);
                    }
                    var29_20 = var25_19.zzb((String)Preconditions.checkNotNull((Object)var27_17.zza)).zza(zzin.zzb((String)var27_17.zzt));
                    var28_14.zzg(var29_20.zzg());
                    if (var28_14.zzx().isEmpty() && !TextUtils.isEmpty((CharSequence)var27_17.zzp)) {
                        var28_14.zza(var27_17.zzp);
                    }
                    if (zzpg.zza() && var25_19.zze().zze(var27_17.zza, zzbf.zzbz)) {
                        var25_19.zzq();
                        if (zznp.zzd((String)var27_17.zza)) {
                            var28_14.zzd(var27_17.zzaa);
                            var30_25 = var27_17.zzab;
                            if (!var25_19.zze().zza(zzbf.zzcd) && !var29_20.zzi() && var30_25 != 0L) {
                                var30_25 = var30_25 & -2L | 32L;
                            }
                            var28_14.zza(var30_25 == 1L);
                            if (var30_25 != 0L) {
                                var37_49 = var30_25;
                                var40_51 /* !! */  = zzfn.zzc.zza();
                                var40_51 /* !! */ .zzc((var37_49 & 1L) != 0L);
                                var40_51 /* !! */ .zze((var37_49 & 2L) != 0L);
                                var40_51 /* !! */ .zzf((var37_49 & 4L) != 0L);
                                var40_51 /* !! */ .zzg((var37_49 & 8L) != 0L);
                                var40_51 /* !! */ .zzb((var37_49 & 16L) != 0L);
                                var40_51 /* !! */ .zza((var37_49 & 32L) != 0L);
                                var40_51 /* !! */ .zzd((var37_49 & 64L) != 0L);
                                var28_14.zza((zzfn.zzc)((zzjk)var40_51 /* !! */ .zzai()));
                            }
                        }
                    }
                    if (var27_17.zzf != 0L) {
                        var28_14.zzc(var27_17.zzf);
                    }
                    var28_14.zzd(var27_17.zzr);
                    var30_26 = var25_19.zzp().zzu();
                    if (var30_26 != null) {
                        var28_14.zzc(var30_26);
                    }
                    if ((var31_52 = var25_19.zzb((String)Preconditions.checkNotNull((Object)var27_17.zza)).zza(zzin.zzb((String)var27_17.zzt))).zzi() && var27_17.zzn && (var32_23 = var25_19.zzj.zza(var27_17.zza, var31_52)) != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var32_23.first)) && var27_17.zzn) {
                        var28_14.zzq((String)var32_23.first);
                        if (var32_23.second != null) {
                            var28_14.zzc((Boolean)var32_23.second);
                        }
                        if (com.google.android.gms.internal.measurement.zznl.zza() && var25_19.zze().zza(zzbf.zzck) && !var26_18.zzb.equals("_fx") && !((String)var32_23.first).equals("00000000-0000-0000-0000-000000000000") && (var33_29 = var25_19.zzf().zze(var27_17.zza)) != null && var33_29.zzau()) {
                            var25_19.zza(var27_17.zza, false, null, null);
                            var34_35 = new Bundle();
                            if (var25_19.zze().zza(zzbf.zzcs)) {
                                var35_53 = var33_29.zzy();
                                if (var35_53 != null) {
                                    var34_35.putLong("_pfo", Math.max(0L, var35_53.longValue()));
                                }
                                if ((var36_27 = var33_29.zzz()) != null) {
                                    var34_35.putLong("_uwa", var36_27.longValue());
                                }
                            } else if (var25_19.zze().zza(zzbf.zzcr)) {
                                var35_54 = var25_19.zzf().zzb(var27_17.zza) - 1L;
                                var34_35.putLong("_pfo", Math.max(0L, var35_54));
                            }
                            var34_35.putLong("_r", 1L);
                            var25_19.zzah.zza(var27_17.zza, "_fx", var34_35);
                        }
                    }
                    var25_19.zzm.zzg().zzac();
                    v4 = var28_14.zzi(Build.MODEL);
                    var25_19.zzm.zzg().zzac();
                    v4.zzo(Build.VERSION.RELEASE).zzj((int)var25_19.zzm.zzg().zzg()).zzs(var25_19.zzm.zzg().zzh());
                    var28_14.zzj(var27_17.zzx);
                    if (var25_19.zzm.zzac()) {
                        var28_14.zzt();
                        if (!TextUtils.isEmpty(null)) {
                            var28_14.zzj(null);
                        }
                    }
                    if ((var32_24 = var25_19.zzf().zze(var27_17.zza)) == null) {
                        var32_24 = new zzg(var25_19.zzm, var27_17.zza);
                        var32_24.zzb(var25_19.zza(var31_52));
                        var32_24.zze(var27_17.zzk);
                        var32_24.zzf(var27_17.zzb);
                        if (var31_52.zzi()) {
                            var32_24.zzh(var25_19.zzj.zza(var27_17.zza, var27_17.zzn));
                        }
                        var32_24.zzq(0L);
                        var32_24.zzr(0L);
                        var32_24.zzp(0L);
                        var32_24.zzd(var27_17.zzc);
                        var32_24.zzb(var27_17.zzj);
                        var32_24.zzc(var27_17.zzd);
                        var32_24.zzn(var27_17.zze);
                        var32_24.zzk(var27_17.zzf);
                        var32_24.zzb(var27_17.zzh);
                        var32_24.zzl(var27_17.zzr);
                        var42_31 = var32_24;
                        var25_19.zzf().zza((zzg)var42_31, false, false);
                    }
                    if (var31_52.zzj() && !TextUtils.isEmpty((CharSequence)var32_24.zzad())) {
                        var28_14.zzc((String)Preconditions.checkNotNull((Object)var32_24.zzad()));
                    }
                    if (!TextUtils.isEmpty((CharSequence)var32_24.zzag())) {
                        var28_14.zzl((String)Preconditions.checkNotNull((Object)var32_24.zzag()));
                    }
                    var33_29 = var25_19.zzf().zzk(var27_17.zza);
                    for (var34_36 = 0; var34_36 < var33_29.size(); ++var34_36) {
                        var35_53 = zzfn.zzo.zze().zza(((zznq)var33_29.get((int)var34_36)).zzc).zzb(((zznq)var33_29.get((int)var34_36)).zzd);
                        var25_19.zzp().zza((zzfn.zzo.zza)var35_53, ((zznq)var33_29.get((int)var34_36)).zze);
                        var28_14.zza((zzfn.zzo.zza)var35_53);
                        if (!"_sid".equals(((zznq)var33_29.get((int)var34_36)).zzc) || var32_24.zzv() == 0L || var25_19.zzp().zza(var27_17.zzv) == var32_24.zzv()) continue;
                        var28_14.zzr();
                    }
                    try {
                        var34_37 = var25_19.zzf().zza((zzfn.zzk)((zzjk)var28_14.zzai()));
                    }
                    catch (IOException var36_28) {
                        var25_19.zzj().zzg().zza("Data loss. Failed to insert raw event metadata. appId", zzfw.zza((String)var28_14.zzt()), (Object)var36_28);
                        break block74;
                    }
                    v5 = var25_19.zzf();
                    var38_55 = var26_18;
                    var37_50 = var25_19;
                    if (var38_55.zze == null) ** GOTO lbl-1000
                    for (zzfn.zzc.zza var40_51 : var38_55.zze) {
                        if (!"_r".equals((Object)var40_51 /* !! */ )) continue;
                        v6 = true;
                        break block75;
                    }
                    var39_57 = var37_50.zzi().zzc(var38_55.zza, var38_55.zzb);
                    var40_51 /* !! */  = var37_50.zzf().zza(var37_50.zzx(), var38_55.zza, false, false, false, false, false, false);
                    if (var39_57 && var40_51 /* !! */ .zze < (long)var37_50.zze().zzc(var38_55.zza)) {
                        v6 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = false;
                    }
                }
                if (v5.zza((zzba)var26_18, var34_37, v6)) {
                    var25_19.zzp = 0L;
                }
            }
            this.zzf().zzw();
        }
        finally {
            this.zzf().zzu();
        }
        this.zzab();
        this.zzj().zzp().zza("Background event processing time, ms", (Object)((System.nanoTime() - var3_3 + 500000L) / 1000000L));
    }

    private static boolean zzh(zzo zzo2) {
        return !TextUtils.isEmpty((CharSequence)zzo2.zzb) || !TextUtils.isEmpty((CharSequence)zzo2.zzp);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @WorkerThread
    private final boolean zza(@Nullable String var1_1, long var2_2) {
        this.zzf().zzp();
        try {
            block168: {
                block172: {
                    block171: {
                        block166: {
                            var4_3 = new zza(null);
                            var34_4 = var4_3;
                            var32_6 = this.zzab;
                            var30_12 = var2_2;
                            var29_19 = null;
                            var28_20 = this.zzf();
                            Preconditions.checkNotNull((Object)var34_4);
                            var28_20.zzt();
                            var28_20.zzal();
                            var35_21 = null;
                            try {
                                var36_27 /* !! */  = var28_20.e_();
                                if (TextUtils.isEmpty(null)) {
                                    var38_33 = var32_6 != -1L ? new String[]{String.valueOf(var32_6), String.valueOf(var30_12)} : new String[]{String.valueOf(var30_12)};
                                    var47_35 = var32_6 != -1L ? "rowid <= ? and " : "";
                                    var35_21 = var36_27 /* !! */ .rawQuery("select app_id, metadata_fingerprint from raw_events where " + var47_35 + "app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;", (String[])var38_33);
                                    if (!var35_21.moveToFirst()) break block166;
                                    var29_19 = var35_21.getString(0);
                                    var37_36 = var35_21.getString(1);
                                    var35_21.close();
                                } else {
                                    var38_33 = var32_6 != -1L ? new String[]{null, String.valueOf(var32_6)} : new String[]{null};
                                    var47_35 = var32_6 != -1L ? " and rowid <= ?" : "";
                                    var35_21 = var36_27 /* !! */ .rawQuery("select metadata_fingerprint from raw_events where app_id = ?" + var47_35 + " order by rowid limit 1;", (String[])var38_33);
                                    if (!var35_21.moveToFirst()) break block166;
                                    var37_36 = var35_21.getString(0);
                                    var35_21.close();
                                }
                                var35_21 = var36_27 /* !! */ .query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{var29_19, var37_36}, null, null, "rowid", "2");
                                if (!var35_21.moveToFirst()) {
                                    var28_20.zzj().zzg().zza("Raw event metadata record is missing. appId", zzfw.zza((String)var29_19));
                                    break block166;
                                }
                                var38_33 = var35_21.getBlob(0);
                                try {
                                    var39_37 /* !! */  = (zzfn.zzk)((zzjk)zznl.zza(zzfn.zzk.zzw(), (byte[])var38_33).zzai());
                                }
                                catch (IOException var40_38) {
                                    var28_20.zzj().zzg().zza("Data loss. Failed to merge raw event metadata. appId", zzfw.zza((String)var29_19), (Object)var40_38);
                                    if (var35_21 != null) {
                                        var35_21.close();
                                    }
                                    break block166;
                                }
                                if (var35_21.moveToNext()) {
                                    var28_20.zzj().zzu().zza("Get multiple raw event metadata records, expected one. appId", zzfw.zza((String)var29_19));
                                }
                                var35_21.close();
                                var34_4.zza(var39_37 /* !! */ );
                                if (var32_6 != -1L) {
                                    var40_39 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                                    var41_41 = new String[]{var29_19, var37_36, String.valueOf(var32_6)};
                                } else {
                                    var40_39 = "app_id = ? and metadata_fingerprint = ?";
                                    var41_41 = new String[]{var29_19, var37_36};
                                }
                                var35_21 = var36_27 /* !! */ .query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, var40_39, var41_41, null, null, "rowid", null);
                                if (!var35_21.moveToFirst()) {
                                    var28_20.zzj().zzu().zza("Raw event data disappeared while in transaction. appId", zzfw.zza((String)var29_19));
                                    break block166;
                                }
                                do {
                                    var42_42 = var35_21.getLong(0);
                                    var38_33 = var35_21.getBlob(3);
                                    try {
                                        var44_44 = zznl.zza(zzfn.zzf.zze(), (byte[])var38_33);
                                    }
                                    catch (IOException var45_46) {
                                        var28_20.zzj().zzg().zza("Data loss. Failed to merge raw event. appId", zzfw.zza((String)var29_19), (Object)var45_46);
                                        continue;
                                    }
                                    var44_44.zza(var35_21.getString(1)).zzb(var35_21.getLong(2));
                                    if (!var34_4.zza(var42_42, (zzfn.zzf)((zzjk)var44_44.zzai()))) break;
                                } while (var35_21.moveToNext());
                            }
                            catch (SQLiteException var36_28) {
                                var28_20.zzj().zzg().zza("Data loss. Error selecting raw event. appId", zzfw.zza(var29_19), (Object)var36_28);
                            }
                            finally {
                                if (var35_21 != null) {
                                    var35_21.close();
                                }
                            }
                        }
                        var28_20 = var4_3;
                        if (var28_20.zzc == null || var28_20.zzc.isEmpty() != false) break block168;
                        var5_49 = false;
                        var6_50 = ((zzfn.zzk.zza)var4_3.zza.zzcc()).zzl();
                        var7_51 = 0;
                        var8_52 = 0L;
                        var10_53 = null;
                        var11_54 = -1;
                        var12_55 = null;
                        var13_56 = -1;
                        for (var14_57 = 0; var14_57 < var4_3.zzc.size(); ++var14_57) {
                            block170: {
                                block169: {
                                    var15_58 = var5_49;
                                    var16_61 = (zzfn.zzf.zza)var4_3.zzc.get(var14_57).zzcc();
                                    if (this.zzi().zzd(var4_3.zza.zzz(), var16_61.zze())) {
                                        this.zzj().zzu().zza("Dropping blocked raw event. appId", zzfw.zza((String)var4_3.zza.zzz()), (Object)this.zzm.zzk().zza(var16_61.zze()));
                                        if (this.zzi().zzm(var4_3.zza.zzz()) != false || this.zzi().zzo(var4_3.zza.zzz()) != false || "_err".equals(var16_61.zze())) continue;
                                        this.zzq();
                                        zznp.zza((zznr)this.zzah, (String)var4_3.zza.zzz(), (int)11, (String)"_ev", (String)var16_61.zze(), (int)0);
                                        continue;
                                    }
                                    if (var16_61.zze().equals(zziq.zza((String)"_ai"))) {
                                        var16_61.zza("_ai");
                                        this.zzj().zzp().zza("Renaming ad_impression to _ai");
                                        if (this.zzj().zza(5)) {
                                            for (var17_64 = 0; var17_64 < var16_61.zza(); ++var17_64) {
                                                if (!"ad_platform".equals(var16_61.zzb(var17_64).zzg()) || var16_61.zzb(var17_64).zzh().isEmpty() || !"admob".equalsIgnoreCase(var16_61.zzb(var17_64).zzh())) continue;
                                                this.zzj().zzv().zza("AdMob ad impression logged from app. Potentially duplicative.");
                                            }
                                        }
                                    }
                                    if ((var17_64 = this.zzi().zzc(var4_3.zza.zzz(), var16_61.zze())) != 0) break block169;
                                    this.zzp();
                                    var28_20 = var16_61.zze();
                                    Preconditions.checkNotEmpty((String)var28_20);
                                    var30_13 = var28_20;
                                    var31_97 = -1;
                                    switch (var30_13.hashCode()) {
                                        case 95027: {
                                            if (!var30_13.equals("_ui")) break;
                                            var31_97 = 0;
                                        }
                                    }
                                    switch (var31_97) {
                                        case 0: {
                                            v0 = true;
                                            break;
                                        }
                                        default: {
                                            v0 = false;
                                        }
                                    }
                                    if (!v0) break block170;
                                }
                                var18_69 = false;
                                var19_73 = 0;
                                for (var20_75 = 0; var20_75 < var16_61.zza(); ++var20_75) {
                                    if ("_c".equals(var16_61.zzb(var20_75).zzg())) {
                                        var21_79 = (zzfn.zzh)((zzjk)((zzfn.zzh.zza)var16_61.zzb(var20_75).zzcc()).zza(1L).zzai());
                                        var18_69 = true;
                                        var16_61.zza(var20_75, var21_79);
                                        continue;
                                    }
                                    if (!"_r".equals(var16_61.zzb(var20_75).zzg())) continue;
                                    var21_79 = (zzfn.zzh)((zzjk)((zzfn.zzh.zza)var16_61.zzb(var20_75).zzcc()).zza(1L).zzai());
                                    var19_73 = 1;
                                    var16_61.zza(var20_75, var21_79);
                                }
                                if (!var18_69 && var17_64 != 0) {
                                    this.zzj().zzp().zza("Marking event as conversion", (Object)this.zzm.zzk().zza(var16_61.zze()));
                                    var16_61.zza(zzfn.zzh.zze().zza("_c").zza(1L));
                                }
                                if (var19_73 == 0) {
                                    this.zzj().zzp().zza("Marking event as real-time", (Object)this.zzm.zzk().zza(var16_61.zze()));
                                    var16_61.zza(zzfn.zzh.zze().zza("_r").zza(1L));
                                }
                                var5_49 = true;
                                if (this.zzf().zza((long)this.zzx(), (String)var4_3.zza.zzz(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)false).zze > (long)this.zze().zzc(var4_3.zza.zzz())) {
                                    zznc.zza((zzfn.zzf.zza)var16_61, "_r");
                                    var5_49 = var15_58;
                                }
                                if (zznp.zzh((String)var16_61.zze()) && var17_64 != 0 && this.zzf().zza((long)this.zzx(), (String)var4_3.zza.zzz(), (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false).zzc > (long)this.zze().zzb(var4_3.zza.zzz(), zzbf.zzn)) {
                                    this.zzj().zzu().zza("Too many conversions. Not logging as conversion. appId", zzfw.zza((String)var4_3.zza.zzz()));
                                    var22_84 = false;
                                    var23_87 = null;
                                    var24_90 = -1;
                                    for (var25_93 = 0; var25_93 < var16_61.zza(); ++var25_93) {
                                        var26_96 = var16_61.zzb(var25_93);
                                        if ("_c".equals(var26_96.zzg())) {
                                            var23_87 = (zzfn.zzh.zza)var26_96.zzcc();
                                            var24_90 = var25_93;
                                            continue;
                                        }
                                        if (!"_err".equals(var26_96.zzg())) continue;
                                        var22_84 = true;
                                    }
                                    if (var22_84 && var23_87 != null) {
                                        var16_61.zza(var24_90);
                                    } else if (var23_87 != null) {
                                        var25_94 = (zzfn.zzh)((zzjk)((zzfn.zzh.zza)((zzjk.zzb)var23_87.clone())).zza("_err").zza(10L).zzai());
                                        var16_61.zza(var24_90, var25_94);
                                    } else {
                                        this.zzj().zzg().zza("Did not find conversion parameter. appId", zzfw.zza((String)var4_3.zza.zzz()));
                                    }
                                }
                            }
                            if (var17_64 != 0) {
                                var29_19 = var16_61;
                                var28_20 = this;
                                var30_13 = new ArrayList<zzfn.zzh>(var29_19.zzf());
                                var31_97 = -1;
                                var32_7 = -1;
                                for (var33_102 = 0; var33_102 < var30_13.size(); ++var33_102) {
                                    if ("value".equals(((zzfn.zzh)var30_13.get(var33_102)).zzg())) {
                                        var31_97 = var33_102;
                                        continue;
                                    }
                                    if (!"currency".equals(((zzfn.zzh)var30_13.get(var33_102)).zzg())) continue;
                                    var32_7 = var33_102;
                                }
                                if (var31_97 != -1) {
                                    if (!((zzfn.zzh)var30_13.get(var31_97)).zzl() && !((zzfn.zzh)var30_13.get(var31_97)).zzj()) {
                                        var28_20.zzj().zzv().zza("Value must be specified with a numeric type.");
                                        var29_19.zza(var31_97);
                                        zznc.zza((zzfn.zzf.zza)var29_19, "_c");
                                        zznc.zza((zzfn.zzf.zza)var29_19, 18, "value");
                                    } else {
                                        var33_102 = 0;
                                        if (var32_7 == -1) {
                                            var33_102 = 1;
                                        } else {
                                            var34_4 = ((zzfn.zzh)var30_13.get(var32_7)).zzh();
                                            if (var34_4.length() != 3) {
                                                var33_102 = 1;
                                            } else {
                                                for (var35_22 = 0; var35_22 < var34_4.length(); var35_22 += Character.charCount(var36_29)) {
                                                    var36_29 = var34_4.codePointAt(var35_22);
                                                    if (Character.isLetter(var36_29)) continue;
                                                    var33_102 = 1;
                                                    break;
                                                }
                                            }
                                        }
                                        if (var33_102 != 0) {
                                            var28_20.zzj().zzv().zza("Value parameter discarded. You must also supply a 3-letter ISO_4217 currency code in the currency parameter.");
                                            var29_19.zza(var31_97);
                                            zznc.zza((zzfn.zzf.zza)var29_19, "_c");
                                            zznc.zza((zzfn.zzf.zza)var29_19, 19, "currency");
                                        }
                                    }
                                }
                            }
                            if ("_e".equals(var16_61.zze())) {
                                this.zzp();
                                if (zznl.zza((zzfn.zzf)((zzjk)var16_61.zzai()), "_fr") == null) {
                                    if (var12_55 != null && Math.abs(var12_55.zzc() - var16_61.zzc()) <= 1000L) {
                                        var18_70 = (zzfn.zzf.zza)((zzjk.zzb)var12_55.clone());
                                        if (this.zza((zzfn.zzf.zza)var16_61, var18_70)) {
                                            var10_53 = null;
                                            var12_55 = null;
                                            var6_50.zza(var13_56, var18_70);
                                        } else {
                                            var10_53 = var16_61;
                                            var11_54 = var7_51;
                                        }
                                    } else {
                                        var10_53 = var16_61;
                                        var11_54 = var7_51;
                                    }
                                }
                            } else if ("_vs".equals(var16_61.zze())) {
                                this.zzp();
                                if (zznl.zza((zzfn.zzf)((zzjk)var16_61.zzai()), "_et") == null) {
                                    if (var10_53 != null && Math.abs(var10_53.zzc() - var16_61.zzc()) <= 1000L) {
                                        var18_71 = (zzfn.zzf.zza)((zzjk.zzb)var10_53.clone());
                                        if (this.zza(var18_71, (zzfn.zzf.zza)var16_61)) {
                                            var10_53 = null;
                                            var12_55 = null;
                                            var6_50.zza(var11_54, var18_71);
                                        } else {
                                            var12_55 = var16_61;
                                            var13_56 = var7_51;
                                        }
                                    } else {
                                        var12_55 = var16_61;
                                        var13_56 = var7_51;
                                    }
                                }
                            }
                            if (zzop.zza() && this.zze().zza(zzbf.zzcn) && var16_61.zza() != 0) {
                                this.zzp();
                                var18_72 = zznl.zza(var16_61.zzf());
                                for (var19_73 = 0; var19_73 < var16_61.zza(); ++var19_73) {
                                    var20_76 = var16_61.zzb(var19_73);
                                    if (var20_76.zzg().equals("items") && !var20_76.zzi().isEmpty()) {
                                        var32_8 = var18_72;
                                        var31_98 = var4_3.zza.zzz();
                                        var30_14 = var16_61;
                                        var29_19 = var20_76;
                                        var28_20 = this;
                                        var33_103 = var29_19.zzi();
                                        var34_4 = new Bundle[var33_103.size()];
                                        for (var35_23 = 0; var35_23 < var33_103.size(); ++var35_23) {
                                            var36_30 = var33_103.get(var35_23);
                                            var28_20.zzp();
                                            var37_36 = zznl.zza(var36_30.zzi());
                                            for (zzfn.zzk var39_37 : var36_30.zzi()) {
                                                super.zza(var30_14.zze(), (zzfn.zzh.zza)var39_37 /* !! */ .zzcc(), (Bundle)var37_36, var31_98);
                                            }
                                            var34_4[var35_23] = var37_36;
                                        }
                                        var32_8.putParcelableArray("items", (Parcelable[])var34_4);
                                        continue;
                                    }
                                    if (var20_76.zzg().equals("items")) continue;
                                    this.zza(var16_61.zze(), (zzfn.zzh.zza)var20_76.zzcc(), var18_72, var4_3.zza.zzz());
                                }
                                var30_14 = var16_61;
                                var29_19 = var18_72;
                                var28_20 = this;
                                var30_14.zzd();
                                var34_4 = var29_19;
                                var33_104 = var28_20.zzp();
                                var35_24 = new ArrayList<zzfn.zzh>();
                                for (String var37_36 : var34_4.keySet()) {
                                    var38_33 = zzfn.zzh.zze().zza(var37_36);
                                    var39_37 /* !! */  = var34_4.get(var37_36);
                                    if (var39_37 /* !! */  == null) continue;
                                    var33_104.zza((zzfn.zzh.zza)var38_33, (Object)var39_37 /* !! */ );
                                    var35_24.add((zzfn.zzh)((zzjk)var38_33.zzai()));
                                }
                                var51_106 = var35_24;
                                var52_107 = var51_106.size();
                                for (var53_108 = 0; var53_108 < var52_107; ++var53_108) {
                                    v1 = var51_106.get(var53_108);
                                    var32_9 = (zzfn.zzh)v1;
                                    var30_14.zza(var32_9);
                                }
                            }
                            var4_3.zzc.set(var14_57, (zzfn.zzf)((zzjk)var16_61.zzai()));
                            ++var7_51;
                            var6_50.zza((zzfn.zzf.zza)var16_61);
                        }
                        for (var14_57 = 0; var14_57 < var7_51; ++var14_57) {
                            var15_59 = var6_50.zza(var14_57);
                            if ("_e".equals(var15_59.zzg())) {
                                this.zzp();
                                if (zznl.zza(var15_59, "_fr") != null) {
                                    var6_50.zzb(var14_57);
                                    --var7_51;
                                    --var14_57;
                                    continue;
                                }
                            }
                            this.zzp();
                            var16_61 = zznl.zza(var15_59, "_et");
                            if (var16_61 == null || (var17_66 = var16_61.zzl() != false ? Long.valueOf(var16_61.zzd()) : null) == null || var17_66 <= 0L) continue;
                            var8_52 += var17_66.longValue();
                        }
                        this.zza(var6_50, var8_52, false);
                        var14_57 = 0;
                        for (zzkv var16_61 : var6_50.zzaa()) {
                            if (!"_s".equals(var16_61.zzg())) continue;
                            var14_57 = 1;
                            break;
                        }
                        if (var14_57 != 0) {
                            this.zzf().zzh(var6_50.zzt(), "_se");
                        }
                        if (zznl.zza(var6_50, "_sid") >= 0) {
                            this.zza(var6_50, var8_52, true);
                        } else {
                            var16_62 = zznl.zza(var6_50, "_se");
                            if (var16_62 >= 0) {
                                var6_50.zzc(var16_62);
                                this.zzj().zzg().zza("Session engagement user property is in the bundle without session ID. appId", zzfw.zza((String)var4_3.zza.zzz()));
                            }
                        }
                        this.zzp().zza(var6_50);
                        var30_15 = var6_50;
                        var29_19 = var4_3.zza.zzz();
                        var28_20 = this;
                        var28_20.zzl().zzt();
                        var28_20.zzs();
                        var31_99 /* !! */  = var28_20.zzf().zze((String)var29_19);
                        if (var31_99 /* !! */  == null) {
                            var28_20.zzj().zzg().zza("Cannot fix consent fields without appInfo. appId", zzfw.zza((String)var29_19));
                        } else {
                            var28_20.zza(var31_99 /* !! */ , var30_15);
                        }
                        if (zzoj.zza() && this.zze().zza(zzbf.zzcm)) {
                            var30_15 = var6_50;
                            var29_19 = var4_3.zza.zzz();
                            var28_20 = this;
                            var28_20.zzl().zzt();
                            var28_20.zzs();
                            var31_99 /* !! */  = var28_20.zzf().zze((String)var29_19);
                            if (var31_99 /* !! */  == null) {
                                var28_20.zzj().zzu().zza("Cannot populate ad_campaign_info without appInfo. appId", zzfw.zza((String)var29_19));
                            } else {
                                var28_20.zzb(var31_99 /* !! */ , var30_15);
                            }
                        }
                        var28_20 = var6_50;
                        var28_20.zzi(0x7FFFFFFFFFFFFFFFL).zze(-9223372036854775808L);
                        for (var30_16 = 0; var30_16 < var28_20.zzc(); ++var30_16) {
                            var31_99 /* !! */  = var28_20.zza(var30_16);
                            if (var31_99 /* !! */ .zzd() < var28_20.zzf()) {
                                var28_20.zzi(var31_99 /* !! */ .zzd());
                            }
                            if (var31_99 /* !! */ .zzd() <= var28_20.zze()) continue;
                            var28_20.zze(var31_99 /* !! */ .zzd());
                        }
                        var6_50.zzs();
                        var16_63 = zzin.zza;
                        if (com.google.android.gms.internal.measurement.zznk.zza() && this.zze().zza(zzbf.zzcv)) {
                            var16_63 = this.zzb(var4_3.zza.zzz()).zza(zzin.zzb((String)var4_3.zza.zzae()));
                            var17_67 = this.zzf().zzh(var4_3.zza.zzz());
                            this.zzf().zza(var4_3.zza.zzz(), var16_63);
                            if (!var16_63.zzj() && var17_67.zzj()) {
                                this.zzf().zzo(var4_3.zza.zzz());
                            } else if (var16_63.zzj() && !var17_67.zzj()) {
                                this.zzf().zzp(var4_3.zza.zzz());
                            }
                            zznc.zza(var6_50, var16_63);
                        }
                        if (var17_68 = this.zze().zza(zzbf.zzcd)) {
                            var16_63 = this.zzb(var4_3.zza.zzz()).zza(zzin.zzb((String)var4_3.zza.zzae()));
                            zznc.zza(var6_50, var16_63);
                        }
                        if (!zzpg.zza() || !this.zze().zze(var4_3.zza.zzz(), zzbf.zzbz)) ** GOTO lbl-1000
                        this.zzq();
                        if (zznp.zzd((String)var4_3.zza.zzz()) && var4_3.zza.zzat()) {
                            v2 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 = var18_69 = false;
                        }
                        if (!var17_68) {
                            v3 = var18_69 = var18_69 != false && this.zzb(var4_3.zza.zzz()).zzi() != false;
                        }
                        if (var18_69) {
                            for (var19_73 = 0; var19_73 < var6_50.zzc(); ++var19_73) {
                                var20_77 = (zzfn.zzf.zza)var6_50.zza(var19_73).zzcc();
                                var21_81 = false;
                                for (zzkv var23_87 : var20_77.zzf()) {
                                    if (!"_c".equals(var23_87.zzg())) continue;
                                    var21_81 = true;
                                    break;
                                }
                                if (!var21_81) continue;
                                if (var4_3.zza.zza() >= this.zze().zzb(var4_3.zza.zzz(), zzbf.zzav)) {
                                    var22_86 = null;
                                    if (this.zze().zze(var4_3.zza.zzz(), zzbf.zzcb)) {
                                        var22_86 = this.zzq().zzp();
                                        var23_87 = (zzfn.zzh)((zzjk)zzfn.zzh.zze().zza("_tu").zzb((String)var22_86).zzai());
                                        var20_77.zza((zzfn.zzh)var23_87);
                                    }
                                    var23_87 = (zzfn.zzh)((zzjk)zzfn.zzh.zze().zza("_tr").zza(1L).zzai());
                                    var20_77.zza((zzfn.zzh)var23_87);
                                    var24_92 = this.zzp().zza(var4_3.zza.zzz(), var6_50, var20_77, (String)var22_86);
                                    if (var24_92 != null) {
                                        this.zzj().zzp().zza("Generated trigger URI. appId, uri", (Object)var4_3.zza.zzz(), (Object)var24_92.zza);
                                        this.zzf().zza(var4_3.zza.zzz(), var24_92);
                                        this.zzr.add(var4_3.zza.zzz());
                                    }
                                }
                                var6_50.zza(var19_73, (zzfn.zzf)((zzjk)var20_77.zzai()));
                            }
                        }
                        if (com.google.android.gms.internal.measurement.zznk.zza() && this.zze().zza(zzbf.zzcv)) {
                            var6_50.zzi().zza(this.zzc().zza(var6_50.zzt(), var6_50.zzaa(), var6_50.zzab(), var6_50.zzf(), var6_50.zze(), var16_63.zzj() == false));
                        } else {
                            var6_50.zzi().zza(this.zzc().zza(var6_50.zzt(), var6_50.zzaa(), var6_50.zzab(), var6_50.zzf(), var6_50.zze()));
                        }
                        if (this.zze().zzk(var4_3.zza.zzz())) {
                            var30_17 = var4_3;
                            var29_19 = var6_50;
                            var28_20 = this;
                            var31_99 /* !! */  = new HashMap<K, V>();
                            var32_10 = new ArrayList<zzfn.zzf>();
                            var33_105 = var28_20.zzq().zzv();
                            for (var34_5 = 0; var34_5 < var29_19.zzc(); ++var34_5) {
                                block167: {
                                    var35_25 = (zzfn.zzf.zza)var29_19.zza(var34_5).zzcc();
                                    if (var35_25.zze().equals("_ep")) {
                                        var28_20.zzp();
                                        var36_27 /* !! */  = (String)zznl.zzb((zzfn.zzf)((zzjk)var35_25.zzai()), "_en");
                                        var37_36 = (zzaz)var31_99 /* !! */ .get(var36_27 /* !! */ );
                                        if (var37_36 == null && (var37_36 = var28_20.zzf().zzd(var30_17.zza.zzz(), (String)Preconditions.checkNotNull((Object)var36_27 /* !! */ ))) != null) {
                                            var31_99 /* !! */ .put(var36_27 /* !! */ , var37_36);
                                        }
                                        if (var37_36 != null && var37_36.zzi == null) {
                                            if (var37_36.zzj != null && var37_36.zzj > 1L) {
                                                var28_20.zzp();
                                                zznl.zza(var35_25, "_sr", (Object)var37_36.zzj);
                                            }
                                            if (var37_36.zzk != null && var37_36.zzk.booleanValue()) {
                                                var28_20.zzp();
                                                zznl.zza(var35_25, "_efs", (Object)1L);
                                            }
                                            var32_10.add((zzfn.zzf)((zzjk)var35_25.zzai()));
                                        }
                                        var29_19.zza(var34_5, var35_25);
                                        continue;
                                    }
                                    var36_32 = var28_20.zzi().zza(var30_17.zza.zzz());
                                    var28_20.zzq();
                                    var38_34 = zznp.zza((long)var35_25.zzc(), (long)var36_32);
                                    var40_40 = 1;
                                    var48_110 = 1L;
                                    var47_35 = "_dbg";
                                    var46_48 = (zzfn.zzf)((zzjk)var35_25.zzai());
                                    if (TextUtils.isEmpty((CharSequence)var47_35) || var48_110 == null) {
                                        v4 = false;
                                    } else {
                                        for (zzfn.zzh var50_112 : var46_48.zzh()) {
                                            if (!var47_35.equals(var50_112.zzg())) continue;
                                            v4 = var48_110 instanceof Long != false && var48_110.equals(var50_112.zzd()) != false || var48_110 instanceof String != false && var48_110.equals(var50_112.zzh()) != false || var48_110 instanceof Double && var48_110.equals(var50_112.zza());
                                            break block167;
                                        }
                                        v4 = false;
                                    }
                                }
                                if (!v4) {
                                    var40_40 = var28_20.zzi().zzb(var30_17.zza.zzz(), var35_25.zze());
                                }
                                if (var40_40 <= 0) {
                                    var28_20.zzj().zzu().zza("Sample rate must be positive. event, rate", (Object)var35_25.zze(), (Object)var40_40);
                                    var32_10.add((zzfn.zzf)((zzjk)var35_25.zzai()));
                                    var29_19.zza(var34_5, var35_25);
                                    continue;
                                }
                                var41_41 = (String[])var31_99 /* !! */ .get(var35_25.zze());
                                if (var41_41 == null && (var41_41 = var28_20.zzf().zzd(var30_17.zza.zzz(), var35_25.zze())) == null) {
                                    var28_20.zzj().zzu().zza("Event being bundled has no eventAggregate. appId, eventName", (Object)var30_17.zza.zzz(), (Object)var35_25.zze());
                                    var41_41 = new zzaz(var30_17.zza.zzz(), var35_25.zze(), 1L, 1L, 1L, var35_25.zzc(), 0L, null, null, null, null);
                                }
                                var28_20.zzp();
                                var42_43 = (Long)zznl.zzb((zzfn.zzf)((zzjk)var35_25.zzai()), "_eid");
                                var43_109 = var42_43 != null;
                                if (var40_40 == 1) {
                                    var32_10.add((zzfn.zzf)((zzjk)var35_25.zzai()));
                                    if (var43_109.booleanValue() && (var41_41.zzi != null || var41_41.zzj != null || var41_41.zzk != null)) {
                                        var41_41 = var41_41.zza(null, null, null);
                                        var31_99 /* !! */ .put(var35_25.zze(), var41_41);
                                    }
                                    var29_19.zza(var34_5, var35_25);
                                    continue;
                                }
                                if (var33_105.nextInt(var40_40) == 0) {
                                    var28_20.zzp();
                                    zznl.zza(var35_25, "_sr", (Object)var40_40);
                                    var32_10.add((zzfn.zzf)((zzjk)var35_25.zzai()));
                                    if (var43_109.booleanValue()) {
                                        var41_41 = var41_41.zza(null, Long.valueOf(var40_40), null);
                                    }
                                    var31_99 /* !! */ .put(var35_25.zze(), var41_41.zza(var35_25.zzc(), var38_34));
                                } else {
                                    if (var41_41.zzh != null) {
                                        var44_45 = var41_41.zzh;
                                    } else {
                                        var28_20.zzq();
                                        var44_45 = zznp.zza((long)var35_25.zzb(), (long)var36_32);
                                    }
                                    if (var44_45 != var38_34) {
                                        var28_20.zzp();
                                        zznl.zza(var35_25, "_efs", (Object)1L);
                                        var28_20.zzp();
                                        zznl.zza(var35_25, "_sr", (Object)var40_40);
                                        var32_10.add((zzfn.zzf)((zzjk)var35_25.zzai()));
                                        if (var43_109.booleanValue()) {
                                            var41_41 = var41_41.zza(null, Long.valueOf(var40_40), Boolean.valueOf(true));
                                        }
                                        var31_99 /* !! */ .put(var35_25.zze(), var41_41.zza(var35_25.zzc(), var38_34));
                                    } else if (var43_109.booleanValue()) {
                                        var31_99 /* !! */ .put(var35_25.zze(), var41_41.zza(var42_43, null, null));
                                    }
                                }
                                var29_19.zza(var34_5, var35_25);
                            }
                            if (var32_10.size() < var29_19.zzc()) {
                                var29_19.zzl().zzb(var32_10);
                            }
                            for (Map.Entry var35_26 : var31_99 /* !! */ .entrySet()) {
                                var28_20.zzf().zza((zzaz)var35_26.getValue());
                            }
                        }
                        var19_74 = var4_3.zza.zzz();
                        var20_78 = this.zzf().zze(var19_74);
                        if (var20_78 != null) break block171;
                        this.zzj().zzg().zza("Bundling raw events w/o app info. appId", zzfw.zza((String)var4_3.zza.zzz()));
                        break block172;
                    }
                    if (var6_50.zzc() <= 0) break block172;
                    var21_82 = var20_78.zzs();
                    if (var21_82 != 0L) {
                        var6_50.zzg(var21_82);
                    } else {
                        var6_50.zzo();
                    }
                    var23_88 = var20_78.zzu();
                    if (var23_88 == 0L) {
                        var23_88 = var21_82;
                    }
                    if (var23_88 != 0L) {
                        var6_50.zzh(var23_88);
                    } else {
                        var6_50.zzp();
                    }
                    if (!zzpn.zza() || !this.zze().zza(zzbf.zzbs)) ** GOTO lbl-1000
                    this.zzq();
                    if (zznp.zzf((String)var20_78.zzac())) {
                        var20_78.zza((long)var6_50.zzc());
                        var6_50.zzg((int)var20_78.zzr());
                    } else lbl-1000:
                    // 2 sources

                    {
                        var20_78.zzap();
                    }
                    var6_50.zzf((int)var20_78.zzt());
                    var20_78.zzr(var6_50.zzf());
                    var20_78.zzp(var6_50.zze());
                    var25_95 = var20_78.zzab();
                    if (var25_95 != null) {
                        var6_50.zzn(var25_95);
                    } else {
                        var6_50.zzm();
                    }
                    this.zzf().zza(var20_78, false, false);
                }
                if (var6_50.zzc() > 0) {
                    var21_83 = this.zzi().zzc(var4_3.zza.zzz());
                    if (var21_83 == null || !var21_83.zzs()) {
                        if (var4_3.zza.zzaj().isEmpty()) {
                            var6_50.zzb(-1L);
                        } else {
                            this.zzj().zzu().zza("Did not find measurement config or missing version info. appId", zzfw.zza((String)var4_3.zza.zzz()));
                        }
                    } else {
                        var6_50.zzb(var21_83.zzc());
                    }
                    this.zzf().zza((zzfn.zzk)((zzjk)var6_50.zzai()), var5_49);
                }
                var29_19 = var4_3.zzb;
                var28_20 = this.zzf();
                Preconditions.checkNotNull((Object)var29_19);
                var28_20.zzt();
                var28_20.zzal();
                var30_18 = new StringBuilder("rowid in (");
                for (var31_100 = 0; var31_100 < var29_19.size(); ++var31_100) {
                    if (var31_100 != 0) {
                        var30_18.append(",");
                    }
                    var30_18.append((Long)var29_19.get(var31_100));
                }
                var30_18.append(")");
                var32_11 = var28_20.e_().delete("raw_events", var30_18.toString(), null);
                if (var32_11 != var29_19.size()) {
                    var28_20.zzj().zzg().zza("Deleted fewer rows from raw events table than expected", (Object)var32_11, (Object)var29_19.size());
                }
                var29_19 = var19_74;
                var28_20 = this.zzf();
                var30_18 = var28_20.e_();
                try {
                    var30_18.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", new String[]{var29_19, var29_19});
                }
                catch (SQLiteException var31_101) {
                    var28_20.zzj().zzg().zza("Failed to remove unused event metadata. appId", zzfw.zza((String)var29_19), (Object)var31_101);
                }
                this.zzf().zzw();
                return true;
            }
            this.zzf().zzw();
            return false;
        }
        finally {
            this.zzf().zzu();
        }
    }

    private final boolean zzac() {
        this.zzl().zzt();
        this.zzs();
        return this.zzf().zzx() || !TextUtils.isEmpty((CharSequence)this.zzf().f_());
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zzad() {
        this.zzl().zzt();
        if (this.zzx != null && this.zzx.isValid()) {
            this.zzj().zzp().zza("Storage concurrent access okay");
            return true;
        }
        String string = "google_app_measurement.db";
        File file = this.zzm.zza().getFilesDir();
        File file2 = new File(zzcf.zza().zza(file, string));
        try {
            this.zzy = new RandomAccessFile(file2, "rw").getChannel();
            this.zzx = this.zzy.tryLock();
            if (this.zzx != null) {
                this.zzj().zzp().zza("Storage concurrent access okay");
                return true;
            }
            this.zzj().zzg().zza("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzj().zzg().zza("Failed to acquire storage lock", (Object)fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to access storage lock file", (Object)iOException);
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            this.zzj().zzu().zza("Storage lock already acquired", (Object)overlappingFileLockException);
        }
        return false;
    }

    private final boolean zza(zzfn.zzf.zza zza2, zzfn.zzf.zza zza3) {
        Preconditions.checkArgument((boolean)"_e".equals(zza2.zze()));
        this.zzp();
        zzfn.zzh zzh2 = zznl.zza((zzfn.zzf)((zzjk)zza2.zzai()), "_sc");
        String string = zzh2 == null ? null : zzh2.zzh();
        this.zzp();
        zzfn.zzh zzh3 = zznl.zza((zzfn.zzf)((zzjk)zza3.zzai()), "_pc");
        String string2 = zzh3 == null ? null : zzh3.zzh();
        if (string2 != null && string2.equals(string)) {
            zzfn.zzf.zza zza4 = zza3;
            zzfn.zzf.zza zza5 = zza2;
            zznc zznc2 = this;
            Preconditions.checkArgument((boolean)"_e".equals(zza5.zze()));
            zznc2.zzp();
            zzfn.zzh zzh4 = zznl.zza((zzfn.zzf)((zzjk)zza5.zzai()), "_et");
            if (zzh4 != null && zzh4.zzl() && zzh4.zzd() > 0L) {
                long l = zzh4.zzd();
                zznc2.zzp();
                zzh4 = zznl.zza((zzfn.zzf)((zzjk)zza4.zzai()), "_et");
                if (zzh4 != null && zzh4.zzd() > 0L) {
                    l += zzh4.zzd();
                }
                zznc2.zzp();
                zznl.zza(zza4, "_et", (Object)l);
                zznc2.zzp();
                zznl.zza(zza5, "_fr", (Object)1L);
            }
            return true;
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zza(int n, @Nullable FileChannel fileChannel) {
        this.zzl().zzt();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj().zzg().zza("Bad channel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzj().zzg().zza("Error writing to channel. Bytes written", (Object)fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to write to channel", (Object)iOException);
            return false;
        }
    }

    private final class zzb {
        final String zza;
        long zzb;

        private zzb(zznc zznc2) {
            this(zznc2, zznc2.zzq().zzp());
        }

        /* synthetic */ zzb(zznc zznc2, zznk zznk2) {
            this(zznc2);
        }

        private zzb(zznc zznc2, String string) {
            this.zza = string;
            this.zzb = zznc2.zzb().elapsedRealtime();
        }

        /* synthetic */ zzb(zznc zznc2, String string, zznk zznk2) {
            this(zznc2, string);
        }
    }

    private final class zza
    implements zzap {
        zzfn.zzk zza;
        List<Long> zzb;
        List<zzfn.zzf> zzc;
        private long zzd;

        private static long zza(zzfn.zzf zzf2) {
            return zzf2.zzd() / 1000L / 60L / 60L;
        }

        private zza() {
        }

        /* synthetic */ zza(zznj zznj2) {
            this();
        }

        @Override
        public final void zza(zzfn.zzk zzk2) {
            Preconditions.checkNotNull((Object)((Object)zzk2));
            this.zza = zzk2;
        }

        @Override
        public final boolean zza(long l, zzfn.zzf zzf2) {
            Preconditions.checkNotNull((Object)((Object)zzf2));
            if (this.zzc == null) {
                this.zzc = new ArrayList<zzfn.zzf>();
            }
            if (this.zzb == null) {
                this.zzb = new ArrayList<Long>();
            }
            if (!this.zzc.isEmpty() && com.google.android.gms.measurement.internal.zznc$zza.zza(this.zzc.get(0)) != com.google.android.gms.measurement.internal.zznc$zza.zza(zzf2)) {
                return false;
            }
            long l2 = this.zzd + (long)zzf2.zzca();
            zznc.this.zze();
            if (l2 >= (long)Math.max(0, (Integer)zzbf.zzi.zza(null))) {
                return false;
            }
            this.zzd = l2;
            this.zzc.add(zzf2);
            this.zzb.add(l);
            int n = this.zzc.size();
            zznc.this.zze();
            return n < Math.max(1, (Integer)zzbf.zzj.zza(null));
        }
    }
}

