/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.annotation.TargetApi;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.Context;
import android.os.Build;
import android.os.UserHandle;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@TargetApi(value=24)
public final class zzcv {
    @Nullable
    private static final Method zza = zzcv.zzc();
    @Nullable
    private static final Method zzb = zzcv.zzb();
    private final JobScheduler zzc;

    private static int zza() {
        block4: {
            if (zzb != null) {
                try {
                    Integer n = (Integer)zzb.invoke(UserHandle.class, new Object[0]);
                    if (n != null) {
                        return n;
                    }
                    return 0;
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    if (!Log.isLoggable((String)"JobSchedulerCompat", (int)6)) break block4;
                    Log.e((String)"JobSchedulerCompat", (String)"myUserId invocation illegal", (Throwable)reflectiveOperationException);
                }
            }
        }
        return 0;
    }

    private final int zza(JobInfo jobInfo, String string, int n, String string2) {
        if (zza != null) {
            try {
                Integer n2 = (Integer)zza.invoke((Object)this.zzc, jobInfo, string, n, string2);
                if (n2 != null) {
                    return n2;
                }
                return 0;
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                Log.e((String)string2, (String)"error calling scheduleAsPackage", (Throwable)reflectiveOperationException);
            }
        }
        return this.zzc.schedule(jobInfo);
    }

    public static int zza(Context context, JobInfo jobInfo, String string, String string2) {
        JobScheduler jobScheduler = (JobScheduler)Preconditions.checkNotNull((Object)((JobScheduler)context.getSystemService("jobscheduler")));
        if (zza == null || context.checkSelfPermission("android.permission.UPDATE_DEVICE_STATS") != 0) {
            return jobScheduler.schedule(jobInfo);
        }
        return new zzcv(jobScheduler).zza(jobInfo, string, zzcv.zza(), string2);
    }

    @Nullable
    private static Method zzb() {
        block3: {
            if (Build.VERSION.SDK_INT >= 24) {
                try {
                    return UserHandle.class.getDeclaredMethod("myUserId", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (!Log.isLoggable((String)"JobSchedulerCompat", (int)6)) break block3;
                    Log.e((String)"JobSchedulerCompat", (String)"No myUserId method available");
                }
            }
        }
        return null;
    }

    @Nullable
    private static Method zzc() {
        block3: {
            if (Build.VERSION.SDK_INT >= 24) {
                try {
                    return JobScheduler.class.getDeclaredMethod("scheduleAsPackage", JobInfo.class, String.class, Integer.TYPE, String.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (!Log.isLoggable((String)"JobSchedulerCompat", (int)6)) break block3;
                    Log.e((String)"JobSchedulerCompat", (String)"No scheduleAsPackage method available, falling back to schedule");
                }
            }
        }
        return null;
    }

    private zzcv(JobScheduler jobScheduler) {
        this.zzc = jobScheduler;
    }
}

