/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.measurement.zzcv;
import com.google.android.gms.internal.measurement.zzcw;
import com.google.android.gms.measurement.internal.zzav;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzjc;
import com.google.android.gms.measurement.internal.zznp;
import com.google.android.gms.measurement.internal.zznr;
import com.google.android.gms.measurement.internal.zznv;
import com.google.android.gms.measurement.internal.zzos;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zznq
extends zznr {
    private final @Nullable AlarmManager zza = (AlarmManager)this.zza().getSystemService("alarm");
    private @Nullable zzav zzb;
    private Integer zzc;

    private final int zzv() {
        if (this.zzc == null) {
            String string = this.zza().getPackageName();
            this.zzc = ("measurement" + string).hashCode();
        }
        return this.zzc;
    }

    private final PendingIntent zzw() {
        Context context = this.zza();
        Intent intent = new Intent().setClassName(context, "com.google.android.gms.measurement.AppMeasurementReceiver").setAction("com.google.android.gms.measurement.UPLOAD");
        return zzcw.zza(context, 0, intent, zzcw.zza);
    }

    private final zzav zzx() {
        if (this.zzb == null) {
            this.zzb = new zznp(this, (zzjc)this.zzg.zzk());
        }
        return this.zzb;
    }

    protected zznq(zznv zznv2) {
        super(zznv2);
    }

    public final void zzu() {
        this.zzal();
        this.zzj().zzp().zza("Unscheduling upload");
        if (this.zza != null) {
            this.zza.cancel(this.zzw());
        }
        this.zzx().zza();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzy();
        }
    }

    @TargetApi(value=24)
    private final void zzy() {
        JobScheduler jobScheduler = (JobScheduler)this.zza().getSystemService("jobscheduler");
        if (jobScheduler != null) {
            jobScheduler.cancel(this.zzv());
        }
    }

    public final void zza(long l) {
        this.zzal();
        Context context = this.zza();
        if (!zzos.zza((Context)context)) {
            this.zzj().zzc().zza("Receiver not registered/enabled");
        }
        if (!zzos.zza((Context)context, (boolean)false)) {
            this.zzj().zzc().zza("Service not registered/enabled");
        }
        this.zzu();
        this.zzj().zzp().zza("Scheduling upload, millis", (Object)l);
        long l2 = this.zzb().elapsedRealtime() + l;
        if (l < Math.max(0L, (Long)zzbh.zzy.zza(null)) && !this.zzx().zzc()) {
            this.zzx().zza(l);
        }
        if (Build.VERSION.SDK_INT >= 24) {
            long l3 = l;
            zznq zznq2 = this;
            Context context2 = zznq2.zza();
            ComponentName componentName = new ComponentName(context2, "com.google.android.gms.measurement.AppMeasurementJobService");
            int n = zznq2.zzv();
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            JobInfo jobInfo = new JobInfo.Builder(n, componentName).setMinimumLatency(l3).setOverrideDeadline(l3 << 1).setExtras(persistableBundle).build();
            zzcv.zza(context2, jobInfo, "com.google.android.gms", "UploadAlarm");
            return;
        }
        if (this.zza != null) {
            this.zza.setInexactRepeating(2, l2, Math.max((Long)zzbh.zzt.zza(null), l), this.zzw());
        }
    }

    @Override
    protected final boolean zzc() {
        if (this.zza != null) {
            this.zza.cancel(this.zzw());
        }
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzy();
        }
        return false;
    }
}

