/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.internal.measurement.zzad;
import com.google.android.gms.internal.measurement.zzfo;
import com.google.android.gms.internal.measurement.zzfy;
import com.google.android.gms.internal.measurement.zzjg;
import com.google.android.gms.internal.measurement.zzjt;
import com.google.android.gms.internal.measurement.zzkb;
import com.google.android.gms.internal.measurement.zzlb;
import com.google.android.gms.internal.measurement.zzov;
import com.google.android.gms.internal.measurement.zzpn;
import com.google.android.gms.internal.measurement.zzpo;
import com.google.android.gms.internal.measurement.zzpu;
import com.google.android.gms.measurement.internal.zzbc;
import com.google.android.gms.measurement.internal.zzbe;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzji;
import com.google.android.gms.measurement.internal.zzno;
import com.google.android.gms.measurement.internal.zznr;
import com.google.android.gms.measurement.internal.zzns;
import com.google.android.gms.measurement.internal.zznv;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzos;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzoo
extends zznr {
    static int zza(zzfy.zzk.zza zza2, String string) {
        if (zza2 == null) {
            return -1;
        }
        for (int i = 0; i < zza2.zzd(); ++i) {
            if (!string.equals(zza2.zzk(i).zzg())) continue;
            return i;
        }
        return -1;
    }

    final long zza(@Nullable String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return 0L;
        }
        return this.zza(string.getBytes(Charset.forName("UTF-8")));
    }

    @WorkerThread
    final long zza(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        this.zzq().zzt();
        MessageDigest messageDigest = zzos.zzu();
        if (messageDigest == null) {
            this.zzj().zzg().zza("Failed to get MD5");
            return 0L;
        }
        return zzos.zza((byte[])messageDigest.digest(byArray));
    }

    static Bundle zza(List<zzfy.zzh> list) {
        Bundle bundle = new Bundle();
        for (zzfy.zzh zzh2 : list) {
            String string = zzh2.zzg();
            if (zzh2.zzj()) {
                bundle.putDouble(string, zzh2.zza());
                continue;
            }
            if (zzh2.zzk()) {
                bundle.putFloat(string, zzh2.zzb());
                continue;
            }
            if (zzh2.zzn()) {
                bundle.putString(string, zzh2.zzh());
                continue;
            }
            if (!zzh2.zzl()) continue;
            bundle.putLong(string, zzh2.zzd());
        }
        return bundle;
    }

    private final Bundle zza(Map<String, Object> map, boolean bl) {
        Bundle bundle = new Bundle();
        for (String string : map.keySet()) {
            Object object = map.get(string);
            if (object == null) {
                bundle.putString(string, null);
                continue;
            }
            if (object instanceof Long) {
                bundle.putLong(string, ((Long)object).longValue());
                continue;
            }
            if (object instanceof Double) {
                bundle.putDouble(string, ((Double)object).doubleValue());
                continue;
            }
            if (object instanceof ArrayList) {
                if (!bl) continue;
                ArrayList arrayList = (ArrayList)object;
                zzoo zzoo2 = this;
                ArrayList<Bundle> arrayList2 = new ArrayList<Bundle>();
                ArrayList arrayList3 = arrayList;
                int n = arrayList3.size();
                for (int i = 0; i < n; ++i) {
                    Object e = arrayList3.get(i);
                    Map map2 = (Map)e;
                    Bundle bundle2 = zzoo2.zza(map2, false);
                    arrayList2.add(bundle2);
                }
                bundle.putParcelableArray(string, arrayList2.toArray(new Parcelable[0]));
                continue;
            }
            bundle.putString(string, object.toString());
        }
        return bundle;
    }

    final <T extends Parcelable> @Nullable T zza(byte[] byArray, Parcelable.Creator<T> creator) {
        if (byArray == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcel.unmarshall(byArray, 0, byArray.length);
            parcel.setDataPosition(0);
            Parcelable parcelable = (Parcelable)creator.createFromParcel(parcel);
            return (T)parcelable;
        }
        catch (SafeParcelReader.ParseException parseException) {
            this.zzj().zzg().zza("Failed to load parcelable from buffer");
            return null;
        }
        finally {
            parcel.recycle();
        }
    }

    final zzbf zza(zzad zzad2) {
        Object object;
        Bundle bundle = this.zza(zzad2.zzc(), true);
        String string = "app";
        if (bundle.containsKey("_o") && (object = bundle.get("_o")) != null) {
            string = object.toString();
        }
        if ((object = zzji.zzb((String)zzad2.zzb())) == null) {
            object = zzad2.zzb();
        }
        return new zzbf((String)object, new zzbe(bundle), string, zzad2.zza());
    }

    @TargetApi(value=30)
    final @Nullable zzno zza(String string, zzfy.zzk.zza zza2, zzfy.zzf.zza zza3, @Nullable String string2) {
        int n;
        String string3;
        if (!zzpn.zza() || !this.zze().zze(string, zzbh.zzch)) {
            return null;
        }
        long l = this.zzb().currentTimeMillis();
        Object object = this.zze().zzd(string, zzbh.zzbg).split(",");
        Object object2 = new HashSet<String>(((String[])object).length);
        Object object3 = object;
        int n2 = ((String[])object).length;
        for (int i = 0; i < n2; ++i) {
            string3 = object3[i];
            if (((HashSet)object2).add(Objects.requireNonNull(string3))) continue;
            throw new IllegalArgumentException("duplicate element: " + string3);
        }
        Set<String> set = Collections.unmodifiableSet(object2);
        object2 = string;
        object = ((zzns)this).zzo();
        object3 = ((zzns)((Object)object)).zzm().zzf((String)object2);
        Object object4 = new Uri.Builder();
        object4.scheme(object.zze().zzd((String)object2, zzbh.zzaz));
        if (!TextUtils.isEmpty((CharSequence)object3)) {
            string3 = object.zze().zzd((String)object2, zzbh.zzba);
            Object object5 = object3;
            object4.authority((String)object5 + "." + string3);
        } else {
            object4.authority(object.zze().zzd((String)object2, zzbh.zzba));
        }
        object4.path(object.zze().zzd((String)object2, zzbh.zzbb));
        Uri.Builder builder = object4;
        zzoo.zza(builder, "gmp_app_id", zza2.zzx(), set);
        zzoo.zza(builder, "gmp_version", "106000", set);
        String string4 = zza2.zzu();
        if (this.zze().zze(string, zzbh.zzck) && ((zzns)this).zzm().zzo(string)) {
            string4 = "";
        }
        zzoo.zza(builder, "app_instance_id", string4, set);
        zzoo.zza(builder, "rdid", zza2.zzz(), set);
        zzoo.zza(builder, "bundle_id", zza2.zzt(), set);
        String string5 = zza3.zze();
        String string6 = zzji.zza((String)string5);
        if (!TextUtils.isEmpty((CharSequence)string6)) {
            string5 = string6;
        }
        zzoo.zza(builder, "app_event_name", string5, set);
        zzoo.zza(builder, "app_version", String.valueOf(zza2.zzb()), set);
        String string7 = zza2.zzy();
        if (this.zze().zze(string, zzbh.zzck) && ((zzns)this).zzm().zzs(string) && !TextUtils.isEmpty((CharSequence)string7) && (n = string7.indexOf(".")) != -1) {
            string7 = string7.substring(0, n);
        }
        zzoo.zza(builder, "os_version", string7, set);
        zzoo.zza(builder, "timestamp", String.valueOf(zza3.zzc()), set);
        if (zza2.zzad()) {
            zzoo.zza(builder, "lat", "1", set);
        }
        zzoo.zza(builder, "privacy_sandbox_version", String.valueOf(zza2.zza()), set);
        zzoo.zza(builder, "trigger_uri_source", "1", set);
        zzoo.zza(builder, "trigger_uri_timestamp", String.valueOf(l), set);
        zzoo.zza(builder, "request_uuid", string2, set);
        object = zza3.zzf();
        object3 = new Bundle();
        object4 = object.iterator();
        while (object4.hasNext()) {
            zzfy.zzh zzh2 = (zzfy.zzh)((Object)object4.next());
            string3 = zzh2.zzg();
            if (zzh2.zzj()) {
                object3.putString(string3, String.valueOf(zzh2.zza()));
                continue;
            }
            if (zzh2.zzk()) {
                object3.putString(string3, String.valueOf(zzh2.zzb()));
                continue;
            }
            if (zzh2.zzn()) {
                object3.putString(string3, zzh2.zzh());
                continue;
            }
            if (!zzh2.zzl()) continue;
            object3.putString(string3, String.valueOf(zzh2.zzd()));
        }
        Bundle bundle = object3;
        String[] stringArray = this.zze().zzd(string, zzbh.zzbf).split("\\|");
        zzoo.zza(builder, stringArray, bundle, set);
        object = zza2.zzab();
        object3 = new Bundle();
        object4 = object.iterator();
        while (object4.hasNext()) {
            zzfy.zzo zzo2 = (zzfy.zzo)((Object)object4.next());
            string3 = zzo2.zzg();
            if (zzo2.zzi()) {
                object3.putString(string3, String.valueOf(zzo2.zza()));
                continue;
            }
            if (zzo2.zzj()) {
                object3.putString(string3, String.valueOf(zzo2.zzb()));
                continue;
            }
            if (zzo2.zzm()) {
                object3.putString(string3, zzo2.zzh());
                continue;
            }
            if (!zzo2.zzk()) continue;
            object3.putString(string3, String.valueOf(zzo2.zzc()));
        }
        Bundle bundle2 = object3;
        String[] stringArray2 = this.zze().zzd(string, zzbh.zzbe).split("\\|");
        zzoo.zza(builder, stringArray2, bundle2, set);
        zzoo.zza(builder, "dma", zza2.zzac() ? "1" : "0", set);
        if (!zza2.zzw().isEmpty()) {
            zzoo.zza(builder, "dma_cps", zza2.zzw(), set);
        }
        if (this.zze().zza(zzbh.zzcm) && zza2.zzae()) {
            object4 = set;
            object3 = zza2.zzg();
            object2 = builder;
            if (!((zzfy.zza)((Object)object3)).zzh().isEmpty()) {
                zzoo.zza((Uri.Builder)object2, "dl_gclid", ((zzfy.zza)((Object)object3)).zzh(), (Set<String>)object4);
            }
            if (!((zzfy.zza)((Object)object3)).zzg().isEmpty()) {
                zzoo.zza((Uri.Builder)object2, "dl_gbraid", ((zzfy.zza)((Object)object3)).zzg(), (Set<String>)object4);
            }
            if (!((zzfy.zza)((Object)object3)).zzf().isEmpty()) {
                zzoo.zza((Uri.Builder)object2, "dl_gs", ((zzfy.zza)((Object)object3)).zzf(), (Set<String>)object4);
            }
            if (((zzfy.zza)((Object)object3)).zza() > 0L) {
                zzoo.zza((Uri.Builder)object2, "dl_ss_ts", String.valueOf(((zzfy.zza)((Object)object3)).zza()), (Set<String>)object4);
            }
            if (!((zzfy.zza)((Object)object3)).zzk().isEmpty()) {
                zzoo.zza((Uri.Builder)object2, "mr_gclid", ((zzfy.zza)((Object)object3)).zzk(), (Set<String>)object4);
            }
            if (!((zzfy.zza)((Object)object3)).zzj().isEmpty()) {
                zzoo.zza((Uri.Builder)object2, "mr_gbraid", ((zzfy.zza)((Object)object3)).zzj(), (Set<String>)object4);
            }
            if (!((zzfy.zza)((Object)object3)).zzi().isEmpty()) {
                zzoo.zza((Uri.Builder)object2, "mr_gs", ((zzfy.zza)((Object)object3)).zzi(), (Set<String>)object4);
            }
            if (((zzfy.zza)((Object)object3)).zzb() > 0L) {
                zzoo.zza((Uri.Builder)object2, "mr_click_ts", String.valueOf(((zzfy.zza)((Object)object3)).zzb()), (Set<String>)object4);
            }
        }
        return new zzno(builder.build().toString(), l, 1);
    }

    final zzfy.zzf zza(zzbc zzbc2) {
        zzfy.zzf.zza zza2 = zzfy.zzf.zze().zza(zzbc2.zze);
        for (String string : zzbc2.zzf) {
            zzfy.zzh.zza zza3 = zzfy.zzh.zze().zza(string);
            Object object = zzbc2.zzf.zzc(string);
            Preconditions.checkNotNull((Object)object);
            this.zza(zza3, object);
            zza2.zza(zza3);
        }
        if (this.zze().zza(zzbh.zzdi) && !TextUtils.isEmpty((CharSequence)zzbc2.zzc) && zzbc2.zzf.zzc("_o") == null) {
            zza2.zza((zzfy.zzh)((zzjt)zzfy.zzh.zze().zza("_o").zzb(zzbc2.zzc).zzai()));
        }
        return (zzfy.zzf)((zzjt)zza2.zzai());
    }

    static @Nullable zzfy.zzh zza(zzfy.zzf zzf2, String string) {
        for (zzfy.zzh zzh2 : zzf2.zzh()) {
            if (!zzh2.zzg().equals(string)) continue;
            return zzh2;
        }
        return null;
    }

    static <BuilderT extends zzlb> BuilderT zza(BuilderT BuilderT, byte[] byArray) throws zzkb {
        zzjg zzjg2 = zzjg.zza();
        if (zzjg2 != null) {
            return (BuilderT)BuilderT.zza(byArray, zzjg2);
        }
        return (BuilderT)BuilderT.zza(byArray);
    }

    static @Nullable Object zzb(zzfy.zzf zzf2, String string) {
        zzfy.zzh zzh2 = zzoo.zza(zzf2, string);
        if (zzh2 != null) {
            if (zzh2.zzn()) {
                return zzh2.zzh();
            }
            if (zzh2.zzl()) {
                return zzh2.zzd();
            }
            if (zzh2.zzj()) {
                return zzh2.zza();
            }
            if (zzh2.zzc() > 0) {
                return zzoo.zzb(zzh2.zzi());
            }
        }
        return null;
    }

    static Object zza(zzfy.zzf zzf2, String string, Object object) {
        Object object2 = zzoo.zzb(zzf2, string);
        if (object2 == null) {
            return object;
        }
        return object2;
    }

    final String zza(zzfy.zzj zzj2) {
        if (zzj2 == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nbatch {\n");
        if (zzpu.zza() && this.zze().zza(zzbh.zzbx) && zzj2.zza() > 0) {
            this.zzq();
            if (zzos.zzf((String)zzj2.zza(0).zzz())) {
                if (zzj2.zzh()) {
                    zzoo.zza(stringBuilder, 0, "upload_subdomain", zzj2.zze());
                }
                if (zzj2.zzg()) {
                    zzoo.zza(stringBuilder, 0, "sgtm_join_id", zzj2.zzd());
                }
            }
        }
        Iterator<zzfy.zzk> iterator = zzj2.zzf().iterator();
        while (iterator.hasNext()) {
            Object object;
            Iterator iterator2;
            StringBuilder stringBuilder2;
            int n;
            Object object2;
            zzfy.zzk zzk2;
            zzfy.zzk zzk3 = zzk2 = iterator.next();
            StringBuilder stringBuilder3 = stringBuilder;
            zzoo zzoo2 = this;
            if (zzk3 == null) continue;
            zzoo.zza(stringBuilder3, 1);
            stringBuilder3.append("bundle {\n");
            if (zzk3.zzbp()) {
                zzoo.zza(stringBuilder3, 1, "protocol_version", zzk3.zzf());
            }
            if (zzpo.zza() && zzoo2.zze().zze(zzk3.zzz(), zzbh.zzbw) && zzk3.zzbs()) {
                zzoo.zza(stringBuilder3, 1, "session_stitching_token", zzk3.zzao());
            }
            zzoo.zza(stringBuilder3, 1, "platform", zzk3.zzam());
            if (zzk3.zzbk()) {
                zzoo.zza(stringBuilder3, 1, "gmp_version", zzk3.zzn());
            }
            if (zzk3.zzbx()) {
                zzoo.zza(stringBuilder3, 1, "uploading_gmp_version", zzk3.zzt());
            }
            if (zzk3.zzbi()) {
                zzoo.zza(stringBuilder3, 1, "dynamite_version", zzk3.zzl());
            }
            if (zzk3.zzbb()) {
                zzoo.zza(stringBuilder3, 1, "config_version", zzk3.zzj());
            }
            zzoo.zza(stringBuilder3, 1, "gmp_app_id", zzk3.zzaj());
            zzoo.zza(stringBuilder3, 1, "admob_app_id", zzk3.zzy());
            zzoo.zza(stringBuilder3, 1, "app_id", zzk3.zzz());
            zzoo.zza(stringBuilder3, 1, "app_version", zzk3.zzac());
            if (zzk3.zzay()) {
                zzoo.zza(stringBuilder3, 1, "app_version_major", zzk3.zzb());
            }
            zzoo.zza(stringBuilder3, 1, "firebase_instance_id", zzk3.zzai());
            if (zzk3.zzbg()) {
                zzoo.zza(stringBuilder3, 1, "dev_cert_hash", zzk3.zzk());
            }
            zzoo.zza(stringBuilder3, 1, "app_store", zzk3.zzab());
            if (zzk3.zzbw()) {
                zzoo.zza(stringBuilder3, 1, "upload_timestamp_millis", zzk3.zzs());
            }
            if (zzk3.zzbt()) {
                zzoo.zza(stringBuilder3, 1, "start_timestamp_millis", zzk3.zzq());
            }
            if (zzk3.zzbj()) {
                zzoo.zza(stringBuilder3, 1, "end_timestamp_millis", zzk3.zzm());
            }
            if (zzk3.zzbo()) {
                zzoo.zza(stringBuilder3, 1, "previous_bundle_start_timestamp_millis", zzk3.zzp());
            }
            if (zzk3.zzbn()) {
                zzoo.zza(stringBuilder3, 1, "previous_bundle_end_timestamp_millis", zzk3.zzo());
            }
            zzoo.zza(stringBuilder3, 1, "app_instance_id", zzk3.zzaa());
            zzoo.zza(stringBuilder3, 1, "resettable_device_id", zzk3.zzan());
            zzoo.zza(stringBuilder3, 1, "ds_id", zzk3.zzah());
            if (zzk3.zzbm()) {
                zzoo.zza(stringBuilder3, 1, "limited_ad_tracking", zzk3.zzav());
            }
            zzoo.zza(stringBuilder3, 1, "os_version", zzk3.zzal());
            zzoo.zza(stringBuilder3, 1, "device_model", zzk3.zzag());
            zzoo.zza(stringBuilder3, 1, "user_default_language", zzk3.zzap());
            if (zzk3.zzbv()) {
                zzoo.zza(stringBuilder3, 1, "time_zone_offset_minutes", zzk3.zzh());
            }
            if (zzk3.zzba()) {
                zzoo.zza(stringBuilder3, 1, "bundle_sequential_index", zzk3.zzc());
            }
            if (zzpu.zza()) {
                zzoo2.zzq();
                if (zzos.zzf((String)zzk3.zzz()) && zzoo2.zze().zza(zzbh.zzbx) && zzk3.zzbf()) {
                    zzoo.zza(stringBuilder3, 1, "delivery_index", zzk3.zzd());
                }
            }
            if (zzk3.zzbr()) {
                zzoo.zza(stringBuilder3, 1, "service_upload", zzk3.zzaw());
            }
            zzoo.zza(stringBuilder3, 1, "health_monitor", zzk3.zzak());
            if (zzk3.zzbq()) {
                zzoo.zza(stringBuilder3, 1, "retry_counter", zzk3.zzg());
            }
            if (zzk3.zzbd()) {
                zzoo.zza(stringBuilder3, 1, "consent_signals", zzk3.zzae());
            }
            if (zzk3.zzbl()) {
                zzoo.zza(stringBuilder3, 1, "is_dma_region", zzk3.zzau());
            }
            if (zzk3.zzbe()) {
                zzoo.zza(stringBuilder3, 1, "core_platform_services", zzk3.zzaf());
            }
            if (zzk3.zzbc()) {
                zzoo.zza(stringBuilder3, 1, "consent_diagnostics", zzk3.zzad());
            }
            if (zzk3.zzbu()) {
                zzoo.zza(stringBuilder3, 1, "target_os_version", zzk3.zzr());
            }
            if (zzpn.zza() && zzoo2.zze().zze(zzk3.zzz(), zzbh.zzch)) {
                zzoo.zza(stringBuilder3, 1, "ad_services_version", zzk3.zza());
                if (zzk3.zzaz()) {
                    object2 = zzk3.zzv();
                    n = 1;
                    stringBuilder2 = stringBuilder3;
                    if (object2 != null) {
                        ++n;
                        zzoo.zza(stringBuilder2, 2);
                        stringBuilder2.append("attribution_eligibility_status {\n");
                        zzoo.zza(stringBuilder2, 2, "eligible", ((zzfy.zzc)((Object)object2)).zzf());
                        zzoo.zza(stringBuilder2, 2, "no_access_adservices_attribution_permission", ((zzfy.zzc)((Object)object2)).zzh());
                        zzoo.zza(stringBuilder2, 2, "pre_r", ((zzfy.zzc)((Object)object2)).zzi());
                        zzoo.zza(stringBuilder2, 2, "r_extensions_too_old", ((zzfy.zzc)((Object)object2)).zzj());
                        zzoo.zza(stringBuilder2, 2, "adservices_extension_too_old", ((zzfy.zzc)((Object)object2)).zze());
                        zzoo.zza(stringBuilder2, 2, "ad_storage_not_allowed", ((zzfy.zzc)((Object)object2)).zzd());
                        zzoo.zza(stringBuilder2, 2, "measurement_manager_disabled", ((zzfy.zzc)((Object)object2)).zzg());
                        zzoo.zza(stringBuilder2, 2);
                        stringBuilder2.append("}\n");
                    }
                }
            }
            if (zzov.zza() && zzoo2.zze().zza(zzbh.zzcu) && zzk3.zzax()) {
                object2 = zzk3.zzu();
                stringBuilder2 = stringBuilder3;
                zzoo.zza(stringBuilder2, 2);
                stringBuilder2.append("ad_campaign_info {\n");
                if (((zzfy.zza)((Object)object2)).zzn()) {
                    zzoo.zza(stringBuilder2, 2, "deep_link_gclid", ((zzfy.zza)((Object)object2)).zzh());
                }
                if (((zzfy.zza)((Object)object2)).zzm()) {
                    zzoo.zza(stringBuilder2, 2, "deep_link_gbraid", ((zzfy.zza)((Object)object2)).zzg());
                }
                if (((zzfy.zza)((Object)object2)).zzl()) {
                    zzoo.zza(stringBuilder2, 2, "deep_link_gad_source", ((zzfy.zza)((Object)object2)).zzf());
                }
                if (((zzfy.zza)((Object)object2)).zzo()) {
                    zzoo.zza(stringBuilder2, 2, "deep_link_session_millis", ((zzfy.zza)((Object)object2)).zza());
                }
                if (((zzfy.zza)((Object)object2)).zzs()) {
                    zzoo.zza(stringBuilder2, 2, "market_referrer_gclid", ((zzfy.zza)((Object)object2)).zzk());
                }
                if (((zzfy.zza)((Object)object2)).zzr()) {
                    zzoo.zza(stringBuilder2, 2, "market_referrer_gbraid", ((zzfy.zza)((Object)object2)).zzj());
                }
                if (((zzfy.zza)((Object)object2)).zzq()) {
                    zzoo.zza(stringBuilder2, 2, "market_referrer_gad_source", ((zzfy.zza)((Object)object2)).zzi());
                }
                if (((zzfy.zza)((Object)object2)).zzp()) {
                    zzoo.zza(stringBuilder2, 2, "market_referrer_click_millis", ((zzfy.zza)((Object)object2)).zzb());
                }
                zzoo.zza(stringBuilder2, 2);
                stringBuilder2.append("}\n");
            }
            object2 = zzk3.zzas();
            n = 1;
            stringBuilder2 = stringBuilder3;
            zzoo zzoo3 = zzoo2;
            if (object2 != null) {
                ++n;
                iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    object = (zzfy.zzo)((Object)iterator2.next());
                    if (object == null) continue;
                    zzoo.zza(stringBuilder2, 2);
                    stringBuilder2.append("user_property {\n");
                    zzoo.zza(stringBuilder2, 2, "set_timestamp_millis", object.zzl() ? Long.valueOf(object.zzd()) : null);
                    zzoo.zza(stringBuilder2, 2, "name", zzoo3.zzi().zzc(object.zzg()));
                    zzoo.zza(stringBuilder2, 2, "string_value", object.zzh());
                    zzoo.zza(stringBuilder2, 2, "int_value", object.zzk() ? Long.valueOf(object.zzc()) : null);
                    zzoo.zza(stringBuilder2, 2, "double_value", object.zzi() ? Double.valueOf(object.zza()) : null);
                    zzoo.zza(stringBuilder2, 2);
                    stringBuilder2.append("}\n");
                }
            }
            List<zzfy.zzd> list = zzk3.zzaq();
            zzk3.zzz();
            object2 = list;
            n = 1;
            stringBuilder2 = stringBuilder3;
            if (object2 != null) {
                ++n;
                object = object2.iterator();
                while (object.hasNext()) {
                    zzfy.zzd zzd2 = (zzfy.zzd)((Object)object.next());
                    if (zzd2 == null) continue;
                    zzoo.zza(stringBuilder2, 2);
                    stringBuilder2.append("audience_membership {\n");
                    if (zzd2.zzg()) {
                        zzoo.zza(stringBuilder2, 2, "audience_id", zzd2.zza());
                    }
                    if (zzd2.zzh()) {
                        zzoo.zza(stringBuilder2, 2, "new_audience", zzd2.zzf());
                    }
                    zzoo.zza(stringBuilder2, 2, "current_data", zzd2.zzd());
                    if (zzd2.zzi()) {
                        zzoo.zza(stringBuilder2, 2, "previous_data", zzd2.zze());
                    }
                    zzoo.zza(stringBuilder2, 2);
                    stringBuilder2.append("}\n");
                }
            }
            object2 = zzk3.zzar();
            n = 1;
            stringBuilder2 = stringBuilder3;
            zzoo3 = zzoo2;
            if (object2 != null) {
                ++n;
                iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    object = (zzfy.zzf)((Object)iterator2.next());
                    if (object == null) continue;
                    zzoo.zza(stringBuilder2, 2);
                    stringBuilder2.append("event {\n");
                    zzoo.zza(stringBuilder2, 2, "name", zzoo3.zzi().zza(((zzfy.zzf)((Object)object)).zzg()));
                    if (((zzfy.zzf)((Object)object)).zzk()) {
                        zzoo.zza(stringBuilder2, 2, "timestamp_millis", ((zzfy.zzf)((Object)object)).zzd());
                    }
                    if (((zzfy.zzf)((Object)object)).zzj()) {
                        zzoo.zza(stringBuilder2, 2, "previous_timestamp_millis", ((zzfy.zzf)((Object)object)).zzc());
                    }
                    if (((zzfy.zzf)((Object)object)).zzi()) {
                        zzoo.zza(stringBuilder2, 2, "count", ((zzfy.zzf)((Object)object)).zza());
                    }
                    if (((zzfy.zzf)((Object)object)).zzb() != 0) {
                        zzoo3.zza(stringBuilder2, 2, ((zzfy.zzf)((Object)object)).zzh());
                    }
                    zzoo.zza(stringBuilder2, 2);
                    stringBuilder2.append("}\n");
                }
            }
            zzoo.zza(stringBuilder3, 1);
            stringBuilder3.append("}\n");
        }
        stringBuilder.append("} // End-of-batch\n");
        return stringBuilder.toString();
    }

    final String zza(zzfo.zzb zzb2) {
        if (zzb2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nevent_filter {\n");
        if (zzb2.zzl()) {
            zzoo.zza(stringBuilder, 0, "filter_id", zzb2.zzb());
        }
        zzoo.zza(stringBuilder, 0, "event_name", this.zzi().zza(zzb2.zzf()));
        String string = zzoo.zza(zzb2.zzh(), zzb2.zzi(), zzb2.zzj());
        if (!string.isEmpty()) {
            zzoo.zza(stringBuilder, 0, "filter_type", string);
        }
        if (zzb2.zzk()) {
            zzoo.zza(stringBuilder, 1, "event_count_filter", zzb2.zze());
        }
        if (zzb2.zza() > 0) {
            stringBuilder.append("  filters {\n");
            for (zzfo.zzc zzc2 : zzb2.zzg()) {
                this.zza(stringBuilder, 2, zzc2);
            }
        }
        zzoo.zza(stringBuilder, 1);
        stringBuilder.append("}\n}\n");
        return stringBuilder.toString();
    }

    private static String zza(boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("Dynamic ");
        }
        if (bl2) {
            stringBuilder.append("Sequence ");
        }
        if (bl3) {
            stringBuilder.append("Session-Scoped ");
        }
        return stringBuilder.toString();
    }

    final String zza(zzfo.zze zze2) {
        if (zze2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nproperty_filter {\n");
        if (zze2.zzi()) {
            zzoo.zza(stringBuilder, 0, "filter_id", zze2.zza());
        }
        zzoo.zza(stringBuilder, 0, "property_name", this.zzi().zzc(zze2.zze()));
        String string = zzoo.zza(zze2.zzf(), zze2.zzg(), zze2.zzh());
        if (!string.isEmpty()) {
            zzoo.zza(stringBuilder, 0, "filter_type", string);
        }
        this.zza(stringBuilder, 1, zze2.zzb());
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    final List<Long> zza(List<Long> list, List<Integer> list2) {
        ArrayList<Long> arrayList = new ArrayList<Long>(list);
        for (Integer n : list2) {
            if (n < 0) {
                this.zzj().zzu().zza("Ignoring negative bit index to be cleared", (Object)n);
                continue;
            }
            int n2 = n / 64;
            if (n2 >= arrayList.size()) {
                this.zzj().zzu().zza("Ignoring bit index greater than bitSet size", (Object)n, (Object)arrayList.size());
                continue;
            }
            arrayList.set(n2, arrayList.get(n2) & (1L << n % 64 ^ 0xFFFFFFFFFFFFFFFFL));
        }
        int n = arrayList.size();
        int n3 = arrayList.size() - 1;
        while (n3 >= 0 && arrayList.get(n3) == 0L) {
            n = n3--;
        }
        return arrayList.subList(0, n);
    }

    final @Nullable List<Integer> zzu() {
        Map map = zzbh.zza((Context)this.zzg.zza());
        if (map == null || map.isEmpty()) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = (Integer)zzbh.zzar.zza(null);
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getKey()).startsWith("measurement.id.")) continue;
            try {
                int n2 = Integer.parseInt((String)entry.getValue());
                if (n2 == 0) continue;
                arrayList.add(n2);
                if (arrayList.size() < n) continue;
                this.zzj().zzu().zza("Too many experiment IDs. Number of IDs", (Object)arrayList.size());
                break;
            }
            catch (NumberFormatException numberFormatException) {
                this.zzj().zzu().zza("Experiment ID NumberFormatException", (Object)numberFormatException);
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    static List<Long> zza(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        for (int i = 0; i < n; ++i) {
            long l = 0L;
            for (int j = 0; j < 64 && (i << 6) + j < bitSet.length(); ++j) {
                if (!bitSet.get((i << 6) + j)) continue;
                l |= 1L << j;
            }
            arrayList.add(l);
        }
        return arrayList;
    }

    final Map<String, Object> zza(Bundle bundle, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string : bundle.keySet()) {
            Object object;
            Object object2 = object = bundle.get(string);
            if (object instanceof Parcelable[] || object2 instanceof ArrayList || object2 instanceof Bundle) {
                if (!bl) continue;
                Object object3 = object;
                object2 = this;
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                if (object3 instanceof Parcelable[]) {
                    for (Parcelable parcelable : (Parcelable[])object3) {
                        if (!(parcelable instanceof Bundle)) continue;
                        arrayList.add(((zzoo)((Object)object2)).zza((Bundle)parcelable, false));
                    }
                } else if (object3 instanceof ArrayList) {
                    ArrayList arrayList2 = (ArrayList)object3;
                    int n = arrayList2.size();
                    for (int i = 0; i < n; ++i) {
                        Object e = arrayList2.get(i);
                        Object e2 = e;
                        if (!(e instanceof Bundle)) continue;
                        arrayList.add(((zzoo)((Object)object2)).zza((Bundle)e2, false));
                    }
                } else if (object3 instanceof Bundle) {
                    arrayList.add(((zzoo)((Object)object2)).zza((Bundle)object3, false));
                }
                hashMap.put(string, arrayList);
                continue;
            }
            if (object == null) continue;
            hashMap.put(string, object);
        }
        return hashMap;
    }

    zzoo(zznv zznv2) {
        super(zznv2);
    }

    static void zza(zzfy.zzf.zza zza2, String string, Object object) {
        List<zzfy.zzh> list = zza2.zzf();
        int n = -1;
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(list.get(i).zzg())) continue;
            n = i;
            break;
        }
        zzfy.zzh.zza zza3 = zzfy.zzh.zze().zza(string);
        if (object instanceof Long) {
            zza3.zza((Long)object);
        } else if (object instanceof String) {
            zza3.zzb((String)object);
        } else if (object instanceof Double) {
            zza3.zza((Double)object);
        }
        if (n >= 0) {
            zza2.zza(n, zza3);
            return;
        }
        zza2.zza(zza3);
    }

    private static void zza(Uri.Builder builder, String[] stringArray, Bundle bundle, Set<String> set) {
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(",");
            String string = stringArray2[0];
            String string2 = stringArray2[stringArray2.length - 1];
            String string3 = bundle.getString(string);
            if (string3 == null) continue;
            zzoo.zza(builder, string2, string3, set);
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzfy.zzm zzm2) {
        int n2;
        if (zzm2 == null) {
            return;
        }
        ++n;
        zzoo.zza(stringBuilder, 3);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzm2.zzb() != 0) {
            zzoo.zza(stringBuilder, 4);
            stringBuilder.append("results: ");
            n2 = 0;
            for (Long object : zzm2.zzi()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object);
            }
            stringBuilder.append('\n');
        }
        if (zzm2.zzd() != 0) {
            zzoo.zza(stringBuilder, 4);
            stringBuilder.append("status: ");
            n2 = 0;
            for (Long l : zzm2.zzk()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
        }
        if (zzm2.zza() != 0) {
            zzoo.zza(stringBuilder, 4);
            stringBuilder.append("dynamic_filter_timestamps: {");
            n2 = 0;
            for (zzfy.zze zze2 : zzm2.zzh()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(zze2.zzf() ? Integer.valueOf(zze2.zza()) : null).append(":").append(zze2.zze() ? Long.valueOf(zze2.zzb()) : null);
            }
            stringBuilder.append("}\n");
        }
        if (zzm2.zzc() != 0) {
            zzoo.zza(stringBuilder, 4);
            stringBuilder.append("sequence_filter_timestamps: {");
            n2 = 0;
            for (zzfy.zzn zzn2 : zzm2.zzj()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(zzn2.zzf() ? Integer.valueOf(zzn2.zzb()) : null).append(": [");
                int n3 = 0;
                for (long l : zzn2.zze()) {
                    if (n3++ != 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(l);
                }
                stringBuilder.append("]");
            }
            stringBuilder.append("}\n");
        }
        zzoo.zza(stringBuilder, 3);
        stringBuilder.append("}\n");
    }

    private final void zza(StringBuilder stringBuilder, int n, List<zzfy.zzh> list) {
        if (list == null) {
            return;
        }
        ++n;
        for (zzfy.zzh zzh2 : list) {
            if (zzh2 == null) continue;
            zzoo.zza(stringBuilder, n);
            stringBuilder.append("param {\n");
            zzoo.zza(stringBuilder, n, "name", zzh2.zzm() ? this.zzi().zzb(zzh2.zzg()) : null);
            zzoo.zza(stringBuilder, n, "string_value", zzh2.zzn() ? zzh2.zzh() : null);
            zzoo.zza(stringBuilder, n, "int_value", zzh2.zzl() ? Long.valueOf(zzh2.zzd()) : null);
            zzoo.zza(stringBuilder, n, "double_value", zzh2.zzj() ? Double.valueOf(zzh2.zza()) : null);
            if (zzh2.zzc() > 0) {
                this.zza(stringBuilder, n, zzh2.zzi());
            }
            zzoo.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private final void zza(StringBuilder stringBuilder, int n, zzfo.zzc zzc2) {
        if (zzc2 == null) {
            return;
        }
        zzoo.zza(stringBuilder, n);
        stringBuilder.append("filter {\n");
        if (zzc2.zzg()) {
            zzoo.zza(stringBuilder, n, "complement", zzc2.zzf());
        }
        if (zzc2.zzi()) {
            zzoo.zza(stringBuilder, n, "param_name", this.zzi().zzb(zzc2.zze()));
        }
        if (zzc2.zzj()) {
            zzfo.zzf zzf2 = zzc2.zzd();
            String string = "string_filter";
            int n2 = n + 1;
            StringBuilder stringBuilder2 = stringBuilder;
            if (zzf2 != null) {
                zzoo.zza(stringBuilder2, n2);
                stringBuilder2.append(string);
                stringBuilder2.append(" {\n");
                if (zzf2.zzj()) {
                    zzoo.zza(stringBuilder2, n2, "match_type", zzf2.zzb().name());
                }
                if (zzf2.zzi()) {
                    zzoo.zza(stringBuilder2, n2, "expression", zzf2.zze());
                }
                if (zzf2.zzh()) {
                    zzoo.zza(stringBuilder2, n2, "case_sensitive", zzf2.zzg());
                }
                if (zzf2.zza() > 0) {
                    zzoo.zza(stringBuilder2, n2 + 1);
                    stringBuilder2.append("expression_list {\n");
                    for (String string2 : zzf2.zzf()) {
                        zzoo.zza(stringBuilder2, n2 + 2);
                        stringBuilder2.append(string2);
                        stringBuilder2.append("\n");
                    }
                    stringBuilder2.append("}\n");
                }
                zzoo.zza(stringBuilder2, n2);
                stringBuilder2.append("}\n");
            }
        }
        if (zzc2.zzh()) {
            zzoo.zza(stringBuilder, n + 1, "number_filter", zzc2.zzc());
        }
        zzoo.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzfo.zzd zzd2) {
        if (zzd2 == null) {
            return;
        }
        zzoo.zza(stringBuilder, n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzd2.zzh()) {
            zzoo.zza(stringBuilder, n, "comparison_type", zzd2.zza().name());
        }
        if (zzd2.zzj()) {
            zzoo.zza(stringBuilder, n, "match_as_float", zzd2.zzg());
        }
        if (zzd2.zzi()) {
            zzoo.zza(stringBuilder, n, "comparison_value", zzd2.zzd());
        }
        if (zzd2.zzl()) {
            zzoo.zza(stringBuilder, n, "min_comparison_value", zzd2.zzf());
        }
        if (zzd2.zzk()) {
            zzoo.zza(stringBuilder, n, "max_comparison_value", zzd2.zze());
        }
        zzoo.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(Uri.Builder builder, String string, @Nullable String string2, Set<String> set) {
        if (set.contains(string) || TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        builder.appendQueryParameter(string, string2);
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, @Nullable Object object) {
        if (object == null) {
            return;
        }
        zzoo.zza(stringBuilder, n + 1);
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }

    final void zza(zzfy.zzh.zza zza2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zza2.zze().zzc().zzb().zzd();
        if (object instanceof String) {
            zza2.zzb((String)object);
            return;
        }
        if (object instanceof Long) {
            zza2.zza((Long)object);
            return;
        }
        if (object instanceof Double) {
            zza2.zza((Double)object);
            return;
        }
        if (object instanceof Bundle[]) {
            Bundle[] bundleArray = (Bundle[])object;
            ArrayList<zzfy.zzh> arrayList = new ArrayList<zzfy.zzh>();
            Bundle[] bundleArray2 = bundleArray;
            int n = bundleArray.length;
            for (int i = 0; i < n; ++i) {
                Bundle bundle = bundleArray2[i];
                if (bundle == null) continue;
                zzfy.zzh.zza zza3 = zzfy.zzh.zze();
                for (String string : bundle.keySet()) {
                    zzfy.zzh.zza zza4 = zzfy.zzh.zze().zza(string);
                    Object object2 = bundle.get(string);
                    if (object2 instanceof Long) {
                        zza4.zza((Long)object2);
                    } else if (object2 instanceof String) {
                        zza4.zzb((String)object2);
                    } else {
                        if (!(object2 instanceof Double)) continue;
                        zza4.zza((Double)object2);
                    }
                    zza3.zza(zza4);
                }
                if (zza3.zza() <= 0) continue;
                arrayList.add((zzfy.zzh)((zzjt)zza3.zzai()));
            }
            zza2.zza(arrayList);
            return;
        }
        this.zzj().zzg().zza("Ignoring invalid (type) event param value", object);
    }

    final void zza(zzfy.zzo.zza zza2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zza2.zzc().zzb().zza();
        if (object instanceof String) {
            zza2.zzb((String)object);
            return;
        }
        if (object instanceof Long) {
            zza2.zza((Long)object);
            return;
        }
        if (object instanceof Double) {
            zza2.zza((Double)object);
            return;
        }
        this.zzj().zzg().zza("Ignoring invalid (type) user attribute value", object);
    }

    @WorkerThread
    static boolean zza(zzbf zzbf2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzbf2);
        Preconditions.checkNotNull((Object)zzo2);
        return !TextUtils.isEmpty((CharSequence)zzo2.zzb) || !TextUtils.isEmpty((CharSequence)zzo2.zzp);
    }

    static boolean zza(List<Long> list, int n) {
        return n < list.size() << 6 && (list.get(n / 64) & 1L << n % 64) != 0L;
    }

    final boolean zza(long l, long l2) {
        return l == 0L || l2 <= 0L || Math.abs(this.zzb().currentTimeMillis() - l) > l2;
    }

    static boolean zzb(String string) {
        return string != null && string.matches("([+-])?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    @Override
    protected final boolean zzc() {
        return false;
    }

    final byte[] zzb(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to gzip content", (Object)iOException);
            throw iOException;
        }
    }

    final byte[] zzc(byte[] byArray) throws IOException {
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to ungzip content", (Object)iOException);
            throw iOException;
        }
    }

    static Bundle[] zzb(List<zzfy.zzh> list) {
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        for (zzfy.zzh zzh2 : list) {
            if (zzh2 == null) continue;
            Bundle bundle = new Bundle();
            for (zzfy.zzh zzh3 : zzh2.zzi()) {
                if (zzh3.zzn()) {
                    bundle.putString(zzh3.zzg(), zzh3.zzh());
                    continue;
                }
                if (zzh3.zzl()) {
                    bundle.putLong(zzh3.zzg(), zzh3.zzd());
                    continue;
                }
                if (!zzh3.zzj()) continue;
                bundle.putDouble(zzh3.zzg(), zzh3.zza());
            }
            if (bundle.isEmpty()) continue;
            arrayList.add(bundle);
        }
        return arrayList.toArray(new Bundle[arrayList.size()]);
    }
}

