/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.measurement.zzcx;
import com.google.android.gms.internal.measurement.zzcy;
import com.google.android.gms.measurement.internal.zzbb;
import com.google.android.gms.measurement.internal.zzbn;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzol;
import com.google.android.gms.measurement.internal.zzot;
import com.google.android.gms.measurement.internal.zzou;
import com.google.android.gms.measurement.internal.zzpn;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzoi
extends zzot {
    private final @Nullable AlarmManager zza = (AlarmManager)this.zza().getSystemService("alarm");
    private @Nullable zzbb zzb;
    private Integer zzc;

    private final int zzw() {
        if (this.zzc == null) {
            String string = this.zza().getPackageName();
            this.zzc = ("measurement" + string).hashCode();
        }
        return this.zzc;
    }

    private final PendingIntent zzx() {
        Context context = this.zza();
        Intent intent = new Intent().setClassName(context, "com.google.android.gms.measurement.AppMeasurementReceiver").setAction("com.google.android.gms.measurement.UPLOAD");
        return zzcy.zza(context, 0, intent, zzcy.zza);
    }

    private final zzbb zzy() {
        if (this.zzb == null) {
            this.zzb = new zzol(this, (zzjh)this.zzg.zzk());
        }
        return this.zzb;
    }

    protected zzoi(zzou zzou2) {
        super(zzou2);
    }

    public final void zzr() {
        this.zzam();
        this.zzj().zzq().zza("Unscheduling upload");
        if (this.zza != null) {
            this.zza.cancel(this.zzx());
        }
        this.zzy().zza();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzz();
        }
    }

    @TargetApi(value=24)
    private final void zzz() {
        JobScheduler jobScheduler = (JobScheduler)this.zza().getSystemService("jobscheduler");
        if (jobScheduler != null) {
            jobScheduler.cancel(this.zzw());
        }
    }

    public final void zza(long l) {
        this.zzam();
        Context context = this.zza();
        if (!zzpn.zza((Context)context)) {
            this.zzj().zzc().zza("Receiver not registered/enabled");
        }
        if (!zzpn.zza((Context)context, (boolean)false)) {
            this.zzj().zzc().zza("Service not registered/enabled");
        }
        this.zzr();
        this.zzj().zzq().zza("Scheduling upload, millis", (Object)l);
        long l2 = this.zzb().elapsedRealtime() + l;
        if (l < Math.max(0L, (Long)zzbn.zzag.zza(null)) && !this.zzy().zzc()) {
            this.zzy().zza(l);
        }
        if (Build.VERSION.SDK_INT >= 24) {
            long l3 = l;
            zzoi zzoi2 = this;
            Context context2 = zzoi2.zza();
            ComponentName componentName = new ComponentName(context2, "com.google.android.gms.measurement.AppMeasurementJobService");
            int n = zzoi2.zzw();
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            JobInfo jobInfo = new JobInfo.Builder(n, componentName).setMinimumLatency(l3).setOverrideDeadline(l3 << 1).setExtras(persistableBundle).build();
            zzcx.zza(context2, jobInfo, "com.google.android.gms", "UploadAlarm");
            return;
        }
        if (this.zza != null) {
            this.zza.setInexactRepeating(2, l2, Math.max((Long)zzbn.zzab.zza(null), l), this.zzx());
        }
    }

    @Override
    protected final boolean zzc() {
        if (this.zza != null) {
            this.zza.cancel(this.zzx());
        }
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzz();
        }
        return false;
    }
}

