/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.internal.measurement.zzad;
import com.google.android.gms.internal.measurement.zzfw;
import com.google.android.gms.internal.measurement.zzgg;
import com.google.android.gms.internal.measurement.zzjv;
import com.google.android.gms.internal.measurement.zzki;
import com.google.android.gms.internal.measurement.zzkq;
import com.google.android.gms.internal.measurement.zzlq;
import com.google.android.gms.internal.measurement.zzpr;
import com.google.android.gms.measurement.internal.zzbg;
import com.google.android.gms.measurement.internal.zzbi;
import com.google.android.gms.measurement.internal.zzbj;
import com.google.android.gms.measurement.internal.zzbl;
import com.google.android.gms.measurement.internal.zzka;
import com.google.android.gms.measurement.internal.zzow;
import com.google.android.gms.measurement.internal.zzpa;
import com.google.android.gms.measurement.internal.zzpf;
import com.google.android.gms.measurement.internal.zzpk;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzqd;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzpz
extends zzpf {
    static int zza(zzgg.zzk.zza zza2, String string) {
        if (zza2 == null) {
            return -1;
        }
        for (int i = 0; i < zza2.zzd(); ++i) {
            if (!string.equals(zza2.zzk(i).zzg())) continue;
            return i;
        }
        return -1;
    }

    final long zza(@Nullable String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return 0L;
        }
        return this.zza(string.getBytes(Charset.forName("UTF-8")));
    }

    @WorkerThread
    final long zza(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        this.zzs().zzv();
        MessageDigest messageDigest = zzqd.zzr();
        if (messageDigest == null) {
            this.zzj().zzg().zza("Failed to get MD5");
            return 0L;
        }
        return zzqd.zza((byte[])messageDigest.digest(byArray));
    }

    static Bundle zza(List<zzgg.zzh> list) {
        Bundle bundle = new Bundle();
        for (zzgg.zzh zzh2 : list) {
            String string = zzh2.zzg();
            if (zzh2.zzj()) {
                bundle.putDouble(string, zzh2.zza());
                continue;
            }
            if (zzh2.zzk()) {
                bundle.putFloat(string, zzh2.zzb());
                continue;
            }
            if (zzh2.zzn()) {
                bundle.putString(string, zzh2.zzh());
                continue;
            }
            if (!zzh2.zzl()) continue;
            bundle.putLong(string, zzh2.zzd());
        }
        return bundle;
    }

    private final Bundle zza(Map<String, Object> map, boolean bl) {
        Bundle bundle = new Bundle();
        for (String string : map.keySet()) {
            Object object = map.get(string);
            if (object == null) {
                bundle.putString(string, null);
                continue;
            }
            if (object instanceof Long) {
                bundle.putLong(string, ((Long)object).longValue());
                continue;
            }
            if (object instanceof Double) {
                bundle.putDouble(string, ((Double)object).doubleValue());
                continue;
            }
            if (object instanceof ArrayList) {
                if (!bl) continue;
                ArrayList arrayList = (ArrayList)object;
                zzpz zzpz2 = this;
                ArrayList<Bundle> arrayList2 = new ArrayList<Bundle>();
                ArrayList arrayList3 = arrayList;
                int n = arrayList3.size();
                for (int i = 0; i < n; ++i) {
                    Object e = arrayList3.get(i);
                    Map map2 = (Map)e;
                    Bundle bundle2 = zzpz2.zza(map2, false);
                    arrayList2.add(bundle2);
                }
                bundle.putParcelableArray(string, arrayList2.toArray(new Parcelable[0]));
                continue;
            }
            bundle.putString(string, object.toString());
        }
        return bundle;
    }

    final <T extends Parcelable> @Nullable T zza(byte[] byArray, Parcelable.Creator<T> creator) {
        if (byArray == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcel.unmarshall(byArray, 0, byArray.length);
            parcel.setDataPosition(0);
            Parcelable parcelable = (Parcelable)creator.createFromParcel(parcel);
            return (T)parcelable;
        }
        catch (SafeParcelReader.ParseException parseException) {
            this.zzj().zzg().zza("Failed to load parcelable from buffer");
            return null;
        }
        finally {
            parcel.recycle();
        }
    }

    final zzbj zza(zzad zzad2) {
        Object object;
        Bundle bundle = this.zza(zzad2.zzc(), true);
        String string = "app";
        if (bundle.containsKey("_o") && (object = bundle.get("_o")) != null) {
            string = object.toString();
        }
        if ((object = zzka.zzb((String)zzad2.zzb())) == null) {
            object = zzad2.zzb();
        }
        return new zzbj((String)object, new zzbi(bundle), string, zzad2.zza());
    }

    @TargetApi(value=30)
    final @Nullable zzow zza(String string, zzgg.zzk.zza zza2, zzgg.zzf.zza zza3, @Nullable String string2) {
        int n;
        String string3;
        if (!com.google.android.gms.internal.measurement.zzpf.zza() || !this.zze().zze(string, zzbl.zzcu)) {
            return null;
        }
        long l = this.zzb().currentTimeMillis();
        Object object = this.zze().zzd(string, zzbl.zzbs).split(",");
        Object object2 = new HashSet<String>(((String[])object).length);
        Bundle bundle = object;
        int n2 = ((String[])object).length;
        for (int i = 0; i < n2; ++i) {
            string3 = bundle[i];
            if (((HashSet)object2).add(Objects.requireNonNull(string3))) continue;
            throw new IllegalArgumentException("duplicate element: " + string3);
        }
        Set<String> set = Collections.unmodifiableSet(object2);
        object2 = string;
        object = ((zzpa)this).zzp();
        bundle = ((zzpa)((Object)object)).zzm().zzf((String)object2);
        Object object3 = new Uri.Builder();
        object3.scheme(object.zze().zzd((String)object2, zzbl.zzbl));
        if (!TextUtils.isEmpty((CharSequence)bundle)) {
            string3 = object.zze().zzd((String)object2, zzbl.zzbm);
            Object object4 = bundle;
            object3.authority((String)object4 + "." + string3);
        } else {
            object3.authority(object.zze().zzd((String)object2, zzbl.zzbm));
        }
        object3.path(object.zze().zzd((String)object2, zzbl.zzbn));
        Uri.Builder builder = object3;
        zzpz.zza(builder, "gmp_app_id", zza2.zzy(), set);
        zzpz.zza(builder, "gmp_version", "118003", set);
        String string4 = zza2.zzv();
        if (this.zze().zze(string, zzbl.zzcx) && ((zzpa)this).zzm().zzo(string)) {
            string4 = "";
        }
        zzpz.zza(builder, "app_instance_id", string4, set);
        zzpz.zza(builder, "rdid", zza2.zzaa(), set);
        zzpz.zza(builder, "bundle_id", zza2.zzu(), set);
        String string5 = zza3.zze();
        String string6 = zzka.zza((String)string5);
        if (!TextUtils.isEmpty((CharSequence)string6)) {
            string5 = string6;
        }
        zzpz.zza(builder, "app_event_name", string5, set);
        zzpz.zza(builder, "app_version", String.valueOf(zza2.zzb()), set);
        String string7 = zza2.zzz();
        if (this.zze().zze(string, zzbl.zzcx) && ((zzpa)this).zzm().zzs(string) && !TextUtils.isEmpty((CharSequence)string7) && (n = string7.indexOf(".")) != -1) {
            string7 = string7.substring(0, n);
        }
        zzpz.zza(builder, "os_version", string7, set);
        zzpz.zza(builder, "timestamp", String.valueOf(zza3.zzc()), set);
        if (zza2.zzae()) {
            zzpz.zza(builder, "lat", "1", set);
        }
        zzpz.zza(builder, "privacy_sandbox_version", String.valueOf(zza2.zza()), set);
        zzpz.zza(builder, "trigger_uri_source", "1", set);
        zzpz.zza(builder, "trigger_uri_timestamp", String.valueOf(l), set);
        zzpz.zza(builder, "request_uuid", string2, set);
        object = zza3.zzf();
        bundle = new Bundle();
        object3 = object.iterator();
        while (object3.hasNext()) {
            zzgg.zzh zzh2 = (zzgg.zzh)object3.next();
            string3 = zzh2.zzg();
            if (zzh2.zzj()) {
                bundle.putString(string3, String.valueOf(zzh2.zza()));
                continue;
            }
            if (zzh2.zzk()) {
                bundle.putString(string3, String.valueOf(zzh2.zzb()));
                continue;
            }
            if (zzh2.zzn()) {
                bundle.putString(string3, zzh2.zzh());
                continue;
            }
            if (!zzh2.zzl()) continue;
            bundle.putString(string3, String.valueOf(zzh2.zzd()));
        }
        Bundle bundle2 = bundle;
        String[] stringArray = this.zze().zzd(string, zzbl.zzbr).split("\\|");
        zzpz.zza(builder, stringArray, bundle2, set);
        object = zza2.zzac();
        bundle = new Bundle();
        object3 = object.iterator();
        while (object3.hasNext()) {
            zzgg.zzp zzp2 = (zzgg.zzp)object3.next();
            string3 = zzp2.zzg();
            if (zzp2.zzi()) {
                bundle.putString(string3, String.valueOf(zzp2.zza()));
                continue;
            }
            if (zzp2.zzj()) {
                bundle.putString(string3, String.valueOf(zzp2.zzb()));
                continue;
            }
            if (zzp2.zzm()) {
                bundle.putString(string3, zzp2.zzh());
                continue;
            }
            if (!zzp2.zzk()) continue;
            bundle.putString(string3, String.valueOf(zzp2.zzc()));
        }
        Bundle bundle3 = bundle;
        String[] stringArray2 = this.zze().zzd(string, zzbl.zzbq).split("\\|");
        zzpz.zza(builder, stringArray2, bundle3, set);
        zzpz.zza(builder, "dma", zza2.zzad() ? "1" : "0", set);
        if (!zza2.zzx().isEmpty()) {
            zzpz.zza(builder, "dma_cps", zza2.zzx(), set);
        }
        if (this.zze().zza(zzbl.zzcz) && zza2.zzaf()) {
            object3 = set;
            bundle = zza2.zzg();
            object2 = builder;
            if (!bundle.zzh().isEmpty()) {
                zzpz.zza((Uri.Builder)object2, "dl_gclid", bundle.zzh(), (Set<String>)object3);
            }
            if (!bundle.zzg().isEmpty()) {
                zzpz.zza((Uri.Builder)object2, "dl_gbraid", bundle.zzg(), (Set<String>)object3);
            }
            if (!bundle.zzf().isEmpty()) {
                zzpz.zza((Uri.Builder)object2, "dl_gs", bundle.zzf(), (Set<String>)object3);
            }
            if (bundle.zza() > 0L) {
                zzpz.zza((Uri.Builder)object2, "dl_ss_ts", String.valueOf(bundle.zza()), (Set<String>)object3);
            }
            if (!bundle.zzk().isEmpty()) {
                zzpz.zza((Uri.Builder)object2, "mr_gclid", bundle.zzk(), (Set<String>)object3);
            }
            if (!bundle.zzj().isEmpty()) {
                zzpz.zza((Uri.Builder)object2, "mr_gbraid", bundle.zzj(), (Set<String>)object3);
            }
            if (!bundle.zzi().isEmpty()) {
                zzpz.zza((Uri.Builder)object2, "mr_gs", bundle.zzi(), (Set<String>)object3);
            }
            if (bundle.zzb() > 0L) {
                zzpz.zza((Uri.Builder)object2, "mr_click_ts", String.valueOf(bundle.zzb()), (Set<String>)object3);
            }
        }
        return new zzow(builder.build().toString(), l, 1);
    }

    final zzgg.zzf zza(zzbg zzbg2) {
        zzgg.zzf.zza zza2 = zzgg.zzf.zze().zza(zzbg2.zze);
        for (String string : zzbg2.zzf) {
            zzgg.zzh.zza zza3 = zzgg.zzh.zze().zza(string);
            Object object = zzbg2.zzf.zzc(string);
            Preconditions.checkNotNull((Object)object);
            this.zza(zza3, object);
            zza2.zza(zza3);
        }
        if (!TextUtils.isEmpty((CharSequence)zzbg2.zzc) && zzbg2.zzf.zzc("_o") == null) {
            zza2.zza((zzgg.zzh)((zzki)zzgg.zzh.zze().zza("_o").zzb(zzbg2.zzc).zzaj()));
        }
        return (zzgg.zzf)((zzki)zza2.zzaj());
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable zzgg.zzh zza(zzgg.zzf zzf2, String string) {
        for (zzgg.zzh zzh2 : zzf2.zzh()) {
            if (!zzh2.zzg().equals(string)) continue;
            return zzh2;
        }
        return null;
    }

    static <BuilderT extends zzlq> BuilderT zza(BuilderT BuilderT, byte[] byArray) throws zzkq {
        zzjv zzjv2 = zzjv.zza();
        if (zzjv2 != null) {
            return (BuilderT)BuilderT.zza(byArray, zzjv2);
        }
        return (BuilderT)BuilderT.zza(byArray);
    }

    static @Nullable Object zzb(zzgg.zzf zzf2, String string) {
        zzgg.zzh zzh2 = zzpz.zza(zzf2, string);
        if (zzh2 != null) {
            if (zzh2.zzn()) {
                return zzh2.zzh();
            }
            if (zzh2.zzl()) {
                return zzh2.zzd();
            }
            if (zzh2.zzj()) {
                return zzh2.zza();
            }
            if (zzh2.zzc() > 0) {
                return zzpz.zzb(zzh2.zzi());
            }
        }
        return null;
    }

    static Object zza(zzgg.zzf zzf2, String string, Object object) {
        Object object2 = zzpz.zzb(zzf2, string);
        if (object2 == null) {
            return object;
        }
        return object2;
    }

    final String zza(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable zzgg.zzj zzj2) {
        if (zzj2 == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nbatch {\n");
        if (zzj2.zzh()) {
            zzpz.zza(stringBuilder, 0, "upload_subdomain", zzj2.zze());
        }
        if (zzj2.zzg()) {
            zzpz.zza(stringBuilder, 0, "sgtm_join_id", zzj2.zzd());
        }
        Iterator iterator = zzj2.zzf().iterator();
        while (iterator.hasNext()) {
            Object object;
            Iterator iterator2;
            StringBuilder stringBuilder2;
            int n;
            Object object2;
            zzgg.zzk zzk2;
            zzgg.zzk zzk3 = zzk2 = (zzgg.zzk)iterator.next();
            StringBuilder stringBuilder3 = stringBuilder;
            zzpz zzpz2 = this;
            if (zzk3 == null) continue;
            zzpz.zza(stringBuilder3, 1);
            stringBuilder3.append("bundle {\n");
            if (zzk3.zzbs()) {
                zzpz.zza(stringBuilder3, 1, "protocol_version", zzk3.zzf());
            }
            if (zzpr.zza() && zzpz2.zze().zze(zzk3.zzab(), zzbl.zzck) && zzk3.zzbv()) {
                zzpz.zza(stringBuilder3, 1, "session_stitching_token", zzk3.zzaq());
            }
            zzpz.zza(stringBuilder3, 1, "platform", zzk3.zzao());
            if (zzk3.zzbn()) {
                zzpz.zza(stringBuilder3, 1, "gmp_version", zzk3.zzo());
            }
            if (zzk3.zzcb()) {
                zzpz.zza(stringBuilder3, 1, "uploading_gmp_version", zzk3.zzu());
            }
            if (zzk3.zzbl()) {
                zzpz.zza(stringBuilder3, 1, "dynamite_version", zzk3.zzm());
            }
            if (zzk3.zzbe()) {
                zzpz.zza(stringBuilder3, 1, "config_version", zzk3.zzk());
            }
            zzpz.zza(stringBuilder3, 1, "gmp_app_id", zzk3.zzal());
            zzpz.zza(stringBuilder3, 1, "admob_app_id", zzk3.zzaa());
            zzpz.zza(stringBuilder3, 1, "app_id", zzk3.zzab());
            zzpz.zza(stringBuilder3, 1, "app_version", zzk3.zzae());
            if (zzk3.zzba()) {
                zzpz.zza(stringBuilder3, 1, "app_version_major", zzk3.zzb());
            }
            zzpz.zza(stringBuilder3, 1, "firebase_instance_id", zzk3.zzak());
            if (zzk3.zzbj()) {
                zzpz.zza(stringBuilder3, 1, "dev_cert_hash", zzk3.zzl());
            }
            zzpz.zza(stringBuilder3, 1, "app_store", zzk3.zzad());
            if (zzk3.zzca()) {
                zzpz.zza(stringBuilder3, 1, "upload_timestamp_millis", zzk3.zzt());
            }
            if (zzk3.zzbx()) {
                zzpz.zza(stringBuilder3, 1, "start_timestamp_millis", zzk3.zzr());
            }
            if (zzk3.zzbm()) {
                zzpz.zza(stringBuilder3, 1, "end_timestamp_millis", zzk3.zzn());
            }
            if (zzk3.zzbr()) {
                zzpz.zza(stringBuilder3, 1, "previous_bundle_start_timestamp_millis", zzk3.zzq());
            }
            if (zzk3.zzbq()) {
                zzpz.zza(stringBuilder3, 1, "previous_bundle_end_timestamp_millis", zzk3.zzp());
            }
            zzpz.zza(stringBuilder3, 1, "app_instance_id", zzk3.zzac());
            zzpz.zza(stringBuilder3, 1, "resettable_device_id", zzk3.zzap());
            zzpz.zza(stringBuilder3, 1, "ds_id", zzk3.zzaj());
            if (zzk3.zzbp()) {
                zzpz.zza(stringBuilder3, 1, "limited_ad_tracking", zzk3.zzax());
            }
            zzpz.zza(stringBuilder3, 1, "os_version", zzk3.zzan());
            zzpz.zza(stringBuilder3, 1, "device_model", zzk3.zzai());
            zzpz.zza(stringBuilder3, 1, "user_default_language", zzk3.zzar());
            if (zzk3.zzbz()) {
                zzpz.zza(stringBuilder3, 1, "time_zone_offset_minutes", zzk3.zzh());
            }
            if (zzk3.zzbd()) {
                zzpz.zza(stringBuilder3, 1, "bundle_sequential_index", zzk3.zzc());
            }
            if (zzk3.zzbi()) {
                zzpz.zza(stringBuilder3, 1, "delivery_index", zzk3.zzd());
            }
            if (zzk3.zzbu()) {
                zzpz.zza(stringBuilder3, 1, "service_upload", zzk3.zzay());
            }
            zzpz.zza(stringBuilder3, 1, "health_monitor", zzk3.zzam());
            if (zzk3.zzbt()) {
                zzpz.zza(stringBuilder3, 1, "retry_counter", zzk3.zzg());
            }
            if (zzk3.zzbg()) {
                zzpz.zza(stringBuilder3, 1, "consent_signals", zzk3.zzag());
            }
            if (zzk3.zzbo()) {
                zzpz.zza(stringBuilder3, 1, "is_dma_region", zzk3.zzaw());
            }
            if (zzk3.zzbh()) {
                zzpz.zza(stringBuilder3, 1, "core_platform_services", zzk3.zzah());
            }
            if (zzk3.zzbf()) {
                zzpz.zza(stringBuilder3, 1, "consent_diagnostics", zzk3.zzaf());
            }
            if (zzk3.zzby()) {
                zzpz.zza(stringBuilder3, 1, "target_os_version", zzk3.zzs());
            }
            if (com.google.android.gms.internal.measurement.zzpf.zza() && zzpz2.zze().zze(zzk3.zzab(), zzbl.zzcu)) {
                zzpz.zza(stringBuilder3, 1, "ad_services_version", zzk3.zza());
                if (zzk3.zzbb()) {
                    object2 = zzk3.zzw();
                    n = 1;
                    stringBuilder2 = stringBuilder3;
                    if (object2 != null) {
                        ++n;
                        zzpz.zza(stringBuilder2, 2);
                        stringBuilder2.append("attribution_eligibility_status {\n");
                        zzpz.zza(stringBuilder2, 2, "eligible", object2.zzf());
                        zzpz.zza(stringBuilder2, 2, "no_access_adservices_attribution_permission", object2.zzh());
                        zzpz.zza(stringBuilder2, 2, "pre_r", object2.zzi());
                        zzpz.zza(stringBuilder2, 2, "r_extensions_too_old", object2.zzj());
                        zzpz.zza(stringBuilder2, 2, "adservices_extension_too_old", object2.zze());
                        zzpz.zza(stringBuilder2, 2, "ad_storage_not_allowed", object2.zzd());
                        zzpz.zza(stringBuilder2, 2, "measurement_manager_disabled", object2.zzg());
                        zzpz.zza(stringBuilder2, 2);
                        stringBuilder2.append("}\n");
                    }
                }
            }
            if (zzk3.zzaz()) {
                object2 = zzk3.zzv();
                stringBuilder2 = stringBuilder3;
                zzpz.zza(stringBuilder2, 2);
                stringBuilder2.append("ad_campaign_info {\n");
                if (object2.zzn()) {
                    zzpz.zza(stringBuilder2, 2, "deep_link_gclid", object2.zzh());
                }
                if (object2.zzm()) {
                    zzpz.zza(stringBuilder2, 2, "deep_link_gbraid", object2.zzg());
                }
                if (object2.zzl()) {
                    zzpz.zza(stringBuilder2, 2, "deep_link_gad_source", object2.zzf());
                }
                if (object2.zzo()) {
                    zzpz.zza(stringBuilder2, 2, "deep_link_session_millis", object2.zza());
                }
                if (object2.zzs()) {
                    zzpz.zza(stringBuilder2, 2, "market_referrer_gclid", object2.zzk());
                }
                if (object2.zzr()) {
                    zzpz.zza(stringBuilder2, 2, "market_referrer_gbraid", object2.zzj());
                }
                if (object2.zzq()) {
                    zzpz.zza(stringBuilder2, 2, "market_referrer_gad_source", object2.zzi());
                }
                if (object2.zzp()) {
                    zzpz.zza(stringBuilder2, 2, "market_referrer_click_millis", object2.zzb());
                }
                zzpz.zza(stringBuilder2, 2);
                stringBuilder2.append("}\n");
            }
            if (zzk3.zzbc()) {
                zzpz.zza(stringBuilder3, 1, "batching_timestamp_millis", zzk3.zzj());
            }
            if (zzk3.zzbw()) {
                object2 = zzk3.zzz();
                stringBuilder2 = stringBuilder3;
                zzpz.zza(stringBuilder2, 2);
                stringBuilder2.append("sgtm_diagnostics {\n");
                zzpz.zza(stringBuilder2, 2, "upload_type", object2.zzd().name());
                zzpz.zza(stringBuilder2, 2, "client_upload_eligibility", object2.zzb().name());
                zzpz.zza(stringBuilder2, 2, "service_upload_eligibility", object2.zzc().name());
                zzpz.zza(stringBuilder2, 2);
                stringBuilder2.append("}\n");
            }
            object2 = zzk3.zzau();
            n = 1;
            stringBuilder2 = stringBuilder3;
            zzpz zzpz3 = zzpz2;
            if (object2 != null) {
                ++n;
                iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    object = (zzgg.zzp)iterator2.next();
                    if (object == null) continue;
                    zzpz.zza(stringBuilder2, 2);
                    stringBuilder2.append("user_property {\n");
                    zzpz.zza(stringBuilder2, 2, "set_timestamp_millis", object.zzl() ? Long.valueOf(object.zzd()) : null);
                    zzpz.zza(stringBuilder2, 2, "name", zzpz3.zzi().zzc(object.zzg()));
                    zzpz.zza(stringBuilder2, 2, "string_value", object.zzh());
                    zzpz.zza(stringBuilder2, 2, "int_value", object.zzk() ? Long.valueOf(object.zzc()) : null);
                    zzpz.zza(stringBuilder2, 2, "double_value", object.zzi() ? Double.valueOf(object.zza()) : null);
                    zzpz.zza(stringBuilder2, 2);
                    stringBuilder2.append("}\n");
                }
            }
            List list = zzk3.zzas();
            zzk3.zzab();
            object2 = list;
            n = 1;
            stringBuilder2 = stringBuilder3;
            if (object2 != null) {
                ++n;
                object = object2.iterator();
                while (object.hasNext()) {
                    zzgg.zzd zzd2 = (zzgg.zzd)object.next();
                    if (zzd2 == null) continue;
                    zzpz.zza(stringBuilder2, 2);
                    stringBuilder2.append("audience_membership {\n");
                    if (zzd2.zzg()) {
                        zzpz.zza(stringBuilder2, 2, "audience_id", zzd2.zza());
                    }
                    if (zzd2.zzh()) {
                        zzpz.zza(stringBuilder2, 2, "new_audience", zzd2.zzf());
                    }
                    zzpz.zza(stringBuilder2, 2, "current_data", zzd2.zzd());
                    if (zzd2.zzi()) {
                        zzpz.zza(stringBuilder2, 2, "previous_data", zzd2.zze());
                    }
                    zzpz.zza(stringBuilder2, 2);
                    stringBuilder2.append("}\n");
                }
            }
            object2 = zzk3.zzat();
            n = 1;
            stringBuilder2 = stringBuilder3;
            zzpz3 = zzpz2;
            if (object2 != null) {
                ++n;
                iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    object = (zzgg.zzf)iterator2.next();
                    if (object == null) continue;
                    zzpz.zza(stringBuilder2, 2);
                    stringBuilder2.append("event {\n");
                    zzpz.zza(stringBuilder2, 2, "name", zzpz3.zzi().zza(object.zzg()));
                    if (object.zzk()) {
                        zzpz.zza(stringBuilder2, 2, "timestamp_millis", object.zzd());
                    }
                    if (object.zzj()) {
                        zzpz.zza(stringBuilder2, 2, "previous_timestamp_millis", object.zzc());
                    }
                    if (object.zzi()) {
                        zzpz.zza(stringBuilder2, 2, "count", object.zza());
                    }
                    if (object.zzb() != 0) {
                        zzpz3.zza(stringBuilder2, 2, object.zzh());
                    }
                    zzpz.zza(stringBuilder2, 2);
                    stringBuilder2.append("}\n");
                }
            }
            zzpz.zza(stringBuilder3, 1);
            stringBuilder3.append("}\n");
        }
        stringBuilder.append("} // End-of-batch\n");
        return stringBuilder.toString();
    }

    final String zza(zzfw.zzb zzb2) {
        if (zzb2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nevent_filter {\n");
        if (zzb2.zzl()) {
            zzpz.zza(stringBuilder, 0, "filter_id", zzb2.zzb());
        }
        zzpz.zza(stringBuilder, 0, "event_name", this.zzi().zza(zzb2.zzf()));
        String string = zzpz.zza(zzb2.zzh(), zzb2.zzi(), zzb2.zzj());
        if (!string.isEmpty()) {
            zzpz.zza(stringBuilder, 0, "filter_type", string);
        }
        if (zzb2.zzk()) {
            zzpz.zza(stringBuilder, 1, "event_count_filter", zzb2.zze());
        }
        if (zzb2.zza() > 0) {
            stringBuilder.append("  filters {\n");
            for (zzfw.zzc zzc2 : zzb2.zzg()) {
                this.zza(stringBuilder, 2, zzc2);
            }
        }
        zzpz.zza(stringBuilder, 1);
        stringBuilder.append("}\n}\n");
        return stringBuilder.toString();
    }

    private static String zza(boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("Dynamic ");
        }
        if (bl2) {
            stringBuilder.append("Sequence ");
        }
        if (bl3) {
            stringBuilder.append("Session-Scoped ");
        }
        return stringBuilder.toString();
    }

    final String zza(zzfw.zze zze2) {
        if (zze2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nproperty_filter {\n");
        if (zze2.zzi()) {
            zzpz.zza(stringBuilder, 0, "filter_id", zze2.zza());
        }
        zzpz.zza(stringBuilder, 0, "property_name", this.zzi().zzc(zze2.zze()));
        String string = zzpz.zza(zze2.zzf(), zze2.zzg(), zze2.zzh());
        if (!string.isEmpty()) {
            zzpz.zza(stringBuilder, 0, "filter_type", string);
        }
        this.zza(stringBuilder, 1, zze2.zzb());
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    final List<Long> zza(List<Long> list, List<Integer> list2) {
        ArrayList<Long> arrayList = new ArrayList<Long>(list);
        for (Integer n : list2) {
            if (n < 0) {
                this.zzj().zzr().zza("Ignoring negative bit index to be cleared", (Object)n);
                continue;
            }
            int n2 = n / 64;
            if (n2 >= arrayList.size()) {
                this.zzj().zzr().zza("Ignoring bit index greater than bitSet size", (Object)n, (Object)arrayList.size());
                continue;
            }
            arrayList.set(n2, arrayList.get(n2) & (1L << n % 64 ^ 0xFFFFFFFFFFFFFFFFL));
        }
        int n = arrayList.size();
        int n3 = arrayList.size() - 1;
        while (n3 >= 0 && arrayList.get(n3) == 0L) {
            n = n3--;
        }
        return arrayList.subList(0, n);
    }

    final @Nullable List<Integer> zzr() {
        Map map = zzbl.zza((Context)this.zzg.zza());
        if (map == null || map.isEmpty()) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = (Integer)zzbl.zzbd.zza(null);
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getKey()).startsWith("measurement.id.")) continue;
            try {
                int n2 = Integer.parseInt((String)entry.getValue());
                if (n2 == 0) continue;
                arrayList.add(n2);
                if (arrayList.size() < n) continue;
                this.zzj().zzr().zza("Too many experiment IDs. Number of IDs", (Object)arrayList.size());
                break;
            }
            catch (NumberFormatException numberFormatException) {
                this.zzj().zzr().zza("Experiment ID NumberFormatException", (Object)numberFormatException);
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    static List<Long> zza(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        for (int i = 0; i < n; ++i) {
            long l = 0L;
            for (int j = 0; j < 64 && (i << 6) + j < bitSet.length(); ++j) {
                if (!bitSet.get((i << 6) + j)) continue;
                l |= 1L << j;
            }
            arrayList.add(l);
        }
        return arrayList;
    }

    final Map<String, Object> zza(Bundle bundle, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string : bundle.keySet()) {
            Object object;
            Object object2 = object = bundle.get(string);
            if (object instanceof Parcelable[] || object2 instanceof ArrayList || object2 instanceof Bundle) {
                if (!bl) continue;
                Object object3 = object;
                object2 = this;
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                if (object3 instanceof Parcelable[]) {
                    for (Parcelable parcelable : (Parcelable[])object3) {
                        if (!(parcelable instanceof Bundle)) continue;
                        arrayList.add(((zzpz)((Object)object2)).zza((Bundle)parcelable, false));
                    }
                } else if (object3 instanceof ArrayList) {
                    ArrayList arrayList2 = (ArrayList)object3;
                    int n = arrayList2.size();
                    for (int i = 0; i < n; ++i) {
                        Object e = arrayList2.get(i);
                        Object e2 = e;
                        if (!(e instanceof Bundle)) continue;
                        arrayList.add(((zzpz)((Object)object2)).zza((Bundle)e2, false));
                    }
                } else if (object3 instanceof Bundle) {
                    arrayList.add(((zzpz)((Object)object2)).zza((Bundle)object3, false));
                }
                hashMap.put(string, arrayList);
                continue;
            }
            if (object == null) continue;
            hashMap.put(string, object);
        }
        return hashMap;
    }

    zzpz(zzpk zzpk2) {
        super(zzpk2);
    }

    static void zza(zzgg.zzf.zza zza2, String string, Object object) {
        List list = zza2.zzf();
        int n = -1;
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(((zzgg.zzh)list.get(i)).zzg())) continue;
            n = i;
            break;
        }
        zzgg.zzh.zza zza3 = zzgg.zzh.zze().zza(string);
        if (object instanceof Long) {
            zza3.zza(((Long)object).longValue());
        } else if (object instanceof String) {
            zza3.zzb((String)object);
        } else if (object instanceof Double) {
            zza3.zza(((Double)object).doubleValue());
        }
        if (n >= 0) {
            zza2.zza(n, zza3);
            return;
        }
        zza2.zza(zza3);
    }

    private static void zza(Uri.Builder builder, String[] stringArray, Bundle bundle, Set<String> set) {
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(",");
            String string = stringArray2[0];
            String string2 = stringArray2[stringArray2.length - 1];
            String string3 = bundle.getString(string);
            if (string3 == null) continue;
            zzpz.zza(builder, string2, string3, set);
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzgg.zzm zzm2) {
        int n2;
        if (zzm2 == null) {
            return;
        }
        ++n;
        zzpz.zza(stringBuilder, 3);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzm2.zzb() != 0) {
            zzpz.zza(stringBuilder, 4);
            stringBuilder.append("results: ");
            n2 = 0;
            for (Long l : zzm2.zzi()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
        }
        if (zzm2.zzd() != 0) {
            zzpz.zza(stringBuilder, 4);
            stringBuilder.append("status: ");
            n2 = 0;
            for (Long l : zzm2.zzk()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
        }
        if (zzm2.zza() != 0) {
            zzpz.zza(stringBuilder, 4);
            stringBuilder.append("dynamic_filter_timestamps: {");
            n2 = 0;
            for (Long l : zzm2.zzh()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l.zzf() ? Integer.valueOf(l.zza()) : null).append(":").append(l.zze() ? Long.valueOf(l.zzb()) : null);
            }
            stringBuilder.append("}\n");
        }
        if (zzm2.zzc() != 0) {
            zzpz.zza(stringBuilder, 4);
            stringBuilder.append("sequence_filter_timestamps: {");
            n2 = 0;
            for (Long l : zzm2.zzj()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l.zzf() ? Integer.valueOf(l.zzb()) : null).append(": [");
                int n3 = 0;
                Iterator iterator = l.zze().iterator();
                while (iterator.hasNext()) {
                    long l2 = (Long)iterator.next();
                    if (n3++ != 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(l2);
                }
                stringBuilder.append("]");
            }
            stringBuilder.append("}\n");
        }
        zzpz.zza(stringBuilder, 3);
        stringBuilder.append("}\n");
    }

    private final void zza(StringBuilder stringBuilder, int n, List<zzgg.zzh> list) {
        if (list == null) {
            return;
        }
        ++n;
        for (zzgg.zzh zzh2 : list) {
            if (zzh2 == null) continue;
            zzpz.zza(stringBuilder, n);
            stringBuilder.append("param {\n");
            zzpz.zza(stringBuilder, n, "name", zzh2.zzm() ? this.zzi().zzb(zzh2.zzg()) : null);
            zzpz.zza(stringBuilder, n, "string_value", zzh2.zzn() ? zzh2.zzh() : null);
            zzpz.zza(stringBuilder, n, "int_value", zzh2.zzl() ? Long.valueOf(zzh2.zzd()) : null);
            zzpz.zza(stringBuilder, n, "double_value", zzh2.zzj() ? Double.valueOf(zzh2.zza()) : null);
            if (zzh2.zzc() > 0) {
                this.zza(stringBuilder, n, zzh2.zzi());
            }
            zzpz.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private final void zza(StringBuilder stringBuilder, int n, zzfw.zzc zzc2) {
        if (zzc2 == null) {
            return;
        }
        zzpz.zza(stringBuilder, n);
        stringBuilder.append("filter {\n");
        if (zzc2.zzg()) {
            zzpz.zza(stringBuilder, n, "complement", zzc2.zzf());
        }
        if (zzc2.zzi()) {
            zzpz.zza(stringBuilder, n, "param_name", this.zzi().zzb(zzc2.zze()));
        }
        if (zzc2.zzj()) {
            zzfw.zzf zzf2 = zzc2.zzd();
            String string = "string_filter";
            int n2 = n + 1;
            StringBuilder stringBuilder2 = stringBuilder;
            if (zzf2 != null) {
                zzpz.zza(stringBuilder2, n2);
                stringBuilder2.append(string);
                stringBuilder2.append(" {\n");
                if (zzf2.zzj()) {
                    zzpz.zza(stringBuilder2, n2, "match_type", zzf2.zzb().name());
                }
                if (zzf2.zzi()) {
                    zzpz.zza(stringBuilder2, n2, "expression", zzf2.zze());
                }
                if (zzf2.zzh()) {
                    zzpz.zza(stringBuilder2, n2, "case_sensitive", zzf2.zzg());
                }
                if (zzf2.zza() > 0) {
                    zzpz.zza(stringBuilder2, n2 + 1);
                    stringBuilder2.append("expression_list {\n");
                    for (String string2 : zzf2.zzf()) {
                        zzpz.zza(stringBuilder2, n2 + 2);
                        stringBuilder2.append(string2);
                        stringBuilder2.append("\n");
                    }
                    stringBuilder2.append("}\n");
                }
                zzpz.zza(stringBuilder2, n2);
                stringBuilder2.append("}\n");
            }
        }
        if (zzc2.zzh()) {
            zzpz.zza(stringBuilder, n + 1, "number_filter", zzc2.zzc());
        }
        zzpz.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzfw.zzd zzd2) {
        if (zzd2 == null) {
            return;
        }
        zzpz.zza(stringBuilder, n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzd2.zzh()) {
            zzpz.zza(stringBuilder, n, "comparison_type", zzd2.zza().name());
        }
        if (zzd2.zzj()) {
            zzpz.zza(stringBuilder, n, "match_as_float", zzd2.zzg());
        }
        if (zzd2.zzi()) {
            zzpz.zza(stringBuilder, n, "comparison_value", zzd2.zzd());
        }
        if (zzd2.zzl()) {
            zzpz.zza(stringBuilder, n, "min_comparison_value", zzd2.zzf());
        }
        if (zzd2.zzk()) {
            zzpz.zza(stringBuilder, n, "max_comparison_value", zzd2.zze());
        }
        zzpz.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(Uri.Builder builder, String string, @Nullable String string2, Set<String> set) {
        if (set.contains(string) || TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        builder.appendQueryParameter(string, string2);
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, @Nullable Object object) {
        if (object == null) {
            return;
        }
        zzpz.zza(stringBuilder, n + 1);
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }

    final void zza(zzgg.zzh.zza zza2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zza2.zze().zzc().zzb().zzd();
        if (object instanceof String) {
            zza2.zzb((String)object);
            return;
        }
        if (object instanceof Long) {
            zza2.zza(((Long)object).longValue());
            return;
        }
        if (object instanceof Double) {
            zza2.zza(((Double)object).doubleValue());
            return;
        }
        if (object instanceof Bundle[]) {
            Bundle[] bundleArray = (Bundle[])object;
            ArrayList<zzgg.zzh> arrayList = new ArrayList<zzgg.zzh>();
            Bundle[] bundleArray2 = bundleArray;
            int n = bundleArray.length;
            for (int i = 0; i < n; ++i) {
                Bundle bundle = bundleArray2[i];
                if (bundle == null) continue;
                zzgg.zzh.zza zza3 = zzgg.zzh.zze();
                for (String string : bundle.keySet()) {
                    zzgg.zzh.zza zza4 = zzgg.zzh.zze().zza(string);
                    Object object2 = bundle.get(string);
                    if (object2 instanceof Long) {
                        zza4.zza(((Long)object2).longValue());
                    } else if (object2 instanceof String) {
                        zza4.zzb((String)object2);
                    } else {
                        if (!(object2 instanceof Double)) continue;
                        zza4.zza(((Double)object2).doubleValue());
                    }
                    zza3.zza(zza4);
                }
                if (zza3.zza() <= 0) continue;
                arrayList.add((zzgg.zzh)((zzki)zza3.zzaj()));
            }
            zza2.zza(arrayList);
            return;
        }
        this.zzj().zzg().zza("Ignoring invalid (type) event param value", object);
    }

    final void zza(zzgg.zzp.zza zza2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zza2.zzc().zzb().zza();
        if (object instanceof String) {
            zza2.zzb((String)object);
            return;
        }
        if (object instanceof Long) {
            zza2.zza(((Long)object).longValue());
            return;
        }
        if (object instanceof Double) {
            zza2.zza(((Double)object).doubleValue());
            return;
        }
        this.zzj().zzg().zza("Ignoring invalid (type) user attribute value", object);
    }

    @WorkerThread
    static boolean zza(zzbj zzbj2, zzq zzq2) {
        Preconditions.checkNotNull((Object)zzbj2);
        Preconditions.checkNotNull((Object)zzq2);
        return !TextUtils.isEmpty((CharSequence)zzq2.zzb) || !TextUtils.isEmpty((CharSequence)zzq2.zzp);
    }

    static boolean zza(List<Long> list, int n) {
        return n < list.size() << 6 && (list.get(n / 64) & 1L << n % 64) != 0L;
    }

    final boolean zza(long l, long l2) {
        return l == 0L || l2 <= 0L || Math.abs(this.zzb().currentTimeMillis() - l) > l2;
    }

    static boolean zzb(String string) {
        return string != null && string.matches("([+-])?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    @Override
    protected final boolean zzc() {
        return false;
    }

    final byte[] zzb(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to gzip content", (Object)iOException);
            throw iOException;
        }
    }

    final byte[] zzc(byte[] byArray) throws IOException {
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to ungzip content", (Object)iOException);
            throw iOException;
        }
    }

    static Bundle[] zzb(List<zzgg.zzh> list) {
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        for (zzgg.zzh zzh2 : list) {
            if (zzh2 == null) continue;
            Bundle bundle = new Bundle();
            for (zzgg.zzh zzh3 : zzh2.zzi()) {
                if (zzh3.zzn()) {
                    bundle.putString(zzh3.zzg(), zzh3.zzh());
                    continue;
                }
                if (zzh3.zzl()) {
                    bundle.putLong(zzh3.zzg(), zzh3.zzd());
                    continue;
                }
                if (!zzh3.zzj()) continue;
                bundle.putDouble(zzh3.zzg(), zzh3.zza());
            }
            if (bundle.isEmpty()) continue;
            arrayList.add(bundle);
        }
        return arrayList.toArray(new Bundle[arrayList.size()]);
    }
}

