/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.internal.measurement.zzaa;
import com.google.android.gms.internal.measurement.zzfj;
import com.google.android.gms.internal.measurement.zzfl;
import com.google.android.gms.internal.measurement.zzfp;
import com.google.android.gms.internal.measurement.zzfr;
import com.google.android.gms.internal.measurement.zzfv;
import com.google.android.gms.internal.measurement.zzhi;
import com.google.android.gms.internal.measurement.zzhk;
import com.google.android.gms.internal.measurement.zzhl;
import com.google.android.gms.internal.measurement.zzhm;
import com.google.android.gms.internal.measurement.zzhp;
import com.google.android.gms.internal.measurement.zzhq;
import com.google.android.gms.internal.measurement.zzhv;
import com.google.android.gms.internal.measurement.zzhw;
import com.google.android.gms.internal.measurement.zzhx;
import com.google.android.gms.internal.measurement.zzic;
import com.google.android.gms.internal.measurement.zzie;
import com.google.android.gms.internal.measurement.zzin;
import com.google.android.gms.internal.measurement.zzlp;
import com.google.android.gms.internal.measurement.zzmm;
import com.google.android.gms.internal.measurement.zzng;
import com.google.android.gms.internal.measurement.zzqr;
import com.google.android.gms.internal.measurement.zzrd;
import com.google.android.gms.measurement.internal.zzbc;
import com.google.android.gms.measurement.internal.zzbe;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzjy;
import com.google.android.gms.measurement.internal.zzov;
import com.google.android.gms.measurement.internal.zzoz;
import com.google.android.gms.measurement.internal.zzpg;
import com.google.android.gms.measurement.internal.zzpi;
import com.google.android.gms.measurement.internal.zzpv;
import com.google.android.gms.measurement.internal.zzqf;
import com.google.android.gms.measurement.internal.zzr;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.GZIPOutputStream;

public final class zzqa
extends zzpg {
    static int zza(zzhw zzhw2, String string) {
        for (int i = 0; i < zzhw2.zzd(); ++i) {
            if (!string.equals(zzhw2.zzaE(i).zzg())) continue;
            return i;
        }
        return -1;
    }

    final long zzd(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return 0L;
        }
        return this.zzf(string.getBytes(Charset.forName("UTF-8")));
    }

    @WorkerThread
    final long zzf(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        zzqa zzqa2 = zzqa2.zzu;
        zzqa2.zzw().zzg();
        MessageDigest messageDigest = zzqf.zzI();
        if (messageDigest == null) {
            zzqa2.zzaW().zze().zza("Failed to get MD5");
            return 0L;
        }
        return zzqf.zzr((byte[])messageDigest.digest(byArray));
    }

    final Bundle zzh(Map map, boolean bl) {
        Bundle bundle = new Bundle();
        for (String string : map.keySet()) {
            Object v = map.get(string);
            if (v == null) {
                bundle.putString(string, null);
                continue;
            }
            if (v instanceof Long) {
                bundle.putLong(string, ((Long)v).longValue());
                continue;
            }
            if (v instanceof Double) {
                bundle.putDouble(string, ((Double)v).doubleValue());
                continue;
            }
            if (v instanceof ArrayList) {
                if (!bl) continue;
                ArrayList arrayList = (ArrayList)v;
                ArrayList<Bundle> arrayList2 = new ArrayList<Bundle>();
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    arrayList2.add(this.zzh((Map)arrayList.get(i), false));
                }
                bundle.putParcelableArray(string, arrayList2.toArray(new Parcelable[0]));
                continue;
            }
            bundle.putString(string, v.toString());
        }
        return bundle;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Parcelable zzi(byte[] byArray, Parcelable.Creator creator) {
        Parcel parcel;
        block5: {
            zzqa zzqa2;
            if (byArray == null) {
                return null;
            }
            parcel = Parcel.obtain();
            try {
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                zzqa2 = (Parcelable)creator.createFromParcel(parcel);
                break block5;
            }
            catch (SafeParcelReader.ParseException parseException) {
                try {
                    zzqa2 = zzqa2.zzu.zzaW();
                    zzqa2.zze().zza("Failed to load parcelable from buffer");
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }
            zzqa2 = null;
        }
        parcel.recycle();
        return zzqa2;
    }

    final zzbh zzj(zzaa zzaa2) {
        Object object;
        Bundle bundle = object2.zzh(zzaa2.zzf(), true);
        Object object2 = "app";
        if (bundle.containsKey("_o") && (object = bundle.get("_o")) != null) {
            object2 = object.toString();
        }
        if ((object = zzjy.zzb((String)zzaa2.zze())) == null) {
            object = zzaa2.zze();
        }
        return new zzbh((String)object, new zzbf(bundle), (String)object2, zzaa2.zza());
    }

    /*
     * Enabled aggressive block sorting
     */
    @TargetApi(value=30)
    final zzov zzl(String string, zzhw zzhw2, zzhl object, String string22) {
        int n;
        String string3;
        zzqr.zzb();
        zzio zzio2 = ((zzjq)object3).zzu;
        if (!zzio2.zzf().zzx(string, zzgi.zzaV)) {
            return null;
        }
        long l = zzio2.zzaU().currentTimeMillis();
        Object object2 = zzio2.zzf().zzr(string, zzgi.zzat).split(",");
        int n2 = ((String[])object2).length;
        Uri.Builder builder = new HashSet(n2);
        for (int i = 0; i < n2; ++i) {
            string3 = object2[i];
            if (builder.add(Objects.requireNonNull(string3))) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("duplicate element: ");
            stringBuilder.append((Object)string3);
            throw new IllegalArgumentException("duplicate element: ".concat(String.valueOf(string3)));
        }
        Set set = Collections.unmodifiableSet(builder);
        object2 = ((zzoz)((Object)object3)).zzg;
        zzpi zzpi2 = ((zzpv)object2).zzy();
        Object object3 = zzpi2.zzg.zzr().zzm(string);
        builder = new Uri.Builder();
        zzio zzio3 = zzpi2.zzu;
        builder.scheme(zzio3.zzf().zzr(string, zzgi.zzam));
        if (!TextUtils.isEmpty((CharSequence)object3)) {
            String string4 = zzio3.zzf().zzr(string, zzgi.zzan);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((String)object3);
            stringBuilder.append(".");
            stringBuilder.append(string4);
            builder.authority(stringBuilder.toString());
        } else {
            builder.authority(zzio3.zzf().zzr(string, zzgi.zzan));
        }
        builder.path(zzio3.zzf().zzr(string, zzgi.zzao));
        object3 = zzhw2.zzaJ();
        zzqa.zzM(builder, "gmp_app_id", (String)object3, set);
        zzio2.zzf().zzj();
        zzqa.zzM(builder, "gmp_version", String.valueOf(119002L), set);
        object3 = zzhw2.zzaG();
        zzio3 = zzgi.zzaY;
        if (zzio2.zzf().zzx(string, (zzgg)zzio3) && ((zzpv)object2).zzr().zzA(string)) {
            object3 = "";
        }
        zzqa.zzM(builder, "app_instance_id", (String)object3, set);
        object3 = zzhw2.zzaL();
        zzqa.zzM(builder, "rdid", (String)object3, set);
        object3 = zzhw2.zzaF();
        zzqa.zzM(builder, "bundle_id", (String)object3, set);
        object3 = object.zzo();
        string3 = zzjy.zza((String)object3);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            object3 = string3;
        }
        zzqa.zzM(builder, "app_event_name", (String)object3, set);
        object3 = String.valueOf(zzhw2.zzb());
        zzqa.zzM(builder, "app_version", (String)object3, set);
        object3 = zzhw2.zzaK();
        if (zzio2.zzf().zzx(string, (zzgg)zzio3) && ((zzpv)object2).zzr().zzE(string) && !TextUtils.isEmpty((CharSequence)object3) && (n = ((String)object3).indexOf(".")) != -1) {
            object3 = ((String)object3).substring(0, n);
        }
        zzqa.zzM(builder, "os_version", (String)object3, set);
        object3 = String.valueOf(object.zzc());
        zzqa.zzM(builder, "timestamp", (String)object3, set);
        if (zzhw2.zzaP()) {
            zzqa.zzM(builder, "lat", "1", set);
        }
        object3 = String.valueOf(zzhw2.zza());
        zzqa.zzM(builder, "privacy_sandbox_version", (String)object3, set);
        zzqa.zzM(builder, "trigger_uri_source", "1", set);
        object3 = String.valueOf(l);
        zzqa.zzM(builder, "trigger_uri_timestamp", (String)object3, set);
        zzqa.zzM(builder, "request_uuid", string22, set);
        object3 = new Bundle();
        for (String string22 : object.zzp()) {
            String string5 = string22.zzg();
            if (string22.zzu()) {
                object3.putString(string5, String.valueOf(string22.zza()));
                continue;
            }
            if (string22.zzv()) {
                object3.putString(string5, String.valueOf(string22.zzb()));
                continue;
            }
            if (string22.zzy()) {
                object3.putString(string5, string22.zzh());
                continue;
            }
            if (!string22.zzw()) continue;
            object3.putString(string5, String.valueOf(string22.zzd()));
        }
        zzqa.zzO(builder, zzio2.zzf().zzr(string, zzgi.zzas).split("\\|"), (Bundle)object3, set);
        object3 = new Bundle();
        for (String string22 : zzhw2.zzaN()) {
            String string6 = string22.zzg();
            if (string22.zzr()) {
                object3.putString(string6, String.valueOf(string22.zza()));
                continue;
            }
            if (string22.zzs()) {
                object3.putString(string6, String.valueOf(string22.zzb()));
                continue;
            }
            if (string22.zzv()) {
                object3.putString(string6, string22.zzh());
                continue;
            }
            if (!string22.zzt()) continue;
            object3.putString(string6, String.valueOf(string22.zzc()));
        }
        zzqa.zzO(builder, zzio2.zzf().zzr(string, zzgi.zzar).split("\\|"), (Bundle)object3, set);
        object3 = true != zzhw2.zzaO() ? "0" : "1";
        zzqa.zzM(builder, "dma", (String)object3, set);
        if (!zzhw2.zzaI().isEmpty()) {
            object3 = zzhw2.zzaI();
            zzqa.zzM(builder, "dma_cps", (String)object3, set);
        }
        if (zzhw2.zzaQ()) {
            object3 = zzhw2.zzg();
            if (!object3.zzh().isEmpty()) {
                string = object3.zzh();
                zzqa.zzM(builder, "dl_gclid", string, set);
            }
            if (!object3.zzg().isEmpty()) {
                string = object3.zzg();
                zzqa.zzM(builder, "dl_gbraid", string, set);
            }
            if (!object3.zzf().isEmpty()) {
                string = object3.zzf();
                zzqa.zzM(builder, "dl_gs", string, set);
            }
            if (object3.zza() > 0L) {
                string = String.valueOf(object3.zza());
                zzqa.zzM(builder, "dl_ss_ts", string, set);
            }
            if (!object3.zzk().isEmpty()) {
                string = object3.zzk();
                zzqa.zzM(builder, "mr_gclid", string, set);
            }
            if (!object3.zzj().isEmpty()) {
                string = object3.zzj();
                zzqa.zzM(builder, "mr_gbraid", string, set);
            }
            if (!object3.zzi().isEmpty()) {
                string = object3.zzi();
                zzqa.zzM(builder, "mr_gs", string, set);
            }
            if (object3.zzb() > 0L) {
                object3 = String.valueOf(object3.zzb());
                zzqa.zzM(builder, "mr_click_ts", (String)object3, set);
            }
        }
        return new zzov(builder.build().toString(), l, 1);
    }

    final zzhm zzm(zzbc zzbc2) {
        zzhl zzhl2 = zzhm.zze();
        zzhl2.zzl(zzbc2.zze);
        zzbf zzbf2 = zzbc2.zzf;
        zzbe zzbe2 = new zzbe(zzbf2);
        while (zzbe2.hasNext()) {
            String string = zzbe2.zza();
            zzhp zzhp2 = zzhq.zze();
            zzhp2.zzj(string);
            Object object = zzbf2.zzf(string);
            Preconditions.checkNotNull((Object)object);
            ((zzqa)((Object)string)).zzw(zzhp2, object);
            zzhl2.zze(zzhp2);
        }
        String string = zzbc2.zzc;
        if (!TextUtils.isEmpty((CharSequence)string) && zzbf2.zzf("_o") == null) {
            zzhp zzhp3 = zzhq.zze();
            zzhp3.zzj("_o");
            zzhp3.zzk(string);
            zzhl2.zzf((zzhq)zzhp3.zzba());
        }
        return (zzhm)zzhl2.zzba();
    }

    static zzng zzp(zzng zzng2, byte[] byArray) throws zzmm {
        zzlp zzlp2 = zzlp.zza();
        if (zzlp2 != null) {
            return zzng2.zzaV(byArray, zzlp2);
        }
        return zzng2.zzaU(byArray);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    final String zzq(zzhv var1_1) {
        if (var1_1 == null) {
            return "";
        }
        var2_2 = new StringBuilder();
        var2_2.append("\nbatch {\n");
        if (var1_1.zzq()) {
            var3_3 = var1_1.zzg();
            zzqa.zzQ(var2_2, 0, "upload_subdomain", var3_3);
        }
        if (var1_1.zzp()) {
            var3_3 = var1_1.zzf();
            zzqa.zzQ(var2_2, 0, "sgtm_join_id", var3_3);
        }
        var3_3 = var1_1.zzh().iterator();
        block13: while (true) {
            if (!var3_3.hasNext()) {
                var2_2.append("} // End-of-batch\n");
                return var2_2.toString();
            }
            var4_4 = (zzhx)var3_3.next();
            if (var4_4 == null) continue;
            zzqa.zzL(var2_2, 1);
            var2_2.append("bundle {\n");
            if (var4_4.zzbQ()) {
                var1_1 = var4_4.zzf();
                zzqa.zzQ(var2_2, 1, "protocol_version", var1_1);
            }
            zzrd.zzb();
            var5_5 = this.zzu;
            if (var5_5.zzf().zzx(var4_4.zzF(), zzgi.zzaL) && var4_4.zzbT()) {
                var1_1 = var4_4.zzU();
                zzqa.zzQ(var2_2, 1, "session_stitching_token", var1_1);
            }
            var1_1 = var4_4.zzS();
            zzqa.zzQ(var2_2, 1, "platform", var1_1);
            if (var4_4.zzbL()) {
                var1_1 = var4_4.zzp();
                zzqa.zzQ(var2_2, 1, "gmp_version", var1_1);
            }
            if (var4_4.zzbZ()) {
                var1_1 = var4_4.zzv();
                zzqa.zzQ(var2_2, 1, "uploading_gmp_version", var1_1);
            }
            if (var4_4.zzbJ()) {
                var1_1 = var4_4.zzn();
                zzqa.zzQ(var2_2, 1, "dynamite_version", var1_1);
            }
            if (var4_4.zzbC()) {
                var1_1 = var4_4.zzk();
                zzqa.zzQ(var2_2, 1, "config_version", var1_1);
            }
            var1_1 = var4_4.zzP();
            zzqa.zzQ(var2_2, 1, "gmp_app_id", var1_1);
            var1_1 = var4_4.zzE();
            zzqa.zzQ(var2_2, 1, "admob_app_id", var1_1);
            var1_1 = var4_4.zzF();
            zzqa.zzQ(var2_2, 1, "app_id", var1_1);
            var1_1 = var4_4.zzI();
            zzqa.zzQ(var2_2, 1, "app_version", var1_1);
            if (var4_4.zzby()) {
                var1_1 = var4_4.zzb();
                zzqa.zzQ(var2_2, 1, "app_version_major", var1_1);
            }
            var1_1 = var4_4.zzO();
            zzqa.zzQ(var2_2, 1, "firebase_instance_id", var1_1);
            if (var4_4.zzbH()) {
                var1_1 = var4_4.zzm();
                zzqa.zzQ(var2_2, 1, "dev_cert_hash", var1_1);
            }
            var1_1 = var4_4.zzH();
            zzqa.zzQ(var2_2, 1, "app_store", var1_1);
            if (var4_4.zzbY()) {
                var1_1 = var4_4.zzu();
                zzqa.zzQ(var2_2, 1, "upload_timestamp_millis", var1_1);
            }
            if (var4_4.zzbV()) {
                var1_1 = var4_4.zzs();
                zzqa.zzQ(var2_2, 1, "start_timestamp_millis", var1_1);
            }
            if (var4_4.zzbK()) {
                var1_1 = var4_4.zzo();
                zzqa.zzQ(var2_2, 1, "end_timestamp_millis", var1_1);
            }
            if (var4_4.zzbP()) {
                var1_1 = var4_4.zzr();
                zzqa.zzQ(var2_2, 1, "previous_bundle_start_timestamp_millis", var1_1);
            }
            if (var4_4.zzbO()) {
                var1_1 = var4_4.zzq();
                zzqa.zzQ(var2_2, 1, "previous_bundle_end_timestamp_millis", var1_1);
            }
            var1_1 = var4_4.zzG();
            zzqa.zzQ(var2_2, 1, "app_instance_id", var1_1);
            var1_1 = var4_4.zzT();
            zzqa.zzQ(var2_2, 1, "resettable_device_id", var1_1);
            var1_1 = var4_4.zzN();
            zzqa.zzQ(var2_2, 1, "ds_id", var1_1);
            if (var4_4.zzbN()) {
                var1_1 = var4_4.zzbv();
                zzqa.zzQ(var2_2, 1, "limited_ad_tracking", var1_1);
            }
            var1_1 = var4_4.zzR();
            zzqa.zzQ(var2_2, 1, "os_version", var1_1);
            var1_1 = var4_4.zzM();
            zzqa.zzQ(var2_2, 1, "device_model", var1_1);
            var1_1 = var4_4.zzV();
            zzqa.zzQ(var2_2, 1, "user_default_language", var1_1);
            if (var4_4.zzbX()) {
                var1_1 = var4_4.zzh();
                zzqa.zzQ(var2_2, 1, "time_zone_offset_minutes", var1_1);
            }
            if (var4_4.zzbB()) {
                var1_1 = var4_4.zzc();
                zzqa.zzQ(var2_2, 1, "bundle_sequential_index", var1_1);
            }
            if (var4_4.zzbG()) {
                var1_1 = var4_4.zzd();
                zzqa.zzQ(var2_2, 1, "delivery_index", var1_1);
            }
            if (var4_4.zzbS()) {
                var1_1 = var4_4.zzbw();
                zzqa.zzQ(var2_2, 1, "service_upload", var1_1);
            }
            var1_1 = var4_4.zzQ();
            zzqa.zzQ(var2_2, 1, "health_monitor", var1_1);
            if (var4_4.zzbR()) {
                var1_1 = var4_4.zzg();
                zzqa.zzQ(var2_2, 1, "retry_counter", var1_1);
            }
            if (var4_4.zzbE()) {
                var1_1 = var4_4.zzK();
                zzqa.zzQ(var2_2, 1, "consent_signals", var1_1);
            }
            if (var4_4.zzbM()) {
                var1_1 = var4_4.zzbu();
                zzqa.zzQ(var2_2, 1, "is_dma_region", var1_1);
            }
            if (var4_4.zzbF()) {
                var1_1 = var4_4.zzL();
                zzqa.zzQ(var2_2, 1, "core_platform_services", var1_1);
            }
            if (var4_4.zzbD()) {
                var1_1 = var4_4.zzJ();
                zzqa.zzQ(var2_2, 1, "consent_diagnostics", var1_1);
            }
            if (var4_4.zzbW()) {
                var1_1 = var4_4.zzt();
                zzqa.zzQ(var2_2, 1, "target_os_version", var1_1);
            }
            zzqr.zzb();
            if (var5_5.zzf().zzx(var4_4.zzF(), zzgi.zzaV)) {
                var1_1 = var4_4.zza();
                zzqa.zzQ(var2_2, 1, "ad_services_version", var1_1);
                if (var4_4.zzbz() && (var1_1 = var4_4.zzx()) != null) {
                    zzqa.zzL(var2_2, 2);
                    var2_2.append("attribution_eligibility_status {\n");
                    var6_6 /* !! */  = Boolean.valueOf(var1_1.zzn());
                    zzqa.zzQ(var2_2, 2, "eligible", var6_6 /* !! */ );
                    var6_6 /* !! */  = Boolean.valueOf(var1_1.zzp());
                    zzqa.zzQ(var2_2, 2, "no_access_adservices_attribution_permission", var6_6 /* !! */ );
                    var6_6 /* !! */  = Boolean.valueOf(var1_1.zzq());
                    zzqa.zzQ(var2_2, 2, "pre_r", var6_6 /* !! */ );
                    var6_6 /* !! */  = Boolean.valueOf(var1_1.zzr());
                    zzqa.zzQ(var2_2, 2, "r_extensions_too_old", var6_6 /* !! */ );
                    var6_6 /* !! */  = Boolean.valueOf(var1_1.zzm());
                    zzqa.zzQ(var2_2, 2, "adservices_extension_too_old", var6_6 /* !! */ );
                    var6_6 /* !! */  = Boolean.valueOf(var1_1.zzk());
                    zzqa.zzQ(var2_2, 2, "ad_storage_not_allowed", var6_6 /* !! */ );
                    var1_1 = var1_1.zzo();
                    zzqa.zzQ(var2_2, 2, "measurement_manager_disabled", var1_1);
                    zzqa.zzL(var2_2, 2);
                    var2_2.append("}\n");
                }
            }
            if (var4_4.zzbx()) {
                var1_1 = var4_4.zzw();
                zzqa.zzL(var2_2, 2);
                var2_2.append("ad_campaign_info {\n");
                if (var1_1.zzC()) {
                    var6_6 /* !! */  = var1_1.zzh();
                    zzqa.zzQ(var2_2, 2, "deep_link_gclid", var6_6 /* !! */ );
                }
                if (var1_1.zzB()) {
                    var6_6 /* !! */  = var1_1.zzg();
                    zzqa.zzQ(var2_2, 2, "deep_link_gbraid", var6_6 /* !! */ );
                }
                if (var1_1.zzA()) {
                    var6_6 /* !! */  = var1_1.zzf();
                    zzqa.zzQ(var2_2, 2, "deep_link_gad_source", var6_6 /* !! */ );
                }
                if (var1_1.zzD()) {
                    var6_6 /* !! */  = Long.valueOf(var1_1.zza());
                    zzqa.zzQ(var2_2, 2, "deep_link_session_millis", var6_6 /* !! */ );
                }
                if (var1_1.zzH()) {
                    var6_6 /* !! */  = var1_1.zzk();
                    zzqa.zzQ(var2_2, 2, "market_referrer_gclid", var6_6 /* !! */ );
                }
                if (var1_1.zzG()) {
                    var6_6 /* !! */  = var1_1.zzj();
                    zzqa.zzQ(var2_2, 2, "market_referrer_gbraid", var6_6 /* !! */ );
                }
                if (var1_1.zzF()) {
                    var6_6 /* !! */  = var1_1.zzi();
                    zzqa.zzQ(var2_2, 2, "market_referrer_gad_source", var6_6 /* !! */ );
                }
                if (var1_1.zzE()) {
                    var1_1 = var1_1.zzb();
                    zzqa.zzQ(var2_2, 2, "market_referrer_click_millis", var1_1);
                }
                zzqa.zzL(var2_2, 2);
                var2_2.append("}\n");
            }
            if (var4_4.zzbA()) {
                var1_1 = var4_4.zzj();
                zzqa.zzQ(var2_2, 1, "batching_timestamp_millis", var1_1);
            }
            if (var4_4.zzbU()) {
                var6_6 /* !! */  = var4_4.zzC();
                zzqa.zzL(var2_2, 2);
                var2_2.append("sgtm_diagnostics {\n");
                switch (var6_6 /* !! */ .zzg()) {
                    default: {
                        var1_1 = "SDK_SERVICE_UPLOAD";
                        break;
                    }
                    case 1: {
                        var1_1 = "UPLOAD_TYPE_UNKNOWN";
                        break;
                    }
                    case 4: {
                        var1_1 = "PACKAGE_SERVICE_UPLOAD";
                        break;
                    }
                    case 3: {
                        var1_1 = "SDK_CLIENT_UPLOAD";
                        break;
                    }
                    case 2: {
                        var1_1 = "GA_UPLOAD";
                    }
                }
                zzqa.zzQ(var2_2, 2, "upload_type", var1_1);
                var1_1 = var6_6 /* !! */ .zzb().name();
                zzqa.zzQ(var2_2, 2, "client_upload_eligibility", var1_1);
                switch (var6_6 /* !! */ .zzf()) {
                    default: {
                        var1_1 = "NON_PLAY_MISSING_SGTM_SERVER_URL";
                        break;
                    }
                    case 1: {
                        var1_1 = "SERVICE_UPLOAD_ELIGIBILITY_UNKNOWN";
                        break;
                    }
                    case 5: {
                        var1_1 = "MISSING_SGTM_PROXY_INFO";
                        break;
                    }
                    case 4: {
                        var1_1 = "MISSING_SGTM_SETTINGS";
                        break;
                    }
                    case 3: {
                        var1_1 = "NOT_IN_ROLLOUT";
                        break;
                    }
                    case 2: {
                        var1_1 = "SERVICE_UPLOAD_ELIGIBLE";
                    }
                }
                zzqa.zzQ(var2_2, 2, "service_upload_eligibility", var1_1);
                zzqa.zzL(var2_2, 2);
                var2_2.append("}\n");
            }
            if ((var1_1 = var4_4.zzY()) == null) ** GOTO lbl236
            var6_6 /* !! */  = var1_1.iterator();
            while (true) {
                block70: {
                    if (var6_6 /* !! */ .hasNext()) break block70;
lbl236:
                    // 2 sources

                    if ((var1_1 = var4_4.zzW()) != null) {
                        var1_1 = var1_1.iterator();
                        while (var1_1.hasNext()) {
                            var6_6 /* !! */  = (zzhi)var1_1.next();
                            if (var6_6 /* !! */  == null) continue;
                            zzqa.zzL(var2_2, 2);
                            var2_2.append("audience_membership {\n");
                            if (var6_6 /* !! */ .zzk()) {
                                var7_7 /* !! */  = Integer.valueOf(var6_6 /* !! */ .zza());
                                zzqa.zzQ(var2_2, 2, "audience_id", var7_7 /* !! */ );
                            }
                            if (var6_6 /* !! */ .zzm()) {
                                var7_7 /* !! */  = Boolean.valueOf(var6_6 /* !! */ .zzj());
                                zzqa.zzQ(var2_2, 2, "new_audience", var7_7 /* !! */ );
                            }
                            var7_7 /* !! */  = var6_6 /* !! */ .zzd();
                            zzqa.zzP(var2_2, 2, "current_data", (zzic)var7_7 /* !! */ );
                            if (var6_6 /* !! */ .zzn()) {
                                var6_6 /* !! */  = var6_6 /* !! */ .zze();
                                zzqa.zzP(var2_2, 2, "previous_data", (zzic)var6_6 /* !! */ );
                            }
                            zzqa.zzL(var2_2, 2);
                            var2_2.append("}\n");
                        }
                    }
                    if ((var1_1 = var4_4.zzX()) != null) {
                        var1_1 = var1_1.iterator();
                        while (var1_1.hasNext()) {
                            var4_4 = (zzhm)var1_1.next();
                            if (var4_4 == null) continue;
                            zzqa.zzL(var2_2, 2);
                            var2_2.append("event {\n");
                            var6_6 /* !! */  = var5_5.zzj().zzd(var4_4.zzh());
                            zzqa.zzQ(var2_2, 2, "name", var6_6 /* !! */ );
                            if (var4_4.zzu()) {
                                var6_6 /* !! */  = Long.valueOf(var4_4.zzd());
                                zzqa.zzQ(var2_2, 2, "timestamp_millis", var6_6 /* !! */ );
                            }
                            if (var4_4.zzt()) {
                                var6_6 /* !! */  = Long.valueOf(var4_4.zzc());
                                zzqa.zzQ(var2_2, 2, "previous_timestamp_millis", var6_6 /* !! */ );
                            }
                            if (var4_4.zzs()) {
                                var6_6 /* !! */  = Integer.valueOf(var4_4.zza());
                                zzqa.zzQ(var2_2, 2, "count", var6_6 /* !! */ );
                            }
                            if (var4_4.zzb() != 0) {
                                this.zzJ(var2_2, 2, var4_4.zzi());
                            }
                            zzqa.zzL(var2_2, 2);
                            var2_2.append("}\n");
                        }
                    }
                    zzqa.zzL(var2_2, 1);
                    var2_2.append("}\n");
                    continue block13;
                }
                var7_7 /* !! */  = (com.google.android.gms.internal.measurement.zzio)var6_6 /* !! */ .next();
                if (var7_7 /* !! */  == null) continue;
                zzqa.zzL(var2_2, 2);
                var2_2.append("user_property {\n");
                var1_1 = var7_7 /* !! */ .zzu() != false ? Long.valueOf(var7_7 /* !! */ .zzd()) : null;
                zzqa.zzQ(var2_2, 2, "set_timestamp_millis", var1_1);
                var1_1 = var5_5.zzj().zzf(var7_7 /* !! */ .zzg());
                zzqa.zzQ(var2_2, 2, "name", var1_1);
                var1_1 = var7_7 /* !! */ .zzh();
                zzqa.zzQ(var2_2, 2, "string_value", var1_1);
                var1_1 = var7_7 /* !! */ .zzt() != false ? Long.valueOf(var7_7 /* !! */ .zzc()) : null;
                zzqa.zzQ(var2_2, 2, "int_value", var1_1);
                var1_1 = var7_7 /* !! */ .zzr() != false ? Double.valueOf(var7_7 /* !! */ .zza()) : null;
                zzqa.zzQ(var2_2, 2, "double_value", var1_1);
                zzqa.zzL(var2_2, 2);
                var2_2.append("}\n");
            }
            break;
        }
    }

    final String zzr(zzfj object) {
        Object object2;
        if (object == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nevent_filter {\n");
        if (((zzfj)((Object)object)).zzp()) {
            object2 = ((zzfj)((Object)object)).zzb();
            zzqa.zzQ(stringBuilder, 0, "filter_id", object2);
        }
        object2 = this.zzu.zzj().zzd(((zzfj)((Object)object)).zzg());
        zzqa.zzQ(stringBuilder, 0, "event_name", object2);
        object2 = zzqa.zzN(((zzfj)((Object)object)).zzk(), ((zzfj)((Object)object)).zzm(), ((zzfj)((Object)object)).zzn());
        if (!((String)object2).isEmpty()) {
            zzqa.zzQ(stringBuilder, 0, "filter_type", object2);
        }
        if (((zzfj)((Object)object)).zzo()) {
            object2 = ((zzfj)((Object)object)).zzf();
            zzqa.zzR(stringBuilder, 1, "event_count_filter", (zzfp)((Object)object2));
        }
        if (((zzfj)((Object)object)).zza() > 0) {
            stringBuilder.append("  filters {\n");
            object = ((zzfj)((Object)object)).zzh().iterator();
            while (object.hasNext()) {
                this.zzK(stringBuilder, 2, (zzfl)((Object)object.next()));
            }
        }
        zzqa.zzL(stringBuilder, 1);
        stringBuilder.append("}\n}\n");
        return stringBuilder.toString();
    }

    final String zzs(zzfr zzfr2) {
        Object object;
        if (zzfr2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nproperty_filter {\n");
        if (zzfr2.zzj()) {
            object = zzfr2.zza();
            zzqa.zzQ(stringBuilder, 0, "filter_id", object);
        }
        object = this.zzu.zzj().zzf(zzfr2.zze());
        zzqa.zzQ(stringBuilder, 0, "property_name", object);
        object = zzqa.zzN(zzfr2.zzg(), zzfr2.zzh(), zzfr2.zzi());
        if (!((String)object).isEmpty()) {
            zzqa.zzQ(stringBuilder, 0, "filter_type", object);
        }
        this.zzK(stringBuilder, 1, zzfr2.zzb());
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    final List zzt(List object, List object2) {
        ArrayList<Long> arrayList = new ArrayList<Long>((Collection<Long>)object);
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = (Integer)object.next();
            if ((Integer)object2 < 0) {
                this.zzu.zzaW().zzk().zzb("Ignoring negative bit index to be cleared", object2);
                continue;
            }
            int n = (Integer)object2 / 64;
            if (n >= arrayList.size()) {
                Integer n2 = arrayList.size();
                this.zzu.zzaW().zzk().zzc("Ignoring bit index greater than bitSet size", object2, (Object)n2);
                continue;
            }
            ArrayList<Long> arrayList2 = arrayList;
            int n3 = n;
            arrayList2.set(n3, (Long)arrayList2.get(n3) & (1L << (Integer)object2 % 64 ^ 0xFFFFFFFFFFFFFFFFL));
        }
        int n = arrayList.size();
        int n4 = arrayList.size() + -1;
        while (n4 >= 0 && (Long)arrayList.get(n4) == 0L) {
            n = n4;
            n4 += -1;
        }
        return arrayList.subList(0, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    static List zzu(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        int n2 = 0;
        block0: while (n2 < n) {
            long l = 0L;
            int n3 = 0;
            while (true) {
                int n4;
                int n5;
                if (n3 >= 64 || (n5 = n2 * 64 + n3) >= (n4 = bitSet.length())) {
                    arrayList.add(l);
                    ++n2;
                    continue block0;
                }
                long l2 = bitSet.get(n5) ? l | 1L << n3 : l;
                l = l2;
                ++n3;
            }
            break;
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    final Map zzv(Bundle bundle, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = bundle.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = bundle.get(string);
            boolean bl2 = object instanceof Parcelable[];
            if (bl2 || object instanceof ArrayList || object instanceof Bundle) {
                if (!bl) continue;
                ArrayList<Map> arrayList = new ArrayList<Map>();
                if (bl2) {
                    for (Parcelable parcelable : (Parcelable[])object) {
                        if (!(parcelable instanceof Bundle)) continue;
                        arrayList.add(this.zzv((Bundle)parcelable, false));
                    }
                } else if (object instanceof ArrayList) {
                    ArrayList arrayList2 = (ArrayList)object;
                    int n = arrayList2.size();
                    for (int i = 0; i < n; ++i) {
                        Object e = arrayList2.get(i);
                        if (!(e instanceof Bundle)) continue;
                        arrayList.add(this.zzv((Bundle)e, false));
                    }
                } else if (object instanceof Bundle) {
                    arrayList.add(this.zzv((Bundle)object, false));
                }
                hashMap.put(string, arrayList);
                continue;
            }
            if (object == null) continue;
            hashMap.put(string, object);
        }
        return hashMap;
    }

    zzqa(zzpv zzpv2) {
        super(zzpv2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzJ(StringBuilder stringBuilder, int n, List iterator) {
        if (iterator != null) {
            int n2 = n + 1;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                zzhq zzhq2 = (zzhq)iterator.next();
                if (zzhq2 == null) continue;
                zzqa.zzL(stringBuilder, n2);
                stringBuilder.append("param {\n");
                Object object = zzhq2.zzx() ? this.zzu.zzj().zze(zzhq2.zzg()) : null;
                zzqa.zzQ(stringBuilder, n2, "name", object);
                object = zzhq2.zzy() ? zzhq2.zzh() : null;
                zzqa.zzQ(stringBuilder, n2, "string_value", object);
                object = zzhq2.zzw() ? Long.valueOf(zzhq2.zzd()) : null;
                zzqa.zzQ(stringBuilder, n2, "int_value", object);
                object = zzhq2.zzu() ? Double.valueOf(zzhq2.zza()) : null;
                zzqa.zzQ(stringBuilder, n2, "double_value", object);
                if (zzhq2.zzc() > 0) {
                    this.zzJ(stringBuilder, n2, zzhq2.zzi());
                }
                zzqa.zzL(stringBuilder, n2);
                stringBuilder.append("}\n");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzK(StringBuilder stringBuilder, int n, zzfl zzfl2) {
        Object object;
        if (zzfl2 == null) {
            return;
        }
        zzqa.zzL(stringBuilder, n);
        stringBuilder.append("filter {\n");
        if (zzfl2.zzh()) {
            Boolean bl = zzfl2.zzg();
            zzqa.zzQ(stringBuilder, n, "complement", bl);
        }
        if (zzfl2.zzj()) {
            object = ((zzjq)object).zzu.zzj().zze(zzfl2.zze());
            zzqa.zzQ(stringBuilder, n, "param_name", object);
        }
        if (zzfl2.zzk()) {
            int n2 = n + 1;
            zzfv zzfv2 = zzfl2.zzd();
            if (zzfv2 != null) {
                zzqa.zzL(stringBuilder, n2);
                stringBuilder.append("string_filter {\n");
                if (zzfv2.zzi()) {
                    switch (zzfv2.zzj()) {
                        default: {
                            object = "IN_LIST";
                            break;
                        }
                        case 1: {
                            object = "UNKNOWN_MATCH_TYPE";
                            break;
                        }
                        case 6: {
                            object = "EXACT";
                            break;
                        }
                        case 5: {
                            object = "PARTIAL";
                            break;
                        }
                        case 4: {
                            object = "ENDS_WITH";
                            break;
                        }
                        case 3: {
                            object = "BEGINS_WITH";
                            break;
                        }
                        case 2: {
                            object = "REGEXP";
                        }
                    }
                    zzqa.zzQ(stringBuilder, n2, "match_type", object);
                }
                if (zzfv2.zzh()) {
                    object = zzfv2.zzd();
                    zzqa.zzQ(stringBuilder, n2, "expression", object);
                }
                if (zzfv2.zzg()) {
                    object = zzfv2.zzf();
                    zzqa.zzQ(stringBuilder, n2, "case_sensitive", object);
                }
                if (zzfv2.zza() > 0) {
                    zzqa.zzL(stringBuilder, n2 + 1);
                    stringBuilder.append("expression_list {\n");
                    object = zzfv2.zze().iterator();
                    while (object.hasNext()) {
                        StringBuilder stringBuilder2 = stringBuilder;
                        zzqa.zzL(stringBuilder2, n2 + 2);
                        stringBuilder2.append((String)object.next());
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append("}\n");
                }
                zzqa.zzL(stringBuilder, n2);
                stringBuilder.append("}\n");
            }
        }
        if (zzfl2.zzi()) {
            object = zzfl2.zzc();
            zzqa.zzR(stringBuilder, n + 1, "number_filter", (zzfp)((Object)object));
        }
        zzqa.zzL(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    /*
     * Unable to fully structure code
     */
    final void zzw(zzhp var1_2, Object var2_3) {
        block9: {
            Preconditions.checkNotNull((Object)var2_3);
            var1_2.zzg();
            var1_2.zze();
            var1_2.zzd();
            var1_2.zzf();
            if (var2_3 instanceof String) {
                var1_2.zzk((String)var2_3);
                return;
            }
            if (var2_3 instanceof Long) {
                var1_2.zzi(((Long)var2_3).longValue());
                return;
            }
            if (var2_3 instanceof Double) {
                var1_2.zzh(((Double)var2_3).doubleValue());
                return;
            }
            if (!(var2_3 instanceof Bundle[])) break block9;
            var2_3 = var2_3;
            var3_4 = new ArrayList<zzhq>();
            block0: for (Bundle var5_6 : var2_3) {
                if (var5_6 == null) lbl-1000:
                // 3 sources

                {
                    continue block0;
                }
                var6_7 = zzhq.zze();
                block2: for (Object var8_9 : var5_6.keySet()) {
                    block10: {
                        var9_10 = zzhq.zze();
                        var9_10.zzj((String)var8_9);
                        var8_9 = var5_6.get((String)var8_9);
                        if (var8_9 instanceof Long) {
                            var9_10.zzi(((Long)var8_9).longValue());
lbl39:
                            // 3 sources

                            while (true) {
                                var6_7.zzc(var9_10);
                                continue block2;
                                break;
                            }
                        }
                        if (!(var8_9 instanceof String)) break block10;
                        var9_10.zzk((String)var8_9);
                        ** GOTO lbl39
                    }
                    if (!(var8_9 instanceof Double)) continue;
                    var9_10.zzh(((Double)var8_9).doubleValue());
                    ** continue;
                }
                if (var6_7.zza() <= 0) ** GOTO lbl-1000
                var3_4.add((zzhq)var6_7.zzba());
                ** continue;
            }
            var1_2.zzb(var3_4);
            return;
        }
        this.zzu.zzaW().zze().zzb("Ignoring invalid (type) event param value", (Object)var2_3);
    }

    final void zzx(zzin zzin2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zzin2.zzc();
        zzin2.zzb();
        zzin2.zza();
        if (object instanceof String) {
            zzin2.zzh((String)object);
            return;
        }
        if (object instanceof Long) {
            zzin2.zze(((Long)object).longValue());
            return;
        }
        if (object instanceof Double) {
            zzin2.zzd(((Double)object).doubleValue());
            return;
        }
        this.zzu.zzaW().zze().zzb("Ignoring invalid (type) user attribute value", object);
    }

    static boolean zzy(List list, int n) {
        return n < list.size() * 64 && ((Long)list.get(n / 64) & 1L << n % 64) != 0L;
    }

    final boolean zzz(long l, long l2) {
        return l == 0L || l2 <= 0L || Math.abs(this.zzu.zzaU().currentTimeMillis() - l) > l2;
    }

    static boolean zzA(String string) {
        return string != null && string.matches("([+-])?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    @Override
    protected final boolean zzb() {
        return false;
    }

    final byte[] zzB(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            Object object = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            object.zzu.zzaW().zze().zzb("Failed to gzip content", (Object)iOException);
            throw iOException;
        }
        return object;
    }

    static Bundle[] zzC(List object) {
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        object = object.iterator();
        while (object.hasNext()) {
            zzhq zzhq2 = (zzhq)object.next();
            if (zzhq2 == null) continue;
            Bundle bundle = new Bundle();
            for (zzhq zzhq3 : zzhq2.zzi()) {
                if (zzhq3.zzy()) {
                    bundle.putString(zzhq3.zzg(), zzhq3.zzh());
                    continue;
                }
                if (zzhq3.zzw()) {
                    bundle.putLong(zzhq3.zzg(), zzhq3.zzd());
                    continue;
                }
                if (!zzhq3.zzu()) continue;
                bundle.putDouble(zzhq3.zzg(), zzhq3.zza());
            }
            if (bundle.isEmpty()) continue;
            arrayList.add(bundle);
        }
        ArrayList<Bundle> arrayList2 = arrayList;
        return arrayList2.toArray(new Bundle[arrayList2.size()]);
    }

    /*
     * Enabled aggressive block sorting
     */
    static final void zzD(zzhl zzhl2, String string, Object object) {
        int n;
        List list;
        block3: {
            list = zzhl2.zzp();
            for (n = 0; n < list.size(); ++n) {
                if (!string.equals(((zzhq)list.get(n)).zzg())) {
                    continue;
                }
                break block3;
            }
            n = -1;
        }
        list = zzhq.zze();
        list.zzj(string);
        list.zzi((Long)object);
        if (n >= 0) {
            zzhl2.zzj(n, (zzhp)list);
            return;
        }
        zzhl2.zze((zzhp)list);
    }

    private static final void zzL(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    private static final void zzM(Uri.Builder builder, String string, String string2, Set set) {
        if (set.contains(string) || TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        builder.appendQueryParameter(string, string2);
    }

    @WorkerThread
    static final boolean zzE(zzbh zzbh2, zzr zzr2) {
        Preconditions.checkNotNull((Object)zzbh2);
        Preconditions.checkNotNull((Object)zzr2);
        return !TextUtils.isEmpty((CharSequence)zzr2.zzb) || !TextUtils.isEmpty((CharSequence)zzr2.zzp);
    }

    static final Bundle zzF(List object) {
        Bundle bundle = new Bundle();
        object = object.iterator();
        while (object.hasNext()) {
            zzhq zzhq2 = (zzhq)object.next();
            String string = zzhq2.zzg();
            if (zzhq2.zzu()) {
                bundle.putDouble(string, zzhq2.zza());
                continue;
            }
            if (zzhq2.zzv()) {
                bundle.putFloat(string, zzhq2.zzb());
                continue;
            }
            if (zzhq2.zzy()) {
                bundle.putString(string, zzhq2.zzh());
                continue;
            }
            if (!zzhq2.zzw()) continue;
            bundle.putLong(string, zzhq2.zzd());
        }
        return bundle;
    }

    static final zzhq zzG(zzhm object, String string) {
        for (zzhq zzhq2 : object.zzi()) {
            if (!zzhq2.zzg().equals(string)) continue;
            return zzhq2;
        }
        return null;
    }

    private static final String zzN(boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("Dynamic ");
        }
        if (bl2) {
            stringBuilder.append("Sequence ");
        }
        if (bl3) {
            stringBuilder.append("Session-Scoped ");
        }
        return stringBuilder.toString();
    }

    private static final void zzO(Uri.Builder builder, String[] stringArray, Bundle bundle, Set set) {
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = stringArray[i].split(",");
            String string = object[0];
            object = object[((String[])object).length + -1];
            String string2 = bundle.getString(string);
            if (string2 == null) continue;
            zzqa.zzM(builder, (String)object, string2, set);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final void zzP(StringBuilder stringBuilder, int n, String iterator, zzic object) {
        void var5_27;
        Long l;
        Iterator iterator2;
        Object object2;
        if (object2 == null) {
            return;
        }
        zzqa.zzL(stringBuilder, 3);
        stringBuilder.append((String)((Object)iterator2));
        stringBuilder.append(" {\n");
        if (object2.zzb() != 0) {
            zzqa.zzL(stringBuilder, 4);
            stringBuilder.append("results: ");
            iterator2 = object2.zzi().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                void var1_3;
                l = (Long)iterator2.next();
                var5_27 = var1_3 + true;
                if (var1_3 != false) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
                var1_3 = var5_27;
            }
            stringBuilder.append('\n');
        }
        if (object2.zzd() != 0) {
            zzqa.zzL(stringBuilder, 4);
            stringBuilder.append("status: ");
            iterator2 = object2.zzk().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                void var1_5;
                l = (Long)iterator2.next();
                var5_27 = var1_5 + true;
                if (var1_5 != false) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
                var1_5 = var5_27;
            }
            stringBuilder.append('\n');
        }
        if (object2.zza() != 0) {
            zzqa.zzL(stringBuilder, 4);
            stringBuilder.append("dynamic_filter_timestamps: {");
            iterator2 = object2.zzh().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                void var1_11;
                void var1_9;
                void var1_7;
                l = (zzhk)iterator2.next();
                var5_27 = var1_7 + true;
                if (var1_7 != false) {
                    stringBuilder.append(", ");
                }
                if (l.zzh()) {
                    Integer n2 = l.zza();
                } else {
                    Object var1_14 = null;
                }
                stringBuilder.append(var1_9);
                stringBuilder.append(":");
                if (l.zzg()) {
                    Long l2 = l.zzb();
                } else {
                    Object var1_13 = null;
                }
                stringBuilder.append(var1_11);
                void var1_12 = var5_27;
            }
            stringBuilder.append("}\n");
        }
        if (object2.zzc() != 0) {
            zzqa.zzL(stringBuilder, 4);
            stringBuilder.append("sequence_filter_timestamps: {");
            iterator2 = object2.zzj().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                void var1_18;
                void var1_16;
                object2 = (zzie)iterator2.next();
                void var4_26 = var1_16 + true;
                if (var1_16 != false) {
                    stringBuilder.append(", ");
                }
                if (object2.zzi()) {
                    Integer n3 = object2.zzb();
                } else {
                    Object var1_22 = null;
                }
                stringBuilder.append(var1_18);
                stringBuilder.append(": [");
                object2 = object2.zzf().iterator();
                boolean bl2 = false;
                while (object2.hasNext()) {
                    void var1_20;
                    long l3 = (Long)object2.next();
                    var5_27 = var1_20 + true;
                    if (var1_20 != false) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(l3);
                    var1_20 = var5_27;
                }
                stringBuilder.append("]");
                void var1_21 = var4_26;
            }
            stringBuilder.append("}\n");
        }
        zzqa.zzL(stringBuilder, 3);
        stringBuilder.append("}\n");
    }

    private static final void zzQ(StringBuilder stringBuilder, int n, String string, Object object) {
        if (object == null) {
            return;
        }
        zzqa.zzL(stringBuilder, n + 1);
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }

    static final Object zzH(zzhm zzhm2, String string) {
        if ((zzhm2 = zzqa.zzG(zzhm2, string)) != null) {
            if (zzhm2.zzy()) {
                return zzhm2.zzh();
            }
            if (zzhm2.zzw()) {
                return zzhm2.zzd();
            }
            if (zzhm2.zzu()) {
                return zzhm2.zza();
            }
            if (zzhm2.zzc() > 0) {
                return zzqa.zzC(zzhm2.zzi());
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void zzR(StringBuilder stringBuilder, int n, String object, zzfp zzfp2) {
        if (zzfp2 == null) {
            return;
        }
        zzqa.zzL(stringBuilder, n);
        stringBuilder.append((String)object);
        stringBuilder.append(" {\n");
        if (zzfp2.zzg()) {
            switch (zzfp2.zzm()) {
                default: {
                    object = "BETWEEN";
                    break;
                }
                case 1: {
                    object = "UNKNOWN_COMPARISON_TYPE";
                    break;
                }
                case 4: {
                    object = "EQUAL";
                    break;
                }
                case 3: {
                    object = "GREATER_THAN";
                    break;
                }
                case 2: {
                    object = "LESS_THAN";
                }
            }
            zzqa.zzQ(stringBuilder, n, "comparison_type", object);
        }
        if (zzfp2.zzi()) {
            object = zzfp2.zzf();
            zzqa.zzQ(stringBuilder, n, "match_as_float", object);
        }
        if (zzfp2.zzh()) {
            object = zzfp2.zzc();
            zzqa.zzQ(stringBuilder, n, "comparison_value", object);
        }
        if (zzfp2.zzk()) {
            object = zzfp2.zze();
            zzqa.zzQ(stringBuilder, n, "min_comparison_value", object);
        }
        if (zzfp2.zzj()) {
            object = zzfp2.zzd();
            zzqa.zzQ(stringBuilder, n, "max_comparison_value", object);
        }
        zzqa.zzL(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    static final Object zzI(zzhm object, String string, Object object2) {
        if ((object = zzqa.zzH(object, string)) == null) {
            return object2;
        }
        return object;
    }
}

