/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.os.Binder;
import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.BinderThread;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.internal.measurement.zzaa;
import com.google.android.gms.internal.measurement.zzc;
import com.google.android.gms.internal.measurement.zzd;
import com.google.android.gms.internal.measurement.zzhz;
import com.google.android.gms.internal.measurement.zzmq;
import com.google.android.gms.internal.measurement.zznk;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzav;
import com.google.android.gms.measurement.internal.zzbb;
import com.google.android.gms.measurement.internal.zzbe;
import com.google.android.gms.measurement.internal.zzbg;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzhs;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzie;
import com.google.android.gms.measurement.internal.zzif;
import com.google.android.gms.measurement.internal.zzig;
import com.google.android.gms.measurement.internal.zzih;
import com.google.android.gms.measurement.internal.zzii;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzik;
import com.google.android.gms.measurement.internal.zzil;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzin;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzip;
import com.google.android.gms.measurement.internal.zziq;
import com.google.android.gms.measurement.internal.zzir;
import com.google.android.gms.measurement.internal.zzis;
import com.google.android.gms.measurement.internal.zzit;
import com.google.android.gms.measurement.internal.zziu;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zziw;
import com.google.android.gms.measurement.internal.zzix;
import com.google.android.gms.measurement.internal.zziy;
import com.google.android.gms.measurement.internal.zziz;
import com.google.android.gms.measurement.internal.zzja;
import com.google.android.gms.measurement.internal.zzjb;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzjl;
import com.google.android.gms.measurement.internal.zzol;
import com.google.android.gms.measurement.internal.zzon;
import com.google.android.gms.measurement.internal.zzop;
import com.google.android.gms.measurement.internal.zzor;
import com.google.android.gms.measurement.internal.zzpf;
import com.google.android.gms.measurement.internal.zzpi;
import com.google.android.gms.measurement.internal.zzpj;
import com.google.android.gms.measurement.internal.zzpk;
import com.google.android.gms.measurement.internal.zzpm;
import com.google.android.gms.measurement.internal.zzpo;
import com.google.android.gms.measurement.internal.zzr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class zzjc
extends zzfz {
    private final zzpf zza;
    private Boolean zzb;
    private String zzc;

    public zzjc(zzpf zzpf2, String string) {
        Preconditions.checkNotNull((Object)zzpf2);
        this.zza = zzpf2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzi(zzr zzr2) {
        this.zzN(zzr2, false);
        zzjc zzjc2 = this;
        zzjc2.zzd(new zzim(zzjc2, zzr2));
    }

    @BinderThread
    public final void zzv(zzr zzr2) {
        Preconditions.checkNotEmpty((String)zzr2.zza);
        Preconditions.checkNotNull((Object)zzr2.zzs);
        zzjc zzjc2 = this;
        zzjc2.zzE(new zzio(zzjc2, zzr2));
    }

    @BinderThread
    public final void zzy(zzr zzr2) {
        Preconditions.checkNotEmpty((String)zzr2.zza);
        Preconditions.checkNotNull((Object)zzr2.zzs);
        zzjc zzjc2 = this;
        zzjc2.zzE(new zzjb(zzjc2, zzr2));
    }

    @BinderThread
    public final void zzz(zzr zzr2) {
        Preconditions.checkNotEmpty((String)zzr2.zza);
        Preconditions.checkNotNull((Object)zzr2.zzs);
        zzjc zzjc2 = this;
        zzjc2.zzE(new zziw(zzjc2, zzr2));
    }

    @BinderThread
    public final zzao zzw(zzr zzr2) {
        Object object;
        object.zzN(zzr2, false);
        Preconditions.checkNotEmpty((String)zzr2.zza);
        Future future = object.zza.zzaW().zzi((Callable)new zzip((zzjc)((Object)object), zzr2));
        try {
            object = (zzao)future.get(10000L, TimeUnit.MILLISECONDS);
            return object;
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            object = zzgt.zzl((String)zzr2.zza);
            object.zza.zzaV().zzb().zzc("Failed to get consent. appId", object, (Object)exception);
            return new zzao(null);
        }
    }

    @BinderThread
    public final void zze(zzbg zzbg2, zzr zzr2) {
        Preconditions.checkNotNull((Object)zzbg2);
        this.zzN(zzr2, false);
        zzjc zzjc2 = this;
        zzjc2.zzd(new zziq(zzjc2, zzbg2, zzr2));
    }

    private final void zzM(zzbg zzbg2, zzr zzr2) {
        zzpf zzpf2 = this.zza;
        zzpf2.zzY();
        zzpf2.zzF(zzbg2, zzr2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void zzb(zzbg object, zzr zzr2) {
        Object object22;
        block6: {
            block8: {
                block7: {
                    zzpf zzpf2;
                    zzjc zzjc2;
                    Object object3 = this.zza;
                    object22 = object3.zzh();
                    Object object4 = zzr2.zza;
                    object22 = TextUtils.isEmpty((CharSequence)object4) ? null : (zzc)((zzhs)((Object)object22)).zzd.get(object4);
                    if (object22 == null) {
                        object22 = zzr2.zza;
                        this.zza.zzaV().zzk().zzb("EES not loaded for", object22);
                        this.zzM((zzbg)object, zzr2);
                        return;
                    }
                    try {
                        boolean bl;
                        object3 = object3.zzp();
                        object4 = object3.zzz(((zzbg)object).zzb.zzf(), true);
                        object3 = ((zzbg)object).zza;
                        Object object5 = zzjl.zza((String)object3);
                        if (object5 != null) {
                            object3 = object5;
                        }
                        if (!(bl = ((zzc)object22).zzb((zzaa)(object5 = new zzaa((String)object3, ((zzbg)object).zzd, (Map)object4))))) break block6;
                        if (!((zzc)object22).zzc()) break block7;
                        zzjc2 = this;
                        zzpf2 = zzjc2.zza;
                        object = ((zzbg)object).zza;
                    }
                    catch (zzd zzd2) {
                        object22 = zzr2.zzb;
                        object3 = ((zzbg)object).zza;
                        this.zza.zzaV().zzb().zzc("EES error. appId, eventName", object22, object3);
                    }
                    zzpf2.zzaV().zzk().zzb("EES edited event", object);
                    zzjc2.zzM(zzpf2.zzp().zzA(((zzc)object22).zze().zzc()), zzr2);
                    break block8;
                }
                this.zzM((zzbg)object, zzr2);
            }
            if (((zzc)object22).zzd()) {
                for (Object object22 : ((zzc)object22).zze().zzf()) {
                    zzjc zzjc3 = this;
                    zzpf zzpf3 = zzjc3.zza;
                    String string = ((zzaa)object22).zzb();
                    zzpf3.zzaV().zzk().zzb("EES logging created event", (Object)string);
                    zzjc3.zzM(zzpf3.zzp().zzA((zzaa)object22), zzr2);
                }
            }
            return;
        }
        object22 = ((zzbg)object).zza;
        this.zza.zzaV().zzk().zzb("EES was not applied to event", object22);
        this.zzM((zzbg)object, zzr2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    final zzbg zzc(zzbg zzbg2, zzr zzr2) {
        String string;
        zzbe zzbe2;
        void var1_3;
        if (!"_cmp".equals(var1_3.zza) || (zzbe2 = var1_3.zzb) == null || zzbe2.zze() == 0 || !"referrer broadcast".equals(string = zzbe2.zzd("_cis")) && !"referrer API".equals(string)) {
            return var1_3;
        }
        String string2 = var1_3.toString();
        this.zza.zzaV().zzi().zzb("Event has been filtered ", (Object)string2);
        String string3 = var1_3.zzc;
        long l = var1_3.zzd;
        return new zzbg("_cmpx", zzbe2, string3, l);
    }

    @BinderThread
    public final void zzh(zzbg zzbg2, String string, String string2) {
        Preconditions.checkNotNull((Object)zzbg2);
        Preconditions.checkNotEmpty((String)string);
        this.zzO(string, true);
        zzjc zzjc2 = this;
        zzjc2.zzd(new zzir(zzjc2, zzbg2, string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final byte[] zzk(zzbg zzbg2, String object) {
        Preconditions.checkNotEmpty((String)object);
        Preconditions.checkNotNull((Object)zzbg2);
        ((zzjc)((Object)object3)).zzO((String)object, true);
        zzpf zzpf2 = ((zzjc)((Object)object3)).zza;
        String string = zzbg2.zza;
        Object object2 = zzpf2.zzs().zza(string);
        zzpf2.zzaV().zzj().zzb("Log and bundle. event", object2);
        long l = zzpf2.zzaZ().nanoTime() / 1000000L;
        object2 = zzpf2.zzaW().zzi((Callable)new zzis((zzjc)((Object)object3), zzbg2, (String)object));
        try {
            object2 = (byte[])object2.get();
            if (object2 == null) {
                zzpf2.zzaV().zzb().zzb("Log and bundle returned null. appId", zzgt.zzl((String)object));
                object2 = new byte[0];
            }
            long l2 = zzpf2.zzaZ().nanoTime() / 1000000L;
            zzgr zzgr2 = zzpf2.zzaV().zzj();
            String string2 = "Log and bundle processed. event, size, time_ms";
            zzpf2 = zzpf2.zzs();
            zzgr2.zzd(string2, (Object)zzpf2.zza(string), (Object)((Object)object2).length, (Object)(l2 - l));
            return object2;
        }
        catch (InterruptedException | ExecutionException exception) {
            Object object3 = ((zzjc)((Object)object3)).zza;
            zzgr zzgr3 = ((zzpf)object3).zzaV().zzb();
            object = zzgt.zzl((String)object);
            object3 = ((zzpf)object3).zzs().zza(zzbg2.zza);
            zzgr3.zzd("Failed to log and bundle. appId, event, error", object, object3, (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zzf(zzpk zzpk2, zzr zzr2) {
        Preconditions.checkNotNull((Object)zzpk2);
        this.zzN(zzr2, false);
        zzjc zzjc2 = this;
        zzjc2.zzd(new zzit(zzjc2, zzpk2, zzr2));
    }

    /*
     * Loose catch block
     */
    @BinderThread
    public final List zzx(zzr zzr2, Bundle object) {
        Object object2;
        object2.zzN(zzr2, false);
        Preconditions.checkNotNull((Object)zzr2.zza);
        zzpf zzpf2 = object2.zza;
        if (zzpf2.zzd().zzp(null, zzfx.zzaY)) {
            object = zzpf2.zzaW().zzi((Callable)new zziu((zzjc)((Object)object2), zzr2, (Bundle)object));
            object2 = (List)object.get(10000L, TimeUnit.MILLISECONDS);
            return object2;
        }
        object = object2.zza.zzaW().zzh((Callable)new zziv((zzjc)((Object)object2), zzr2, (Bundle)object));
        object2 = (List)object.get();
        return object2;
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            object2 = zzgt.zzl((String)zzr2.zza);
            object2.zza.zzaV().zzb().zzc("Failed to get trigger URIs. appId", object2, (Object)exception);
            return Collections.emptyList();
        }
        catch (InterruptedException | ExecutionException exception) {
            object2 = zzgt.zzl((String)zzr2.zza);
            object2.zza.zzaV().zzb().zzc("Failed to get trigger URIs. appId", object2, (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final void zzD(zzr zzr2, Bundle bundle, zzgd zzgd2) {
        this.zzN(zzr2, false);
        String string = (String)Preconditions.checkNotNull((Object)zzr2.zza);
        this.zza.zzaW().zzj((Runnable)new zzix(this, zzr2, bundle, zzgd2, string));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List zzj(zzr zzr2, boolean bl) {
        void var1_2;
        this.zzN((zzr)var1_2, false);
        Iterator iterator = var1_2.zza;
        Preconditions.checkNotNull((Object)iterator);
        iterator = this.zza.zzaW().zzh((Callable)new zzic(this, (String)((Object)iterator)));
        try {
            iterator = (List)iterator.get();
            ArrayList<zzpk> arrayList = new ArrayList<zzpk>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                boolean bl2;
                void var2_3;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                zzpm zzpm2 = (zzpm)iterator.next();
                if (var2_3 == false && (bl2 = zzpo.zzZ((String)zzpm2.zzc))) continue;
                arrayList.add(new zzpk(zzpm2));
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            Object object = zzgt.zzl((String)var1_2.zza);
            this.zza.zzaV().zzb().zzc("Failed to get user properties. appId", object, (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zzg(zzr zzr2) {
        this.zzN(zzr2, false);
        zzjc zzjc2 = this;
        zzjc2.zzd(new zzid(zzjc2, zzr2));
    }

    @BinderThread
    public final void zzA(zzr zzr2) {
        this.zzN(zzr2, false);
        zzjc zzjc2 = this;
        zzjc2.zzd(new zzie(zzjc2, zzr2));
    }

    @BinderThread
    public final void zzB(zzr object, zzon zzon2, zzgg zzgg2) {
        this.zzN((zzr)object, false);
        object = (String)Preconditions.checkNotNull((Object)object.zza);
        this.zza.zzaW().zzj((Runnable)new zziy(this, (String)object, zzon2, zzgg2));
    }

    @BinderThread
    public final void zzC(zzr zzr2, zzaf zzaf2) {
        this.zzN(zzr2, false);
        zzjc zzjc2 = this;
        zzjc2.zzd(new zziz(zzjc2, zzr2, zzaf2));
    }

    @BinderThread
    private final void zzN(zzr zzr2, boolean bl) {
        Preconditions.checkNotNull((Object)zzr2);
        String string = zzr2.zza;
        Preconditions.checkNotEmpty((String)string);
        this.zzO(string, false);
        this.zza.zzt().zzA(zzr2.zzb);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    private final void zzO(String string, boolean bl) {
        block12: {
            boolean bl2;
            boolean bl3;
            String string2;
            void var1_2;
            block11: {
                boolean bl4;
                block8: {
                    boolean bl5;
                    block10: {
                        block9: {
                            if (TextUtils.isEmpty((CharSequence)var1_2)) {
                                this.zza.zzaV().zzb().zza("Measurement Service called without app package");
                                throw new SecurityException("Measurement Service called without app package");
                            }
                            if (!bl4) break block11;
                            try {
                                Boolean bl6 = this.zzb;
                                if (bl6 != null) break block8;
                                bl5 = "com.google.android.gms".equals(this.zzc);
                                if (bl5) break block9;
                                zzpf zzpf2 = this.zza;
                                boolean bl7 = UidVerifier.isGooglePlayServicesUid((Context)zzpf2.zzaY(), (int)Binder.getCallingUid());
                                bl5 = !bl7 ? (bl5 = GoogleSignatureVerifier.getInstance((Context)zzpf2.zzaY()).isUidGoogleSigned(Binder.getCallingUid())) : true;
                                break block10;
                            }
                            catch (SecurityException securityException) {
                                Object object = zzgt.zzl((String)var1_2);
                                this.zza.zzaV().zzb().zzb("Measurement Service called with invalid calling package. appId", object);
                                throw securityException;
                            }
                        }
                        bl5 = true;
                    }
                    this.zzb = bl5;
                }
                if (bl4 = this.zzb.booleanValue()) break block12;
            }
            if ((string2 = this.zzc) == null && (bl3 = GooglePlayServicesUtilLight.uidHasPackageName((Context)this.zza.zzaY(), (int)Binder.getCallingUid(), (String)var1_2))) {
                this.zzc = var1_2;
            }
            if (!(bl2 = var1_2.equals(this.zzc))) {
                throw new SecurityException(String.format("Unknown calling package name '%s'.", var1_2));
            }
        }
    }

    @BinderThread
    public final void zzl(long l, String string, String string2, String string3) {
        zzjc zzjc2 = this;
        zzjc2.zzd(new zzif(zzjc2, string2, string3, string, l));
    }

    @BinderThread
    public final void zzu(Bundle bundle, zzr zzr2) {
        this.zzN(zzr2, false);
        String string = zzr2.zza;
        Preconditions.checkNotNull((Object)string);
        zzjc zzjc2 = this;
        zzjc2.zzd(new zzja(zzjc2, bundle, string, zzr2));
    }

    @BinderThread
    public final String zzm(zzr zzr2) {
        this.zzN(zzr2, false);
        return this.zza.zzao(zzr2);
    }

    @BinderThread
    public final void zzn(zzah zzah2, zzr zzr2) {
        Preconditions.checkNotNull((Object)zzah2);
        Preconditions.checkNotNull((Object)zzah2.zzc);
        this.zzN(zzr2, false);
        zzah zzah3 = new zzah(zzah2);
        zzah3.zza = zzr2.zza;
        zzjc zzjc2 = this;
        zzjc2.zzd(new zzig(zzjc2, zzah3, zzr2));
    }

    @BinderThread
    public final void zzo(zzah zzah2) {
        Preconditions.checkNotNull((Object)zzah2);
        Preconditions.checkNotNull((Object)zzah2.zzc);
        Preconditions.checkNotEmpty((String)zzah2.zza);
        this.zzO(zzah2.zza, true);
        zzah zzah3 = new zzah(zzah2);
        zzjc zzjc2 = this;
        zzjc2.zzd(new zzih(zzjc2, zzah3));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List zzp(String iterator, String arrayList, boolean bl, zzr zzr2) {
        ArrayList<zzpk> arrayList2;
        Iterator iterator2;
        void var4_6;
        this.zzN((zzr)var4_6, false);
        String string = var4_6.zza;
        Preconditions.checkNotNull((Object)string);
        iterator2 = this.zza.zzaW().zzh((Callable)new zzii(this, string, (String)((Object)iterator2), (String)((Object)arrayList2)));
        try {
            iterator2 = (List)iterator2.get();
            arrayList2 = new ArrayList<zzpk>(iterator2.size());
            iterator2 = iterator2.iterator();
            while (true) {
                boolean bl2;
                void var3_5;
                boolean bl3;
                if (!(bl3 = iterator2.hasNext())) {
                    return arrayList2;
                }
                string = (zzpm)iterator2.next();
                if (var3_5 == false && (bl2 = zzpo.zzZ((String)((zzpm)string).zzc))) continue;
                arrayList2.add(new zzpk((zzpm)string));
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            Object object = zzgt.zzl((String)var4_6.zza);
            this.zza.zzaV().zzb().zzc("Failed to query user properties. appId", object, (Object)exception);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List zzq(String string, String iterator, String arrayList, boolean bl) {
        ArrayList<zzpk> arrayList2;
        Iterator iterator2;
        void var1_2;
        this.zzO((String)var1_2, true);
        iterator2 = this.zza.zzaW().zzh((Callable)new zzij(this, (String)var1_2, (String)((Object)iterator2), (String)((Object)arrayList2)));
        try {
            iterator2 = (List)iterator2.get();
            arrayList2 = new ArrayList<zzpk>(iterator2.size());
            iterator2 = iterator2.iterator();
            while (true) {
                boolean bl2;
                void var4_6;
                boolean bl3;
                if (!(bl3 = iterator2.hasNext())) {
                    return arrayList2;
                }
                zzpm zzpm2 = (zzpm)iterator2.next();
                if (var4_6 == false && (bl2 = zzpo.zzZ((String)zzpm2.zzc))) continue;
                arrayList2.add(new zzpk(zzpm2));
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            Object object = zzgt.zzl((String)var1_2);
            this.zza.zzaV().zzb().zzc("Failed to get user properties as. appId", object, (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List zzr(String object, String string, zzr object2) {
        object3.zzN((zzr)object2, false);
        object2 = object2.zza;
        Preconditions.checkNotNull((Object)object2);
        object = object3.zza.zzaW().zzh((Callable)new zzik((zzjc)((Object)object3), (String)object2, (String)object, string));
        try {
            Object object3 = (List)object.get();
            return object3;
        }
        catch (InterruptedException | ExecutionException exception) {
            object3.zza.zzaV().zzb().zzb("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List zzs(String object, String string, String string2) {
        object2.zzO((String)object, true);
        object = object2.zza.zzaW().zzh((Callable)new zzil((zzjc)((Object)object2), (String)object, string, string2));
        try {
            Object object2 = (List)object.get();
            return object2;
        }
        catch (InterruptedException | ExecutionException exception) {
            object2.zza.zzaV().zzb().zzb("Failed to get conditional user properties as", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final void zzt(zzr zzr2) {
        String string = zzr2.zza;
        Preconditions.checkNotEmpty((String)string);
        this.zzO(string, false);
        zzjc zzjc2 = this;
        zzjc2.zzd(new zzin(zzjc2, zzr2));
    }

    @VisibleForTesting
    final void zzd(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        zzpf zzpf2 = ((zzjc)((Object)zzpf2)).zza;
        if (zzpf2.zzaW().zze()) {
            runnable.run();
            return;
        }
        zzpf2.zzaW().zzj(runnable);
    }

    @VisibleForTesting
    final void zzE(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        zzpf zzpf2 = ((zzjc)((Object)zzpf2)).zza;
        if (zzpf2.zzaW().zze()) {
            runnable.run();
            return;
        }
        zzpf2.zzaW().zzl(runnable);
    }

    final /* synthetic */ void zzF(zzr zzr2) {
        zzpf zzpf2 = this.zza;
        zzpf2.zzY();
        zzpf2.zzv(zzr2);
    }

    final /* synthetic */ void zzG(zzr zzr2) {
        zzpf zzpf2 = this.zza;
        zzpf2.zzY();
        zzpf2.zzw(zzr2);
    }

    final /* synthetic */ void zzH(zzr object, Bundle bundle, zzgd zzgd2, String string) {
        zzpf zzpf2 = this.zza;
        zzpf2.zzY();
        object = zzpf2.zzap((zzr)object, bundle);
        try {
            zzgd2.zze((List)object);
            return;
        }
        catch (RemoteException remoteException) {
            this.zza.zzaV().zzb().zzc("Failed to return trigger URIs for app", (Object)string, (Object)remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final /* synthetic */ void zzI(String string, zzon object, zzgg zzgg2) {
        zzpf zzpf2 = this.zza;
        zzpf2.zzY();
        zzpf2.zzaW().zzg();
        zzpf2.zzu();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        Iterator iterator = zzpf2.zzj().zzC(string, (zzon)object, (Integer)zzfx.zzA.zzb(null)).iterator();
        while (true) {
            block12: {
                Long l;
                block14: {
                    block13: {
                        if (!iterator.hasNext()) break block12;
                        object = (zzpi)iterator.next();
                        if (!zzpf2.zzO(string, ((zzpi)object).zze())) {
                            l = ((zzpi)object).zzc();
                            object = ((zzpi)object).zze();
                            zzpf2.zzaV().zzk().zzd("[sgtm] batch skipped due to destination in backoff. appId, rowId, url", (Object)string, (Object)l, object);
                            continue;
                        }
                        int n = ((zzpi)object).zzi();
                        if (n <= 0) break block13;
                        if (n > (Integer)zzfx.zzy.zzb(null)) break block14;
                        long l2 = Math.min((Long)zzfx.zzw.zzb(null) * (1L << n + -1), (Long)zzfx.zzx.zzb(null));
                        if (zzpf2.zzaZ().currentTimeMillis() < ((zzpi)object).zzh() + l2) break block14;
                    }
                    l = ((zzpi)object).zzb();
                    try {
                        int n;
                        object = com.google.android.gms.internal.measurement.zzib.zzh();
                        byte[] byArray = ((zzol)l).zzb;
                        zzhz zzhz2 = (zzhz)zzpj.zzw((zznk)object, byArray);
                        int n2 = 0;
                        while (n2 < (n = zzhz2.zzb())) {
                            zzhz zzhz3 = zzhz2;
                            int n3 = n2++;
                            com.google.android.gms.internal.measurement.zzic zzic2 = (com.google.android.gms.internal.measurement.zzic)zzhz3.zzc(n3).zzcl();
                            zzic2.zzs(zzpf2.zzaZ().currentTimeMillis());
                            zzhz3.zzd(n3, zzic2);
                        }
                        ((zzol)l).zzb = ((com.google.android.gms.internal.measurement.zzib)zzhz2.zzbc()).zzcc();
                        zzgt zzgt2 = zzpf2.zzaV();
                        boolean bl = Log.isLoggable((String)zzgt2.zzn(), (int)2);
                        if (bl) {
                            ((zzol)l).zzg = zzpf2.zzp().zzi((com.google.android.gms.internal.measurement.zzib)zzhz2.zzbc());
                        }
                        arrayList.add(l);
                    }
                    catch (zzmq zzmq2) {
                        zzpf2.zzaV().zze().zzb("Failed to parse queued batch. appId", (Object)string);
                    }
                    continue;
                }
                l = ((zzpi)object).zzc();
                object = ((zzpi)object).zzh();
                zzpf2.zzaV().zzk().zzd("[sgtm] batch skipped waiting for next retry. appId, rowId, lastUploadMillis", (Object)string, (Object)l, object);
                continue;
            }
            object = new zzop(arrayList);
            try {
                zzgg2.zze((zzop)object);
                this.zza.zzaV().zzk().zzc("[sgtm] Sending queued upload batches to client. appId, count", (Object)string, (Object)((zzop)object).zza.size());
                return;
            }
            catch (RemoteException remoteException) {
                this.zza.zzaV().zzb().zzc("[sgtm] Failed to return upload batches for app", (Object)string, (Object)remoteException);
                return;
            }
            break;
        }
    }

    final /* synthetic */ void zzJ(zzr zzr2, zzaf zzaf2) {
        zzpf zzpf2 = this.zza;
        zzpf2.zzY();
        zzpf2.zzaq((String)Preconditions.checkNotNull((Object)zzr2.zza), zzaf2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final /* synthetic */ void zzK(Bundle bundle, String string, zzr zzr2) {
        Object object;
        zzpf zzpf2 = ((zzjc)((Object)object)).zza;
        boolean bl = zzpf2.zzd().zzp(null, zzfx.zzaV);
        if (bundle.isEmpty() && bl) {
            object = ((zzjc)((Object)object)).zza.zzj();
            object.zzg();
            ((zzor)((Object)object)).zzay();
            ((zzav)((Object)object)).zze().execSQL("delete from default_event_params where app_id=?", (Object[])new String[]{string});
            return;
        }
        zzav zzav2 = zzpf2.zzj();
        zzav2.zzg();
        zzav2.zzay();
        zzib zzib2 = zzav2.zzu;
        String string2 = "dep";
        zzbb zzbb2 = new zzbb(zzib2, "", string, string2, 0L, 0L, bundle);
        byte[] byArray = zzav2.zzg.zzp().zzh(zzbb2).zzcc();
        string2 = zzav2.zzu;
        Integer n = byArray.length;
        string2.zzaV().zzk().zzc("Saving default event parameters, appId, data size", (Object)string, (Object)n);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("parameters", byArray);
        long l = zzav2.zze().insertWithOnConflict("default_event_params", null, contentValues, 5);
        if (l == -1L) {
            zzgt zzgt2 = string2.zzaV();
            zzgt2.zzb().zzb("Failed to insert default event parameters (got -1). appId", zzgt.zzl((String)string));
        }
        catch (SQLiteException sQLiteException) {
            ((zzjd)object).zzu.zzaV().zzb().zzb("Error clearing default event params", (Object)sQLiteException);
            return;
        }
        catch (SQLiteException sQLiteException) {
            Object object2 = zzgt.zzl((String)string);
            zzav2.zzu.zzaV().zzb().zzc("Error storing default event parameters. appId", object2, (Object)sQLiteException);
        }
        object = ((zzjc)((Object)object)).zza;
        long l2 = zzr2.zzD;
        if (((zzpf)object).zzj().zzX(string, l2)) {
            ((zzpf)object).zzj().zzY(string, l2, null, bundle);
            return;
        }
    }

    final /* synthetic */ zzpf zzL() {
        return this.zza;
    }
}

