/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzae;
import com.google.android.gms.internal.measurement.zzaf;
import com.google.android.gms.internal.measurement.zzah;
import com.google.android.gms.internal.measurement.zzal;
import com.google.android.gms.internal.measurement.zzam;
import com.google.android.gms.internal.measurement.zzao;
import com.google.android.gms.internal.measurement.zzas;
import com.google.android.gms.internal.measurement.zzat;
import com.google.android.gms.internal.measurement.zzbk;
import com.google.android.gms.internal.measurement.zzg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class zzh {
    public static void zza(String string, int n, List list) {
        if (list.size() != n) {
            Object[] objectArray = new Object[]{string, n, list.size()};
            throw new IllegalArgumentException(String.format("%s operation requires %s parameters found %s", objectArray));
        }
    }

    public static void zzb(String string, int n, List list) {
        if (list.size() < n) {
            Object[] objectArray = new Object[]{string, n, list.size()};
            throw new IllegalArgumentException(String.format("%s operation requires at least %s parameters found %s", objectArray));
        }
    }

    public static void zzc(String string, int n, List list) {
        if (list.size() > n) {
            Object[] objectArray = new Object[]{string, n, list.size()};
            throw new IllegalArgumentException(String.format("%s operation requires at most %s parameters found %s", objectArray));
        }
    }

    public static boolean zzd(zzao object) {
        if (object == null) {
            return false;
        }
        if (!((Double)(object = object.zzd())).isNaN() && (Double)object >= 0.0) {
            Object object2 = object;
            if (((Double)object2).equals(Math.floor((Double)object2))) {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static zzbk zze(String string) {
        Object[] objectArray = string != null ? (!string.isEmpty() ? zzbk.zza(Integer.parseInt(string)) : null) : null;
        if (objectArray == null) {
            objectArray = new Object[]{string};
            throw new IllegalArgumentException(String.format("Unsupported commandId %s", objectArray));
        }
        return objectArray;
    }

    public static boolean zzf(zzao zzao2, zzao zzao3) {
        if (!zzao2.getClass().equals(zzao3.getClass())) {
            return false;
        }
        if (zzao2 instanceof zzat || zzao2 instanceof zzam) {
            return true;
        }
        if (zzao2 instanceof zzah) {
            if (Double.isNaN(zzao2.zzd()) || Double.isNaN(zzao3.zzd())) {
                return false;
            }
            return zzao2.zzd().equals(zzao3.zzd());
        }
        if (zzao2 instanceof zzas) {
            return zzao2.zzc().equals(zzao3.zzc());
        }
        if (zzao2 instanceof zzaf) {
            return zzao2.zze().equals(zzao3.zze());
        }
        return zzao2 == zzao3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int zzg(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d) || d == 0.0) {
            return 0;
        }
        int n = d > 0.0 ? 1 : -1;
        d = Math.floor(Math.abs(d));
        return (int)((double)n * d % 4.294967296E9);
    }

    public static long zzh(double d) {
        return (long)zzh.zzg(d) & 0xFFFFFFFFL;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static double zzi(double d) {
        if (Double.isNaN(d)) {
            return 0.0;
        }
        if (Double.isInfinite(d) || d == 0.0 || d == 0.0) {
            return d;
        }
        int n = d > 0.0 ? 1 : -1;
        d = Math.floor(Math.abs(d));
        return (double)n * d;
    }

    public static Object zzj(zzao object) {
        if (zzao.zzg.equals(object)) {
            return null;
        }
        if (zzao.zzf.equals(object)) {
            return "";
        }
        if (object instanceof zzal) {
            return zzh.zzk((zzal)object);
        }
        if (object instanceof zzae) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            object = ((zzae)object).iterator();
            while (object.hasNext()) {
                Object object2 = zzh.zzj((zzao)object.next());
                if (object2 == null) continue;
                arrayList.add(object2);
            }
            return arrayList;
        }
        if (!object.zzd().isNaN()) {
            return object.zzd();
        }
        return object.zzc();
    }

    public static Map zzk(zzal zzal2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string : zzal2.zzb()) {
            Object object = zzh.zzj(zzal2.zzk(string));
            if (object == null) continue;
            hashMap.put(string, object);
        }
        return hashMap;
    }

    public static int zzl(zzg zzg2) {
        int n = zzh.zzg(zzg2.zzh("runtime.counter").zzd() + 1.0);
        if (n > 1000000) {
            throw new IllegalStateException("Instructions allowed exceeded");
        }
        double d = n;
        zzah zzah2 = new zzah(d);
        zzg2.zze("runtime.counter", zzah2);
        return n;
    }
}

