/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.PowerManager;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.measurement.AppMeasurementReceiver;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzv;
import com.google.android.gms.measurement.internal.zzw;

public final class AppMeasurementService
extends Service {
    private final Handler mHandler = new Handler();
    private static Boolean zzLj;

    public static boolean zzW(Context context) {
        zzx.zzw((Object)context);
        if (zzLj != null) {
            return zzLj;
        }
        boolean bl = zzag.zza(context, AppMeasurementService.class);
        zzLj = bl;
        return bl;
    }

    public void onCreate() {
        super.onCreate();
        zzv zzv2 = zzv.zzaL((Context)this);
        zzp zzp2 = zzv2.zzyd();
        if (zzv2.zzzt().zzjA()) {
            zzp2.zzzQ().zzec("Device AppMeasurementService is starting up");
        } else {
            zzp2.zzzQ().zzec("Local AppMeasurementService is starting up");
        }
    }

    public void onDestroy() {
        zzv zzv2 = zzv.zzaL((Context)this);
        zzp zzp2 = zzv2.zzyd();
        if (zzv2.zzzt().zzjA()) {
            zzp2.zzzQ().zzec("Device AppMeasurementService is shutting down");
        } else {
            zzp2.zzzQ().zzec("Local AppMeasurementService is shutting down");
        }
        super.onDestroy();
    }

    public int onStartCommand(Intent intent, int flags, final int startId) {
        this.zzhH();
        final zzv zzv2 = zzv.zzaL((Context)this);
        final zzp zzp2 = zzv2.zzyd();
        String string = intent.getAction();
        if (zzv2.zzzt().zzjA()) {
            zzp2.zzzQ().zze("Device AppMeasurementService called. startId, action", startId, string);
        } else {
            zzp2.zzzQ().zze("Local AppMeasurementService called. startId, action", startId, string);
        }
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            zzv2.zzzr().zzh(new Runnable(){

                @Override
                public void run() {
                    zzv2.zzAk();
                    AppMeasurementService.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            boolean bl = AppMeasurementService.this.stopSelfResult(startId);
                            if (bl) {
                                if (zzv2.zzzt().zzjA()) {
                                    zzp2.zzzQ().zzec("Device AppMeasurementService processed last upload request");
                                } else {
                                    zzp2.zzzQ().zzec("Local AppMeasurementService processed last upload request");
                                }
                            }
                        }
                    });
                }
            });
            return 2;
        }
        return 2;
    }

    public IBinder onBind(Intent intent) {
        if (intent == null) {
            this.zzyd().zzzK().zzec("onBind called with null intent");
            return null;
        }
        String string = intent.getAction();
        if ("com.google.android.gms.measurement.START".equals(string)) {
            return new zzw(zzv.zzaL((Context)this));
        }
        this.zzyd().zzzL().zzj("onBind received unknown action", string);
        return null;
    }

    public boolean onUnbind(Intent intent) {
        if (intent == null) {
            this.zzyd().zzzK().zzec("onUnbind called with null intent");
            return true;
        }
        String string = intent.getAction();
        this.zzyd().zzzQ().zzj("onUnbind called for intent. action", string);
        return true;
    }

    public void onRebind(Intent intent) {
        if (intent == null) {
            this.zzyd().zzzK().zzec("onRebind called with null intent");
            return;
        }
        String string = intent.getAction();
        this.zzyd().zzzQ().zzj("onRebind called. action", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzhH() {
        try {
            Object object = AppMeasurementReceiver.zzpy;
            synchronized (object) {
                PowerManager.WakeLock wakeLock = AppMeasurementReceiver.zzaKH;
                if (wakeLock != null && wakeLock.isHeld()) {
                    wakeLock.release();
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private zzp zzyd() {
        return zzv.zzaL((Context)this).zzyd();
    }
}

