/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.PowerManager;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.measurement.AppMeasurementReceiver;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzt;
import com.google.android.gms.measurement.internal.zzu;

public final class AppMeasurementService
extends Service {
    private final Handler mHandler = new Handler();
    private static Boolean zzNu;

    public static boolean zzY(Context context) {
        zzx.zzy((Object)context);
        if (zzNu != null) {
            return zzNu;
        }
        boolean bl = zzae.zza(context, AppMeasurementService.class);
        zzNu = bl;
        return bl;
    }

    public void onCreate() {
        super.onCreate();
        zzt zzt2 = zzt.zzaU((Context)this);
        zzo zzo2 = zzt2.zzzz();
        if (zzt2.zzAX().zzka()) {
            zzo2.zzBr().zzez("Device AppMeasurementService is starting up");
        } else {
            zzo2.zzBr().zzez("Local AppMeasurementService is starting up");
        }
    }

    public void onDestroy() {
        zzt zzt2 = zzt.zzaU((Context)this);
        zzo zzo2 = zzt2.zzzz();
        if (zzt2.zzAX().zzka()) {
            zzo2.zzBr().zzez("Device AppMeasurementService is shutting down");
        } else {
            zzo2.zzBr().zzez("Local AppMeasurementService is shutting down");
        }
        super.onDestroy();
    }

    public int onStartCommand(Intent intent, int flags, final int startId) {
        this.zzih();
        final zzt zzt2 = zzt.zzaU((Context)this);
        final zzo zzo2 = zzt2.zzzz();
        String string = intent.getAction();
        if (zzt2.zzAX().zzka()) {
            zzo2.zzBr().zze("Device AppMeasurementService called. startId, action", startId, string);
        } else {
            zzo2.zzBr().zze("Local AppMeasurementService called. startId, action", startId, string);
        }
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            zzt2.zzAV().zzg(new Runnable(){

                @Override
                public void run() {
                    zzt2.zzBK();
                    AppMeasurementService.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            boolean bl = AppMeasurementService.this.stopSelfResult(startId);
                            if (bl) {
                                if (zzt2.zzAX().zzka()) {
                                    zzo2.zzBr().zzez("Device AppMeasurementService processed last upload request");
                                } else {
                                    zzo2.zzBr().zzez("Local AppMeasurementService processed last upload request");
                                }
                            }
                        }
                    });
                }
            });
            return 2;
        }
        return 2;
    }

    public IBinder onBind(Intent intent) {
        if (intent == null) {
            this.zzzz().zzBl().zzez("onBind called with null intent");
            return null;
        }
        String string = intent.getAction();
        if ("com.google.android.gms.measurement.START".equals(string)) {
            return new zzu(zzt.zzaU((Context)this));
        }
        this.zzzz().zzBm().zzj("onBind received unknown action", string);
        return null;
    }

    public boolean onUnbind(Intent intent) {
        if (intent == null) {
            this.zzzz().zzBl().zzez("onUnbind called with null intent");
            return true;
        }
        String string = intent.getAction();
        this.zzzz().zzBr().zzj("onUnbind called for intent. action", string);
        return true;
    }

    public void onRebind(Intent intent) {
        if (intent == null) {
            this.zzzz().zzBl().zzez("onRebind called with null intent");
            return;
        }
        String string = intent.getAction();
        this.zzzz().zzBr().zzj("onRebind called. action", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzih() {
        try {
            Object object = AppMeasurementReceiver.zzqf;
            synchronized (object) {
                PowerManager.WakeLock wakeLock = AppMeasurementReceiver.zzaQY;
                if (wakeLock != null && wakeLock.isHeld()) {
                    wakeLock.release();
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private zzo zzzz() {
        return zzt.zzaU((Context)this).zzzz();
    }
}

