/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.support.v4.util.ArrayMap;
import android.util.Pair;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzqq;
import com.google.android.gms.internal.zztc;
import com.google.android.gms.internal.zztd;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzt;
import com.google.android.gms.measurement.internal.zzw;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class zzd
extends zzw {
    private static final Map<String, String> zzaSu = new ArrayMap(5);
    private final zza zzaSv;
    private final zzaa zzaSw = new zzaa(this.zziT());

    zzd(zzt zzt2) {
        super(zzt2);
        String string2 = this.zzjz();
        this.zzaSv = new zza(this.getContext(), string2);
    }

    @Override
    protected void zzir() {
    }

    public void beginTransaction() {
        this.zzje();
        this.getWritableDatabase().beginTransaction();
    }

    public void setTransactionSuccessful() {
        this.zzje();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    public void endTransaction() {
        this.zzje();
        this.getWritableDatabase().endTransaction();
    }

    private long zza(String string2, String[] stringArray, long l) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string2, stringArray);
            if (cursor.moveToFirst()) {
                long l2 = cursor.getLong(0);
                return l2;
            }
            long l3 = l;
            return l3;
        }
    }

    SQLiteDatabase getWritableDatabase() {
        this.zziS();
        try {
            return this.zzaSv.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzzz().zzBm().zzj("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    private String zzjz() {
        if (!this.zzAX().zzka()) {
            return this.zzAX().zzkA();
        }
        if (this.zzAX().zzkb()) {
            return this.zzAX().zzkA();
        }
        this.zzzz().zzBn().zzez("Using secondary database");
        return this.zzAX().zzkB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzh zzL(String string2, String string3) {
        zzx.zzcG((String)string2);
        zzx.zzcG((String)string3);
        this.zziS();
        this.zzje();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("events", new String[]{"lifetime_count", "current_bundle_count", "last_fire_timestamp"}, "app_id=? and name=?", new String[]{string2, string3}, null, null, null);
            if (!cursor.moveToFirst()) {
                zzh zzh2 = null;
                return zzh2;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            zzh zzh3 = new zzh(string2, string3, l, l2, l3);
            if (cursor.moveToNext()) {
                this.zzzz().zzBl().zzez("Got multiple records for event aggregates, expected one");
            }
            zzh zzh4 = zzh3;
            return zzh4;
        }
    }

    public void zza(zzh zzh2) {
        zzx.zzy((Object)zzh2);
        this.zziS();
        this.zzje();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzh2.zzaRd);
        contentValues.put("name", zzh2.mName);
        contentValues.put("lifetime_count", Long.valueOf(zzh2.zzaSF));
        contentValues.put("current_bundle_count", Long.valueOf(zzh2.zzaSG));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzh2.zzaSH));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.insertWithOnConflict("events", null, contentValues, 5);
            if (l == -1L) {
                this.zzzz().zzBl().zzez("Failed to insert/update event aggregates (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzzz().zzBl().zzj("Error storing event aggregates", (Object)sQLiteException);
        }
    }

    public void zzM(String string2, String string3) {
        zzx.zzcG((String)string2);
        zzx.zzcG((String)string3);
        this.zziS();
        this.zzje();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            int n = sQLiteDatabase.delete("user_attributes", "app_id=? and name=?", new String[]{string2, string3});
            this.zzzz().zzBr().zzj("Deleted user attribute rows:", n);
        }
        catch (SQLiteException sQLiteException) {
            this.zzzz().zzBl().zzd("Error deleting user attribute", string2, string3, (Object)sQLiteException);
        }
    }

    public void zza(zzac zzac2) {
        zzx.zzy((Object)zzac2);
        this.zziS();
        this.zzje();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzac2.zzaRd);
        contentValues.put("name", zzac2.mName);
        contentValues.put("set_timestamp", Long.valueOf(zzac2.zzaVf));
        this.zza(contentValues, "value", zzac2.zzLI);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.insertWithOnConflict("user_attributes", null, contentValues, 5);
            if (l == -1L) {
                this.zzzz().zzBl().zzez("Failed to insert/update user attribute (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzzz().zzBl().zzj("Error storing user attribute", (Object)sQLiteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<zzac> zzev(String string2) {
        zzx.zzcG((String)string2);
        this.zziS();
        this.zzje();
        ArrayList<zzac> arrayList = new ArrayList<zzac>();
        try (Cursor cursor = null;){
            Object object;
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("user_attributes", new String[]{"name", "set_timestamp", "value"}, "app_id=?", new String[]{string2}, null, null, "rowid", String.valueOf(this.zzAX().zzAz() + 1));
            if (!cursor.moveToFirst()) {
                ArrayList<zzac> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zzb(cursor, 2);
                if (object2 == null) {
                    this.zzzz().zzBl().zzez("Read invalid user attribute value, ignoring it");
                    continue;
                }
                zzac zzac2 = new zzac(string2, (String)object, l, object2);
                arrayList.add(zzac2);
            } while (cursor.moveToNext());
            if (arrayList.size() > this.zzAX().zzAz()) {
                this.zzzz().zzBl().zzez("Loaded too many user attributes");
                arrayList.remove(this.zzAX().zzAz());
            }
            object = arrayList;
            return object;
        }
    }

    public void zza(com.google.android.gms.measurement.internal.zza zza2) {
        zzx.zzy((Object)zza2);
        this.zziS();
        this.zzje();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zza2.zzaRd);
        contentValues.put("app_instance_id", zza2.zzaSe);
        contentValues.put("gmp_app_id", zza2.zzaSf);
        contentValues.put("resettable_device_id_hash", zza2.zzaSg);
        contentValues.put("last_bundle_index", Long.valueOf(zza2.zzaSh));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zza2.zzaSi));
        contentValues.put("app_version", zza2.zzRl);
        contentValues.put("app_store", zza2.zzaSj);
        contentValues.put("gmp_version", Long.valueOf(zza2.zzaSk));
        contentValues.put("dev_cert_hash", Long.valueOf(zza2.zzaSl));
        contentValues.put("measurement_enabled", Boolean.valueOf(zza2.zzaSm));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5);
            if (l == -1L) {
                this.zzzz().zzBl().zzez("Failed to insert/update app (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzzz().zzBl().zzj("Error storing app", (Object)sQLiteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.google.android.gms.measurement.internal.zza zzew(String string2) {
        zzx.zzcG((String)string2);
        this.zziS();
        this.zzje();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled"}, "app_id=?", new String[]{string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                com.google.android.gms.measurement.internal.zza zza2 = null;
                return zza2;
            }
            String string3 = cursor.getString(0);
            String string4 = cursor.getString(1);
            String string5 = cursor.getString(2);
            long l = cursor.getLong(3);
            long l2 = cursor.getLong(4);
            String string6 = cursor.getString(5);
            String string7 = cursor.getString(6);
            long l3 = cursor.getLong(7);
            long l4 = cursor.getLong(8);
            int n = cursor.isNull(9) ? 1 : cursor.getInt(9);
            com.google.android.gms.measurement.internal.zza zza3 = new com.google.android.gms.measurement.internal.zza(string2, string3, string4, string5, l, l2, string6, string7, l3, l4, n != 0);
            if (cursor.moveToNext()) {
                this.zzzz().zzBl().zzez("Got multiple records for app, expected one");
            }
            com.google.android.gms.measurement.internal.zza zza4 = zza3;
            return zza4;
        }
    }

    public void zza(zzqq.zzd zzd2) {
        byte[] byArray;
        Object object;
        this.zziS();
        this.zzje();
        zzx.zzy((Object)((Object)zzd2));
        zzx.zzcG((String)zzd2.appId);
        zzx.zzy((Object)zzd2.zzaVw);
        this.zzAZ();
        long l = this.zziT().currentTimeMillis();
        if (zzd2.zzaVw < l - this.zzAX().zzAF() || zzd2.zzaVw > l + this.zzAX().zzAF()) {
            this.zzzz().zzBm().zze("Storing bundle outside of the max uploading time span. now, timestamp", l, zzd2.zzaVw);
        }
        try {
            int n = zzd2.getSerializedSize();
            object = new byte[n];
            zztd zztd2 = zztd.zzD((byte[])object);
            zzd2.writeTo(zztd2);
            zztd2.zzHy();
            byArray = this.zzAU().zzg((byte[])object);
        }
        catch (IOException iOException) {
            this.zzzz().zzBl().zzj("Data loss. Failed to serialize bundle", iOException);
            return;
        }
        this.zzzz().zzBr().zzj("Saving bundle, size", byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzd2.appId);
        contentValues.put("bundle_end_timestamp", zzd2.zzaVw);
        contentValues.put("data", byArray);
        try {
            object = this.getWritableDatabase();
            long l2 = object.insert("queue", null, contentValues);
            if (l2 == -1L) {
                this.zzzz().zzBl().zzez("Failed to insert bundle (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzzz().zzBl().zzj("Error storing bundle", (Object)sQLiteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zzAY() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            String string2 = "SELECT q.app_id FROM queue q JOIN apps a ON a.app_id=q.app_id WHERE a.measurement_enabled!=0 ORDER BY q.rowid LIMIT 1;";
            cursor = sQLiteDatabase.rawQuery(string2, null);
            if (cursor.moveToFirst()) {
                String string3 = cursor.getString(0);
                return string3;
            }
            String string4 = null;
            return string4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pair<zzqq.zzd, Long>> zzn(String string2, int n, int n2) {
        this.zziS();
        this.zzje();
        zzx.zzab((n > 0 ? 1 : 0) != 0);
        zzx.zzab((n2 > 0 ? 1 : 0) != 0);
        zzx.zzcG((String)string2);
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("queue", new String[]{"rowid", "data"}, "app_id=?", new String[]{string2}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzqq.zzd, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzqq.zzd, Long>> arrayList = new ArrayList<Pair<zzqq.zzd, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzAU().zzq((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzzz().zzBl().zze("Failed to unzip queued bundle", string2, iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                object = zztc.zzC((byte[])byArray);
                zzqq.zzd zzd2 = new zzqq.zzd();
                try {
                    zzd2.zzw((zztc)object);
                }
                catch (IOException iOException) {
                    this.zzzz().zzBl().zze("Failed to merge queued bundle", string2, iOException);
                    continue;
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzqq.zzd, Long>)Pair.create((Object)((Object)zzd2), (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzqq.zzd, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    public void zzP(long l) {
        this.zziS();
        this.zzje();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        String[] stringArray = new String[]{String.valueOf(l)};
        int n = sQLiteDatabase.delete("queue", "rowid=?", stringArray);
        if (n != 1) {
            this.zzzz().zzBl().zzez("Deleted fewer rows from queue than expected");
        }
    }

    void zzAZ() {
        this.zziS();
        this.zzje();
        if (!this.zzBc()) {
            return;
        }
        long l = this.zzAW().zzaTI.get();
        long l2 = this.zziT().elapsedRealtime();
        if (Math.abs(l2 - l) > this.zzAX().zzAG()) {
            this.zzAW().zzaTI.set(l2);
            this.zzBa();
        }
    }

    void zzBa() {
        this.zziS();
        this.zzje();
        if (!this.zzBc()) {
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        String[] stringArray = new String[]{String.valueOf(this.zziT().currentTimeMillis()), String.valueOf(this.zzAX().zzAF())};
        int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
        if (n > 0) {
            this.zzzz().zzBr().zzj("Deleted stale rows. rowsDeleted", n);
        }
    }

    void zza(ContentValues contentValues, String string2, Object object) {
        zzx.zzcG((String)string2);
        zzx.zzy((Object)object);
        if (object instanceof String) {
            contentValues.put(string2, (String)object);
        } else if (object instanceof Long) {
            contentValues.put(string2, (Long)object);
        } else if (object instanceof Float) {
            contentValues.put(string2, (Float)object);
        } else {
            throw new IllegalArgumentException("Invalid value type");
        }
    }

    static int zza(Cursor cursor, int n) {
        int n2;
        if (Build.VERSION.SDK_INT >= 11) {
            return cursor.getType(n);
        }
        SQLiteCursor sQLiteCursor = (SQLiteCursor)cursor;
        CursorWindow cursorWindow = sQLiteCursor.getWindow();
        if (cursorWindow.isNull(n2 = cursor.getPosition(), n)) {
            return 0;
        }
        if (cursorWindow.isLong(n2, n)) {
            return 1;
        }
        if (cursorWindow.isFloat(n2, n)) {
            return 2;
        }
        if (cursorWindow.isString(n2, n)) {
            return 3;
        }
        if (cursorWindow.isBlob(n2, n)) {
            return 4;
        }
        return -1;
    }

    Object zzb(Cursor cursor, int n) {
        int n2 = zzd.zza(cursor, n);
        switch (n2) {
            case 0: {
                this.zzzz().zzBl().zzez("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return Float.valueOf(cursor.getFloat(n));
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzzz().zzBl().zzez("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzzz().zzBl().zzj("Loaded invalid unknown value type, ignoring it", n2);
        return null;
    }

    public long zzBb() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    private boolean zzBc() {
        return this.getContext().getDatabasePath(this.zzjz()).exists();
    }

    static {
        zzaSu.put("app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;");
        zzaSu.put("app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;");
        zzaSu.put("gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;");
        zzaSu.put("dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;");
        zzaSu.put("measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;");
    }

    private class zza
    extends SQLiteOpenHelper {
        zza(Context context, String string2) {
            super(context, string2, null, 1);
        }

        public SQLiteDatabase getWritableDatabase() {
            if (!zzd.this.zzaSw.zzv(zzd.this.zzAX().zzAA())) {
                throw new SQLiteException("Database open failed");
            }
            try {
                return super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                zzd.this.zzaSw.start();
                zzd.this.zzzz().zzBl().zzez("Opening the database failed, dropping and recreating it");
                String string2 = zzd.this.zzjz();
                zzd.this.getContext().getDatabasePath(string2).delete();
                try {
                    SQLiteDatabase sQLiteDatabase = super.getWritableDatabase();
                    zzd.this.zzaSw.clear();
                    return sQLiteDatabase;
                }
                catch (SQLiteException sQLiteException2) {
                    zzd.this.zzzz().zzBl().zzj("Failed to open freshly created database", (Object)sQLiteException2);
                    throw sQLiteException2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(SQLiteDatabase sQLiteDatabase, String string2) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string2}, null, null, null);
                boolean bl = cursor.moveToFirst();
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<String> zzb(SQLiteDatabase sQLiteDatabase, String string2) {
            HashSet<String> hashSet = new HashSet<String>();
            String string3 = "SELECT * FROM " + string2 + " LIMIT 0";
            try (Cursor cursor = sQLiteDatabase.rawQuery(string3, null);){
                Collections.addAll(hashSet, cursor.getColumnNames());
            }
            return hashSet;
        }

        private void zza(SQLiteDatabase sQLiteDatabase, String string2, String string3, Map<String, String> map) throws SQLiteException {
            Set<String> set = this.zzb(sQLiteDatabase, string2);
            for (String string4 : string3.split(",")) {
                if (set.remove(string4)) continue;
                throw new SQLiteException("Database " + string2 + " is missing required column: " + string4);
            }
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    if (set.remove(entry.getKey())) continue;
                    sQLiteDatabase.execSQL((String)entry.getValue());
                }
            }
            if (!set.isEmpty()) {
                throw new SQLiteException("Database " + string2 + " table has extra columns");
            }
        }

        private void zza(SQLiteDatabase sQLiteDatabase, String string2, String string3, String string4, Map<String, String> map) throws SQLiteException {
            if (!this.zza(sQLiteDatabase, string2)) {
                sQLiteDatabase.execSQL(string3);
            }
            try {
                this.zza(sQLiteDatabase, string2, string4, map);
            }
            catch (SQLiteException sQLiteException) {
                zzd.this.zzzz().zzBl().zzj("Failed to verify columns on table that was just created", string2);
                throw sQLiteException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpen(SQLiteDatabase database) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = database.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            this.zza(database, "events", "CREATE TABLE IF NOT EXISTS events ( app_id TEXT NOT NULL, name TEXT NOT NULL, lifetime_count INTEGER NOT NULL, current_bundle_count INTEGER NOT NULL, last_fire_timestamp INTEGER NOT NULL, PRIMARY KEY (app_id, name)) ;", "app_id,name,lifetime_count,current_bundle_count,last_fire_timestamp", null);
            this.zza(database, "user_attributes", "CREATE TABLE IF NOT EXISTS user_attributes ( app_id TEXT NOT NULL, name TEXT NOT NULL, set_timestamp INTEGER NOT NULL, value BLOB NOT NULL, PRIMARY KEY (app_id, name)) ;", "app_id,name,set_timestamp,value", null);
            this.zza(database, "apps", "CREATE TABLE IF NOT EXISTS apps ( app_id TEXT NOT NULL, app_instance_id TEXT, gmp_app_id TEXT, resettable_device_id_hash TEXT, last_bundle_index INTEGER NOT NULL, last_bundle_end_timestamp INTEGER NOT NULL, PRIMARY KEY (app_id)) ;", "app_id,app_instance_id,gmp_app_id,resettable_device_id_hash,last_bundle_index,last_bundle_end_timestamp", zzaSu);
            this.zza(database, "queue", "CREATE TABLE IF NOT EXISTS queue ( app_id TEXT NOT NULL, bundle_end_timestamp INTEGER NOT NULL, data BLOB NOT NULL);", "app_id,bundle_end_timestamp,data", null);
        }

        public void onCreate(SQLiteDatabase database) {
            if (Build.VERSION.SDK_INT >= 9) {
                File file = new File(database.getPath());
                file.setReadable(false, false);
                file.setWritable(false, false);
                file.setReadable(true, true);
                file.setWritable(true, true);
            }
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        }
    }
}

