/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.internal.EventParams;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzt;
import com.google.android.gms.measurement.internal.zzw;
import java.lang.reflect.Method;

public class zzy
extends zzw {
    private zza zzaUI;
    private AppMeasurement.zza zzaUJ;
    private boolean zzaUK;

    protected zzy(zzt zzt2) {
        super(zzt2);
    }

    @Override
    protected void zzir() {
    }

    public void zzBR() {
        if (this.getContext().getApplicationContext() instanceof Application) {
            Application application = (Application)this.getContext().getApplicationContext();
            if (this.zzaUI == null) {
                this.zzaUI = new zza();
            }
            application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzaUI);
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzaUI);
            this.zzzz().zzBr().zzez("Registered activity lifecycle callback");
        }
    }

    public void setMeasurementEnabled(final boolean enabled) {
        this.zzje();
        this.zziR();
        this.zzAV().zzg(new Runnable(){

            @Override
            public void run() {
                zzy.this.zzaq(enabled);
            }
        });
    }

    private void zzaq(boolean bl) {
        this.zziS();
        this.zziR();
        this.zzje();
        this.zzzz().zzBq().zzj("Setting app measurement enabled (FE)", bl);
        this.zzAW().setMeasurementEnabled(bl);
        this.zzAT().zzBV();
    }

    public void zze(String string2, String string3, Bundle bundle) {
        this.zziR();
        this.zza(string2, string3, bundle, true, null);
    }

    private void zza(final String string2, final String string3, Bundle bundle, final boolean bl, final String string4) {
        zzx.zzcG((String)string2);
        final long l = this.zziT().currentTimeMillis();
        this.zzAU().zzeE(string3);
        final Bundle bundle2 = new Bundle();
        if (bundle != null) {
            for (String string5 : bundle.keySet()) {
                this.zzAU().zzeG(string5);
                Object object = this.zzAU().zzk(string5, bundle.get(string5));
                if (object == null) continue;
                this.zzAU().zza(bundle2, string5, object);
            }
        }
        this.zzAV().zzg(new Runnable(){

            @Override
            public void run() {
                zzy.this.zza(string2, string3, l, bundle2, bl, string4);
            }
        });
    }

    private void zza(String string2, String string3, long l, Bundle bundle, boolean bl, String string4) {
        zzx.zzcG((String)string2);
        zzx.zzcG((String)string3);
        zzx.zzy((Object)bundle);
        this.zziS();
        this.zzje();
        if (!this.zzAW().zzzC()) {
            this.zzzz().zzBp().zzez("Event not sent since app measurement is disabled");
            return;
        }
        if (!this.zzaUK) {
            this.zzaUK = true;
            this.zzBT();
        }
        if (bl && this.zzaUJ != null) {
            this.zzzz().zzBq().zze("Passing event to registered event handler (FE)", string3, bundle);
            this.zzaUJ.zze(string2, string3, bundle);
            return;
        }
        if (!this.zzaQX.zzBz()) {
            return;
        }
        this.zzzz().zzBq().zze("Logging event (FE)", string3, bundle);
        EventParcel eventParcel = new EventParcel(string3, new EventParams(bundle), string2, l);
        this.zzAT().zzb(eventParcel, string4);
    }

    public void zza(final String string2, final String string3, Object object) {
        zzx.zzcG((String)string2);
        final long l = this.zziT().currentTimeMillis();
        this.zzAU().zzeF(string3);
        if (object != null) {
            this.zzAU().zzl(string3, object);
            final Object object2 = this.zzAU().zzm(string3, object);
            if (object2 != null) {
                this.zzAV().zzg(new Runnable(){

                    @Override
                    public void run() {
                        zzy.this.zza(string2, string3, object2, l);
                    }
                });
            }
        } else {
            this.zzAV().zzg(new Runnable(){

                @Override
                public void run() {
                    zzy.this.zza(string2, string3, null, l);
                }
            });
        }
    }

    private void zza(String string2, String string3, Object object, long l) {
        zzx.zzcG((String)string2);
        zzx.zzcG((String)string3);
        this.zziS();
        this.zziR();
        this.zzje();
        if (!this.zzAW().zzzC()) {
            this.zzzz().zzBp().zzez("User attribute not set since app measurement is disabled");
            return;
        }
        if (!this.zzaQX.zzBz()) {
            return;
        }
        this.zzzz().zzBq().zze("Setting user attribute (FE)", string3, object);
        UserAttributeParcel userAttributeParcel = new UserAttributeParcel(string3, l, object, string2);
        this.zzAT().zza(userAttributeParcel);
    }

    public void zzBS() {
        this.zziS();
        this.zziR();
        this.zzje();
        if (!this.zzaQX.zzBz()) {
            return;
        }
        this.zzAT().zzBS();
    }

    private void zzBT() {
        try {
            Class<?> clazz = Class.forName(this.zzBU());
            this.zzg(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.zzzz().zzBp().zzez("Tag Manager is not found and thus will not be used");
        }
    }

    private String zzBU() {
        return "com.google.android.gms.tagmanager.TagManagerService";
    }

    public void zzg(Class<?> clazz) {
        try {
            Method method = clazz.getDeclaredMethod("initialize", Context.class);
            method.invoke(null, this.getContext());
        }
        catch (Exception exception) {
            this.zzzz().zzBm().zzj("Failed to invoke Tag Manager's initialize() method", exception);
        }
    }

    private class zza
    implements Application.ActivityLifecycleCallbacks {
        private zza() {
        }

        private boolean zzeD(String string2) {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                zzy.this.zza("auto", "_ldl", string2);
                return true;
            }
            return false;
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            try {
                Uri uri;
                zzy.this.zzzz().zzBr().zzez("onActivityCreated");
                Intent intent = activity.getIntent();
                if (intent != null && (uri = intent.getData()) != null && uri.isHierarchical()) {
                    String string2 = uri.getQueryParameter("referrer");
                    if (TextUtils.isEmpty((CharSequence)string2)) {
                        return;
                    }
                    if (!string2.contains("gclid")) {
                        zzy.this.zzzz().zzBq().zzez("Activity created with data 'referrer' param without gclid");
                        return;
                    }
                    zzy.this.zzzz().zzBq().zzj("Activity created with referrer", string2);
                    this.zzeD(string2);
                }
            }
            catch (Throwable throwable) {
                zzy.this.zzzz().zzBl().zzj("Throwable caught in onActivityCreated", throwable);
            }
        }

        public void onActivityDestroyed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }
    }
}

