/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.stats.zzb;
import com.google.android.gms.measurement.AppMeasurementService;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzl;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzt;
import com.google.android.gms.measurement.internal.zzu;
import com.google.android.gms.measurement.internal.zzw;
import java.util.ArrayList;
import java.util.List;

public class zzz
extends zzw {
    private final zza zzaUS;
    private zzl zzaUT;
    private Boolean zzaUU;
    private final zze zzaUV;
    private final zzaa zzaUW;
    private final List<Runnable> zzaUX = new ArrayList<Runnable>();
    private final zze zzaUY;

    protected zzz(zzt zzt2) {
        super(zzt2);
        this.zzaUW = new zzaa(zzt2.zziT());
        this.zzaUS = new zza();
        this.zzaUV = new zze(zzt2){

            @Override
            public void run() {
                zzz.this.zzjs();
            }
        };
        this.zzaUY = new zze(zzt2){

            @Override
            public void run() {
                zzz.this.zzzz().zzBm().zzez("Tasks have been queued for a long time");
            }
        };
    }

    @Override
    protected void zzir() {
    }

    public boolean isConnected() {
        this.zziS();
        this.zzje();
        return this.zzaUT != null;
    }

    protected void zzBV() {
        this.zziS();
        this.zzje();
        this.zzi(new Runnable(){

            @Override
            public void run() {
                zzl zzl2 = zzz.this.zzaUT;
                if (zzl2 == null) {
                    zzz.this.zzzz().zzBl().zzez("Failed to send measurementEnabled to service");
                    return;
                }
                try {
                    zzl2.zzb(zzz.this.zzAS().zzex(zzz.this.zzzz().zzBs()));
                    zzz.this.zzjr();
                }
                catch (RemoteException remoteException) {
                    zzz.this.zzzz().zzBl().zzj("Failed to send measurementEnabled to AppMeasurementService", (Object)remoteException);
                }
            }
        });
    }

    protected void zzb(final EventParcel eventParcel, final String string2) {
        zzx.zzy((Object)eventParcel);
        this.zziS();
        this.zzje();
        this.zzi(new Runnable(){

            @Override
            public void run() {
                zzl zzl2 = zzz.this.zzaUT;
                if (zzl2 == null) {
                    zzz.this.zzzz().zzBl().zzez("Discarding data. Failed to send event to service");
                    return;
                }
                try {
                    if (TextUtils.isEmpty((CharSequence)string2)) {
                        zzl2.zza(eventParcel, zzz.this.zzAS().zzex(zzz.this.zzzz().zzBs()));
                    } else {
                        zzl2.zza(eventParcel, string2, zzz.this.zzzz().zzBs());
                    }
                    zzz.this.zzjr();
                }
                catch (RemoteException remoteException) {
                    zzz.this.zzzz().zzBl().zzj("Failed to send event to AppMeasurementService", (Object)remoteException);
                }
            }
        });
    }

    protected void zza(final UserAttributeParcel userAttributeParcel) {
        this.zziS();
        this.zzje();
        this.zzi(new Runnable(){

            @Override
            public void run() {
                zzl zzl2 = zzz.this.zzaUT;
                if (zzl2 == null) {
                    zzz.this.zzzz().zzBl().zzez("Discarding data. Failed to set user attribute");
                    return;
                }
                try {
                    zzl2.zza(userAttributeParcel, zzz.this.zzAS().zzex(zzz.this.zzzz().zzBs()));
                    zzz.this.zzjr();
                }
                catch (RemoteException remoteException) {
                    zzz.this.zzzz().zzBl().zzj("Failed to send attribute to AppMeasurementService", (Object)remoteException);
                }
            }
        });
    }

    protected void zzBS() {
        this.zziS();
        this.zzje();
        this.zzi(new Runnable(){

            @Override
            public void run() {
                zzl zzl2 = zzz.this.zzaUT;
                if (zzl2 == null) {
                    zzz.this.zzzz().zzBl().zzez("Discarding data. Failed to send app launch");
                    return;
                }
                try {
                    zzl2.zza(zzz.this.zzAS().zzex(zzz.this.zzzz().zzBs()));
                    zzz.this.zzjr();
                }
                catch (RemoteException remoteException) {
                    zzz.this.zzzz().zzBl().zzj("Failed to send app launch to AppMeasurementService", (Object)remoteException);
                }
            }
        });
    }

    private void zzjr() {
        this.zziS();
        this.zzaUW.start();
        if (!this.zzaQX.zzBI()) {
            this.zzaUV.zzt(this.zzAX().zzkv());
        }
    }

    private void zzjG() {
        this.zziS();
        this.zzje();
        if (this.isConnected()) {
            return;
        }
        if (this.zzaUU == null) {
            this.zzaUU = this.zzAW().zzBx();
            if (this.zzaUU == null) {
                this.zzzz().zzBr().zzez("State of service unknown");
                this.zzaUU = this.zzBX();
                this.zzAW().zzap(this.zzaUU);
            }
        }
        if (this.zzaUU.booleanValue()) {
            this.zzzz().zzBr().zzez("Using measurement service");
            this.zzaUS.zzCa();
        } else {
            if (this.zzBW() && !this.zzaQX.zzBI()) {
                this.zzzz().zzBr().zzez("Using local app measurement service");
                Intent intent = new Intent("com.google.android.gms.measurement.START");
                intent.setComponent(new ComponentName(this.getContext(), AppMeasurementService.class));
                this.zzaUS.zzA(intent);
                return;
            }
            if (this.zzAX().zzkb()) {
                this.zzzz().zzBr().zzez("Using direct local measurement implementation");
                this.zza(new zzu(this.zzaQX, true));
            } else {
                this.zzzz().zzBl().zzez("Not in main process. Unable to use local measurement implementation. Please register the AppMeasurementService service in the app manifest");
            }
        }
    }

    private boolean zzBW() {
        Intent intent;
        PackageManager packageManager = this.getContext().getPackageManager();
        List list = packageManager.queryIntentServices(intent = new Intent(this.getContext(), AppMeasurementService.class), 65536);
        return list != null && list.size() > 0;
    }

    private boolean zzBX() {
        this.zziS();
        this.zzje();
        if (this.zzAX().zzka()) {
            return true;
        }
        Intent intent = new Intent("com.google.android.gms.measurement.START");
        intent.setComponent(new ComponentName("com.google.android.gms", "com.google.android.gms.measurement.service.MeasurementBrokerService"));
        zzb zzb2 = zzb.zzrz();
        this.zzzz().zzBr().zzez("Checking service availability");
        if (zzb2.zza(this.getContext(), intent, new ServiceConnection(){

            public void onServiceConnected(ComponentName name, IBinder binder) {
            }

            public void onServiceDisconnected(ComponentName name) {
            }
        }, 0)) {
            this.zzzz().zzBr().zzez("Service available");
            return true;
        }
        return false;
    }

    private void zza(zzl zzl2) {
        this.zziS();
        zzx.zzy((Object)zzl2);
        this.zzaUT = zzl2;
        this.zzjr();
        this.zzBZ();
    }

    public void disconnect() {
        this.zziS();
        this.zzje();
        try {
            zzb zzb2 = zzb.zzrz();
            zzb2.zza(this.getContext(), (ServiceConnection)this.zzaUS);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            // empty catch block
        }
        this.zzaUT = null;
    }

    private void onServiceDisconnected(ComponentName name) {
        this.zziS();
        if (this.zzaUT != null) {
            this.zzaUT = null;
            this.zzzz().zzBr().zzj("Disconnected from device MeasurementService", name);
            this.zzBY();
        }
    }

    private void zzjs() {
        this.zziS();
        if (!this.isConnected()) {
            return;
        }
        this.zzzz().zzBr().zzez("Inactivity, disconnecting from AppMeasurementService");
        this.disconnect();
    }

    private void zzBY() {
        this.zziS();
        this.zzjG();
    }

    private void zzi(Runnable runnable) throws IllegalStateException {
        this.zziS();
        if (this.isConnected()) {
            runnable.run();
        } else {
            if ((long)this.zzaUX.size() >= this.zzAX().zzAH()) {
                this.zzzz().zzBl().zzez("Discarding data. Max runnable queue size reached");
                return;
            }
            this.zzaUX.add(runnable);
            if (!this.zzaQX.zzBI()) {
                this.zzaUY.zzt(60000L);
            }
            this.zzjG();
        }
    }

    private void zzBZ() {
        this.zziS();
        this.zzzz().zzBr().zzj("Processing queued up service tasks", this.zzaUX.size());
        for (Runnable runnable : this.zzaUX) {
            this.zzAV().zzg(runnable);
        }
        this.zzaUX.clear();
        this.zzaUY.cancel();
    }

    protected class zza
    implements ServiceConnection,
    GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private volatile boolean zzaVa;
        private volatile zzn zzaVb;

        protected zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzA(Intent intent) {
            zzz.this.zziS();
            Context context = zzz.this.getContext();
            zzb zzb2 = zzb.zzrz();
            zza zza2 = this;
            synchronized (zza2) {
                if (this.zzaVa) {
                    zzz.this.zzzz().zzBr().zzez("Connection attempt already in progress");
                    return;
                }
                this.zzaVa = true;
                zzb2.zza(context, intent, (ServiceConnection)zzz.this.zzaUS, 129);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName name, IBinder binder) {
            zzx.zzcx((String)"MeasurementServiceConnection.onServiceConnected");
            zza zza2 = this;
            synchronized (zza2) {
                Object object;
                this.zzaVa = false;
                if (binder == null) {
                    zzz.this.zzzz().zzBl().zzez("Service connected with null binder");
                    return;
                }
                zzl zzl2 = null;
                try {
                    object = binder.getInterfaceDescriptor();
                    if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(object)) {
                        zzl2 = zzl.zza.zzdi(binder);
                        zzz.this.zzzz().zzBr().zzez("Bound to IMeasurementService interface");
                    } else {
                        zzz.this.zzzz().zzBl().zzj("Got binder with a wrong descriptor", object);
                    }
                }
                catch (RemoteException remoteException) {
                    zzz.this.zzzz().zzBl().zzez("Service connect failed to get IMeasurementService");
                }
                if (zzl2 == null) {
                    try {
                        zzb.zzrz().zza(zzz.this.getContext(), (ServiceConnection)zzz.this.zzaUS);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else {
                    object = zzl2;
                    zzz.this.zzAV().zzg(new Runnable((zzl)object){
                        final /* synthetic */ zzl zzaVc;
                        {
                            this.zzaVc = zzl2;
                        }

                        @Override
                        public void run() {
                            if (!zzz.this.isConnected()) {
                                zzz.this.zzzz().zzBq().zzez("Connected to service");
                                zzz.this.zza(this.zzaVc);
                            }
                        }
                    });
                }
            }
        }

        public void onServiceDisconnected(final ComponentName name) {
            zzx.zzcx((String)"MeasurementServiceConnection.onServiceDisconnected");
            zzz.this.zzzz().zzBq().zzez("Service disconnected");
            zzz.this.zzAV().zzg(new Runnable(){

                @Override
                public void run() {
                    zzz.this.onServiceDisconnected(name);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzCa() {
            zzz.this.zziS();
            Context context = zzz.this.getContext();
            zza zza2 = this;
            synchronized (zza2) {
                if (this.zzaVa) {
                    zzz.this.zzzz().zzBr().zzez("Connection attempt already in progress");
                    return;
                }
                if (this.zzaVb != null) {
                    zzz.this.zzzz().zzBr().zzez("Already awaiting connection attempt");
                    return;
                }
                this.zzaVb = new zzn(context, Looper.getMainLooper(), zzf.zzas((Context)context), this, this);
                zzz.this.zzzz().zzBr().zzez("Connecting to remote service");
                this.zzaVa = true;
                this.zzaVb.zzqp();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConnected(Bundle connectionHint) {
            zzx.zzcx((String)"MeasurementServiceConnection.onConnected");
            zza zza2 = this;
            synchronized (zza2) {
                this.zzaVa = false;
                try {
                    final zzl zzl2 = (zzl)this.zzaVb.zzqs();
                    this.zzaVb = null;
                    zzz.this.zzAV().zzg(new Runnable(){

                        @Override
                        public void run() {
                            if (!zzz.this.isConnected()) {
                                zzz.this.zzzz().zzBq().zzez("Connected to remote service");
                                zzz.this.zza(zzl2);
                            }
                        }
                    });
                }
                catch (DeadObjectException | IllegalStateException throwable) {
                    this.zzaVb = null;
                }
            }
        }

        public void onConnectionSuspended(int cause) {
            zzx.zzcx((String)"MeasurementServiceConnection.onConnectionSuspended");
            zzz.this.zzzz().zzBq().zzez("Service connection suspended");
            zzz.this.zzAV().zzg(new Runnable(){

                @Override
                public void run() {
                    zzz.this.onServiceDisconnected(new ComponentName(zzz.this.getContext(), AppMeasurementService.class));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConnectionFailed(ConnectionResult result) {
            zzx.zzcx((String)"MeasurementServiceConnection.onConnectionFailed");
            zzz.this.zzzz().zzBm().zzj("Service connection failed", result);
            zza zza2 = this;
            synchronized (zza2) {
                this.zzaVa = false;
                this.zzaVb = null;
            }
        }
    }
}

