/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.stats.zzb;
import com.google.android.gms.common.zzc;
import com.google.android.gms.measurement.AppMeasurementService;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzz;
import java.util.ArrayList;
import java.util.List;

public class zzac
extends zzz {
    private final zza zzaYN;
    private zzm zzaYO;
    private Boolean zzaYP;
    private final zzf zzaYQ;
    private final zzaf zzaYR;
    private final List<Runnable> zzaYS = new ArrayList<Runnable>();
    private final zzf zzaYT;

    protected zzac(zzw zzw2) {
        super(zzw2);
        this.zzaYR = new zzaf(zzw2.zzjl());
        this.zzaYN = new zza();
        this.zzaYQ = new zzf(zzw2){

            @Override
            public void run() {
                zzac.this.zzjJ();
            }
        };
        this.zzaYT = new zzf(zzw2){

            @Override
            public void run() {
                zzac.this.zzAo().zzCF().zzfg("Tasks have been queued for a long time");
            }
        };
    }

    @Override
    protected void zziJ() {
    }

    @WorkerThread
    public boolean isConnected() {
        this.zzjk();
        this.zzjv();
        return this.zzaYO != null;
    }

    @WorkerThread
    protected void zzDo() {
        this.zzjk();
        this.zzjv();
        this.zzi(new Runnable(){

            @Override
            public void run() {
                zzm zzm2 = zzac.this.zzaYO;
                if (zzm2 == null) {
                    zzac.this.zzAo().zzCE().zzfg("Failed to send measurementEnabled to service");
                    return;
                }
                try {
                    zzm2.zzb(zzac.this.zzCg().zzfe(zzac.this.zzAo().zzCL()));
                    zzac.this.zzjI();
                }
                catch (RemoteException remoteException) {
                    zzac.this.zzAo().zzCE().zzj("Failed to send measurementEnabled to AppMeasurementService", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    protected void zzb(final EventParcel eventParcel, final String string2) {
        com.google.android.gms.common.internal.zzx.zzz((Object)eventParcel);
        this.zzjk();
        this.zzjv();
        this.zzi(new Runnable(){

            @Override
            public void run() {
                zzm zzm2 = zzac.this.zzaYO;
                if (zzm2 == null) {
                    zzac.this.zzAo().zzCE().zzfg("Discarding data. Failed to send event to service");
                    return;
                }
                try {
                    if (TextUtils.isEmpty((CharSequence)string2)) {
                        zzm2.zza(eventParcel, zzac.this.zzCg().zzfe(zzac.this.zzAo().zzCL()));
                    } else {
                        zzm2.zza(eventParcel, string2, zzac.this.zzAo().zzCL());
                    }
                    zzac.this.zzjI();
                }
                catch (RemoteException remoteException) {
                    zzac.this.zzAo().zzCE().zzj("Failed to send event to AppMeasurementService", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    protected void zza(final UserAttributeParcel userAttributeParcel) {
        this.zzjk();
        this.zzjv();
        this.zzi(new Runnable(){

            @Override
            public void run() {
                zzm zzm2 = zzac.this.zzaYO;
                if (zzm2 == null) {
                    zzac.this.zzAo().zzCE().zzfg("Discarding data. Failed to set user attribute");
                    return;
                }
                try {
                    zzm2.zza(userAttributeParcel, zzac.this.zzCg().zzfe(zzac.this.zzAo().zzCL()));
                    zzac.this.zzjI();
                }
                catch (RemoteException remoteException) {
                    zzac.this.zzAo().zzCE().zzj("Failed to send attribute to AppMeasurementService", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    protected void zzDl() {
        this.zzjk();
        this.zzjv();
        this.zzi(new Runnable(){

            @Override
            public void run() {
                zzm zzm2 = zzac.this.zzaYO;
                if (zzm2 == null) {
                    zzac.this.zzAo().zzCE().zzfg("Discarding data. Failed to send app launch");
                    return;
                }
                try {
                    zzm2.zza(zzac.this.zzCg().zzfe(zzac.this.zzAo().zzCL()));
                    zzac.this.zzjI();
                }
                catch (RemoteException remoteException) {
                    zzac.this.zzAo().zzCE().zzj("Failed to send app launch to AppMeasurementService", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    private void zzjI() {
        this.zzjk();
        this.zzaYR.start();
        if (!this.zzaTV.zzCZ()) {
            this.zzaYQ.zzt(this.zzCp().zzkM());
        }
    }

    @WorkerThread
    private void zzjX() {
        this.zzjk();
        this.zzjv();
        if (this.isConnected()) {
            return;
        }
        if (this.zzaYP == null) {
            this.zzaYP = this.zzCo().zzCP();
            if (this.zzaYP == null) {
                this.zzAo().zzCK().zzfg("State of service unknown");
                this.zzaYP = this.zzDq();
                this.zzCo().zzar(this.zzaYP);
            }
        }
        if (this.zzaYP.booleanValue()) {
            this.zzAo().zzCK().zzfg("Using measurement service");
            this.zzaYN.zzDt();
        } else {
            if (this.zzDp() && !this.zzaTV.zzCZ()) {
                this.zzAo().zzCK().zzfg("Using local app measurement service");
                Intent intent = new Intent("com.google.android.gms.measurement.START");
                intent.setComponent(new ComponentName(this.getContext(), AppMeasurementService.class));
                this.zzaYN.zzz(intent);
                return;
            }
            if (this.zzCp().zzks()) {
                this.zzAo().zzCK().zzfg("Using direct local measurement implementation");
                this.zza(new zzx(this.zzaTV, true));
            } else {
                this.zzAo().zzCE().zzfg("Not in main process. Unable to use local measurement implementation. Please register the AppMeasurementService service in the app manifest");
            }
        }
    }

    private boolean zzDp() {
        Intent intent;
        PackageManager packageManager = this.getContext().getPackageManager();
        List list = packageManager.queryIntentServices(intent = new Intent(this.getContext(), AppMeasurementService.class), 65536);
        return list != null && list.size() > 0;
    }

    @WorkerThread
    private boolean zzDq() {
        this.zzjk();
        this.zzjv();
        if (this.zzCp().zzkr()) {
            return true;
        }
        this.zzAo().zzCK().zzfg("Checking service availability");
        int n = zzc.zzoK().isGooglePlayServicesAvailable(this.getContext());
        switch (n) {
            case 0: {
                this.zzAo().zzCK().zzfg("Service available");
                return true;
            }
            case 1: {
                this.zzAo().zzCK().zzfg("Service missing");
                return false;
            }
            case 18: {
                this.zzAo().zzCK().zzfg("Service updating");
                return true;
            }
            case 2: {
                this.zzAo().zzCK().zzfg("Service version update required");
                return false;
            }
            case 3: {
                this.zzAo().zzCK().zzfg("Service disabled");
                return false;
            }
            case 9: {
                this.zzAo().zzCK().zzfg("Service invalid");
                return false;
            }
        }
        return false;
    }

    @WorkerThread
    private void zza(zzm zzm2) {
        this.zzjk();
        com.google.android.gms.common.internal.zzx.zzz((Object)zzm2);
        this.zzaYO = zzm2;
        this.zzjI();
        this.zzDs();
    }

    @WorkerThread
    public void disconnect() {
        this.zzjk();
        this.zzjv();
        try {
            zzb zzb2 = zzb.zzrP();
            zzb2.zza(this.getContext(), (ServiceConnection)this.zzaYN);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            // empty catch block
        }
        this.zzaYO = null;
    }

    @WorkerThread
    private void onServiceDisconnected(ComponentName name) {
        this.zzjk();
        if (this.zzaYO != null) {
            this.zzaYO = null;
            this.zzAo().zzCK().zzj("Disconnected from device MeasurementService", name);
            this.zzDr();
        }
    }

    @WorkerThread
    private void zzjJ() {
        this.zzjk();
        if (!this.isConnected()) {
            return;
        }
        this.zzAo().zzCK().zzfg("Inactivity, disconnecting from AppMeasurementService");
        this.disconnect();
    }

    @WorkerThread
    private void zzDr() {
        this.zzjk();
        this.zzjX();
    }

    @WorkerThread
    private void zzi(Runnable runnable) throws IllegalStateException {
        this.zzjk();
        if (this.isConnected()) {
            runnable.run();
        } else {
            if ((long)this.zzaYS.size() >= this.zzCp().zzBS()) {
                this.zzAo().zzCE().zzfg("Discarding data. Max runnable queue size reached");
                return;
            }
            this.zzaYS.add(runnable);
            if (!this.zzaTV.zzCZ()) {
                this.zzaYT.zzt(60000L);
            }
            this.zzjX();
        }
    }

    @WorkerThread
    private void zzDs() {
        this.zzjk();
        this.zzAo().zzCK().zzj("Processing queued up service tasks", this.zzaYS.size());
        for (Runnable runnable : this.zzaYS) {
            this.zzCn().zzg(runnable);
        }
        this.zzaYS.clear();
        this.zzaYT.cancel();
    }

    protected class zza
    implements ServiceConnection,
    GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private volatile boolean zzaYV;
        private volatile zzo zzaYW;

        protected zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void zzz(Intent intent) {
            zzac.this.zzjk();
            Context context = zzac.this.getContext();
            zzb zzb2 = zzb.zzrP();
            zza zza2 = this;
            synchronized (zza2) {
                if (this.zzaYV) {
                    zzac.this.zzAo().zzCK().zzfg("Connection attempt already in progress");
                    return;
                }
                this.zzaYV = true;
                zzb2.zza(context, intent, (ServiceConnection)zzac.this.zzaYN, 129);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onServiceConnected(ComponentName name, IBinder binder) {
            com.google.android.gms.common.internal.zzx.zzcD((String)"MeasurementServiceConnection.onServiceConnected");
            zza zza2 = this;
            synchronized (zza2) {
                Object object;
                if (binder == null) {
                    this.zzaYV = false;
                    zzac.this.zzAo().zzCE().zzfg("Service connected with null binder");
                    return;
                }
                zzm zzm2 = null;
                try {
                    object = binder.getInterfaceDescriptor();
                    if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(object)) {
                        zzm2 = zzm.zza.zzdn(binder);
                        zzac.this.zzAo().zzCK().zzfg("Bound to IMeasurementService interface");
                    } else {
                        zzac.this.zzAo().zzCE().zzj("Got binder with a wrong descriptor", object);
                    }
                }
                catch (RemoteException remoteException) {
                    zzac.this.zzAo().zzCE().zzfg("Service connect failed to get IMeasurementService");
                }
                if (zzm2 == null) {
                    this.zzaYV = false;
                    try {
                        zzb.zzrP().zza(zzac.this.getContext(), (ServiceConnection)zzac.this.zzaYN);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else {
                    object = zzm2;
                    zzac.this.zzCn().zzg(new Runnable((zzm)object){
                        final /* synthetic */ zzm zzaYX;
                        {
                            this.zzaYX = zzm2;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            zza zza2 = zza.this;
                            synchronized (zza2) {
                                zza.this.zzaYV = false;
                                if (!zzac.this.isConnected()) {
                                    zzac.this.zzAo().zzCK().zzfg("Connected to service");
                                    zzac.this.zza(this.zzaYX);
                                }
                            }
                        }
                    });
                }
            }
        }

        @MainThread
        public void onServiceDisconnected(final ComponentName name) {
            com.google.android.gms.common.internal.zzx.zzcD((String)"MeasurementServiceConnection.onServiceDisconnected");
            zzac.this.zzAo().zzCJ().zzfg("Service disconnected");
            zzac.this.zzCn().zzg(new Runnable(){

                @Override
                public void run() {
                    zzac.this.onServiceDisconnected(name);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void zzDt() {
            zzac.this.zzjk();
            Context context = zzac.this.getContext();
            zza zza2 = this;
            synchronized (zza2) {
                if (this.zzaYV) {
                    zzac.this.zzAo().zzCK().zzfg("Connection attempt already in progress");
                    return;
                }
                if (this.zzaYW != null) {
                    zzac.this.zzAo().zzCK().zzfg("Already awaiting connection attempt");
                    return;
                }
                this.zzaYW = new zzo(context, Looper.getMainLooper(), com.google.android.gms.common.internal.zzf.zzat((Context)context), this, this);
                zzac.this.zzAo().zzCK().zzfg("Connecting to remote service");
                this.zzaYV = true;
                this.zzaYW.zzqG();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onConnected(@Nullable Bundle connectionHint) {
            com.google.android.gms.common.internal.zzx.zzcD((String)"MeasurementServiceConnection.onConnected");
            zza zza2 = this;
            synchronized (zza2) {
                try {
                    final zzm zzm2 = (zzm)this.zzaYW.zzqJ();
                    this.zzaYW = null;
                    zzac.this.zzCn().zzg(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            zza zza2 = zza.this;
                            synchronized (zza2) {
                                zza.this.zzaYV = false;
                                if (!zzac.this.isConnected()) {
                                    zzac.this.zzAo().zzCJ().zzfg("Connected to remote service");
                                    zzac.this.zza(zzm2);
                                }
                            }
                        }
                    });
                }
                catch (DeadObjectException | IllegalStateException throwable) {
                    this.zzaYW = null;
                    this.zzaYV = false;
                }
            }
        }

        @MainThread
        public void onConnectionSuspended(int cause) {
            com.google.android.gms.common.internal.zzx.zzcD((String)"MeasurementServiceConnection.onConnectionSuspended");
            zzac.this.zzAo().zzCJ().zzfg("Service connection suspended");
            zzac.this.zzCn().zzg(new Runnable(){

                @Override
                public void run() {
                    zzac.this.onServiceDisconnected(new ComponentName(zzac.this.getContext(), AppMeasurementService.class));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onConnectionFailed(@NonNull ConnectionResult result) {
            com.google.android.gms.common.internal.zzx.zzcD((String)"MeasurementServiceConnection.onConnectionFailed");
            zzp zzp2 = zzac.this.zzaTV.zzCT();
            if (zzp2 != null) {
                zzp2.zzCF().zzj("Service connection failed", result);
            }
            zza zza2 = this;
            synchronized (zza2) {
                this.zzaYV = false;
                this.zzaYW = null;
            }
        }
    }
}

