/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.text.TextUtils;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.measurement.internal.AppMetadata;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzz;
import com.google.android.gms.measurement.zza;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public class zzn
extends zzz {
    private static final X500Principal zzaWz = new X500Principal("CN=Android Debug,O=Android,C=US");
    private String zzaUa;
    private String zzSF;
    private String zzaVi;
    private String zzSE;
    private long zzaWA;
    private String zzaVd;

    zzn(zzw zzw2) {
        super(zzw2);
    }

    @Override
    protected void zziJ() {
        boolean bl;
        boolean bl2;
        CharSequence charSequence;
        Object object;
        String string2;
        String string3 = "Unknown";
        String string4 = "Unknown";
        PackageManager packageManager = this.getContext().getPackageManager();
        String string5 = packageManager.getInstallerPackageName(string2 = this.getContext().getPackageName());
        if (string5 == null) {
            string5 = "manual_install";
        } else if ("com.android.vending".equals(string5)) {
            string5 = "";
        }
        try {
            object = packageManager.getPackageInfo(this.getContext().getPackageName(), 0);
            if (object != null) {
                charSequence = packageManager.getApplicationLabel(((PackageInfo)object).applicationInfo);
                if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                    string4 = charSequence.toString();
                }
                string3 = ((PackageInfo)object).versionName;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzAo().zzCE().zzj("Error retrieving package info: appName", string4);
        }
        this.zzaUa = string2;
        this.zzaVi = string5;
        this.zzSF = string3;
        this.zzSE = string4;
        object = zzaj.zzbv("MD5");
        if (object == null) {
            this.zzAo().zzCE().zzfg("Could not get MD5 instance");
            this.zzaWA = -1L;
        } else {
            this.zzaWA = 0L;
            try {
                if (!this.zzCD()) {
                    charSequence = packageManager.getPackageInfo(this.getContext().getPackageName(), 64);
                    if (((PackageInfo)charSequence).signatures != null && ((PackageInfo)charSequence).signatures.length > 0) {
                        byte[] byArray = ((MessageDigest)object).digest(((PackageInfo)charSequence).signatures[0].toByteArray());
                        this.zzaWA = zzaj.zzq(byArray);
                    }
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                this.zzAo().zzCE().zzj("Package name not found", (Object)nameNotFoundException);
            }
        }
        charSequence = this.zzCp().zzkr() ? zza.zzb(this.getContext(), "-", true) : zza.zzaR(this.getContext());
        boolean bl3 = bl2 = charSequence != null && charSequence.isSuccess();
        if (!bl2) {
            this.zzba((Status)charSequence);
        }
        if (bl2) {
            bl = zza.zzAr();
            if (bl) {
                this.zzAo().zzCK().zzfg("AppMeasurement enabled");
            } else {
                this.zzAo().zzCI().zzfg("AppMeasurement disabled with google_app_measurement_enable=0");
            }
        } else {
            bl = false;
        }
        this.zzaVd = "";
        if (!this.zzCp().zzkr()) {
            try {
                String string6 = zza.zzAp();
                String string7 = this.zzaVd = TextUtils.isEmpty((CharSequence)string6) ? "" : string6;
                if (bl) {
                    this.zzAo().zzCK().zze("App package, google app id", this.zzaUa, this.zzaVd);
                }
            }
            catch (IllegalStateException illegalStateException) {
                this.zzAo().zzCE().zzj("getGoogleAppId or isMeasurementEnabled failed with exception", illegalStateException);
            }
        }
    }

    protected void zzba(Status status) {
        if (status == null) {
            this.zzAo().zzCE().zzfg("GoogleService failed to initialize (no status)");
        } else {
            this.zzAo().zzCE().zze("GoogleService failed to initialize, status", status.getStatusCode(), status.getStatusMessage());
        }
    }

    AppMetadata zzfe(String string2) {
        return new AppMetadata(this.zzwK(), this.zzBk(), this.zzli(), this.zzBo(), this.zzBp(), this.zzBq(), string2, this.zzCo().zzAr(), !this.zzCo().zzaXx);
    }

    String zzwK() {
        this.zzjv();
        return this.zzaUa;
    }

    String zzBk() {
        this.zzjv();
        return this.zzaVd;
    }

    String zzli() {
        this.zzjv();
        return this.zzSF;
    }

    String zzBo() {
        this.zzjv();
        return this.zzaVi;
    }

    long zzBp() {
        return this.zzCp().zzBp();
    }

    long zzBq() {
        this.zzjv();
        return this.zzaWA;
    }

    boolean zzCD() {
        try {
            PackageInfo packageInfo = this.getContext().getPackageManager().getPackageInfo(this.getContext().getPackageName(), 64);
            if (packageInfo != null && packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                Signature signature = packageInfo.signatures[0];
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(signature.toByteArray()));
                return x509Certificate.getSubjectX500Principal().equals(zzaWz);
            }
        }
        catch (CertificateException certificateException) {
            this.zzAo().zzCE().zzj("Error obtaining certificate", certificateException);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzAo().zzCE().zzj("Package name not found", (Object)nameNotFoundException);
        }
        return true;
    }
}

