/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzz;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;

public class zzv
extends zzz {
    private zzc zzaXI;
    private zzc zzaXJ;
    private final BlockingQueue<FutureTask<?>> zzaXK;
    private final BlockingQueue<FutureTask<?>> zzaXL;
    private final Thread.UncaughtExceptionHandler zzaXM;
    private final Thread.UncaughtExceptionHandler zzaXN;
    private final Object zzaXO = new Object();
    private final Semaphore zzaXP = new Semaphore(2);
    private volatile boolean zzaXQ;

    zzv(zzw zzw2) {
        super(zzw2);
        this.zzaXK = new LinkedBlockingQueue();
        this.zzaXL = new LinkedBlockingQueue();
        this.zzaXM = new zzb("Thread death: Uncaught exception on worker thread");
        this.zzaXN = new zzb("Thread death: Uncaught exception on network thread");
    }

    @Override
    protected void zziJ() {
    }

    @Override
    public void zzjk() {
        if (Thread.currentThread() != this.zzaXI) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public void zzCd() {
        if (Thread.currentThread() != this.zzaXJ) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public <V> Future<V> zzd(Callable<V> callable) throws IllegalStateException {
        this.zzjv();
        zzx.zzz(callable);
        zza<V> zza2 = new zza<V>(callable, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzaXI) {
            zza2.run();
        } else {
            this.zza(zza2);
        }
        return zza2;
    }

    public void zzg(Runnable runnable) throws IllegalStateException {
        this.zzjv();
        zzx.zzz((Object)runnable);
        this.zza(new zza(runnable, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(FutureTask<?> futureTask) {
        Object object = this.zzaXO;
        synchronized (object) {
            this.zzaXK.add(futureTask);
            if (this.zzaXI == null) {
                this.zzaXI = new zzc("Measurement Worker", this.zzaXK);
                this.zzaXI.setUncaughtExceptionHandler(this.zzaXM);
                this.zzaXI.start();
            } else {
                this.zzaXI.zzfb();
            }
        }
    }

    public void zzh(Runnable runnable) throws IllegalStateException {
        this.zzjv();
        zzx.zzz((Object)runnable);
        this.zzb(new zza(runnable, "Task exception on network thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(FutureTask<?> futureTask) {
        Object object = this.zzaXO;
        synchronized (object) {
            this.zzaXL.add(futureTask);
            if (this.zzaXJ == null) {
                this.zzaXJ = new zzc("Measurement Network", this.zzaXL);
                this.zzaXJ.setUncaughtExceptionHandler(this.zzaXN);
                this.zzaXJ.start();
            } else {
                this.zzaXJ.zzfb();
            }
        }
    }

    private final class zzb
    implements Thread.UncaughtExceptionHandler {
        private final String zzaXR;

        public zzb(String string2) {
            zzx.zzz((Object)string2);
            this.zzaXR = string2;
        }

        @Override
        public synchronized void uncaughtException(Thread thread, Throwable error) {
            zzv.this.zzAo().zzCE().zzj(this.zzaXR, error);
        }
    }

    private final class zza<V>
    extends FutureTask<V> {
        private final String zzaXR;

        zza(Callable<V> callable, String string2) {
            super(callable);
            zzx.zzz((Object)string2);
            this.zzaXR = string2;
        }

        zza(Runnable runnable, String string2) {
            super(runnable, null);
            zzx.zzz((Object)string2);
            this.zzaXR = string2;
        }

        @Override
        protected void setException(Throwable error) {
            zzv.this.zzAo().zzCE().zzj(this.zzaXR, error);
            super.setException(error);
        }
    }

    private final class zzc
    extends Thread {
        private final Object zzaXT;
        private final BlockingQueue<FutureTask<?>> zzaXU;

        public zzc(String string2, BlockingQueue<FutureTask<?>> blockingQueue) {
            zzx.zzz((Object)string2);
            this.zzaXT = new Object();
            this.zzaXU = blockingQueue;
            this.setName(string2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            boolean bl = false;
            while (!bl) {
                try {
                    zzv.this.zzaXP.acquire();
                    bl = true;
                }
                catch (InterruptedException interruptedException) {
                    this.zza(interruptedException);
                }
            }
            try {
                while (true) {
                    FutureTask futureTask;
                    if ((futureTask = (FutureTask)this.zzaXU.poll()) != null) {
                        futureTask.run();
                        continue;
                    }
                    Object object = this.zzaXT;
                    synchronized (object) {
                        if (this.zzaXU.peek() == null && !zzv.this.zzaXQ) {
                            try {
                                this.zzaXT.wait(30000L);
                            }
                            catch (InterruptedException interruptedException) {
                                this.zza(interruptedException);
                            }
                        }
                    }
                    object = zzv.this.zzaXO;
                    synchronized (object) {
                        if (this.zzaXU.peek() == null) {
                            return;
                        }
                    }
                }
            }
            finally {
                Object object = zzv.this.zzaXO;
                synchronized (object) {
                    zzv.this.zzaXP.release();
                    zzv.this.zzaXO.notifyAll();
                    if (this == zzv.this.zzaXI) {
                        zzv.this.zzaXI = null;
                    } else if (this == zzv.this.zzaXJ) {
                        zzv.this.zzaXJ = null;
                    } else {
                        zzv.this.zzAo().zzCE().zzfg("Current scheduler thread is neither worker nor network");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzfb() {
            Object object = this.zzaXT;
            synchronized (object) {
                this.zzaXT.notifyAll();
            }
        }

        private void zza(InterruptedException interruptedException) {
            zzv.this.zzAo().zzCF().zzj(this.getName() + " was interrupted", interruptedException);
        }
    }
}

