/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.mlkit_vision_text;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.core.os.ConfigurationCompat;
import androidx.core.os.LocaleListCompat;
import com.google.android.gms.internal.mlkit_vision_text.zzap;
import com.google.android.gms.internal.mlkit_vision_text.zzbh;
import com.google.android.gms.internal.mlkit_vision_text.zzbs;
import com.google.android.gms.internal.mlkit_vision_text.zzef;
import com.google.android.gms.internal.mlkit_vision_text.zzeh;
import com.google.android.gms.internal.mlkit_vision_text.zzei;
import com.google.android.gms.internal.mlkit_vision_text.zzej;
import com.google.android.gms.internal.mlkit_vision_text.zzfy;
import com.google.android.gms.internal.mlkit_vision_text.zzs;
import com.google.android.gms.tasks.Task;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentContainer;
import com.google.firebase.components.Dependency;
import com.google.mlkit.common.sdkinternal.CommonUtils;
import com.google.mlkit.common.sdkinternal.LibraryVersion;
import com.google.mlkit.common.sdkinternal.MLTaskExecutor;
import com.google.mlkit.common.sdkinternal.SharedPrefManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class zzeg {
    @Nullable
    private static List<String> zzb;
    private final String zzc;
    private final String zzd;
    private final zzb zze;
    private final SharedPrefManager zzf;
    private final Task<String> zzg;
    private final Task<String> zzh;
    private final Map<zzbs, Long> zzi = new HashMap<zzbs, Long>();
    private final Map<zzbs, zzap<Object, Long>> zzj = new HashMap<zzbs, zzap<Object, Long>>();
    private static boolean zzk;
    private static boolean zzl;
    public static final Component<?> zza;

    private zzeg(Context context, SharedPrefManager sharedPrefManager, zzb zzb2) {
        this.zzc = context.getPackageName();
        this.zzd = CommonUtils.getAppVersion((Context)context);
        this.zzf = sharedPrefManager;
        this.zze = zzb2;
        this.zzg = MLTaskExecutor.getInstance().scheduleCallable(zzef.zza);
        MLTaskExecutor mLTaskExecutor = MLTaskExecutor.getInstance();
        SharedPrefManager sharedPrefManager2 = sharedPrefManager;
        sharedPrefManager2.getClass();
        this.zzh = mLTaskExecutor.scheduleCallable(zzei.zza(sharedPrefManager2));
    }

    public final void zza(@NonNull zzbh.zzad.zza zza2, @NonNull zzbs zzbs2) {
        MLTaskExecutor.workerThreadExecutor().execute(new zzeh(this, zza2, zzbs2));
    }

    @WorkerThread
    public final void zza(@NonNull zzc zzc2, @NonNull zzbs zzbs2) {
        long l = SystemClock.elapsedRealtime();
        if (!this.zza(zzbs2, l, 30L)) {
            return;
        }
        this.zzi.put(zzbs2, l);
        this.zza(zzc2.zza(), zzbs2);
    }

    @WorkerThread
    public final <K> void zza(@NonNull K k, long l, @NonNull zzbs zzbs2, @NonNull zza<K> zza2) {
        if (!zzk) {
            return;
        }
        if (!this.zzj.containsKey(zzbs2)) {
            this.zzj.put(zzbs2, zzs.zzf());
        }
        zzap<Object, Long> zzap2 = this.zzj.get(zzbs2);
        zzap2.zza(k, l);
        long l2 = SystemClock.elapsedRealtime();
        if (!this.zza(zzbs2, l2, 30L)) {
            return;
        }
        this.zzi.put(zzbs2, l2);
        Iterator iterator = zzap2.zzh().iterator();
        while (iterator.hasNext()) {
            Object k2;
            Object k3 = k2 = iterator.next();
            List<Long> list = zzap2.zza(k2);
            Collections.sort(list);
            zzbh.zzab.zza zza3 = zzbh.zzab.zza();
            List<Long> list2 = list;
            long l3 = 0L;
            for (long l4 : list2) {
                l3 += l4;
            }
            zzbh.zzab zzab2 = (zzbh.zzab)((zzfy)zza3.zzc(l3 / (long)list2.size()).zza(zzeg.zza(list, 100.0)).zzf(zzeg.zza(list, 75.0)).zze(zzeg.zza(list, 50.0)).zzd(zzeg.zza(list, 25.0)).zzb(zzeg.zza(list, 0.0)).zzh());
            this.zza(zza2.zza(k3, zzap2.zza(k2).size(), zzab2), zzbs2);
        }
        this.zzj.remove(zzbs2);
    }

    @VisibleForTesting
    private static long zza(List<Long> list, double d) {
        int n = (int)Math.ceil(d / 100.0 * (double)list.size());
        return list.get(Math.max(n - 1, 0));
    }

    @WorkerThread
    private final boolean zza(@NonNull zzbs zzbs2, long l, long l2) {
        if (this.zzi.get(zzbs2) == null) {
            return true;
        }
        return l - this.zzi.get(zzbs2) > TimeUnit.SECONDS.toMillis(30L);
    }

    @NonNull
    private static synchronized List<String> zzb() {
        if (zzb != null) {
            return zzb;
        }
        LocaleListCompat localeListCompat = ConfigurationCompat.getLocales((Configuration)Resources.getSystem().getConfiguration());
        zzb = new ArrayList<String>(localeListCompat.size());
        for (int i = 0; i < localeListCompat.size(); ++i) {
            Locale locale = localeListCompat.get(i);
            zzb.add(CommonUtils.languageTagFromLocale((Locale)locale));
        }
        return zzb;
    }

    final /* synthetic */ void zzb(zzbh.zzad.zza zza2, zzbs zzbs2) {
        String string = zza2.zza().zza();
        if ("NA".equals(string) || "".equals(string)) {
            string = "NA";
        }
        zzeg zzeg2 = this;
        zzbh.zzbg.zza zza3 = zzbh.zzbg.zzb().zza(this.zzc).zzb(this.zzd).zzd(string).zza((Iterable<String>)zzeg.zzb()).zzb(true).zzc(zzeg2.zzg.isSuccessful() ? (String)zzeg2.zzg.getResult() : LibraryVersion.getInstance().getVersion("text-recognition"));
        if (zzl) {
            zzeg2 = this;
            zza3.zze(zzeg2.zzh.isSuccessful() ? (String)zzeg2.zzh.getResult() : zzeg2.zzf.getMlSdkInstanceId());
        }
        zza2.zza(zzbs2).zza(zza3);
        this.zze.zza((zzbh.zzad)((zzfy)zza2.zzh()));
    }

    static final /* synthetic */ zzeg zza(ComponentContainer componentContainer) {
        return new zzeg((Context)componentContainer.get(Context.class), (SharedPrefManager)componentContainer.get(SharedPrefManager.class), (zzb)componentContainer.get(zzb.class));
    }

    static final /* synthetic */ String zza() throws Exception {
        return LibraryVersion.getInstance().getVersion("text-recognition");
    }

    static {
        zzk = true;
        zzl = true;
        zza = Component.builder(zzeg.class).add(Dependency.required(Context.class)).add(Dependency.required(SharedPrefManager.class)).add(Dependency.required(zzb.class)).factory(zzej.zza).build();
    }

    public static interface zza<K> {
        public zzbh.zzad.zza zza(K var1, int var2, zzbh.zzab var3);
    }

    public static interface zzc {
        public zzbh.zzad.zza zza();
    }

    public static interface zzb {
        public void zza(zzbh.zzad var1);
    }
}

