/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.nearby.messages.zzd;
import java.util.ArrayList;

public class Strategy
extends zza {
    public static final Parcelable.Creator<Strategy> CREATOR = new zzd();
    public static final int DISCOVERY_MODE_BROADCAST = 1;
    public static final int DISCOVERY_MODE_SCAN = 2;
    public static final int DISCOVERY_MODE_DEFAULT = 3;
    public static final int DISTANCE_TYPE_DEFAULT = 0;
    public static final int DISTANCE_TYPE_EARSHOT = 1;
    public static final int TTL_SECONDS_DEFAULT = 300;
    public static final int TTL_SECONDS_MAX = 86400;
    public static final int TTL_SECONDS_INFINITE = Integer.MAX_VALUE;
    public static final Strategy DEFAULT = new Builder().build();
    public static final Strategy BLE_ONLY;
    @Deprecated
    public static final Strategy zzbxE;
    final int mVersionCode;
    @Deprecated
    final int zzbxF;
    final int zzbxG;
    final int zzbxH;
    @Deprecated
    final boolean zzbxI;
    final int zzbxJ;
    final int zzbxK;
    private final int zzbxL;

    Strategy(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, int n7) {
        this.mVersionCode = n;
        this.zzbxF = n2;
        if (n2 == 0) {
            this.zzbxK = n6;
        } else {
            switch (n2) {
                case 2: {
                    this.zzbxK = 1;
                    break;
                }
                case 3: {
                    this.zzbxK = 2;
                    break;
                }
                default: {
                    this.zzbxK = 3;
                }
            }
        }
        this.zzbxH = n4;
        this.zzbxI = bl;
        if (bl) {
            this.zzbxJ = 2;
            this.zzbxG = Integer.MAX_VALUE;
        } else {
            this.zzbxG = n3;
            switch (n5) {
                case -1: 
                case 0: 
                case 1: 
                case 6: {
                    this.zzbxJ = -1;
                    break;
                }
                default: {
                    this.zzbxJ = n5;
                }
            }
        }
        this.zzbxL = n7;
    }

    public int zzNd() {
        return this.zzbxJ;
    }

    public int zzNe() {
        return this.zzbxK;
    }

    public int zzNf() {
        return this.zzbxL;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzd.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Strategy)) {
            return false;
        }
        Strategy strategy = (Strategy)((Object)object);
        return this.mVersionCode == strategy.mVersionCode && this.zzbxK == strategy.zzbxK && this.zzbxG == strategy.zzbxG && this.zzbxH == strategy.zzbxH && this.zzbxJ == strategy.zzbxJ;
    }

    public int hashCode() {
        int n = this.mVersionCode;
        n = 31 * n + this.zzbxK;
        n = 31 * n + this.zzbxG;
        n = 31 * n + this.zzbxH;
        n = 31 * n + this.zzbxJ;
        return n;
    }

    public String toString() {
        int n = this.zzbxG;
        String string = String.valueOf(Strategy.zzlM(this.zzbxH));
        String string2 = String.valueOf(Strategy.zzlN(this.zzbxJ));
        String string3 = String.valueOf(Strategy.zzlO(this.zzbxK));
        String string4 = String.valueOf(Strategy.zzlL(this.zzbxL));
        return new StringBuilder(102 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("Strategy{ttlSeconds=").append(n).append(", distanceType=").append(string).append(", discoveryMedium=").append(string2).append(", discoveryMode=").append(string3).append(", backgroundScanMode=").append(string4).append("}").toString();
    }

    private static String zzlL(int n) {
        switch (n) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "ALWAYS_ON";
            }
        }
        return new StringBuilder(20).append("UNKNOWN: ").append(n).toString();
    }

    private static String zzlM(int n) {
        switch (n) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "EARSHOT";
            }
        }
        return new StringBuilder(19).append("UNKNOWN:").append(n).toString();
    }

    private static String zzlN(int n) {
        if (n == -1) {
            return "DEFAULT";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((n & 4) > 0) {
            arrayList.add("ULTRASOUND");
        }
        if ((n & 2) > 0) {
            arrayList.add("BLE");
        }
        if (arrayList.isEmpty()) {
            return new StringBuilder(19).append("UNKNOWN:").append(n).toString();
        }
        return ((Object)arrayList).toString();
    }

    private static String zzlO(int n) {
        if (n == 3) {
            return "DEFAULT";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((n & 1) > 0) {
            arrayList.add("BROADCAST");
        }
        if ((n & 2) > 0) {
            arrayList.add("SCAN");
        }
        if (arrayList.isEmpty()) {
            return new StringBuilder(19).append("UNKNOWN:").append(n).toString();
        }
        return ((Object)arrayList).toString();
    }

    static {
        zzbxE = BLE_ONLY = new Builder().zzlP(2).setTtlSeconds(Integer.MAX_VALUE).build();
    }

    public static class Builder {
        private int zzbxM = 3;
        private int zzbxN = 300;
        private int zzbxO = 0;
        private int zzbxP = -1;
        private int zzbxQ = 0;

        public Builder setDiscoveryMode(int n) {
            this.zzbxM = n;
            return this;
        }

        public Builder zzlP(int n) {
            this.zzbxP = n;
            return this;
        }

        public Builder setTtlSeconds(int n) {
            zzac.zzb((n == Integer.MAX_VALUE || n > 0 && n <= 86400 ? 1 : 0) != 0, (String)"mTtlSeconds(%d) must either be TTL_SECONDS_INFINITE, or it must be between 1 and TTL_SECONDS_MAX(%d) inclusive", (Object[])new Object[]{n, 86400});
            this.zzbxN = n;
            return this;
        }

        public Builder setDistanceType(int n) {
            this.zzbxO = n;
            return this;
        }

        public Strategy build() {
            if (this.zzbxP == 2 && this.zzbxO == 1) {
                throw new IllegalStateException("Cannot set EARSHOT with BLE only mode.");
            }
            return new Strategy(2, 0, this.zzbxN, this.zzbxO, false, this.zzbxP, this.zzbxM, 0);
        }
    }
}

