/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzavp;
import com.google.android.gms.internal.zzzv;
import com.google.android.gms.nearby.Nearby;
import com.google.android.gms.nearby.messages.Message;
import com.google.android.gms.nearby.messages.MessageListener;
import com.google.android.gms.nearby.messages.Messages;
import com.google.android.gms.nearby.messages.MessagesOptions;
import com.google.android.gms.nearby.messages.PublishCallback;
import com.google.android.gms.nearby.messages.PublishOptions;
import com.google.android.gms.nearby.messages.StatusCallback;
import com.google.android.gms.nearby.messages.SubscribeCallback;
import com.google.android.gms.nearby.messages.SubscribeOptions;
import com.google.android.gms.nearby.messages.internal.Update;
import com.google.android.gms.nearby.messages.internal.zzs;
import com.google.android.gms.nearby.messages.internal.zzv;
import com.google.android.gms.nearby.messages.internal.zzx;
import java.util.List;

public class zzy
implements Messages {
    public static final zzy zzbyO = new zzy();
    public static final Api.zzf<zzx> zzahc = new Api.zzf();
    public static final Api.zza<zzx, MessagesOptions> zzahd = new Api.zza<zzx, MessagesOptions>(){

        public zzx zza(Context context, Looper looper, zzg zzg2, MessagesOptions messagesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return new zzx(context, looper, connectionCallbacks, onConnectionFailedListener, zzg2, messagesOptions);
        }

        public int getPriority() {
            return Integer.MAX_VALUE;
        }
    };

    private zzy() {
    }

    @Override
    public PendingResult<Status> publish(GoogleApiClient googleApiClient, final Message message, final PublishOptions publishOptions) {
        zzac.zzw((Object)((Object)message));
        zzac.zzw((Object)publishOptions);
        final zzaaz<PublishCallback> zzaaz2 = ((zzx)googleApiClient.zza(zzahc)).zza(googleApiClient, publishOptions.getCallback());
        return googleApiClient.zzb((zzzv.zza)new zza(this, googleApiClient){

            protected void zza(zzx zzx2) throws RemoteException {
                zzv zzv2 = zzv.zza(message);
                zzx2.zza((zzzv.zzb<Status>)this, zzv2, (zzaaz<PublishCallback>)zzaaz2, publishOptions);
            }
        });
    }

    @Override
    public PendingResult<Status> publish(GoogleApiClient googleApiClient, Message message) {
        return this.publish(googleApiClient, message, PublishOptions.DEFAULT);
    }

    @Override
    public PendingResult<Status> unpublish(GoogleApiClient googleApiClient, final Message message) {
        zzac.zzw((Object)((Object)message));
        return googleApiClient.zzb((zzzv.zza)new zza(this, googleApiClient){

            protected void zza(zzx zzx2) throws RemoteException {
                zzv zzv2 = zzv.zza(message);
                zzx2.zza((zzzv.zzb<Status>)this, zzv2);
            }
        });
    }

    @Override
    public PendingResult<Status> subscribe(GoogleApiClient googleApiClient, final MessageListener messageListener, final SubscribeOptions subscribeOptions) {
        zzac.zzw((Object)messageListener);
        zzac.zzw((Object)subscribeOptions);
        zzac.zzb((subscribeOptions.getStrategy().zzNf() == 0 ? 1 : 0) != 0, (Object)"Strategy.setBackgroundScanMode() is only supported by background subscribe (the version which takes a PendingIntent).");
        final zzaaz<MessageListener> zzaaz2 = ((zzx)googleApiClient.zza(zzahc)).zza(googleApiClient, messageListener);
        final zzaaz<SubscribeCallback> zzaaz3 = ((zzx)googleApiClient.zza(zzahc)).zza(googleApiClient, subscribeOptions.getCallback());
        return googleApiClient.zzb((zzzv.zza)new zza(this, googleApiClient){

            protected void zza(zzx zzx2) throws RemoteException {
                zzx2.zza((zzzv.zzb<Status>)this, (zzaaz<MessageListener>)zzaaz2, messageListener, (zzaaz<SubscribeCallback>)zzaaz3, subscribeOptions, null);
            }
        });
    }

    @Override
    public PendingResult<Status> subscribe(GoogleApiClient googleApiClient, MessageListener messageListener) {
        return this.subscribe(googleApiClient, messageListener, SubscribeOptions.DEFAULT);
    }

    @Override
    public PendingResult<Status> subscribe(GoogleApiClient googleApiClient, final PendingIntent pendingIntent, final SubscribeOptions subscribeOptions) {
        zzac.zzw((Object)pendingIntent);
        zzac.zzw((Object)subscribeOptions);
        final zzaaz<SubscribeCallback> zzaaz2 = ((zzx)googleApiClient.zza(zzahc)).zza(googleApiClient, subscribeOptions.getCallback());
        return googleApiClient.zzb((zzzv.zza)new zza(this, googleApiClient){

            protected void zza(zzx zzx2) throws RemoteException {
                zzx2.zza((zzzv.zzb<Status>)this, pendingIntent, (zzaaz<SubscribeCallback>)zzaaz2, subscribeOptions);
            }
        });
    }

    @Override
    public PendingResult<Status> subscribe(GoogleApiClient googleApiClient, PendingIntent pendingIntent) {
        return this.subscribe(googleApiClient, pendingIntent, SubscribeOptions.DEFAULT);
    }

    @Override
    public PendingResult<Status> unsubscribe(GoogleApiClient googleApiClient, final MessageListener messageListener) {
        zzac.zzw((Object)messageListener);
        return googleApiClient.zzb((zzzv.zza)new zza(this, googleApiClient){

            protected void zza(zzx zzx2) throws RemoteException {
                zzx2.zza((zzzv.zzb<Status>)this, messageListener);
            }
        });
    }

    @Override
    public PendingResult<Status> unsubscribe(GoogleApiClient googleApiClient, final PendingIntent pendingIntent) {
        zzac.zzw((Object)pendingIntent);
        return googleApiClient.zzb((zzzv.zza)new zza(this, googleApiClient){

            protected void zza(zzx zzx2) throws RemoteException {
                zzx2.zza((zzzv.zzb<Status>)this, pendingIntent);
            }
        });
    }

    @Override
    public void handleIntent(Intent intent, MessageListener messageListener) {
        zzy.zza(zzy.zzE(intent), messageListener);
    }

    static void zza(Iterable<Update> iterable, MessageListener messageListener) {
        for (Update update : iterable) {
            if (update.zzmj(1)) {
                messageListener.onFound(update.zzbyC);
            }
            if (update.zzmj(2)) {
                messageListener.onLost(update.zzbyC);
            }
            if (update.zzmj(4)) {
                messageListener.onDistanceChanged(update.zzbyC, update.zzbzj);
            }
            if (update.zzmj(8)) {
                messageListener.onBleSignalChanged(update.zzbyC, update.zzbzk);
            }
            if (!update.zzmj(16)) continue;
            Message cfr_ignored_0 = update.zzbyC;
            zzavp cfr_ignored_1 = update.zzbzl;
        }
    }

    private static List<Update> zzE(Intent intent) {
        return zzs.zzc(intent, "com.google.android.gms.nearby.messages.UPDATES");
    }

    @Override
    public PendingResult<Status> getPermissionStatus(GoogleApiClient googleApiClient) {
        return googleApiClient.zzb((zzzv.zza)new zza(this, googleApiClient){

            protected void zza(zzx zzx2) throws RemoteException {
                zzx2.zzt((zzzv.zzb<Status>)this);
            }
        });
    }

    @Override
    public PendingResult<Status> registerStatusCallback(GoogleApiClient googleApiClient, final StatusCallback statusCallback) {
        zzac.zzw((Object)statusCallback);
        final zzaaz<StatusCallback> zzaaz2 = ((zzx)googleApiClient.zza(zzahc)).zza(googleApiClient, statusCallback);
        return googleApiClient.zzb((zzzv.zza)new zza(this, googleApiClient){

            protected void zza(zzx zzx2) throws RemoteException {
                zzx2.zza((zzzv.zzb<Status>)this, (zzaaz<StatusCallback>)zzaaz2, statusCallback);
            }
        });
    }

    @Override
    public PendingResult<Status> unregisterStatusCallback(GoogleApiClient googleApiClient, final StatusCallback statusCallback) {
        return googleApiClient.zzb((zzzv.zza)new zza(this, googleApiClient){

            protected void zza(zzx zzx2) throws RemoteException {
                zzx2.zza((zzzv.zzb<Status>)this, statusCallback);
            }
        });
    }

    static abstract class zza
    extends zzzv.zza<Status, zzx> {
        public zza(GoogleApiClient googleApiClient) {
            super(Nearby.MESSAGES_API, googleApiClient);
        }

        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }
}

