/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.nearby.messages.zzd;
import java.util.ArrayList;

public class Strategy
extends zza {
    public static final Parcelable.Creator<Strategy> CREATOR = new zzd();
    public static final int DISCOVERY_MODE_BROADCAST = 1;
    public static final int DISCOVERY_MODE_SCAN = 2;
    public static final int DISCOVERY_MODE_DEFAULT = 3;
    public static final int DISTANCE_TYPE_DEFAULT = 0;
    public static final int DISTANCE_TYPE_EARSHOT = 1;
    public static final int TTL_SECONDS_DEFAULT = 300;
    public static final int TTL_SECONDS_MAX = 86400;
    public static final int TTL_SECONDS_INFINITE = Integer.MAX_VALUE;
    public static final Strategy DEFAULT = new Builder().build();
    public static final Strategy BLE_ONLY;
    @Deprecated
    public static final Strategy zzbzT;
    final int zzaiI;
    @Deprecated
    final int zzbzU;
    final int zzbzV;
    final int zzbzW;
    @Deprecated
    final boolean zzbzX;
    final int zzbzY;
    final int zzbzZ;
    private final int zzbAa;

    Strategy(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, int n7) {
        this.zzaiI = n;
        this.zzbzU = n2;
        if (n2 == 0) {
            this.zzbzZ = n6;
        } else {
            switch (n2) {
                case 2: {
                    this.zzbzZ = 1;
                    break;
                }
                case 3: {
                    this.zzbzZ = 2;
                    break;
                }
                default: {
                    this.zzbzZ = 3;
                }
            }
        }
        this.zzbzW = n4;
        this.zzbzX = bl;
        if (bl) {
            this.zzbzY = 2;
            this.zzbzV = Integer.MAX_VALUE;
        } else {
            this.zzbzV = n3;
            switch (n5) {
                case -1: 
                case 0: 
                case 1: 
                case 6: {
                    this.zzbzY = -1;
                    break;
                }
                default: {
                    this.zzbzY = n5;
                }
            }
        }
        this.zzbAa = n7;
    }

    public int zzOI() {
        return this.zzbzY;
    }

    public int zzOb() {
        return this.zzbzZ;
    }

    public int zzOJ() {
        return this.zzbAa;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzd.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Strategy)) {
            return false;
        }
        Strategy strategy = (Strategy)((Object)object);
        return this.zzaiI == strategy.zzaiI && this.zzbzZ == strategy.zzbzZ && this.zzbzV == strategy.zzbzV && this.zzbzW == strategy.zzbzW && this.zzbzY == strategy.zzbzY;
    }

    public int hashCode() {
        int n = this.zzaiI;
        n = 31 * n + this.zzbzZ;
        n = 31 * n + this.zzbzV;
        n = 31 * n + this.zzbzW;
        n = 31 * n + this.zzbzY;
        return n;
    }

    public String toString() {
        int n = this.zzbzV;
        String string = String.valueOf(Strategy.zzmy(this.zzbzW));
        String string2 = String.valueOf(Strategy.zzmz(this.zzbzY));
        String string3 = String.valueOf(Strategy.zzmA(this.zzbzZ));
        String string4 = String.valueOf(Strategy.zzmx(this.zzbAa));
        return new StringBuilder(102 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("Strategy{ttlSeconds=").append(n).append(", distanceType=").append(string).append(", discoveryMedium=").append(string2).append(", discoveryMode=").append(string3).append(", backgroundScanMode=").append(string4).append("}").toString();
    }

    private static String zzmx(int n) {
        switch (n) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "ALWAYS_ON";
            }
        }
        return new StringBuilder(20).append("UNKNOWN: ").append(n).toString();
    }

    private static String zzmy(int n) {
        switch (n) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "EARSHOT";
            }
        }
        return new StringBuilder(19).append("UNKNOWN:").append(n).toString();
    }

    private static String zzmz(int n) {
        if (n == -1) {
            return "DEFAULT";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((n & 4) > 0) {
            arrayList.add("ULTRASOUND");
        }
        if ((n & 2) > 0) {
            arrayList.add("BLE");
        }
        if (arrayList.isEmpty()) {
            return new StringBuilder(19).append("UNKNOWN:").append(n).toString();
        }
        return ((Object)arrayList).toString();
    }

    private static String zzmA(int n) {
        if (n == 3) {
            return "DEFAULT";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((n & 1) > 0) {
            arrayList.add("BROADCAST");
        }
        if ((n & 2) > 0) {
            arrayList.add("SCAN");
        }
        if (arrayList.isEmpty()) {
            return new StringBuilder(19).append("UNKNOWN:").append(n).toString();
        }
        return ((Object)arrayList).toString();
    }

    static {
        zzbzT = BLE_ONLY = new Builder().zzmB(2).setTtlSeconds(Integer.MAX_VALUE).build();
    }

    public static class Builder {
        private int zzbyp = 3;
        private int zzbAb = 300;
        private int zzbAc = 0;
        private int zzbAd = -1;
        private int zzbAe = 0;

        public Builder setDiscoveryMode(int n) {
            this.zzbyp = n;
            return this;
        }

        public Builder zzmB(int n) {
            this.zzbAd = n;
            return this;
        }

        public Builder setTtlSeconds(int n) {
            zzac.zzb((n == Integer.MAX_VALUE || n > 0 && n <= 86400 ? 1 : 0) != 0, (String)"mTtlSeconds(%d) must either be TTL_SECONDS_INFINITE, or it must be between 1 and TTL_SECONDS_MAX(%d) inclusive", (Object[])new Object[]{n, 86400});
            this.zzbAb = n;
            return this;
        }

        public Builder setDistanceType(int n) {
            this.zzbAc = n;
            return this;
        }

        public Strategy build() {
            if (this.zzbAd == 2 && this.zzbAc == 1) {
                throw new IllegalStateException("Cannot set EARSHOT with BLE only mode.");
            }
            return new Strategy(2, 0, this.zzbAb, this.zzbAc, false, this.zzbAd, this.zzbyp, 0);
        }
    }
}

