/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.nearby.messages.zzd;
import java.util.ArrayList;

public class Strategy
extends zza {
    public static final Parcelable.Creator<Strategy> CREATOR = new zzd();
    public static final int DISCOVERY_MODE_BROADCAST = 1;
    public static final int DISCOVERY_MODE_SCAN = 2;
    public static final int DISCOVERY_MODE_DEFAULT = 3;
    public static final int DISTANCE_TYPE_DEFAULT = 0;
    public static final int DISTANCE_TYPE_EARSHOT = 1;
    public static final int TTL_SECONDS_DEFAULT = 300;
    public static final int TTL_SECONDS_MAX = 86400;
    public static final int TTL_SECONDS_INFINITE = Integer.MAX_VALUE;
    public static final Strategy DEFAULT = new Builder().build();
    public static final Strategy BLE_ONLY;
    @Deprecated
    public static final Strategy zzbzP;
    final int zzaiI;
    @Deprecated
    final int zzbzQ;
    final int zzbzR;
    final int zzbzS;
    @Deprecated
    final boolean zzbzT;
    final int zzbzU;
    final int zzbzV;
    private final int zzbzW;

    Strategy(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, int n7) {
        this.zzaiI = n;
        this.zzbzQ = n2;
        if (n2 == 0) {
            this.zzbzV = n6;
        } else {
            switch (n2) {
                case 2: {
                    this.zzbzV = 1;
                    break;
                }
                case 3: {
                    this.zzbzV = 2;
                    break;
                }
                default: {
                    this.zzbzV = 3;
                }
            }
        }
        this.zzbzS = n4;
        this.zzbzT = bl;
        if (bl) {
            this.zzbzU = 2;
            this.zzbzR = Integer.MAX_VALUE;
        } else {
            this.zzbzR = n3;
            switch (n5) {
                case -1: 
                case 0: 
                case 1: 
                case 6: {
                    this.zzbzU = -1;
                    break;
                }
                default: {
                    this.zzbzU = n5;
                }
            }
        }
        this.zzbzW = n7;
    }

    public int zzOJ() {
        return this.zzbzU;
    }

    public int zzOc() {
        return this.zzbzV;
    }

    public int zzOK() {
        return this.zzbzW;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzd.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Strategy)) {
            return false;
        }
        Strategy strategy = (Strategy)((Object)object);
        return this.zzaiI == strategy.zzaiI && this.zzbzV == strategy.zzbzV && this.zzbzR == strategy.zzbzR && this.zzbzS == strategy.zzbzS && this.zzbzU == strategy.zzbzU;
    }

    public int hashCode() {
        int n = this.zzaiI;
        n = 31 * n + this.zzbzV;
        n = 31 * n + this.zzbzR;
        n = 31 * n + this.zzbzS;
        n = 31 * n + this.zzbzU;
        return n;
    }

    public String toString() {
        int n = this.zzbzR;
        String string = String.valueOf(Strategy.zzmy(this.zzbzS));
        String string2 = String.valueOf(Strategy.zzmz(this.zzbzU));
        String string3 = String.valueOf(Strategy.zzmA(this.zzbzV));
        String string4 = String.valueOf(Strategy.zzmx(this.zzbzW));
        return new StringBuilder(102 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("Strategy{ttlSeconds=").append(n).append(", distanceType=").append(string).append(", discoveryMedium=").append(string2).append(", discoveryMode=").append(string3).append(", backgroundScanMode=").append(string4).append("}").toString();
    }

    private static String zzmx(int n) {
        switch (n) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "ALWAYS_ON";
            }
        }
        return new StringBuilder(20).append("UNKNOWN: ").append(n).toString();
    }

    private static String zzmy(int n) {
        switch (n) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "EARSHOT";
            }
        }
        return new StringBuilder(19).append("UNKNOWN:").append(n).toString();
    }

    private static String zzmz(int n) {
        if (n == -1) {
            return "DEFAULT";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((n & 4) > 0) {
            arrayList.add("ULTRASOUND");
        }
        if ((n & 2) > 0) {
            arrayList.add("BLE");
        }
        if (arrayList.isEmpty()) {
            return new StringBuilder(19).append("UNKNOWN:").append(n).toString();
        }
        return ((Object)arrayList).toString();
    }

    private static String zzmA(int n) {
        if (n == 3) {
            return "DEFAULT";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((n & 1) > 0) {
            arrayList.add("BROADCAST");
        }
        if ((n & 2) > 0) {
            arrayList.add("SCAN");
        }
        if (arrayList.isEmpty()) {
            return new StringBuilder(19).append("UNKNOWN:").append(n).toString();
        }
        return ((Object)arrayList).toString();
    }

    static {
        zzbzP = BLE_ONLY = new Builder().zzmB(2).setTtlSeconds(Integer.MAX_VALUE).build();
    }

    public static class Builder {
        private int zzbyl = 3;
        private int zzbzX = 300;
        private int zzbzY = 0;
        private int zzbzZ = -1;
        private int zzbAa = 0;

        public Builder setDiscoveryMode(int n) {
            this.zzbyl = n;
            return this;
        }

        public Builder zzmB(int n) {
            this.zzbzZ = n;
            return this;
        }

        public Builder setTtlSeconds(int n) {
            zzac.zzb((n == Integer.MAX_VALUE || n > 0 && n <= 86400 ? 1 : 0) != 0, (String)"mTtlSeconds(%d) must either be TTL_SECONDS_INFINITE, or it must be between 1 and TTL_SECONDS_MAX(%d) inclusive", (Object[])new Object[]{n, 86400});
            this.zzbzX = n;
            return this;
        }

        public Builder setDistanceType(int n) {
            this.zzbzY = n;
            return this;
        }

        public Strategy build() {
            if (this.zzbzZ == 2 && this.zzbzY == 1) {
                throw new IllegalStateException("Cannot set EARSHOT with BLE only mode.");
            }
            return new Strategy(2, 0, this.zzbzX, this.zzbzY, false, this.zzbzZ, this.zzbyl, 0);
        }
    }
}

