/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.nearby.messages.Message;
import com.google.android.gms.nearby.messages.internal.zzc;
import com.google.android.gms.nearby.messages.internal.zzg;
import java.util.Arrays;

public class EddystoneUid {
    public static final int LENGTH = 16;
    public static final int NAMESPACE_LENGTH = 10;
    public static final int INSTANCE_LENGTH = 6;
    private final zzg zzbxV;

    private EddystoneUid(byte[] byArray) {
        byte[] byArray2 = byArray;
        zzbr.zzb((byArray.length == 16 ? 1 : 0) != 0, (Object)"Bytes must be a namespace plus instance (16 bytes).");
        this.zzbxV = new zzg(byArray2);
    }

    public EddystoneUid(String string) {
        this(zzc.zzeF(string));
    }

    public EddystoneUid(String string, String string2) {
        this.zzbxV = new zzg(string, string2);
    }

    public static EddystoneUid from(Message message) {
        String string = String.valueOf(message.getType());
        zzbr.zzb((boolean)message.zzeE("__eddystone_uid"), (Object)new StringBuilder(58 + String.valueOf(string).length()).append("Message type '").append(string).append("' is not Message.MESSAGE_TYPE_EDDYSTONE_UID.").toString());
        return new EddystoneUid(message.getContent());
    }

    public String getNamespace() {
        return zzc.zzp(Arrays.copyOfRange(this.zzbxV.getBytes(), 0, 10));
    }

    public String getInstance() {
        byte[] byArray = this.zzbxV.getBytes();
        if (byArray.length < 16) {
            return null;
        }
        return zzc.zzp(Arrays.copyOfRange(byArray, 10, 16));
    }

    public String getHex() {
        return this.zzbxV.getHex();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EddystoneUid)) {
            return false;
        }
        EddystoneUid eddystoneUid = (EddystoneUid)object;
        return zzbh.equal((Object)this.zzbxV, (Object)eddystoneUid.zzbxV);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzbxV});
    }

    public String toString() {
        String string = String.valueOf(this.getHex());
        return new StringBuilder(17 + String.valueOf(string).length()).append("EddystoneUid{id=").append(string).append("}").toString();
    }
}

