/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages.internal;

import android.app.PendingIntent;
import android.content.Intent;
import android.os.Bundle;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbfi;
import com.google.android.gms.internal.zzcqv;
import com.google.android.gms.nearby.messages.Message;
import com.google.android.gms.nearby.messages.MessageListener;
import com.google.android.gms.nearby.messages.Messages;
import com.google.android.gms.nearby.messages.MessagesOptions;
import com.google.android.gms.nearby.messages.PublishOptions;
import com.google.android.gms.nearby.messages.StatusCallback;
import com.google.android.gms.nearby.messages.SubscribeOptions;
import com.google.android.gms.nearby.messages.internal.Update;
import com.google.android.gms.nearby.messages.internal.zzah;
import com.google.android.gms.nearby.messages.internal.zzal;
import com.google.android.gms.nearby.messages.internal.zzam;
import com.google.android.gms.nearby.messages.internal.zzan;
import com.google.android.gms.nearby.messages.internal.zzao;
import com.google.android.gms.nearby.messages.internal.zzap;
import com.google.android.gms.nearby.messages.internal.zzaq;
import com.google.android.gms.nearby.messages.internal.zzar;
import com.google.android.gms.nearby.messages.internal.zzas;
import com.google.android.gms.nearby.messages.internal.zzat;
import com.google.android.gms.nearby.messages.internal.zzau;
import java.util.Collections;

public final class zzak
implements Messages {
    public static final zzak zzbzm = new zzak();
    public static final Api.zzf<zzah> zzajT = new Api.zzf();
    public static final Api.zza<zzah, MessagesOptions> zzajU = new zzal();

    private zzak() {
    }

    @Override
    public final PendingResult<Status> publish(GoogleApiClient googleApiClient, Message message, PublishOptions publishOptions) {
        zzbr.zzu((Object)((Object)message));
        zzbr.zzu((Object)publishOptions);
        zzbfi zzbfi2 = publishOptions.getCallback() == null ? null : googleApiClient.zzp((Object)publishOptions.getCallback());
        return googleApiClient.zze((zzbck)new zzan(this, googleApiClient, message, zzbfi2, publishOptions));
    }

    @Override
    public final PendingResult<Status> publish(GoogleApiClient googleApiClient, Message message) {
        return this.publish(googleApiClient, message, PublishOptions.DEFAULT);
    }

    @Override
    public final PendingResult<Status> unpublish(GoogleApiClient googleApiClient, Message message) {
        zzbr.zzu((Object)((Object)message));
        return googleApiClient.zze((zzbck)new zzao(this, googleApiClient, message));
    }

    @Override
    public final PendingResult<Status> subscribe(GoogleApiClient googleApiClient, MessageListener messageListener, SubscribeOptions subscribeOptions) {
        zzbr.zzu((Object)messageListener);
        zzbr.zzu((Object)subscribeOptions);
        zzbr.zzb((subscribeOptions.getStrategy().zzzS() == 0 ? 1 : 0) != 0, (Object)"Strategy.setBackgroundScanMode() is only supported by background subscribe (the version which takes a PendingIntent).");
        zzbfi<MessageListener> zzbfi2 = zzak.zzh(googleApiClient).zza(googleApiClient, messageListener);
        zzbfi zzbfi3 = subscribeOptions.getCallback() == null ? null : googleApiClient.zzp((Object)subscribeOptions.getCallback());
        return googleApiClient.zze((zzbck)new zzap(this, googleApiClient, zzbfi2, zzbfi3, subscribeOptions));
    }

    @Override
    public final PendingResult<Status> subscribe(GoogleApiClient googleApiClient, MessageListener messageListener) {
        return this.subscribe(googleApiClient, messageListener, SubscribeOptions.DEFAULT);
    }

    @Override
    public final PendingResult<Status> subscribe(GoogleApiClient googleApiClient, PendingIntent pendingIntent, SubscribeOptions subscribeOptions) {
        zzbr.zzu((Object)pendingIntent);
        zzbr.zzu((Object)subscribeOptions);
        zzbfi zzbfi2 = subscribeOptions.getCallback() == null ? null : googleApiClient.zzp((Object)subscribeOptions.getCallback());
        return googleApiClient.zze((zzbck)new zzaq(this, googleApiClient, pendingIntent, zzbfi2, subscribeOptions));
    }

    @Override
    public final PendingResult<Status> subscribe(GoogleApiClient googleApiClient, PendingIntent pendingIntent) {
        return this.subscribe(googleApiClient, pendingIntent, SubscribeOptions.DEFAULT);
    }

    @Override
    public final PendingResult<Status> unsubscribe(GoogleApiClient googleApiClient, MessageListener messageListener) {
        zzbr.zzu((Object)messageListener);
        zzbfi<MessageListener> zzbfi2 = zzak.zzh(googleApiClient).zza(messageListener);
        return googleApiClient.zze((zzbck)new zzar(this, googleApiClient, zzbfi2));
    }

    @Override
    public final PendingResult<Status> unsubscribe(GoogleApiClient googleApiClient, PendingIntent pendingIntent) {
        zzbr.zzu((Object)pendingIntent);
        return googleApiClient.zze((zzbck)new zzas(this, googleApiClient, pendingIntent));
    }

    @Override
    public final void handleIntent(Intent intent, MessageListener messageListener) {
        String string = "com.google.android.gms.nearby.messages.UPDATES";
        Bundle bundle = intent.getBundleExtra("com.google.android.gms.nearby.messages.UPDATES");
        zzak.zza(bundle == null ? Collections.emptyList() : bundle.getParcelableArrayList(string), messageListener);
    }

    public static void zza(Iterable<Update> iterable, MessageListener messageListener) {
        for (Update update : iterable) {
            if (update.zzbs(1)) {
                messageListener.onFound(update.zzbzh);
            }
            if (update.zzbs(2)) {
                messageListener.onLost(update.zzbzh);
            }
            if (update.zzbs(4)) {
                messageListener.onDistanceChanged(update.zzbzh, update.zzbzF);
            }
            if (update.zzbs(8)) {
                messageListener.onBleSignalChanged(update.zzbzh, update.zzbzG);
            }
            if (!update.zzbs(16)) continue;
            Message cfr_ignored_0 = update.zzbzh;
            zzcqv cfr_ignored_1 = update.zzbzH;
        }
    }

    @Override
    public final PendingResult<Status> getPermissionStatus(GoogleApiClient googleApiClient) {
        return googleApiClient.zze((zzbck)new zzat(this, googleApiClient));
    }

    @Override
    public final PendingResult<Status> registerStatusCallback(GoogleApiClient googleApiClient, StatusCallback statusCallback) {
        zzbr.zzu((Object)statusCallback);
        zzbfi<StatusCallback> zzbfi2 = zzak.zzh(googleApiClient).zza(googleApiClient, statusCallback);
        return googleApiClient.zze((zzbck)new zzau(this, googleApiClient, zzbfi2));
    }

    @Override
    public final PendingResult<Status> unregisterStatusCallback(GoogleApiClient googleApiClient, StatusCallback statusCallback) {
        zzbr.zzu((Object)statusCallback);
        zzbfi<StatusCallback> zzbfi2 = zzak.zzh(googleApiClient).zza(statusCallback);
        return googleApiClient.zze((zzbck)new zzam(this, googleApiClient, zzbfi2));
    }

    private static zzah zzh(GoogleApiClient googleApiClient) {
        return (zzah)googleApiClient.zza(zzajT);
    }
}

