/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.Service;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.internal.zzbaz;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzcpn;
import com.google.android.gms.internal.zzcpq;
import com.google.android.gms.internal.zzcpx;
import com.google.android.gms.internal.zzcpz;
import com.google.android.gms.nearby.messages.MessageListener;
import com.google.android.gms.nearby.messages.MessagesOptions;
import com.google.android.gms.nearby.messages.StatusCallback;
import com.google.android.gms.nearby.messages.SubscribeCallback;
import com.google.android.gms.nearby.messages.SubscribeOptions;
import com.google.android.gms.nearby.messages.internal.ClientAppContext;
import com.google.android.gms.nearby.messages.internal.SubscribeRequest;
import com.google.android.gms.nearby.messages.internal.zzaf;
import com.google.android.gms.nearby.messages.internal.zzaj;
import com.google.android.gms.nearby.messages.internal.zzaz;
import com.google.android.gms.nearby.messages.internal.zzbc;
import com.google.android.gms.nearby.messages.internal.zzbe;
import com.google.android.gms.nearby.messages.internal.zzj;
import com.google.android.gms.nearby.messages.internal.zzs;
import com.google.android.gms.nearby.messages.internal.zzt;

final class zzah
extends zzz<zzs> {
    private final zzcpz zzbze = new zzcpz();
    private final ClientAppContext zzbzf;
    private final int zzbyi;

    @TargetApi(value=14)
    zzah(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, zzq zzq2, MessagesOptions messagesOptions) {
        super(context, looper, 62, zzq2, connectionCallbacks, onConnectionFailedListener);
        int n;
        String string = zzq2.zzrq();
        Context context2 = context;
        int n2 = context2 instanceof Activity ? 1 : (context2 instanceof Application ? 2 : (n = context2 instanceof Service ? 3 : 0));
        if (messagesOptions != null) {
            this.zzbzf = new ClientAppContext(string, null, false, null, n);
            this.zzbyi = messagesOptions.zzbyg;
        } else {
            this.zzbzf = new ClientAppContext(string, null, false, null, n);
            this.zzbyi = -1;
        }
        if (n == 1) {
            Activity activity = (Activity)context;
            Log.v((String)"NearbyMessagesClient", (String)String.format("Registering ClientLifecycleSafetyNet's ActivityLifecycleCallbacks for %s", activity.getPackageName()));
            activity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzaj(activity, this, null));
        }
    }

    @NonNull
    protected final Bundle zzmo() {
        Bundle bundle = super.zzmo();
        bundle.putInt("NearbyPermissions", this.zzbyi);
        bundle.putParcelable("ClientAppContext", (Parcelable)this.zzbzf);
        return bundle;
    }

    @NonNull
    protected final String zzdb() {
        return "com.google.android.gms.nearby.messages.service.NearbyMessagesService.START";
    }

    @NonNull
    protected final String zzdc() {
        return "com.google.android.gms.nearby.messages.internal.INearbyMessagesService";
    }

    public final void disconnect() {
        try {
            this.zzbs(2);
        }
        catch (RemoteException remoteException) {
            Log.v((String)"NearbyMessagesClient", (String)String.format("Failed to emit CLIENT_DISCONNECTED from override of GmsClient#disconnect(): %s", new Object[]{remoteException}));
        }
        this.zzbze.clear();
        super.disconnect();
    }

    final void zza(zzbdw<zzbaz<Status>> zzbdw2, zzaf zzaf2) throws RemoteException {
        zzbc zzbc2 = new zzbc(zzaf2, new zzcpq(zzbdw2), this.zzbzf);
        ((zzs)this.zzrf()).zza(zzbc2);
    }

    final void zza(zzbdw<zzbaz<Status>> zzbdw2, zzbdw<MessageListener> zzbdw3, @Nullable zzbdw<SubscribeCallback> zzbdw4, SubscribeOptions subscribeOptions, @Nullable byte[] byArray) throws RemoteException {
        SubscribeRequest subscribeRequest = new SubscribeRequest(this.zzbze.zzh(zzbdw3), subscribeOptions.getStrategy(), new zzcpq(zzbdw2), subscribeOptions.getFilter(), null, null, zzbdw4 == null ? null : new zzcpx(zzbdw4), subscribeOptions.zzbyA);
        ((zzs)this.zzrf()).zza(subscribeRequest);
    }

    final void zza(zzbdw<zzbaz<Status>> zzbdw2, @Nullable zzbdw<MessageListener> zzbdw3) throws RemoteException {
        if (zzbdw3 == null) {
            return;
        }
        zzbe zzbe2 = new zzbe(this.zzbze.zzh(zzbdw3), new zzcpq(zzbdw2), null);
        ((zzs)this.zzrf()).zza(zzbe2);
        this.zzbze.zzi(zzbdw3);
    }

    final void zzb(zzbdw<zzbaz<Status>> zzbdw2, zzbdw<StatusCallback> zzbdw3) throws RemoteException {
        zzaz zzaz2 = new zzaz(new zzcpq(zzbdw2), this.zzbze.zzh(zzbdw3));
        new zzaz(new zzcpq(zzbdw2), this.zzbze.zzh(zzbdw3)).zzbzu = true;
        ((zzs)this.zzrf()).zza(zzaz2);
    }

    final void zzc(zzbdw<zzbaz<Status>> zzbdw2, @Nullable zzbdw<StatusCallback> zzbdw3) throws RemoteException {
        if (zzbdw3 == null) {
            return;
        }
        zzaz zzaz2 = new zzaz(new zzcpq(zzbdw2), this.zzbze.zzh(zzbdw3));
        new zzaz(new zzcpq(zzbdw2), this.zzbze.zzh(zzbdw3)).zzbzu = false;
        ((zzs)this.zzrf()).zza(zzaz2);
        this.zzbze.zzi(zzbdw3);
    }

    final void zzbs(int n) throws RemoteException {
        String string;
        switch (n) {
            case 1: {
                string = "ACTIVITY_STOPPED";
                break;
            }
            case 2: {
                string = "CLIENT_DISCONNECTED";
                break;
            }
            default: {
                Log.w((String)"NearbyMessagesClient", (String)String.format("Received unknown/unforeseen client lifecycle event %d, can't do anything with it.", n));
                return;
            }
        }
        if (this.isConnected()) {
            zzj zzj2 = new zzj(n);
            Log.d((String)"NearbyMessagesClient", (String)String.format("Emitting client lifecycle event %s", string));
            ((zzs)this.zzrf()).zza(zzj2);
            return;
        }
        Log.d((String)"NearbyMessagesClient", (String)String.format("Failed to emit client lifecycle event %s due to GmsClient being disconnected", string));
    }

    @Nullable
    final zzbdw<MessageListener> zza(GoogleApiClient googleApiClient, @Nullable MessageListener messageListener) {
        return this.zzbze.zzb(googleApiClient, messageListener).zzzX();
    }

    @Nullable
    final zzbdw<StatusCallback> zza(GoogleApiClient googleApiClient, @Nullable StatusCallback statusCallback) {
        return this.zzbze.zzb(googleApiClient, statusCallback).zzzX();
    }

    @Nullable
    final zzbdw<MessageListener> zza(@Nullable MessageListener messageListener) {
        zzcpn<MessageListener> zzcpn2 = this.zzbze.zzE(messageListener);
        if (zzcpn2 == null) {
            return null;
        }
        return zzcpn2.zzzX();
    }

    @Nullable
    final zzbdw<StatusCallback> zza(@Nullable StatusCallback statusCallback) {
        zzcpn<StatusCallback> zzcpn2 = this.zzbze.zzE(statusCallback);
        if (zzcpn2 == null) {
            return null;
        }
        return zzcpn2.zzzX();
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.nearby.messages.internal.INearbyMessagesService");
        if (iInterface instanceof zzs) {
            return (zzs)iInterface;
        }
        return new zzt(iBinder2);
    }
}

