/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.nearby.messages.Message;
import com.google.android.gms.nearby.messages.internal.zzl;
import java.util.Arrays;
import java.util.UUID;

public class IBeaconId {
    public static final int LENGTH = 20;
    private final zzl zzbxS;

    private IBeaconId(byte[] byArray) {
        byte[] byArray2 = byArray;
        zzbo.zzb((byArray.length == 20 ? 1 : 0) != 0, (Object)"iBeacon ID must be a UUID, a major, and a minor (20 total bytes).");
        this.zzbxS = new zzl(byArray2);
    }

    public IBeaconId(UUID uUID, short s, short s2) {
        this.zzbxS = new zzl(uUID, s, s2);
    }

    public static IBeaconId from(Message message) {
        String string = String.valueOf(message.getType());
        zzbo.zzb((boolean)message.zzeD("__i_beacon_id"), (Object)new StringBuilder(55 + String.valueOf(string).length()).append("Message type '").append(string).append("' is not Message.MESSAGE_TYPE_I_BEACON_ID").toString());
        return new IBeaconId(message.getContent());
    }

    public UUID getProximityUuid() {
        return this.zzbxS.getProximityUuid();
    }

    public short getMajor() {
        return this.zzbxS.zzzV();
    }

    public short getMinor() {
        return this.zzbxS.zzzW();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IBeaconId)) {
            return false;
        }
        IBeaconId iBeaconId = (IBeaconId)object;
        return zzbe.equal((Object)this.zzbxS, (Object)iBeaconId.zzbxS);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzbxS});
    }

    public String toString() {
        String string = String.valueOf(this.getProximityUuid());
        short s = this.getMajor();
        short s2 = this.getMinor();
        return new StringBuilder(53 + String.valueOf(string).length()).append("IBeaconId{proximityUuid=").append(string).append(", major=").append(s).append(", minor=").append(s2).append("}").toString();
    }
}

