/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.ParcelFileDescriptor;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.internal.zzckr;
import com.google.android.gms.nearby.connection.Payload;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public final class zzckt {
    static Pair<zzckr, Pair<ParcelFileDescriptor, ParcelFileDescriptor>> zza(Payload payload) throws IOException {
        switch (payload.getType()) {
            case 1: {
                return Pair.create((Object)((Object)new zzckr(payload.getId(), payload.getType(), payload.asBytes(), null, null, -1L, null)), null);
            }
            case 2: {
                String string = payload.asFile().asJavaFile() == null ? null : payload.asFile().asJavaFile().getAbsolutePath();
                return Pair.create((Object)((Object)new zzckr(payload.getId(), payload.getType(), null, payload.asFile().asParcelFileDescriptor(), string, payload.asFile().getSize(), null)), null);
            }
            case 3: {
                ParcelFileDescriptor[] parcelFileDescriptorArray;
                ParcelFileDescriptor[] parcelFileDescriptorArray2;
                try {
                    parcelFileDescriptorArray2 = ParcelFileDescriptor.createPipe();
                    parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
                }
                catch (IOException iOException) {
                    Log.e((String)"NearbyConnections", (String)String.format("Unable to create PFD pipe for streaming payload %d from client to service.", payload.getId()), (Throwable)iOException);
                    throw iOException;
                }
                return Pair.create((Object)((Object)new zzckr(payload.getId(), payload.getType(), null, parcelFileDescriptorArray2[0], null, -1L, parcelFileDescriptorArray[0])), (Object)Pair.create((Object)parcelFileDescriptorArray2[1], (Object)parcelFileDescriptorArray[1]));
            }
        }
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(String.format("Outgoing Payload %d has unknown type %d", payload.getId(), payload.getType()));
        Log.wtf((String)"NearbyConnections", (String)"Unknown payload type!", (Throwable)illegalArgumentException);
        throw illegalArgumentException;
    }

    static Payload zza(zzckr zzckr2) {
        long l = zzckr2.getId();
        switch (zzckr2.getType()) {
            case 1: {
                return Payload.zza(zzckr2.getBytes(), l);
            }
            case 2: {
                String string = zzckr2.zzbas();
                if (string != null) {
                    try {
                        return Payload.zza(Payload.File.zza(new File(string), zzckr2.zzbat()), l);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        String string2 = String.valueOf(string);
                        Log.w((String)"NearbyConnections", (String)(string2.length() != 0 ? "Failed to create Payload from ParcelablePayload: Java file not found at ".concat(string2) : new String("Failed to create Payload from ParcelablePayload: Java file not found at ")), (Throwable)fileNotFoundException);
                    }
                }
                return Payload.zza(Payload.File.zzb(zzckr2.zzbar()), l);
            }
            case 3: {
                return Payload.zza(Payload.Stream.zzc(zzckr2.zzbar()), l);
            }
        }
        Log.w((String)"NearbyConnections", (String)String.format("Incoming ParcelablePayload %d has unknown type %d", zzckr2.getId(), zzckr2.getType()));
        return null;
    }
}

