/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import com.google.android.gms.internal.zzcrr;
import com.google.android.gms.internal.zzcrv;
import com.google.android.gms.nearby.messages.internal.zzad;
import com.google.android.gms.nearby.messages.zzb;
import com.google.android.gms.nearby.messages.zzc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class MessageFilter
extends zzbej {
    public static final Parcelable.Creator<MessageFilter> CREATOR = new zzc();
    public static final MessageFilter INCLUDE_ALL_MY_TYPES = new Builder().includeAllMyTypes().build();
    private int zzdzm;
    private final List<zzad> zzjoq;
    private final List<zzcrv> zzjor;
    private final boolean zzjos;
    private final List<zzcrr> zzjot;
    private final int zzjou;

    MessageFilter(int n, List<zzad> list, List<zzcrv> list2, boolean bl, List<zzcrr> list3, int n2) {
        this.zzdzm = n;
        this.zzjoq = Collections.unmodifiableList((List)zzbq.checkNotNull(list));
        this.zzjos = bl;
        if (list2 == null) {
            list2 = Collections.emptyList();
        }
        this.zzjor = Collections.unmodifiableList(list2);
        if (list3 == null) {
            list3 = Collections.emptyList();
        }
        this.zzjot = Collections.unmodifiableList(list3);
        this.zzjou = n2;
    }

    private MessageFilter(List<zzad> list, List<zzcrv> list2, boolean bl, List<zzcrr> list3, int n) {
        this(2, list, list2, bl, list3, n);
    }

    public final List<zzad> zzbbm() {
        return this.zzjoq;
    }

    public final boolean zzbbn() {
        return this.zzjos;
    }

    final List<zzcrv> zzbbo() {
        return this.zzjor;
    }

    public final List<zzcrr> zzbbp() {
        return this.zzjot;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        MessageFilter messageFilter = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zzc((Parcel)parcel2, (int)1, messageFilter.zzjoq, (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)2, messageFilter.zzjor, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)3, (boolean)messageFilter.zzjos);
        zzbem.zzc((Parcel)parcel2, (int)4, messageFilter.zzjot, (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)5, (int)messageFilter.zzjou);
        zzbem.zzc((Parcel)parcel2, (int)1000, (int)messageFilter.zzdzm);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public String toString() {
        boolean bl = this.zzjos;
        String string = String.valueOf(this.zzjoq);
        return new StringBuilder(53 + String.valueOf(string).length()).append("MessageFilter{includeAllMyTypes=").append(bl).append(", messageTypes=").append(string).append("}").toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessageFilter)) {
            return false;
        }
        MessageFilter messageFilter = (MessageFilter)((Object)object);
        return this.zzjos == messageFilter.zzjos && zzbg.equal(this.zzjoq, messageFilter.zzjoq) && zzbg.equal(this.zzjor, messageFilter.zzjor) && zzbg.equal(this.zzjot, messageFilter.zzjot);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzjoq, this.zzjor, this.zzjos, this.zzjot});
    }

    /* synthetic */ MessageFilter(List list, List list2, boolean bl, List list3, int n, zzb zzb2) {
        this(list, list2, bl, list3, n);
    }

    public static final class Builder {
        private final Set<zzad> zzjov = new HashSet<zzad>();
        private final List<zzcrv> zzjor = new ArrayList<zzcrv>();
        private final Set<zzcrr> zzjow = new HashSet<zzcrr>();
        private boolean zzjos;
        private int zzjou = 0;

        public Builder() {
        }

        public final Builder includeAllMyTypes() {
            this.zzjos = true;
            return this;
        }

        public final Builder includeNamespacedType(String string, String string2) {
            zzbq.zzb((string != null && !string.isEmpty() && !string.contains("*") ? 1 : 0) != 0, (String)"namespace(%s) cannot be null, empty or contain (*).", (Object[])new Object[]{string});
            zzbq.zzb((string2 != null && !string2.contains("*") ? 1 : 0) != 0, (String)"type(%s) cannot be null or contain (*).", (Object[])new Object[]{string2});
            return this.zzat(string, string2);
        }

        public final Builder includeFilter(MessageFilter messageFilter) {
            this.zzjov.addAll(messageFilter.zzbbm());
            this.zzjor.addAll(messageFilter.zzbbo());
            this.zzjow.addAll(messageFilter.zzbbp());
            this.zzjos |= messageFilter.zzbbn();
            return this;
        }

        public final Builder includeEddystoneUids(String string, @Nullable String string2) {
            this.zzat("__reserved_namespace", "__eddystone_uid");
            this.zzjor.add(zzcrv.zzau(string, string2));
            return this;
        }

        public final Builder includeIBeaconIds(UUID uUID, @Nullable Short s, @Nullable Short s2) {
            this.zzat("__reserved_namespace", "__i_beacon_id");
            this.zzjor.add(zzcrv.zza(uUID, s, s2));
            return this;
        }

        public final Builder includeAudioBytes(int n) {
            zzbq.checkArgument((this.zzjou == 0 ? 1 : 0) != 0, (Object)"includeAudioBytes() can only be called once per MessageFilter instance.");
            zzbq.checkArgument((n > 0 ? 1 : 0) != 0, (Object)new StringBuilder(44).append("Invalid value for numAudioBytes: ").append(n).toString());
            zzbq.checkArgument((n <= 10 ? 1 : 0) != 0, (Object)"numAudioBytes is capped by AudioBytes.MAX_SIZE = 10");
            this.zzat("__reserved_namespace", "__audio_bytes");
            this.zzjou = n;
            return this;
        }

        private final Builder zzat(String string, String string2) {
            this.zzjov.add(new zzad(string, string2));
            return this;
        }

        public final MessageFilter build() {
            zzbq.zza((this.zzjos || !this.zzjov.isEmpty() ? 1 : 0) != 0, (Object)"At least one of the include methods must be called.");
            return new MessageFilter(new ArrayList<zzad>(this.zzjov), this.zzjor, this.zzjos, new ArrayList<zzcrr>(this.zzjow), this.zzjou, null);
        }
    }
}

