/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzci;
import com.google.android.gms.common.api.internal.zzn;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.internal.zzcmn;
import com.google.android.gms.internal.zzcmp;
import com.google.android.gms.internal.zzcmr;
import com.google.android.gms.internal.zzcmv;
import com.google.android.gms.internal.zzcng;
import com.google.android.gms.internal.zzcnr;
import com.google.android.gms.internal.zzcnu;
import com.google.android.gms.internal.zzcnw;
import com.google.android.gms.internal.zzcpt;
import com.google.android.gms.internal.zzcqm;
import com.google.android.gms.internal.zzcqn;
import com.google.android.gms.internal.zzcrx;
import com.google.android.gms.internal.zzcrz;
import com.google.android.gms.internal.zzcsb;
import com.google.android.gms.internal.zzcse;
import com.google.android.gms.internal.zzcsg;
import com.google.android.gms.internal.zzcsi;
import com.google.android.gms.internal.zzcsk;
import com.google.android.gms.internal.zzcsm;
import com.google.android.gms.internal.zzcso;
import com.google.android.gms.internal.zzcsq;
import com.google.android.gms.internal.zzcss;
import com.google.android.gms.internal.zzev;
import com.google.android.gms.nearby.connection.AdvertisingOptions;
import com.google.android.gms.nearby.connection.ConnectionLifecycleCallback;
import com.google.android.gms.nearby.connection.Connections;
import com.google.android.gms.nearby.connection.ConnectionsStatusCodes;
import com.google.android.gms.nearby.connection.DiscoveryOptions;
import com.google.android.gms.nearby.connection.EndpointDiscoveryCallback;
import com.google.android.gms.nearby.connection.Payload;
import com.google.android.gms.nearby.connection.PayloadCallback;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class zzcmt
extends zzab<zzcqm> {
    private final long zzjnw;
    private final Set<zzcng> zzjnx = new HashSet<zzcng>();
    private final Set<zzcmv> zzjny = new HashSet<zzcmv>();
    private zzcrx zzjnz;

    public zzcmt(Context context, Looper looper, zzr zzr2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 54, zzr2, connectionCallbacks, onConnectionFailedListener);
        this.zzjnw = ((Object)((Object)this)).hashCode();
    }

    protected final Bundle zzaap() {
        Bundle bundle = new Bundle();
        bundle.putLong("clientId", this.zzjnw);
        return bundle;
    }

    protected final String zzhi() {
        return "com.google.android.gms.nearby.connection.service.START";
    }

    protected final String zzhj() {
        return "com.google.android.gms.nearby.internal.connection.INearbyConnectionService";
    }

    public final void disconnect() {
        if (this.isConnected()) {
            try {
                ((zzcqm)this.zzakn()).zza(new zzcmr());
            }
            catch (RemoteException remoteException) {
                Log.w((String)"NearbyConnectionsClient", (String)"Failed to notify client disconnect.", (Throwable)remoteException);
            }
        }
        this.reset();
        super.disconnect();
    }

    public final void onConnectionSuspended(int n) {
        if (n == 1) {
            this.reset();
        }
        super.onConnectionSuspended(n);
    }

    private final void reset() {
        Iterator<zzev> iterator = this.zzjnx.iterator();
        while (iterator.hasNext()) {
            iterator.next().shutdown();
        }
        iterator = this.zzjny.iterator();
        while (iterator.hasNext()) {
            ((zzcmv)iterator.next()).shutdown();
        }
        this.zzjnx.clear();
        this.zzjny.clear();
        if (this.zzjnz != null) {
            this.zzjnz.shutdown();
            this.zzjnz = null;
        }
    }

    public final void zza(zzn<Connections.StartAdvertisingResult> zzn2, String string, String string2, zzci<ConnectionLifecycleCallback> zzci2, AdvertisingOptions advertisingOptions) throws RemoteException {
        zzcmv zzcmv2 = new zzcmv(zzci2);
        this.zzjny.add(zzcmv2);
        ((zzcqm)this.zzakn()).zza(new zzcsk(new zzcnw(zzn2).asBinder(), null, string, string2, 0L, advertisingOptions, zzcmv2.asBinder()));
    }

    public final void stopAdvertising() throws RemoteException {
        ((zzcqm)this.zzakn()).zza(new zzcso());
    }

    public final void zza(zzn<Status> zzn2, String string, zzci<EndpointDiscoveryCallback> zzci2, DiscoveryOptions discoveryOptions) throws RemoteException {
        zzcng zzcng2 = new zzcng(zzci2);
        this.zzjnx.add(zzcng2);
        ((zzcqm)this.zzakn()).zza(new zzcsm(new zzcnu(zzn2).asBinder(), null, string, 0L, discoveryOptions, zzcng2.asBinder()));
    }

    public final void stopDiscovery() throws RemoteException {
        ((zzcqm)this.zzakn()).zza(new zzcss());
    }

    public final void zza(zzn<Status> zzn2, @Nullable String string, String string2, zzci<ConnectionLifecycleCallback> zzci2) throws RemoteException {
        zzcmv zzcmv2 = new zzcmv(zzci2);
        this.zzjny.add(zzcmv2);
        ((zzcqm)this.zzakn()).zza(new zzcsg(new zzcnu(zzn2).asBinder(), null, null, string, string2, null, zzcmv2.asBinder()));
    }

    public final void zza(zzn<Status> zzn2, String string, zzci<PayloadCallback> zzci2) throws RemoteException {
        ((zzcqm)this.zzakn()).zza(new zzcmn(new zzcnu(zzn2).asBinder(), null, string, null, new zzcnr(zzci2).asBinder()));
    }

    public final void zzj(zzn<Status> zzn2, String string) throws RemoteException {
        ((zzcqm)this.zzakn()).zza(new zzcse(new zzcnu(zzn2).asBinder(), string));
    }

    public final void zza(zzn<Status> zzn2, String[] stringArray, Payload payload, boolean bl) throws RemoteException {
        Pair<zzcrz, Pair<ParcelFileDescriptor, ParcelFileDescriptor>> pair;
        try {
            pair = zzcsb.zza(payload);
        }
        catch (IOException iOException) {
            zzn2.setResult((Object)zzcmt.zzcn(8013));
            return;
        }
        ((zzcqm)this.zzakn()).zza(new zzcsi(new zzcnu(zzn2).asBinder(), stringArray, (zzcrz)((Object)pair.first), bl));
        if (pair.second != null) {
            Pair pair2 = (Pair)pair.second;
            this.zzjnz.zza(payload.asStream().asInputStream(), (OutputStream)new ParcelFileDescriptor.AutoCloseOutputStream((ParcelFileDescriptor)pair2.first), (OutputStream)new ParcelFileDescriptor.AutoCloseOutputStream((ParcelFileDescriptor)pair2.second), payload.getId());
        }
    }

    public final void zza(zzn<Status> zzn2, long l) throws RemoteException {
        ((zzcqm)this.zzakn()).zza(new zzcmp(new zzcnu(zzn2).asBinder(), l));
    }

    public final void disconnectFromEndpoint(String string) throws RemoteException {
        ((zzcqm)this.zzakn()).zza(new zzcpt(string));
    }

    public final void stopAllEndpoints() throws RemoteException {
        ((zzcqm)this.zzakn()).zza(new zzcsq());
    }

    private static Status zzcn(int n) {
        return new Status(n, ConnectionsStatusCodes.getStatusCodeString(n));
    }

    protected final /* synthetic */ void zza(@NonNull IInterface iInterface) {
        zzcqm zzcqm2 = (zzcqm)iInterface;
        zzcmt zzcmt2 = this;
        super.zza((IInterface)zzcqm2);
        zzcmt2.zzjnz = new zzcrx();
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.nearby.internal.connection.INearbyConnectionService");
        if (iInterface instanceof zzcqm) {
            return (zzcqm)iInterface;
        }
        return new zzcqn(iBinder2);
    }

    static /* synthetic */ Status zzec(int n) {
        return zzcmt.zzcn(n);
    }
}

