/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import com.google.android.gms.nearby.messages.zzg;
import java.util.ArrayList;

public class Strategy
extends zzbfm {
    public static final Parcelable.Creator<Strategy> CREATOR = new zzg();
    public static final int DISCOVERY_MODE_BROADCAST = 1;
    public static final int DISCOVERY_MODE_SCAN = 2;
    public static final int DISCOVERY_MODE_DEFAULT = 3;
    public static final int DISTANCE_TYPE_DEFAULT = 0;
    public static final int DISTANCE_TYPE_EARSHOT = 1;
    public static final int TTL_SECONDS_DEFAULT = 300;
    public static final int TTL_SECONDS_MAX = 86400;
    public static final int TTL_SECONDS_INFINITE = Integer.MAX_VALUE;
    public static final Strategy DEFAULT = new Builder().build();
    public static final Strategy BLE_ONLY;
    @Deprecated
    private static Strategy zzjrx;
    private int zzeck;
    @Deprecated
    private int zzjry;
    private int zzjrz;
    private int zzjsa;
    @Deprecated
    private boolean zzjsb;
    private int zzjsc;
    private int zzjsd;
    private final int zzjse;

    Strategy(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, int n7) {
        this.zzeck = n;
        this.zzjry = n2;
        if (n2 == 0) {
            this.zzjsd = n6;
        } else {
            switch (n2) {
                case 2: {
                    this.zzjsd = 1;
                    break;
                }
                case 3: {
                    this.zzjsd = 2;
                    break;
                }
                default: {
                    this.zzjsd = 3;
                }
            }
        }
        this.zzjsa = n4;
        this.zzjsb = bl;
        if (bl) {
            this.zzjsc = 2;
            this.zzjrz = Integer.MAX_VALUE;
        } else {
            this.zzjrz = n3;
            switch (n5) {
                case -1: 
                case 0: 
                case 1: 
                case 6: {
                    this.zzjsc = -1;
                    break;
                }
                default: {
                    this.zzjsc = n5;
                }
            }
        }
        this.zzjse = n7;
    }

    public final int zzbcc() {
        return this.zzjse;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Strategy strategy = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zzc((Parcel)parcel2, (int)1, (int)strategy.zzjry);
        zzbfp.zzc((Parcel)parcel2, (int)2, (int)strategy.zzjrz);
        zzbfp.zzc((Parcel)parcel2, (int)3, (int)strategy.zzjsa);
        zzbfp.zza((Parcel)parcel2, (int)4, (boolean)strategy.zzjsb);
        zzbfp.zzc((Parcel)parcel2, (int)5, (int)strategy.zzjsc);
        zzbfp.zzc((Parcel)parcel2, (int)6, (int)strategy.zzjsd);
        zzbfp.zzc((Parcel)parcel2, (int)7, (int)strategy.zzjse);
        zzbfp.zzc((Parcel)parcel2, (int)1000, (int)strategy.zzeck);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Strategy)) {
            return false;
        }
        Strategy strategy = (Strategy)((Object)object);
        return this.zzeck == strategy.zzeck && this.zzjsd == strategy.zzjsd && this.zzjrz == strategy.zzjrz && this.zzjsa == strategy.zzjsa && this.zzjsc == strategy.zzjsc && this.zzjse == strategy.zzjse;
    }

    public int hashCode() {
        int n = this.zzeck;
        n = n * 31 + this.zzjsd;
        n = n * 31 + this.zzjrz;
        n = n * 31 + this.zzjsa;
        n = n * 31 + this.zzjsc;
        return n * 31 + this.zzjse;
    }

    public String toString() {
        String string;
        String string2;
        ArrayList<String> arrayList;
        String string3;
        String string4;
        int n = this.zzjrz;
        int n2 = this.zzjsa;
        switch (n2) {
            case 0: {
                string4 = "DEFAULT";
                break;
            }
            case 1: {
                string4 = "EARSHOT";
                break;
            }
            default: {
                string4 = new StringBuilder(19).append("UNKNOWN:").append(n2).toString();
            }
        }
        String string5 = string4;
        n2 = this.zzjsc;
        if (n2 == -1) {
            string3 = "DEFAULT";
        } else {
            arrayList = new ArrayList<String>();
            if ((n2 & 4) > 0) {
                arrayList.add("ULTRASOUND");
            }
            if ((n2 & 2) > 0) {
                arrayList.add("BLE");
            }
            string3 = arrayList.isEmpty() ? new StringBuilder(19).append("UNKNOWN:").append(n2).toString() : ((Object)arrayList).toString();
        }
        String string6 = string3;
        n2 = this.zzjsd;
        if (n2 == 3) {
            string2 = "DEFAULT";
        } else {
            arrayList = new ArrayList();
            if ((n2 & 1) > 0) {
                arrayList.add("BROADCAST");
            }
            if ((n2 & 2) > 0) {
                arrayList.add("SCAN");
            }
            string2 = arrayList.isEmpty() ? new StringBuilder(19).append("UNKNOWN:").append(n2).toString() : ((Object)arrayList).toString();
        }
        String string7 = string2;
        n2 = this.zzjse;
        switch (n2) {
            case 0: {
                string = "DEFAULT";
                break;
            }
            case 1: {
                string = "ALWAYS_ON";
                break;
            }
            default: {
                string = new StringBuilder(20).append("UNKNOWN: ").append(n2).toString();
            }
        }
        String string8 = string;
        return new StringBuilder(102 + String.valueOf(string5).length() + String.valueOf(string6).length() + String.valueOf(string7).length() + String.valueOf(string8).length()).append("Strategy{ttlSeconds=").append(n).append(", distanceType=").append(string5).append(", discoveryMedium=").append(string6).append(", discoveryMode=").append(string7).append(", backgroundScanMode=").append(string8).append("}").toString();
    }

    static {
        zzjrx = BLE_ONLY = new Builder().zzee(2).setTtlSeconds(Integer.MAX_VALUE).build();
    }

    public static class Builder {
        private int zzjsf = 3;
        private int zzjsg = 300;
        private int zzjsh = 0;
        private int zzjsi = -1;
        private int zzjsj = 0;

        public Builder() {
        }

        public Builder setDiscoveryMode(int n) {
            this.zzjsf = n;
            return this;
        }

        public final Builder zzee(int n) {
            this.zzjsi = 2;
            return this;
        }

        public Builder setTtlSeconds(int n) {
            zzbq.zzb((n == Integer.MAX_VALUE || n > 0 && n <= 86400 ? 1 : 0) != 0, (String)"mTtlSeconds(%d) must either be TTL_SECONDS_INFINITE, or it must be between 1 and TTL_SECONDS_MAX(%d) inclusive", (Object[])new Object[]{n, 86400});
            this.zzjsg = n;
            return this;
        }

        public Builder setDistanceType(int n) {
            this.zzjsh = n;
            return this;
        }

        public Strategy build() {
            if (this.zzjsi == 2 && this.zzjsh == 1) {
                throw new IllegalStateException("Cannot set EARSHOT with BLE only mode.");
            }
            return new Strategy(2, 0, this.zzjsg, this.zzjsh, false, this.zzjsi, this.zzjsf, 0);
        }
    }
}

