/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzcuu;
import com.google.android.gms.internal.zzcuz;
import com.google.android.gms.nearby.messages.internal.zzad;
import com.google.android.gms.nearby.messages.zzb;
import com.google.android.gms.nearby.messages.zzc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class MessageFilter
extends zzbgl {
    public static final Parcelable.Creator<MessageFilter> CREATOR = new zzc();
    public static final MessageFilter INCLUDE_ALL_MY_TYPES = new Builder().includeAllMyTypes().build();
    private int zza;
    private final List<zzad> zzb;
    private final List<zzcuz> zzc;
    private final boolean zzd;
    private final List<zzcuu> zze;
    private final int zzf;

    MessageFilter(int n, List<zzad> list, List<zzcuz> list2, boolean bl, List<zzcuu> list3, int n2) {
        this.zza = n;
        this.zzb = Collections.unmodifiableList((List)zzbq.zza(list));
        this.zzd = bl;
        if (list2 == null) {
            list2 = Collections.emptyList();
        }
        this.zzc = Collections.unmodifiableList(list2);
        if (list3 == null) {
            list3 = Collections.emptyList();
        }
        this.zze = Collections.unmodifiableList(list3);
        this.zzf = n2;
    }

    private MessageFilter(List<zzad> list, List<zzcuz> list2, boolean bl, List<zzcuu> list3, int n) {
        this(2, list, list2, bl, list3, n);
    }

    @Hide
    public final List<zzad> zza() {
        return this.zzb;
    }

    @Hide
    public final boolean zzb() {
        return this.zzd;
    }

    @Hide
    final List<zzcuz> zzc() {
        return this.zzc;
    }

    @Hide
    public final List<zzcuu> zzd() {
        return this.zze;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        MessageFilter messageFilter = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zzc((Parcel)parcel2, (int)1, messageFilter.zzb, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)2, messageFilter.zzc, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (boolean)messageFilter.zzd);
        zzbgo.zzc((Parcel)parcel2, (int)4, messageFilter.zze, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (int)messageFilter.zzf);
        zzbgo.zza((Parcel)parcel2, (int)1000, (int)messageFilter.zza);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public String toString() {
        boolean bl = this.zzd;
        String string = String.valueOf(this.zzb);
        return new StringBuilder(53 + String.valueOf(string).length()).append("MessageFilter{includeAllMyTypes=").append(bl).append(", messageTypes=").append(string).append("}").toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessageFilter)) {
            return false;
        }
        MessageFilter messageFilter = (MessageFilter)((Object)object);
        return this.zzd == messageFilter.zzd && zzbg.zza(this.zzb, messageFilter.zzb) && zzbg.zza(this.zzc, messageFilter.zzc) && zzbg.zza(this.zze, messageFilter.zze);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzb, this.zzc, this.zzd, this.zze});
    }

    /* synthetic */ MessageFilter(List list, List list2, boolean bl, List list3, int n, zzb zzb2) {
        this(list, list2, bl, list3, n);
    }

    public static final class Builder {
        private final Set<zzad> zza = new HashSet<zzad>();
        private final List<zzcuz> zzb = new ArrayList<zzcuz>();
        private final Set<zzcuu> zzc = new HashSet<zzcuu>();
        private boolean zzd;
        private int zze = 0;

        public Builder() {
        }

        public final Builder includeAllMyTypes() {
            this.zzd = true;
            return this;
        }

        public final Builder includeNamespacedType(String string, String string2) {
            zzbq.zzb((string != null && !string.isEmpty() && !string.contains("*") ? 1 : 0) != 0, (String)"namespace(%s) cannot be null, empty or contain (*).", (Object[])new Object[]{string});
            zzbq.zzb((string2 != null && !string2.contains("*") ? 1 : 0) != 0, (String)"type(%s) cannot be null or contain (*).", (Object[])new Object[]{string2});
            return this.zza(string, string2);
        }

        public final Builder includeFilter(MessageFilter messageFilter) {
            this.zza.addAll(messageFilter.zza());
            this.zzb.addAll(messageFilter.zzc());
            this.zzc.addAll(messageFilter.zzd());
            this.zzd |= messageFilter.zzb();
            return this;
        }

        public final Builder includeEddystoneUids(String string, @Nullable String string2) {
            this.zza("__reserved_namespace", "__eddystone_uid");
            this.zzb.add(zzcuz.zza(string, string2));
            return this;
        }

        public final Builder includeIBeaconIds(UUID uUID, @Nullable Short s, @Nullable Short s2) {
            this.zza("__reserved_namespace", "__i_beacon_id");
            this.zzb.add(zzcuz.zza(uUID, s, s2));
            return this;
        }

        public final Builder includeAudioBytes(int n) {
            zzbq.zzb((this.zze == 0 ? 1 : 0) != 0, (Object)"includeAudioBytes() can only be called once per MessageFilter instance.");
            zzbq.zzb((n > 0 ? 1 : 0) != 0, (Object)new StringBuilder(44).append("Invalid value for numAudioBytes: ").append(n).toString());
            zzbq.zzb((n <= 10 ? 1 : 0) != 0, (Object)"numAudioBytes is capped by AudioBytes.MAX_SIZE = 10");
            this.zza("__reserved_namespace", "__audio_bytes");
            this.zze = n;
            return this;
        }

        private final Builder zza(String string, String string2) {
            this.zza.add(new zzad(string, string2));
            return this;
        }

        public final MessageFilter build() {
            zzbq.zza((this.zzd || !this.zza.isEmpty() ? 1 : 0) != 0, (Object)"At least one of the include methods must be called.");
            return new MessageFilter(new ArrayList<zzad>(this.zza), this.zzb, this.zzd, new ArrayList<zzcuu>(this.zzc), this.zze, null);
        }
    }
}

