/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzci;
import com.google.android.gms.common.api.internal.zzck;
import com.google.android.gms.common.api.internal.zzn;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.internal.zzcvb;
import com.google.android.gms.internal.zzcvd;
import com.google.android.gms.internal.zzcvg;
import com.google.android.gms.internal.zzcvi;
import com.google.android.gms.nearby.messages.MessageListener;
import com.google.android.gms.nearby.messages.MessagesOptions;
import com.google.android.gms.nearby.messages.PublishOptions;
import com.google.android.gms.nearby.messages.StatusCallback;
import com.google.android.gms.nearby.messages.SubscribeOptions;
import com.google.android.gms.nearby.messages.internal.ClientAppContext;
import com.google.android.gms.nearby.messages.internal.SubscribeRequest;
import com.google.android.gms.nearby.messages.internal.zzab;
import com.google.android.gms.nearby.messages.internal.zzaf;
import com.google.android.gms.nearby.messages.internal.zzaj;
import com.google.android.gms.nearby.messages.internal.zzbz;
import com.google.android.gms.nearby.messages.internal.zzcb;
import com.google.android.gms.nearby.messages.internal.zzce;
import com.google.android.gms.nearby.messages.internal.zzcg;
import com.google.android.gms.nearby.messages.internal.zzj;
import com.google.android.gms.nearby.messages.internal.zzs;
import com.google.android.gms.nearby.messages.internal.zzt;
import com.google.android.gms.nearby.messages.internal.zzv;

public final class zzah
extends com.google.android.gms.common.internal.zzab<zzs> {
    private final zzcvi<zzck, IBinder> zzkdb = new zzcvi();
    private final ClientAppContext zzkdc;
    private final int zzkaz;

    static int zzee(Context context) {
        if (context instanceof Activity) {
            return 1;
        }
        if (context instanceof Application) {
            return 2;
        }
        if (context instanceof Service) {
            return 3;
        }
        return 0;
    }

    @TargetApi(value=14)
    zzah(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, zzr zzr2, MessagesOptions messagesOptions) {
        super(context, looper, 62, zzr2, connectionCallbacks, onConnectionFailedListener);
        String string = zzr2.zzami();
        int n = zzah.zzee(context);
        if (messagesOptions != null) {
            this.zzkdc = new ClientAppContext(string, null, false, null, n);
            this.zzkaz = messagesOptions.zzkax;
        } else {
            this.zzkdc = new ClientAppContext(string, null, false, null, n);
            this.zzkaz = -1;
        }
        if (n == 1) {
            Activity activity = (Activity)context;
            if (Log.isLoggable((String)"NearbyMessagesClient", (int)2)) {
                Log.v((String)"NearbyMessagesClient", (String)String.format("Registering ClientLifecycleSafetyNet's ActivityLifecycleCallbacks for %s", activity.getPackageName()));
            }
            activity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzaj(activity, this, null));
        }
    }

    @NonNull
    protected final Bundle zzabt() {
        Bundle bundle = super.zzabt();
        bundle.putInt("NearbyPermissions", this.zzkaz);
        bundle.putParcelable("ClientAppContext", (Parcelable)this.zzkdc);
        return bundle;
    }

    @NonNull
    protected final String zzhm() {
        return "com.google.android.gms.nearby.messages.service.NearbyMessagesService.START";
    }

    @NonNull
    protected final String zzhn() {
        return "com.google.android.gms.nearby.messages.internal.INearbyMessagesService";
    }

    public final void disconnect() {
        block2: {
            try {
                this.zzet(2);
            }
            catch (RemoteException remoteException) {
                if (!Log.isLoggable((String)"NearbyMessagesClient", (int)2)) break block2;
                Log.v((String)"NearbyMessagesClient", (String)String.format("Failed to emit CLIENT_DISCONNECTED from override of GmsClient#disconnect(): %s", new Object[]{remoteException}));
            }
        }
        this.zzkdb.clear();
        super.disconnect();
    }

    final void zza(zzci<zzn<Status>> zzci2, zzaf zzaf2, @Nullable zzv zzv2, PublishOptions publishOptions, int n) throws RemoteException {
        zzbz zzbz2 = new zzbz(zzaf2, publishOptions.getStrategy(), (IBinder)new zzcvd(zzci2), (IBinder)zzv2, n);
        ((zzs)this.zzalw()).zza(zzbz2);
    }

    @Deprecated
    final void zza(zzci<zzn<Status>> zzci2, zzaf zzaf2, @Nullable zzv zzv2, PublishOptions publishOptions) throws RemoteException {
        this.zza(zzci2, zzaf2, zzv2, publishOptions, this.zzkdc.zzkcv);
    }

    final void zza(zzci<zzn<Status>> zzci2, zzaf zzaf2) throws RemoteException {
        zzce zzce2 = new zzce(zzaf2, (IBinder)new zzcvd(zzci2));
        ((zzs)this.zzalw()).zza(zzce2);
    }

    final void zza(zzci<zzn<Status>> zzci2, zzci<MessageListener> zzci3, @Nullable zzab zzab2, SubscribeOptions subscribeOptions, @Nullable byte[] byArray, int n) throws RemoteException {
        if (!this.zzkdb.containsKey(zzci3.zzakx())) {
            this.zzkdb.zzf(zzci3.zzakx(), (IBinder)new zzcvb(zzci3));
        }
        SubscribeRequest subscribeRequest = new SubscribeRequest(this.zzkdb.get(zzci3.zzakx()), subscribeOptions.getStrategy(), (IBinder)new zzcvd(zzci2), subscribeOptions.getFilter(), null, null, (IBinder)zzab2, subscribeOptions.zzkbr, n);
        ((zzs)this.zzalw()).zza(subscribeRequest);
    }

    @Deprecated
    final void zza(zzci<zzn<Status>> zzci2, zzci<MessageListener> zzci3, @Nullable zzab zzab2, SubscribeOptions subscribeOptions, @Nullable byte[] byArray) throws RemoteException {
        this.zza(zzci2, zzci3, zzab2, subscribeOptions, null, this.zzkdc.zzkcv);
    }

    final void zza(zzci<zzn<Status>> zzci2, PendingIntent pendingIntent, @Nullable zzab zzab2, SubscribeOptions subscribeOptions, int n) throws RemoteException {
        SubscribeRequest subscribeRequest = new SubscribeRequest(null, subscribeOptions.getStrategy(), (IBinder)new zzcvd(zzci2), subscribeOptions.getFilter(), pendingIntent, null, (IBinder)zzab2, subscribeOptions.zzkbr, subscribeOptions.zzkbs, this.zzkdc.zzkcv);
        ((zzs)this.zzalw()).zza(subscribeRequest);
    }

    @Deprecated
    final void zza(zzci<zzn<Status>> zzci2, PendingIntent pendingIntent, @Nullable zzab zzab2, SubscribeOptions subscribeOptions) throws RemoteException {
        this.zza(zzci2, pendingIntent, zzab2, subscribeOptions, this.zzkdc.zzkcv);
    }

    final void zza(zzci<zzn<Status>> zzci2, zzci<MessageListener> zzci3) throws RemoteException {
        zzcvd zzcvd2 = new zzcvd(zzci2);
        if (!this.zzkdb.containsKey(zzci3.zzakx())) {
            zzcvd2.zzap(new Status(0));
            return;
        }
        zzcg zzcg2 = new zzcg(this.zzkdb.get(zzci3.zzakx()), (IBinder)zzcvd2, null);
        ((zzs)this.zzalw()).zza(zzcg2);
        this.zzkdb.remove(zzci3.zzakx());
    }

    final void zza(zzci<zzn<Status>> zzci2, PendingIntent pendingIntent) throws RemoteException {
        zzcg zzcg2 = new zzcg(null, (IBinder)new zzcvd(zzci2), pendingIntent);
        ((zzs)this.zzalw()).zza(zzcg2);
    }

    final void zzb(zzci<zzn<Status>> zzci2, zzci<StatusCallback> zzci3) throws RemoteException {
        if (!this.zzkdb.containsKey(zzci3.zzakx())) {
            this.zzkdb.zzf(zzci3.zzakx(), (IBinder)new zzcvg(zzci3));
        }
        zzcb zzcb2 = new zzcb((IBinder)new zzcvd(zzci2), this.zzkdb.get(zzci3.zzakx()));
        new zzcb((IBinder)new zzcvd(zzci2), this.zzkdb.get(zzci3.zzakx())).zzkeh = true;
        ((zzs)this.zzalw()).zza(zzcb2);
    }

    final void zzc(zzci<zzn<Status>> zzci2, zzci<StatusCallback> zzci3) throws RemoteException {
        zzcvd zzcvd2 = new zzcvd(zzci2);
        if (!this.zzkdb.containsKey(zzci3.zzakx())) {
            zzcvd2.zzap(new Status(0));
            return;
        }
        zzcb zzcb2 = new zzcb((IBinder)zzcvd2, this.zzkdb.get(zzci3.zzakx()));
        new zzcb((IBinder)zzcvd2, this.zzkdb.get(zzci3.zzakx())).zzkeh = false;
        ((zzs)this.zzalw()).zza(zzcb2);
        this.zzkdb.remove(zzci3.zzakx());
    }

    final void zzet(int n) throws RemoteException {
        String string;
        switch (n) {
            case 1: {
                string = "ACTIVITY_STOPPED";
                break;
            }
            case 2: {
                string = "CLIENT_DISCONNECTED";
                break;
            }
            default: {
                if (Log.isLoggable((String)"NearbyMessagesClient", (int)5)) {
                    Log.w((String)"NearbyMessagesClient", (String)String.format("Received unknown/unforeseen client lifecycle event %d, can't do anything with it.", n));
                }
                return;
            }
        }
        if (this.isConnected()) {
            zzj zzj2 = new zzj(n);
            if (Log.isLoggable((String)"NearbyMessagesClient", (int)3)) {
                Log.d((String)"NearbyMessagesClient", (String)String.format("Emitting client lifecycle event %s", string));
            }
            ((zzs)this.zzalw()).zza(zzj2);
            return;
        }
        if (Log.isLoggable((String)"NearbyMessagesClient", (int)3)) {
            Log.d((String)"NearbyMessagesClient", (String)String.format("Failed to emit client lifecycle event %s due to GmsClient being disconnected", string));
        }
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.nearby.messages.internal.INearbyMessagesService");
        if (iInterface instanceof zzs) {
            return (zzs)iInterface;
        }
        return new zzt(iBinder2);
    }
}

