/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.api.zze;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzrk;
import com.google.android.gms.nearby.Nearby;
import com.google.android.gms.nearby.connection.AppMetadata;
import com.google.android.gms.nearby.connection.Connections;
import java.util.List;

public final class zzrl
implements Connections {
    public static final Api.zzc<zzrk> zzGR = new Api.zzc();
    public static final Api.zzb<zzrk, Api.ApiOptions.NoOptions> zzGS = new Api.zzb<zzrk, Api.ApiOptions.NoOptions>(){

        public zzrk zzl(Context context, Looper looper, zzf zzf2, Api.ApiOptions.NoOptions noOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return new zzrk(context, looper, connectionCallbacks, onConnectionFailedListener);
        }

        public int getPriority() {
            return Integer.MAX_VALUE;
        }

        public /* synthetic */ Api.zza zza(Context context, Looper looper, zzf zzf2, Object object, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return this.zzl(context, looper, zzf2, (Api.ApiOptions.NoOptions)object, connectionCallbacks, onConnectionFailedListener);
        }
    };

    public static zzrk zzd(GoogleApiClient googleApiClient, boolean bl) {
        zzx.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzx.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        return zzrl.zze(googleApiClient, bl);
    }

    public static zzrk zze(GoogleApiClient googleApiClient, boolean bl) {
        zzx.zza((boolean)googleApiClient.zza(Nearby.CONNECTIONS_API), (Object)"GoogleApiClient is not configured to use the Nearby Connections Api. Pass Nearby.CONNECTIONS_API into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.zzb(Nearby.CONNECTIONS_API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Nearby.CONNECTIONS_API and is not connected to Nearby Connections. Use GoogleApiClient.hasConnectedApi(Nearby.CONNECTIONS_API) to guard this call.");
        }
        return bl2 ? (zzrk)googleApiClient.zza(zzGR) : null;
    }

    @Override
    public String getLocalEndpointId(GoogleApiClient apiClient) {
        return zzrl.zzd(apiClient, true).zzrk();
    }

    @Override
    public String getLocalDeviceId(GoogleApiClient apiClient) {
        return zzrl.zzd(apiClient, true).zzrl();
    }

    @Override
    public PendingResult<Connections.StartAdvertisingResult> startAdvertising(GoogleApiClient apiClient, final String name, final AppMetadata appMetadata, final long durationMillis, Connections.ConnectionRequestListener connectionRequestListener) {
        final zze zze2 = apiClient.zzf((Object)connectionRequestListener);
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            protected void zza(zzrk zzrk2) throws RemoteException {
                zzrk2.zza((zza.zzb<Connections.StartAdvertisingResult>)this, name, appMetadata, durationMillis, (zze<Connections.ConnectionRequestListener>)zze2);
            }
        });
    }

    @Override
    public void stopAdvertising(GoogleApiClient apiClient) {
        zzrl.zzd(apiClient, false).zzrm();
    }

    @Override
    public PendingResult<Status> startDiscovery(GoogleApiClient apiClient, final String serviceId, final long durationMillis, Connections.EndpointDiscoveryListener listener) {
        final zze zze2 = apiClient.zzf((Object)listener);
        return apiClient.zzb((zza.zza)new zzc(apiClient){

            protected void zza(zzrk zzrk2) throws RemoteException {
                zzrk2.zza((zza.zzb<Status>)this, serviceId, durationMillis, (zze<Connections.EndpointDiscoveryListener>)zze2);
            }
        });
    }

    @Override
    public void stopDiscovery(GoogleApiClient apiClient, String serviceId) {
        zzrl.zzd(apiClient, false).zzcx(serviceId);
    }

    @Override
    public PendingResult<Status> sendConnectionRequest(GoogleApiClient apiClient, final String name, final String remoteEndpointId, final byte[] payload, Connections.ConnectionResponseCallback connectionResponseCallback, Connections.MessageListener messageListener) {
        final zze zze2 = apiClient.zzf((Object)connectionResponseCallback);
        final zze zze3 = apiClient.zzf((Object)messageListener);
        return apiClient.zzb((zza.zza)new zzc(apiClient){

            protected void zza(zzrk zzrk2) throws RemoteException {
                zzrk2.zza((zza.zzb<Status>)this, name, remoteEndpointId, payload, (zze<Connections.ConnectionResponseCallback>)zze2, (zze<Connections.MessageListener>)zze3);
            }
        });
    }

    @Override
    public PendingResult<Status> acceptConnectionRequest(GoogleApiClient apiClient, final String remoteEndpointId, final byte[] payload, Connections.MessageListener messageListener) {
        final zze zze2 = apiClient.zzf((Object)messageListener);
        return apiClient.zzb((zza.zza)new zzc(apiClient){

            protected void zza(zzrk zzrk2) throws RemoteException {
                zzrk2.zza((zza.zzb<Status>)this, remoteEndpointId, payload, (zze<Connections.MessageListener>)zze2);
            }
        });
    }

    @Override
    public PendingResult<Status> rejectConnectionRequest(GoogleApiClient apiClient, final String remoteEndpointId) {
        return apiClient.zzb((zza.zza)new zzc(apiClient){

            protected void zza(zzrk zzrk2) throws RemoteException {
                zzrk2.zzq((zza.zzb<Status>)this, remoteEndpointId);
            }
        });
    }

    @Override
    public void sendReliableMessage(GoogleApiClient apiClient, String remoteEndpointId, byte[] payload) {
        zzrl.zzd(apiClient, false).zza(new String[]{remoteEndpointId}, payload);
    }

    @Override
    public void sendReliableMessage(GoogleApiClient apiClient, List<String> remoteEndpointIds, byte[] payload) {
        zzrl.zzd(apiClient, false).zza(remoteEndpointIds.toArray(new String[remoteEndpointIds.size()]), payload);
    }

    @Override
    public void sendUnreliableMessage(GoogleApiClient apiClient, String remoteEndpointId, byte[] payload) {
        zzrl.zzd(apiClient, false).zzb(new String[]{remoteEndpointId}, payload);
    }

    @Override
    public void sendUnreliableMessage(GoogleApiClient apiClient, List<String> remoteEndpointIds, byte[] payload) {
        zzrl.zzd(apiClient, false).zzb(remoteEndpointIds.toArray(new String[remoteEndpointIds.size()]), payload);
    }

    @Override
    public void disconnectFromEndpoint(GoogleApiClient apiClient, String remoteEndpointId) {
        zzrl.zzd(apiClient, false).zzcy(remoteEndpointId);
    }

    @Override
    public void stopAllEndpoints(GoogleApiClient apiClient) {
        zzrl.zzd(apiClient, false).zzrn();
    }

    private static abstract class zzc
    extends zza<Status> {
        private zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzb(x0);
        }
    }

    private static abstract class zzb
    extends zza<Connections.StartAdvertisingResult> {
        private zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Connections.StartAdvertisingResult zzaF(final Status status) {
            return new Connections.StartAdvertisingResult(){

                @Override
                public String getLocalEndpointName() {
                    return null;
                }

                public Status getStatus() {
                    return status;
                }
            };
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzaF(x0);
        }
    }

    private static abstract class zza<R extends Result>
    extends zza.zza<R, zzrk> {
        public zza(GoogleApiClient googleApiClient) {
            super(zzGR, googleApiClient);
        }
    }
}

