/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.nearby.messages.devices.NearbyDeviceFilter;
import com.google.android.gms.nearby.messages.internal.MessageType;
import com.google.android.gms.nearby.messages.zzb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MessageFilter
implements SafeParcelable {
    public static final Parcelable.Creator<MessageFilter> CREATOR = new zzb();
    public static final MessageFilter INCLUDE_ALL_MY_TYPES = new Builder().includeAllMyTypes().build();
    final int mVersionCode;
    private final List<MessageType> zzaWE;
    private final List<NearbyDeviceFilter> zzaWF;
    private final boolean zzaWG;

    MessageFilter(int versionCode, List<MessageType> messageTypes, List<NearbyDeviceFilter> deviceFilters, boolean includeAllMyTypes) {
        this.mVersionCode = versionCode;
        this.zzaWE = Collections.unmodifiableList((List)zzx.zzy(messageTypes));
        this.zzaWG = includeAllMyTypes;
        if (deviceFilters == null) {
            deviceFilters = Collections.emptyList();
        }
        this.zzaWF = Collections.unmodifiableList(deviceFilters);
    }

    private MessageFilter(List<MessageType> messageTypes, List<NearbyDeviceFilter> deviceFilters, boolean includeAllMyTypes) {
        this(1, messageTypes, deviceFilters, includeAllMyTypes);
    }

    List<MessageType> zzCx() {
        return this.zzaWE;
    }

    boolean zzCy() {
        return this.zzaWG;
    }

    List<NearbyDeviceFilter> zzCz() {
        return this.zzaWF;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzb.zza(this, dest, flags);
    }

    public String toString() {
        return "MessageFilter{includeAllMyTypes=" + this.zzaWG + ", messageTypes=" + this.zzaWE + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MessageFilter)) {
            return false;
        }
        MessageFilter messageFilter = (MessageFilter)o;
        return this.zzaWG == messageFilter.zzaWG && zzw.equal(this.zzaWE, messageFilter.zzaWE) && zzw.equal(this.zzaWF, messageFilter.zzaWF);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzaWE, this.zzaWF, this.zzaWG});
    }

    public static final class Builder {
        private final List<MessageType> zzaWH = new ArrayList<MessageType>();
        private final List<NearbyDeviceFilter> zzaWF = new ArrayList<NearbyDeviceFilter>();
        private boolean zzaWG;

        public Builder includeAllMyTypes() {
            this.zzaWG = true;
            return this;
        }

        public Builder includeNamespacedType(String namespace, String type) {
            return this.zzP(namespace, type);
        }

        public Builder includeFilter(MessageFilter filter) {
            this.zzaWH.addAll(filter.zzCx());
            this.zzaWF.addAll(filter.zzCz());
            this.zzaWG |= filter.zzCy();
            return this;
        }

        private Builder zzP(String string, String string2) {
            this.zzaWH.add(new MessageType(string, string2));
            return this;
        }

        public MessageFilter build() {
            zzx.zza((this.zzaWG || !this.zzaWH.isEmpty() ? 1 : 0) != 0, (Object)"At least one of the include methods must be called.");
            return new MessageFilter(this.zzaWH, this.zzaWF, this.zzaWG);
        }
    }
}

