/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.nearby.messages.devices.NearbyDevice;
import com.google.android.gms.nearby.messages.zzc;
import java.util.Arrays;

public class Message
extends AbstractSafeParcelable {
    public static final int MAX_CONTENT_SIZE_BYTES = 102400;
    public static final int MAX_TYPE_LENGTH = 32;
    public static final Parcelable.Creator<Message> CREATOR = new zzc();
    private static final NearbyDevice[] zzbiL = new NearbyDevice[]{NearbyDevice.zzbjr};
    final int versionCode;
    private final byte[] content;
    private final String type;
    private final String zzasB;
    private final NearbyDevice[] zzbiM;

    Message(int n, byte[] byArray, String string, String string2, NearbyDevice[] nearbyDeviceArray) {
        this.versionCode = n;
        this.type = (String)zzaa.zzz((Object)string2);
        String string3 = this.zzasB = string == null ? "" : string;
        if (Message.zzaa(this.zzasB, this.type)) {
            zzaa.zzb((byArray == null ? 1 : 0) != 0, (Object)"Content must be null for a device presence message.");
        } else {
            zzaa.zzz((Object)byArray);
            zzaa.zzb((byArray.length <= 102400 ? 1 : 0) != 0, (String)"Content length(%d) must not exceed MAX_CONTENT_SIZE_BYTES(%d)", (Object[])new Object[]{byArray.length, 102400});
        }
        this.content = byArray;
        if (nearbyDeviceArray == null || nearbyDeviceArray.length == 0) {
            nearbyDeviceArray = zzbiL;
        }
        this.zzbiM = nearbyDeviceArray;
        zzaa.zzb((string2.length() <= 32 ? 1 : 0) != 0, (String)"Type length(%d) must not exceed MAX_TYPE_LENGTH(%d)", (Object[])new Object[]{string2.length(), 32});
    }

    @Deprecated
    public static boolean zzaa(String string, String string2) {
        return string.equals("__reserved_namespace") && string2.equals("__device_presence");
    }

    public Message(byte[] byArray) {
        this(byArray, "", "");
    }

    public Message(byte[] byArray, String string) {
        this(byArray, "", string);
    }

    public Message(byte[] byArray, String string, String string2) {
        this(byArray, string, string2, zzbiL);
    }

    public Message(byte[] byArray, String string, String string2, NearbyDevice[] nearbyDeviceArray) {
        this(2, byArray, string, string2, nearbyDeviceArray);
    }

    public String getType() {
        return this.type;
    }

    public String getNamespace() {
        return this.zzasB;
    }

    public byte[] getContent() {
        return this.content;
    }

    public NearbyDevice[] zzHL() {
        return this.zzbiM;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzc.zza(this, parcel, n);
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzasB, this.type, Arrays.hashCode(this.content)});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Message)) {
            return false;
        }
        Message message = (Message)((Object)object);
        return TextUtils.equals((CharSequence)this.zzasB, (CharSequence)message.zzasB) && TextUtils.equals((CharSequence)this.type, (CharSequence)message.type) && Arrays.equals(this.content, message.content);
    }

    public String toString() {
        String string = this.zzasB;
        String string2 = this.type;
        int n = this.content == null ? 0 : this.content.length;
        String string3 = String.valueOf(Arrays.toString((Object[])this.zzHL()));
        return new StringBuilder(69 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Message{namespace='").append(string).append("', type='").append(string2).append("', content=[").append(n).append(" bytes], devices=").append(string3).append("}").toString();
    }
}

