/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.nearby.messages.devices.NearbyDeviceFilter;
import com.google.android.gms.nearby.messages.internal.MessageType;
import com.google.android.gms.nearby.messages.zzd;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MessageFilter
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<MessageFilter> CREATOR = new zzd();
    public static final MessageFilter INCLUDE_ALL_MY_TYPES = new Builder().includeAllMyTypes().build();
    final int mVersionCode;
    private final List<MessageType> zzbiN;
    private final List<NearbyDeviceFilter> zzbiO;
    private final boolean zzbiP;

    MessageFilter(int n, List<MessageType> list, List<NearbyDeviceFilter> list2, boolean bl) {
        this.mVersionCode = n;
        this.zzbiN = Collections.unmodifiableList((List)zzaa.zzz(list));
        this.zzbiP = bl;
        if (list2 == null) {
            list2 = Collections.emptyList();
        }
        this.zzbiO = Collections.unmodifiableList(list2);
    }

    private MessageFilter(List<MessageType> list, List<NearbyDeviceFilter> list2, boolean bl) {
        this(1, list, list2, bl);
    }

    List<MessageType> zzHM() {
        return this.zzbiN;
    }

    boolean zzHN() {
        return this.zzbiP;
    }

    List<NearbyDeviceFilter> zzHO() {
        return this.zzbiO;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzd.zza(this, parcel, n);
    }

    public String toString() {
        boolean bl = this.zzbiP;
        String string = String.valueOf(this.zzbiN);
        return new StringBuilder(53 + String.valueOf(string).length()).append("MessageFilter{includeAllMyTypes=").append(bl).append(", messageTypes=").append(string).append("}").toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessageFilter)) {
            return false;
        }
        MessageFilter messageFilter = (MessageFilter)((Object)object);
        return this.zzbiP == messageFilter.zzbiP && zzz.equal(this.zzbiN, messageFilter.zzbiN) && zzz.equal(this.zzbiO, messageFilter.zzbiO);
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzbiN, this.zzbiO, this.zzbiP});
    }

    public static final class Builder {
        private final List<MessageType> zzbiQ = new ArrayList<MessageType>();
        private final List<NearbyDeviceFilter> zzbiO = new ArrayList<NearbyDeviceFilter>();
        private boolean zzbiP;

        public Builder includeAllMyTypes() {
            this.zzbiP = true;
            return this;
        }

        public Builder includeNamespacedType(String string, String string2) {
            zzaa.zzb((string != null && !string.isEmpty() && !string.contains("*") ? 1 : 0) != 0, (String)"namespace(%s) cannot be null, empty or contain (*).", (Object[])new Object[]{string});
            zzaa.zzb((string2 != null && !string2.contains("*") ? 1 : 0) != 0, (String)"type(%s) cannot be null or contain (*).", (Object[])new Object[]{string2});
            return this.zzab(string, string2);
        }

        public Builder includeFilter(MessageFilter messageFilter) {
            this.zzbiQ.addAll(messageFilter.zzHM());
            this.zzbiO.addAll(messageFilter.zzHO());
            this.zzbiP |= messageFilter.zzHN();
            return this;
        }

        private Builder zzab(String string, String string2) {
            this.zzbiQ.add(new MessageType(string, string2));
            return this;
        }

        public MessageFilter build() {
            zzaa.zza((this.zzbiP || !this.zzbiQ.isEmpty() ? 1 : 0) != 0, (Object)"At least one of the include methods must be called.");
            return new MessageFilter(this.zzbiQ, this.zzbiO, this.zzbiP);
        }
    }
}

