/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.internal.zzpm;
import com.google.android.gms.internal.zzqn;
import com.google.android.gms.internal.zzuq;
import com.google.android.gms.nearby.Nearby;
import com.google.android.gms.nearby.connection.AppMetadata;
import com.google.android.gms.nearby.connection.Connections;
import java.util.List;

public final class zzur
implements Connections {
    public static final Api.zzf<zzuq> bJ = new Api.zzf();
    public static final Api.zza<zzuq, Api.ApiOptions.NoOptions> bK = new Api.zza<zzuq, Api.ApiOptions.NoOptions>(){

        public zzuq zzq(Context context, Looper looper, zzg zzg2, Api.ApiOptions.NoOptions noOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return new zzuq(context, looper, zzg2, connectionCallbacks, onConnectionFailedListener);
        }

        public /* synthetic */ Api.zze zza(Context context, Looper looper, zzg zzg2, Object object, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return this.zzq(context, looper, zzg2, (Api.ApiOptions.NoOptions)object, connectionCallbacks, onConnectionFailedListener);
        }
    };

    public static zzuq zzd(GoogleApiClient googleApiClient, boolean bl) {
        zzab.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzab.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        return zzur.zze(googleApiClient, bl);
    }

    public static zzuq zze(GoogleApiClient googleApiClient, boolean bl) {
        zzab.zza((boolean)googleApiClient.zza(Nearby.CONNECTIONS_API), (Object)"GoogleApiClient is not configured to use the Nearby Connections Api. Pass Nearby.CONNECTIONS_API into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.hasConnectedApi(Nearby.CONNECTIONS_API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Nearby.CONNECTIONS_API and is not connected to Nearby Connections. Use GoogleApiClient.hasConnectedApi(Nearby.CONNECTIONS_API) to guard this call.");
        }
        return bl2 ? (zzuq)googleApiClient.zza(bJ) : null;
    }

    @Override
    public String getLocalEndpointId(GoogleApiClient googleApiClient) {
        return zzur.zzd(googleApiClient, true).zzbwq();
    }

    @Override
    public String getLocalDeviceId(GoogleApiClient googleApiClient) {
        return zzur.zzd(googleApiClient, true).zzbwr();
    }

    @Override
    public PendingResult<Connections.StartAdvertisingResult> startAdvertising(GoogleApiClient googleApiClient, final String string, final AppMetadata appMetadata, final long l, Connections.ConnectionRequestListener connectionRequestListener) {
        final zzqn zzqn2 = googleApiClient.zzs((Object)connectionRequestListener);
        return googleApiClient.zzd((zzpm.zza)new zzb(googleApiClient){

            protected void zza(zzuq zzuq2) throws RemoteException {
                zzuq2.zza((zzpm.zzb<Connections.StartAdvertisingResult>)this, string, appMetadata, l, (zzqn<Connections.ConnectionRequestListener>)zzqn2);
            }
        });
    }

    @Override
    public void stopAdvertising(GoogleApiClient googleApiClient) {
        zzuq zzuq2 = zzur.zzd(googleApiClient, false);
        if (zzuq2 != null) {
            zzuq2.zzbws();
        }
    }

    @Override
    public PendingResult<Status> startDiscovery(GoogleApiClient googleApiClient, final String string, final long l, Connections.EndpointDiscoveryListener endpointDiscoveryListener) {
        final zzqn zzqn2 = googleApiClient.zzs((Object)endpointDiscoveryListener);
        return googleApiClient.zzd((zzpm.zza)new zzc(googleApiClient){

            protected void zza(zzuq zzuq2) throws RemoteException {
                zzuq2.zza((zzpm.zzb<Status>)this, string, l, (zzqn<Connections.EndpointDiscoveryListener>)zzqn2);
            }
        });
    }

    @Override
    public void stopDiscovery(GoogleApiClient googleApiClient, String string) {
        zzuq zzuq2 = zzur.zzd(googleApiClient, false);
        if (zzuq2 != null) {
            zzuq2.zzmw(string);
        }
    }

    @Override
    public PendingResult<Status> sendConnectionRequest(GoogleApiClient googleApiClient, final String string, final String string2, final byte[] byArray, Connections.ConnectionResponseCallback connectionResponseCallback, Connections.MessageListener messageListener) {
        final zzqn zzqn2 = googleApiClient.zzs((Object)connectionResponseCallback);
        final zzqn zzqn3 = googleApiClient.zzs((Object)messageListener);
        return googleApiClient.zzd((zzpm.zza)new zzc(googleApiClient){

            protected void zza(zzuq zzuq2) throws RemoteException {
                zzuq2.zza((zzpm.zzb<Status>)this, string, string2, byArray, (zzqn<Connections.ConnectionResponseCallback>)zzqn2, (zzqn<Connections.MessageListener>)zzqn3);
            }
        });
    }

    @Override
    public PendingResult<Status> acceptConnectionRequest(GoogleApiClient googleApiClient, final String string, final byte[] byArray, Connections.MessageListener messageListener) {
        final zzqn zzqn2 = googleApiClient.zzs((Object)messageListener);
        return googleApiClient.zzd((zzpm.zza)new zzc(googleApiClient){

            protected void zza(zzuq zzuq2) throws RemoteException {
                zzuq2.zza((zzpm.zzb<Status>)this, string, byArray, (zzqn<Connections.MessageListener>)zzqn2);
            }
        });
    }

    @Override
    public PendingResult<Status> rejectConnectionRequest(GoogleApiClient googleApiClient, final String string) {
        return googleApiClient.zzd((zzpm.zza)new zzc(googleApiClient){

            protected void zza(zzuq zzuq2) throws RemoteException {
                zzuq2.zzt((zzpm.zzb<Status>)this, string);
            }
        });
    }

    @Override
    public void sendReliableMessage(GoogleApiClient googleApiClient, String string, byte[] byArray) {
        zzuq zzuq2 = zzur.zzd(googleApiClient, false);
        if (zzuq2 != null) {
            zzuq2.zza(new String[]{string}, byArray);
        }
    }

    @Override
    public void sendReliableMessage(GoogleApiClient googleApiClient, List<String> list, byte[] byArray) {
        zzuq zzuq2 = zzur.zzd(googleApiClient, false);
        if (zzuq2 != null) {
            zzuq2.zza(list.toArray(new String[0]), byArray);
        }
    }

    @Override
    public void sendUnreliableMessage(GoogleApiClient googleApiClient, String string, byte[] byArray) {
        zzuq zzuq2 = zzur.zzd(googleApiClient, false);
        if (zzuq2 != null) {
            zzuq2.zzb(new String[]{string}, byArray);
        }
    }

    @Override
    public void sendUnreliableMessage(GoogleApiClient googleApiClient, List<String> list, byte[] byArray) {
        zzuq zzuq2 = zzur.zzd(googleApiClient, false);
        if (zzuq2 != null) {
            zzuq2.zzb(list.toArray(new String[0]), byArray);
        }
    }

    @Override
    public void disconnectFromEndpoint(GoogleApiClient googleApiClient, String string) {
        zzuq zzuq2 = zzur.zzd(googleApiClient, false);
        if (zzuq2 != null) {
            zzuq2.zzmx(string);
        }
    }

    @Override
    public void stopAllEndpoints(GoogleApiClient googleApiClient) {
        zzuq zzuq2 = zzur.zzd(googleApiClient, false);
        if (zzuq2 != null) {
            zzuq2.zzbwt();
        }
    }

    private static abstract class zzc
    extends zza<Status> {
        private zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }

    private static abstract class zzb
    extends zza<Connections.StartAdvertisingResult> {
        private zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Connections.StartAdvertisingResult zzds(final Status status) {
            return new Connections.StartAdvertisingResult(){

                @Override
                public String getLocalEndpointName() {
                    return null;
                }

                public Status getStatus() {
                    return status;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzds(status);
        }
    }

    private static abstract class zza<R extends Result>
    extends zzpm.zza<R, zzuq> {
        public zza(GoogleApiClient googleApiClient) {
            super(Nearby.CONNECTIONS_API, googleApiClient);
        }
    }
}

