/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.nearby.messages.devices.NearbyDeviceFilter;
import com.google.android.gms.nearby.messages.internal.MessageType;
import com.google.android.gms.nearby.messages.zzb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class MessageFilter
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<MessageFilter> CREATOR = new zzb();
    public static final MessageFilter INCLUDE_ALL_MY_TYPES = new Builder().includeAllMyTypes().build();
    final int mVersionCode;
    private final List<MessageType> apv;
    private final List<NearbyDeviceFilter> apw;
    private final boolean apx;

    MessageFilter(int n, List<MessageType> list, List<NearbyDeviceFilter> list2, boolean bl) {
        this.mVersionCode = n;
        this.apv = Collections.unmodifiableList((List)zzab.zzy(list));
        this.apx = bl;
        if (list2 == null) {
            list2 = Collections.emptyList();
        }
        this.apw = Collections.unmodifiableList(list2);
    }

    private MessageFilter(List<MessageType> list, List<NearbyDeviceFilter> list2, boolean bl) {
        this(1, list, list2, bl);
    }

    List<MessageType> zzbxn() {
        return this.apv;
    }

    boolean zzbxo() {
        return this.apx;
    }

    List<NearbyDeviceFilter> zzbxp() {
        return this.apw;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public String toString() {
        boolean bl = this.apx;
        String string = String.valueOf(this.apv);
        return new StringBuilder(53 + String.valueOf(string).length()).append("MessageFilter{includeAllMyTypes=").append(bl).append(", messageTypes=").append(string).append("}").toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessageFilter)) {
            return false;
        }
        MessageFilter messageFilter = (MessageFilter)((Object)object);
        return this.apx == messageFilter.apx && zzaa.equal(this.apv, messageFilter.apv) && zzaa.equal(this.apw, messageFilter.apw);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.apv, this.apw, this.apx});
    }

    public static final class Builder {
        private final List<MessageType> apy = new ArrayList<MessageType>();
        private final List<NearbyDeviceFilter> apw = new ArrayList<NearbyDeviceFilter>();
        private boolean apx;

        public Builder includeAllMyTypes() {
            this.apx = true;
            return this;
        }

        public Builder includeNamespacedType(String string, String string2) {
            zzab.zzb((string != null && !string.isEmpty() && !string.contains("*") ? 1 : 0) != 0, (String)"namespace(%s) cannot be null, empty or contain (*).", (Object[])new Object[]{string});
            zzab.zzb((string2 != null && !string2.contains("*") ? 1 : 0) != 0, (String)"type(%s) cannot be null or contain (*).", (Object[])new Object[]{string2});
            return this.zzbd(string, string2);
        }

        public Builder includeFilter(MessageFilter messageFilter) {
            this.apy.addAll(messageFilter.zzbxn());
            this.apw.addAll(messageFilter.zzbxp());
            this.apx |= messageFilter.zzbxo();
            return this;
        }

        public Builder includeEddystoneUids(String string, @Nullable String string2) {
            this.zzbd("__reserved_namespace", "__eddystone_uid");
            this.apw.add(NearbyDeviceFilter.zzbe(string, string2));
            return this;
        }

        public Builder includeIBeaconIds(UUID uUID, @Nullable Short s, @Nullable Short s2) {
            this.zzbd("__reserved_namespace", "__i_beacon_id");
            this.apw.add(NearbyDeviceFilter.zza(uUID, s, s2));
            return this;
        }

        private Builder zzbd(String string, String string2) {
            this.apy.add(new MessageType(string, string2));
            return this;
        }

        public MessageFilter build() {
            zzab.zza((this.apx || !this.apy.isEmpty() ? 1 : 0) != 0, (Object)"At least one of the include methods must be called.");
            return new MessageFilter(this.apy, this.apw, this.apx);
        }
    }
}

