/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.nearby.messages.devices.NearbyDevice;
import com.google.android.gms.nearby.messages.zza;
import java.util.Arrays;

public class Message
extends AbstractSafeParcelable {
    public static final int MAX_CONTENT_SIZE_BYTES = 102400;
    public static final int MAX_TYPE_LENGTH = 32;
    public static final Parcelable.Creator<Message> CREATOR = new zza();
    private static final NearbyDevice[] avw = new NearbyDevice[]{NearbyDevice.avZ};
    public static final String MESSAGE_NAMESPACE_RESERVED = "__reserved_namespace";
    public static final String MESSAGE_TYPE_EDDYSTONE_UID = "__eddystone_uid";
    public static final String MESSAGE_TYPE_I_BEACON_ID = "__i_beacon_id";
    final int versionCode;
    private final byte[] content;
    private final String type;
    private final String Dl;
    private final NearbyDevice[] avx;
    private final long avy;

    Message(int n, @Nullable byte[] byArray, @Nullable String string, String string2, @Nullable NearbyDevice[] nearbyDeviceArray, long l) {
        this.versionCode = n;
        this.type = (String)zzac.zzy((Object)string2);
        this.Dl = string == null ? "" : string;
        this.avy = 0L;
        if (Message.zzbc(this.Dl, this.type)) {
            zzac.zzb((byArray == null ? 1 : 0) != 0, (Object)"Content must be null for a device presence message.");
        } else {
            zzac.zzy((Object)byArray);
            zzac.zzb((byArray.length <= 102400 ? 1 : 0) != 0, (String)"Content length(%d) must not exceed MAX_CONTENT_SIZE_BYTES(%d)", (Object[])new Object[]{byArray.length, 102400});
        }
        this.content = byArray;
        if (nearbyDeviceArray == null || nearbyDeviceArray.length == 0) {
            nearbyDeviceArray = avw;
        }
        this.avx = nearbyDeviceArray;
        zzac.zzb((string2.length() <= 32 ? 1 : 0) != 0, (String)"Type length(%d) must not exceed MAX_TYPE_LENGTH(%d)", (Object[])new Object[]{string2.length(), 32});
    }

    public boolean zzcav() {
        return MESSAGE_NAMESPACE_RESERVED.equals(this.getNamespace());
    }

    public boolean zzno(String string) {
        return this.zzcav() && string.equals(this.getType());
    }

    @Deprecated
    public static boolean zzbc(String string, String string2) {
        return string.equals(MESSAGE_NAMESPACE_RESERVED) && string2.equals("__device_presence");
    }

    public Message(byte[] byArray) {
        this(byArray, "", "");
    }

    public Message(byte[] byArray, String string) {
        this(byArray, "", string);
    }

    public Message(byte[] byArray, String string, String string2) {
        this(byArray, string, string2, avw);
    }

    public Message(byte[] byArray, String string, String string2, NearbyDevice[] nearbyDeviceArray) {
        this(byArray, string, string2, nearbyDeviceArray, 0L);
    }

    public Message(byte[] byArray, String string, String string2, NearbyDevice[] nearbyDeviceArray, long l) {
        this(2, byArray, string, string2, nearbyDeviceArray, l);
    }

    public String getType() {
        return this.type;
    }

    public String getNamespace() {
        return this.Dl;
    }

    public byte[] getContent() {
        return this.content;
    }

    public NearbyDevice[] zzcaw() {
        return this.avx;
    }

    public long zzcax() {
        return 0L;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }

    public int hashCode() {
        Object[] objectArray = new Object[4];
        objectArray[0] = this.Dl;
        objectArray[1] = this.type;
        objectArray[2] = Arrays.hashCode(this.content);
        objectArray[3] = 0L;
        return zzab.hashCode((Object[])objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Message)) {
            return false;
        }
        Message message = (Message)((Object)object);
        if (!TextUtils.equals((CharSequence)this.Dl, (CharSequence)message.Dl)) return false;
        if (!TextUtils.equals((CharSequence)this.type, (CharSequence)message.type)) return false;
        if (!Arrays.equals(this.content, message.content)) return false;
        if (0L != 0L) return false;
        return true;
    }

    public String toString() {
        String string = this.Dl;
        String string2 = this.type;
        int n = this.content == null ? 0 : this.content.length;
        String string3 = String.valueOf(Arrays.toString((Object[])this.zzcaw()));
        return new StringBuilder(69 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Message{namespace='").append(string).append("', type='").append(string2).append("', content=[").append(n).append(" bytes], devices=").append(string3).append("}").toString();
    }
}

