/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages.internal;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.nearby.messages.Distance;
import com.google.android.gms.nearby.messages.internal.zzd;
import java.util.Locale;

public class DistanceImpl
extends AbstractSafeParcelable
implements Distance {
    public static final Parcelable.Creator<DistanceImpl> CREATOR = new zzd();
    final int mVersionCode;
    public final int accuracy;
    public final double awr;

    DistanceImpl(int n, int n2, double d) {
        this.mVersionCode = n;
        this.accuracy = n2;
        this.awr = d;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzd.zza(this, parcel, n);
    }

    public DistanceImpl(int n, double d) {
        this(1, n, d);
    }

    @Override
    public int getAccuracy() {
        return this.accuracy;
    }

    @Override
    public double getMeters() {
        return this.awr;
    }

    public String toString() {
        return String.format(Locale.US, "(%.1fm, %s)", this.awr, DistanceImpl.zzyu(this.accuracy));
    }

    private static String zzyu(int n) {
        switch (n) {
            case 1: {
                return "LOW";
            }
        }
        return "UNKNOWN";
    }

    @Override
    public int compareTo(@NonNull Distance distance) {
        return Double.isNaN(this.getMeters()) && Double.isNaN(distance.getMeters()) ? 0 : Double.compare(this.getMeters(), distance.getMeters());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DistanceImpl)) {
            return false;
        }
        DistanceImpl distanceImpl = (DistanceImpl)object;
        return this.getAccuracy() == distanceImpl.getAccuracy() && this.compareTo(distanceImpl) == 0;
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.getAccuracy(), this.getMeters()});
    }
}

