/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.nearby.messages.zzd;
import java.util.ArrayList;

public class Strategy
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<Strategy> CREATOR = new zzd();
    public static final int DISCOVERY_MODE_BROADCAST = 1;
    public static final int DISCOVERY_MODE_SCAN = 2;
    public static final int DISCOVERY_MODE_DEFAULT = 3;
    public static final int DISTANCE_TYPE_DEFAULT = 0;
    public static final int DISTANCE_TYPE_EARSHOT = 1;
    public static final int TTL_SECONDS_DEFAULT = 300;
    public static final int TTL_SECONDS_MAX = 86400;
    public static final int TTL_SECONDS_INFINITE = Integer.MAX_VALUE;
    public static final Strategy DEFAULT = new Builder().build();
    public static final Strategy BLE_ONLY;
    @Deprecated
    public static final Strategy ayC;
    final int mVersionCode;
    @Deprecated
    final int ayD;
    final int ayE;
    final int ayF;
    @Deprecated
    final boolean ayG;
    final int ayH;
    final int ayI;
    private final int ayJ;

    Strategy(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, int n7) {
        this.mVersionCode = n;
        this.ayD = n2;
        if (n2 == 0) {
            this.ayI = n6;
        } else {
            switch (n2) {
                case 2: {
                    this.ayI = 1;
                    break;
                }
                case 3: {
                    this.ayI = 2;
                    break;
                }
                default: {
                    this.ayI = 3;
                }
            }
        }
        this.ayF = n4;
        this.ayG = bl;
        if (bl) {
            this.ayH = 2;
            this.ayE = Integer.MAX_VALUE;
        } else {
            this.ayE = n3;
            switch (n5) {
                case -1: 
                case 0: 
                case 1: 
                case 6: {
                    this.ayH = -1;
                    break;
                }
                default: {
                    this.ayH = n5;
                }
            }
        }
        this.ayJ = n7;
    }

    public int zzcbb() {
        return this.ayH;
    }

    public int zzcbc() {
        return this.ayI;
    }

    public int zzcbd() {
        return this.ayJ;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzd.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Strategy)) {
            return false;
        }
        Strategy strategy = (Strategy)((Object)object);
        return this.mVersionCode == strategy.mVersionCode && this.ayI == strategy.ayI && this.ayE == strategy.ayE && this.ayF == strategy.ayF && this.ayH == strategy.ayH;
    }

    public int hashCode() {
        int n = this.mVersionCode;
        n = 31 * n + this.ayI;
        n = 31 * n + this.ayE;
        n = 31 * n + this.ayF;
        n = 31 * n + this.ayH;
        return n;
    }

    public String toString() {
        int n = this.ayE;
        String string = String.valueOf(Strategy.zzxy(this.ayF));
        String string2 = String.valueOf(Strategy.zzxz(this.ayH));
        String string3 = String.valueOf(Strategy.zzya(this.ayI));
        String string4 = String.valueOf(Strategy.zzxx(this.ayJ));
        return new StringBuilder(102 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("Strategy{ttlSeconds=").append(n).append(", distanceType=").append(string).append(", discoveryMedium=").append(string2).append(", discoveryMode=").append(string3).append(", backgroundScanMode=").append(string4).append("}").toString();
    }

    private static String zzxx(int n) {
        switch (n) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "ALWAYS_ON";
            }
        }
        return new StringBuilder(20).append("UNKNOWN: ").append(n).toString();
    }

    private static String zzxy(int n) {
        switch (n) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "EARSHOT";
            }
        }
        return new StringBuilder(19).append("UNKNOWN:").append(n).toString();
    }

    private static String zzxz(int n) {
        if (n == -1) {
            return "DEFAULT";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((n & 4) > 0) {
            arrayList.add("ULTRASOUND");
        }
        if ((n & 2) > 0) {
            arrayList.add("BLE");
        }
        if (arrayList.isEmpty()) {
            return new StringBuilder(19).append("UNKNOWN:").append(n).toString();
        }
        return ((Object)arrayList).toString();
    }

    private static String zzya(int n) {
        if (n == 3) {
            return "DEFAULT";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((n & 1) > 0) {
            arrayList.add("BROADCAST");
        }
        if ((n & 2) > 0) {
            arrayList.add("SCAN");
        }
        if (arrayList.isEmpty()) {
            return new StringBuilder(19).append("UNKNOWN:").append(n).toString();
        }
        return ((Object)arrayList).toString();
    }

    static {
        ayC = BLE_ONLY = new Builder().zzyb(2).setTtlSeconds(Integer.MAX_VALUE).build();
    }

    public static class Builder {
        private int ayK = 3;
        private int ayL = 300;
        private int ayM = 0;
        private int ayN = -1;
        private int ayO = 0;

        public Builder setDiscoveryMode(int n) {
            this.ayK = n;
            return this;
        }

        public Builder zzyb(int n) {
            this.ayN = n;
            return this;
        }

        public Builder setTtlSeconds(int n) {
            zzaa.zzb((n == Integer.MAX_VALUE || n > 0 && n <= 86400 ? 1 : 0) != 0, (String)"mTtlSeconds(%d) must either be TTL_SECONDS_INFINITE, or it must be between 1 and TTL_SECONDS_MAX(%d) inclusive", (Object[])new Object[]{n, 86400});
            this.ayL = n;
            return this;
        }

        public Builder setDistanceType(int n) {
            this.ayM = n;
            return this;
        }

        public Strategy build() {
            if (this.ayN == 2 && this.ayM == 1) {
                throw new IllegalStateException("Cannot set EARSHOT with BLE only mode.");
            }
            return new Strategy(2, 0, this.ayL, this.ayM, false, this.ayN, this.ayK, 0);
        }
    }
}

