/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.internal.zzqo;
import com.google.android.gms.internal.zzrr;
import com.google.android.gms.nearby.Nearby;
import com.google.android.gms.nearby.messages.Message;
import com.google.android.gms.nearby.messages.MessageListener;
import com.google.android.gms.nearby.messages.Messages;
import com.google.android.gms.nearby.messages.MessagesOptions;
import com.google.android.gms.nearby.messages.PublishCallback;
import com.google.android.gms.nearby.messages.PublishOptions;
import com.google.android.gms.nearby.messages.StatusCallback;
import com.google.android.gms.nearby.messages.SubscribeCallback;
import com.google.android.gms.nearby.messages.SubscribeOptions;
import com.google.android.gms.nearby.messages.internal.MessageWrapper;
import com.google.android.gms.nearby.messages.internal.Update;
import com.google.android.gms.nearby.messages.internal.zzo;
import com.google.android.gms.nearby.messages.internal.zzr;
import java.util.List;

public class zzs
implements Messages {
    public static final zzs azP = new zzs();
    public static final Api.zzf<zzr> hg = new Api.zzf();
    public static final Api.zza<zzr, MessagesOptions> hh = new Api.zza<zzr, MessagesOptions>(){

        public zzr zza(Context context, Looper looper, zzf zzf2, MessagesOptions messagesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return new zzr(context, looper, connectionCallbacks, onConnectionFailedListener, zzf2, messagesOptions);
        }

        public int getPriority() {
            return Integer.MAX_VALUE;
        }
    };

    private zzs() {
    }

    @Override
    public PendingResult<Status> publish(GoogleApiClient googleApiClient, final Message message, final PublishOptions publishOptions) {
        zzaa.zzy((Object)((Object)message));
        zzaa.zzy((Object)publishOptions);
        final zzrr<PublishCallback> zzrr2 = ((zzr)googleApiClient.zza(hg)).zza(googleApiClient, publishOptions.getCallback());
        return googleApiClient.zzb((zzqo.zza)new zza(googleApiClient){

            protected void zza(zzr zzr2) throws RemoteException {
                MessageWrapper messageWrapper = MessageWrapper.zza(message);
                zzr2.zza((zzqo.zzb<Status>)this, messageWrapper, (zzrr<PublishCallback>)zzrr2, publishOptions);
            }
        });
    }

    @Override
    public PendingResult<Status> publish(GoogleApiClient googleApiClient, Message message) {
        return this.publish(googleApiClient, message, PublishOptions.DEFAULT);
    }

    @Override
    public PendingResult<Status> unpublish(GoogleApiClient googleApiClient, final Message message) {
        zzaa.zzy((Object)((Object)message));
        return googleApiClient.zzb((zzqo.zza)new zza(googleApiClient){

            protected void zza(zzr zzr2) throws RemoteException {
                MessageWrapper messageWrapper = MessageWrapper.zza(message);
                zzr2.zza((zzqo.zzb<Status>)this, messageWrapper);
            }
        });
    }

    @Override
    public PendingResult<Status> subscribe(GoogleApiClient googleApiClient, final MessageListener messageListener, final SubscribeOptions subscribeOptions) {
        zzaa.zzy((Object)messageListener);
        zzaa.zzy((Object)subscribeOptions);
        zzaa.zzb((subscribeOptions.getStrategy().zzcbd() == 0 ? 1 : 0) != 0, (Object)"Strategy.setBackgroundScanMode() is only supported by background subscribe (the version which takes a PendingIntent).");
        final zzrr<MessageListener> zzrr2 = ((zzr)googleApiClient.zza(hg)).zza(googleApiClient, messageListener);
        final zzrr<SubscribeCallback> zzrr3 = ((zzr)googleApiClient.zza(hg)).zza(googleApiClient, subscribeOptions.getCallback());
        return googleApiClient.zzb((zzqo.zza)new zza(googleApiClient){

            protected void zza(zzr zzr2) throws RemoteException {
                zzr2.zza((zzqo.zzb<Status>)this, (zzrr<MessageListener>)zzrr2, messageListener, (zzrr<SubscribeCallback>)zzrr3, subscribeOptions, null);
            }
        });
    }

    @Override
    public PendingResult<Status> subscribe(GoogleApiClient googleApiClient, MessageListener messageListener) {
        return this.subscribe(googleApiClient, messageListener, SubscribeOptions.DEFAULT);
    }

    @Override
    public PendingResult<Status> subscribe(GoogleApiClient googleApiClient, final PendingIntent pendingIntent, final SubscribeOptions subscribeOptions) {
        zzaa.zzy((Object)pendingIntent);
        zzaa.zzy((Object)subscribeOptions);
        final zzrr<SubscribeCallback> zzrr2 = ((zzr)googleApiClient.zza(hg)).zza(googleApiClient, subscribeOptions.getCallback());
        return googleApiClient.zzb((zzqo.zza)new zza(googleApiClient){

            protected void zza(zzr zzr2) throws RemoteException {
                zzr2.zza((zzqo.zzb<Status>)this, pendingIntent, (zzrr<SubscribeCallback>)zzrr2, subscribeOptions);
            }
        });
    }

    @Override
    public PendingResult<Status> subscribe(GoogleApiClient googleApiClient, PendingIntent pendingIntent) {
        return this.subscribe(googleApiClient, pendingIntent, SubscribeOptions.DEFAULT);
    }

    @Override
    public PendingResult<Status> unsubscribe(GoogleApiClient googleApiClient, final MessageListener messageListener) {
        zzaa.zzy((Object)messageListener);
        return googleApiClient.zzb((zzqo.zza)new zza(googleApiClient){

            protected void zza(zzr zzr2) throws RemoteException {
                zzr2.zza((zzqo.zzb<Status>)this, messageListener);
            }
        });
    }

    @Override
    public PendingResult<Status> unsubscribe(GoogleApiClient googleApiClient, final PendingIntent pendingIntent) {
        zzaa.zzy((Object)pendingIntent);
        return googleApiClient.zzb((zzqo.zza)new zza(googleApiClient){

            protected void zza(zzr zzr2) throws RemoteException {
                zzr2.zza((zzqo.zzb<Status>)this, pendingIntent);
            }
        });
    }

    @Override
    public void handleIntent(Intent intent, MessageListener messageListener) {
        zzs.zza(zzs.zzad(intent), messageListener);
    }

    static void zza(Iterable<Update> iterable, MessageListener messageListener) {
        for (Update update : iterable) {
            if (update.zzyv(1)) {
                messageListener.onFound(update.azA);
            }
            if (update.zzyv(2)) {
                messageListener.onLost(update.azA);
            }
            if (update.zzyv(4)) {
                messageListener.onDistanceChanged(update.azA, update.aAl);
            }
            if (update.zzyv(8)) {
                messageListener.onBleSignalChanged(update.azA, update.aAm);
            }
            if (!update.zzyv(16)) continue;
            messageListener.zza(update.azA, update.aAn);
        }
    }

    private static List<Update> zzad(Intent intent) {
        return zzo.zzc(intent, "com.google.android.gms.nearby.messages.UPDATES");
    }

    @Override
    public PendingResult<Status> getPermissionStatus(GoogleApiClient googleApiClient) {
        return googleApiClient.zzb((zzqo.zza)new zza(googleApiClient){

            protected void zza(zzr zzr2) throws RemoteException {
                zzr2.zzt((zzqo.zzb<Status>)this);
            }
        });
    }

    @Override
    public PendingResult<Status> registerStatusCallback(GoogleApiClient googleApiClient, final StatusCallback statusCallback) {
        zzaa.zzy((Object)statusCallback);
        final zzrr<StatusCallback> zzrr2 = ((zzr)googleApiClient.zza(hg)).zza(googleApiClient, statusCallback);
        return googleApiClient.zzb((zzqo.zza)new zza(googleApiClient){

            protected void zza(zzr zzr2) throws RemoteException {
                zzr2.zza((zzqo.zzb<Status>)this, (zzrr<StatusCallback>)zzrr2, statusCallback);
            }
        });
    }

    @Override
    public PendingResult<Status> unregisterStatusCallback(GoogleApiClient googleApiClient, final StatusCallback statusCallback) {
        return googleApiClient.zzb((zzqo.zza)new zza(googleApiClient){

            protected void zza(zzr zzr2) throws RemoteException {
                zzr2.zza((zzqo.zzb<Status>)this, statusCallback);
            }
        });
    }

    static abstract class zza
    extends zzqo.zza<Status, zzr> {
        public zza(GoogleApiClient googleApiClient) {
            super(Nearby.MESSAGES_API, googleApiClient);
        }

        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }
}

