/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places.ui;

import android.annotation.TargetApi;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import com.google.android.gms.R;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.places.AutocompleteFilter;
import com.google.android.gms.location.places.Place;
import com.google.android.gms.location.places.ui.PlaceAutocomplete;
import com.google.android.gms.location.places.ui.PlaceSelectionListener;
import com.google.android.gms.maps.model.LatLngBounds;

@TargetApi(value=12)
public class PlaceAutocompleteFragment
extends Fragment {
    private View zzbnl;
    private View zzbnm;
    private EditText zzbnn;
    private boolean zzbno;
    @Nullable
    private LatLngBounds zzbnp;
    @Nullable
    private AutocompleteFilter zzbnq;
    @Nullable
    private PlaceSelectionListener zzbnr;

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.place_autocomplete_fragment, viewGroup, false);
        this.zzbnl = view.findViewById(R.id.place_autocomplete_search_button);
        this.zzbnm = view.findViewById(R.id.place_autocomplete_clear_button);
        this.zzbnn = (EditText)view.findViewById(R.id.place_autocomplete_search_input);
        View.OnClickListener onClickListener = new View.OnClickListener(){

            public void onClick(View view) {
                if (!PlaceAutocompleteFragment.this.zzbno) {
                    PlaceAutocompleteFragment.this.zzJk();
                }
            }
        };
        this.zzbnl.setOnClickListener(onClickListener);
        this.zzbnn.setOnClickListener(onClickListener);
        this.zzbnm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PlaceAutocompleteFragment.this.setText("");
            }
        });
        this.zzJj();
        return view;
    }

    public void onDestroyView() {
        this.zzbnl = null;
        this.zzbnm = null;
        this.zzbnn = null;
        super.onDestroyView();
    }

    public void setBoundsBias(@Nullable LatLngBounds latLngBounds) {
        this.zzbnp = latLngBounds;
    }

    public void setFilter(@Nullable AutocompleteFilter autocompleteFilter) {
        this.zzbnq = autocompleteFilter;
    }

    public void setText(CharSequence charSequence) {
        this.zzbnn.setText(charSequence);
        this.zzJj();
    }

    public void setHint(CharSequence charSequence) {
        this.zzbnn.setHint(charSequence);
        this.zzbnl.setContentDescription(charSequence);
    }

    public void setOnPlaceSelectedListener(PlaceSelectionListener placeSelectionListener) {
        this.zzbnr = placeSelectionListener;
    }

    private void zzJj() {
        boolean bl = !this.zzbnn.getText().toString().isEmpty();
        this.zzbnm.setVisibility(bl ? 0 : 8);
    }

    private void zzJk() {
        GoogleApiAvailability googleApiAvailability;
        int n = -1;
        try {
            googleApiAvailability = new PlaceAutocomplete.IntentBuilder(2).setBoundsBias(this.zzbnp).setFilter(this.zzbnq).zzeZ(this.zzbnn.getText().toString()).zzlc(1).build(this.getActivity());
            this.zzbno = true;
            this.startActivityForResult((Intent)googleApiAvailability, 30421);
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            n = googlePlayServicesRepairableException.getConnectionStatusCode();
            Log.e((String)"Places", (String)"Could not open autocomplete activity", (Throwable)googlePlayServicesRepairableException);
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            n = googlePlayServicesNotAvailableException.errorCode;
            Log.e((String)"Places", (String)"Could not open autocomplete activity", (Throwable)googlePlayServicesNotAvailableException);
        }
        if (n != -1) {
            googleApiAvailability = GoogleApiAvailability.getInstance();
            googleApiAvailability.showErrorDialogFragment(this.getActivity(), n, 30422);
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        this.zzbno = false;
        if (n == 30421) {
            if (n2 == -1) {
                Place place = PlaceAutocomplete.getPlace((Context)this.getActivity(), intent);
                if (this.zzbnr != null) {
                    this.zzbnr.onPlaceSelected(place);
                }
                this.setText(place.getName().toString());
            } else if (n2 == 2) {
                Status status = PlaceAutocomplete.getStatus((Context)this.getActivity(), intent);
                if (this.zzbnr != null) {
                    this.zzbnr.onError(status);
                }
            }
        }
        super.onActivityResult(n, n2, intent);
    }
}

