/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places.ui;

import android.annotation.TargetApi;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import com.google.android.gms.R;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.location.places.AutocompleteFilter;
import com.google.android.gms.location.places.Place;
import com.google.android.gms.location.places.ui.PlaceAutocomplete;
import com.google.android.gms.location.places.ui.PlaceSelectionListener;
import com.google.android.gms.location.places.ui.zzb;
import com.google.android.gms.location.places.ui.zzc;
import com.google.android.gms.location.places.ui.zzd;
import com.google.android.gms.maps.model.LatLngBounds;

@TargetApi(value=12)
public class PlaceAutocompleteFragment
extends Fragment {
    private View zzizg;
    private View zzizh;
    private EditText zzizi;
    private boolean zzizj;
    @Nullable
    private LatLngBounds zzizk;
    @Nullable
    private AutocompleteFilter zzizl;
    @Nullable
    private PlaceSelectionListener zzizm;

    public PlaceAutocompleteFragment() {
    }

    @Hide
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.place_autocomplete_fragment, viewGroup, false);
        this.zzizg = view.findViewById(R.id.place_autocomplete_search_button);
        this.zzizh = view.findViewById(R.id.place_autocomplete_clear_button);
        this.zzizi = (EditText)view.findViewById(R.id.place_autocomplete_search_input);
        zzc zzc2 = new zzc(this);
        this.zzizg.setOnClickListener((View.OnClickListener)zzc2);
        this.zzizi.setOnClickListener((View.OnClickListener)zzc2);
        this.zzizh.setOnClickListener((View.OnClickListener)new zzd(this));
        this.zzaxn();
        return view;
    }

    @Hide
    public void onDestroyView() {
        this.zzizg = null;
        this.zzizh = null;
        this.zzizi = null;
        super.onDestroyView();
    }

    public void setBoundsBias(@Nullable LatLngBounds latLngBounds) {
        this.zzizk = latLngBounds;
    }

    public void setFilter(@Nullable AutocompleteFilter autocompleteFilter) {
        this.zzizl = autocompleteFilter;
    }

    public void setText(CharSequence charSequence) {
        this.zzizi.setText(charSequence);
        this.zzaxn();
    }

    public void setHint(CharSequence charSequence) {
        this.zzizi.setHint(charSequence);
        this.zzizg.setContentDescription(charSequence);
    }

    public void setOnPlaceSelectedListener(PlaceSelectionListener placeSelectionListener) {
        this.zzizm = placeSelectionListener;
    }

    private final void zzaxn() {
        boolean bl = !this.zzizi.getText().toString().isEmpty();
        this.zzizh.setVisibility(bl ? 0 : 8);
    }

    private final void zzaxo() {
        int n = -1;
        try {
            Intent intent = ((zzb)new PlaceAutocomplete.IntentBuilder(2).setBoundsBias(this.zzizk).setFilter(this.zzizl).zzit(this.zzizi.getText().toString()).zzen(1)).build(this.getActivity());
            this.zzizj = true;
            this.startActivityForResult(intent, 30421);
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            GooglePlayServicesRepairableException googlePlayServicesRepairableException2 = googlePlayServicesRepairableException;
            n = googlePlayServicesRepairableException.getConnectionStatusCode();
            Log.e((String)"Places", (String)"Could not open autocomplete activity", (Throwable)googlePlayServicesRepairableException2);
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException2 = googlePlayServicesNotAvailableException;
            n = googlePlayServicesNotAvailableException.errorCode;
            Log.e((String)"Places", (String)"Could not open autocomplete activity", (Throwable)googlePlayServicesNotAvailableException2);
        }
        if (n != -1) {
            GoogleApiAvailability.getInstance().showErrorDialogFragment(this.getActivity(), n, 30422);
        }
    }

    @Hide
    public void onActivityResult(int n, int n2, Intent intent) {
        this.zzizj = false;
        if (n == 30421) {
            if (n2 == -1) {
                Place place = PlaceAutocomplete.getPlace((Context)this.getActivity(), intent);
                if (this.zzizm != null) {
                    this.zzizm.onPlaceSelected(place);
                }
                this.setText(place.getName().toString());
            } else if (n2 == 2) {
                Status status = PlaceAutocomplete.getStatus((Context)this.getActivity(), intent);
                if (this.zzizm != null) {
                    this.zzizm.onError(status);
                }
            }
        }
        super.onActivityResult(n, n2, intent);
    }

    static /* synthetic */ boolean zza(PlaceAutocompleteFragment placeAutocompleteFragment) {
        return placeAutocompleteFragment.zzizj;
    }

    static /* synthetic */ void zzb(PlaceAutocompleteFragment placeAutocompleteFragment) {
        placeAutocompleteFragment.zzaxo();
    }
}

