/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.places;

import com.google.android.gms.internal.places.zzfm;
import com.google.android.gms.internal.places.zzfp;
import com.google.android.gms.internal.places.zzfr;
import com.google.android.gms.internal.places.zzga;
import com.google.android.gms.internal.places.zzgi;
import com.google.android.gms.internal.places.zzgl;
import com.google.android.gms.internal.places.zzgw;
import com.google.android.gms.internal.places.zzha;
import com.google.android.gms.internal.places.zzhb;
import com.google.android.gms.internal.places.zzhh;
import com.google.android.gms.internal.places.zzhi;
import com.google.android.gms.internal.places.zzhq;
import com.google.android.gms.internal.places.zzhv;
import com.google.android.gms.internal.places.zzia;
import com.google.android.gms.internal.places.zzis;
import com.google.android.gms.internal.places.zziy;
import com.google.android.gms.internal.places.zzjy;
import com.google.android.gms.internal.places.zzke;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

final class zzfo
extends zzfm {
    private final boolean zzno;
    private final byte[] buffer;
    private int pos;
    private final int zznp;
    private int limit;
    private int tag;
    private int zznq;

    public zzfo(ByteBuffer byteBuffer, boolean bl) {
        super(null);
        this.zzno = true;
        this.buffer = byteBuffer.array();
        this.zznp = this.pos = byteBuffer.arrayOffset() + byteBuffer.position();
        this.limit = byteBuffer.arrayOffset() + byteBuffer.limit();
    }

    private final boolean zzbf() {
        return this.pos == this.limit;
    }

    @Override
    public final int zzbg() throws IOException {
        if (this.zzbf()) {
            return Integer.MAX_VALUE;
        }
        this.tag = this.zzbw();
        if (this.tag == this.zznq) {
            return Integer.MAX_VALUE;
        }
        return this.tag >>> 3;
    }

    @Override
    public final int getTag() {
        return this.tag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean zzbh() throws IOException {
        if (this.zzbf() || this.tag == this.zznq) {
            return false;
        }
        switch (this.tag & 7) {
            case 0: {
                zzfo zzfo2 = this;
                if (zzfo2.limit - zzfo2.pos >= 10) {
                    byte[] byArray = zzfo2.buffer;
                    int n = zzfo2.pos;
                    for (int i = 0; i < 10; ++i) {
                        if (byArray[n++] < 0) continue;
                        zzfo2.pos = n;
                        return true;
                    }
                } else {
                    zzfo zzfo3 = zzfo2;
                    for (int i = 0; i < 10; ++i) {
                        if (zzfo3.readByte() >= 0) return true;
                    }
                    throw zzhh.zzeb();
                }
            }
            case 1: {
                this.zzw(8);
                return true;
            }
            case 2: {
                this.zzw(this.zzbw());
                return true;
            }
            case 5: {
                this.zzw(4);
                return true;
            }
            case 3: {
                zzfo zzfo4 = this;
                int n = zzfo4.zznq;
                zzfo4.zznq = zzfo4.tag >>> 3 << 3 | 4;
                while (zzfo4.zzbg() != Integer.MAX_VALUE && zzfo4.zzbh()) {
                }
                if (zzfo4.tag != zzfo4.zznq) {
                    throw zzhh.zzef();
                }
                zzfo4.zznq = n;
                return true;
            }
        }
        throw zzhh.zzed();
    }

    @Override
    public final double readDouble() throws IOException {
        this.zzy(1);
        return Double.longBitsToDouble(this.zzca());
    }

    @Override
    public final float readFloat() throws IOException {
        this.zzy(5);
        return Float.intBitsToFloat(this.zzbz());
    }

    @Override
    public final long zzbi() throws IOException {
        this.zzy(0);
        return this.zzbx();
    }

    @Override
    public final long zzbj() throws IOException {
        this.zzy(0);
        return this.zzbx();
    }

    @Override
    public final int zzbk() throws IOException {
        this.zzy(0);
        return this.zzbw();
    }

    @Override
    public final long zzbl() throws IOException {
        this.zzy(1);
        return this.zzca();
    }

    @Override
    public final int zzbm() throws IOException {
        this.zzy(5);
        return this.zzbz();
    }

    @Override
    public final boolean zzbn() throws IOException {
        this.zzy(0);
        return this.zzbw() != 0;
    }

    @Override
    public final String readString() throws IOException {
        return this.zzc(false);
    }

    @Override
    public final String zzbo() throws IOException {
        return this.zzc(true);
    }

    private final String zzc(boolean bl) throws IOException {
        this.zzy(2);
        int n = this.zzbw();
        if (n == 0) {
            return "";
        }
        this.zzx(n);
        if (bl && !zzjy.zzh(this.buffer, this.pos, this.pos + n)) {
            throw zzhh.zzeg();
        }
        String string = new String(this.buffer, this.pos, n, zzhb.UTF_8);
        this.pos += n;
        return string;
    }

    @Override
    public final <T> T zzb(Class<T> clazz, zzgl zzgl2) throws IOException {
        this.zzy(2);
        return this.zzc(zzis.zzfc().zzg(clazz), zzgl2);
    }

    @Override
    public final <T> T zzb(zziy<T> zziy2, zzgl zzgl2) throws IOException {
        this.zzy(2);
        return this.zzc(zziy2, zzgl2);
    }

    private final <T> T zzc(zziy<T> zziy2, zzgl zzgl2) throws IOException {
        int n;
        int n2 = this.zzbw();
        this.zzx(n2);
        int n3 = this.limit;
        this.limit = n = this.pos + n2;
        try {
            T t = zziy2.newInstance();
            zziy2.zzb(t, this, zzgl2);
            zziy2.zzd(t);
            if (this.pos != n) {
                throw zzhh.zzef();
            }
            T t2 = t;
            return t2;
        }
        finally {
            this.limit = n3;
        }
    }

    @Override
    public final <T> T zzc(Class<T> clazz, zzgl zzgl2) throws IOException {
        this.zzy(3);
        return this.zze(zzis.zzfc().zzg(clazz), zzgl2);
    }

    @Override
    public final <T> T zzd(zziy<T> zziy2, zzgl zzgl2) throws IOException {
        this.zzy(3);
        return this.zze(zziy2, zzgl2);
    }

    private final <T> T zze(zziy<T> zziy2, zzgl zzgl2) throws IOException {
        int n = this.zznq;
        this.zznq = this.tag >>> 3 << 3 | 4;
        try {
            T t = zziy2.newInstance();
            zziy2.zzb(t, this, zzgl2);
            zziy2.zzd(t);
            if (this.tag != this.zznq) {
                throw zzhh.zzef();
            }
            T t2 = t;
            return t2;
        }
        finally {
            this.zznq = n;
        }
    }

    @Override
    public final zzfr zzbp() throws IOException {
        this.zzy(2);
        int n = this.zzbw();
        if (n == 0) {
            return zzfr.zznt;
        }
        this.zzx(n);
        zzfr zzfr2 = this.zzno ? zzfr.zzd(this.buffer, this.pos, n) : zzfr.zzc(this.buffer, this.pos, n);
        this.pos += n;
        return zzfr2;
    }

    @Override
    public final int zzbq() throws IOException {
        this.zzy(0);
        return this.zzbw();
    }

    @Override
    public final int zzbr() throws IOException {
        this.zzy(0);
        return this.zzbw();
    }

    @Override
    public final int zzbs() throws IOException {
        this.zzy(5);
        return this.zzbz();
    }

    @Override
    public final long zzbt() throws IOException {
        this.zzy(1);
        return this.zzca();
    }

    @Override
    public final int zzbu() throws IOException {
        this.zzy(0);
        return zzga.zzan(this.zzbw());
    }

    @Override
    public final long zzbv() throws IOException {
        this.zzy(0);
        return zzga.zzd(this.zzbx());
    }

    @Override
    public final void zze(List<Double> list) throws IOException {
        if (list instanceof zzgi) {
            zzgi zzgi2 = (zzgi)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzbw();
                    this.zzz(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzgi2.zzd(Double.longBitsToDouble(this.zzcc()));
                    }
                    break;
                }
                case 1: {
                    int n;
                    do {
                        zzgi2.zzd(this.readDouble());
                        if (this.zzbf()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzbw() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhh.zzed();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzbw();
                this.zzz(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(Double.longBitsToDouble(this.zzcc()));
                }
                break;
            }
            case 1: {
                int n;
                do {
                    list.add(this.readDouble());
                    if (this.zzbf()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzbw() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhh.zzed();
            }
        }
    }

    @Override
    public final void zzf(List<Float> list) throws IOException {
        if (list instanceof zzgw) {
            zzgw zzgw2 = (zzgw)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzbw();
                    this.zzaa(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzgw2.zzf(Float.intBitsToFloat(this.zzcb()));
                    }
                    break;
                }
                case 5: {
                    int n;
                    do {
                        zzgw2.zzf(this.readFloat());
                        if (this.zzbf()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzbw() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhh.zzed();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzbw();
                this.zzaa(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(Float.valueOf(Float.intBitsToFloat(this.zzcb())));
                }
                break;
            }
            case 5: {
                int n;
                do {
                    list.add(Float.valueOf(this.readFloat()));
                    if (this.zzbf()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzbw() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhh.zzed();
            }
        }
    }

    @Override
    public final void zzg(List<Long> list) throws IOException {
        if (list instanceof zzhv) {
            zzhv zzhv2 = (zzhv)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzbw();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzhv2.zzp(this.zzbx());
                    }
                    this.zzab(n2);
                    return;
                }
                case 0: {
                    int n;
                    do {
                        zzhv2.zzp(this.zzbi());
                        if (this.zzbf()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzbw() == this.tag);
                    this.pos = n;
                    return;
                }
            }
            throw zzhh.zzed();
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzbw();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzbx());
                }
                this.zzab(n3);
                return;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzbi());
                    if (this.zzbf()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzbw() == this.tag);
                this.pos = n;
                return;
            }
        }
        throw zzhh.zzed();
    }

    @Override
    public final void zzh(List<Long> list) throws IOException {
        if (list instanceof zzhv) {
            zzhv zzhv2 = (zzhv)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzbw();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzhv2.zzp(this.zzbx());
                    }
                    this.zzab(n2);
                    return;
                }
                case 0: {
                    int n;
                    do {
                        zzhv2.zzp(this.zzbj());
                        if (this.zzbf()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzbw() == this.tag);
                    this.pos = n;
                    return;
                }
            }
            throw zzhh.zzed();
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzbw();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzbx());
                }
                this.zzab(n3);
                return;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzbj());
                    if (this.zzbf()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzbw() == this.tag);
                this.pos = n;
                return;
            }
        }
        throw zzhh.zzed();
    }

    @Override
    public final void zzi(List<Integer> list) throws IOException {
        if (list instanceof zzha) {
            zzha zzha2 = (zzha)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzbw();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzha2.zzbe(this.zzbw());
                    }
                    this.zzab(n2);
                    return;
                }
                case 0: {
                    int n;
                    do {
                        zzha2.zzbe(this.zzbk());
                        if (this.zzbf()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzbw() == this.tag);
                    this.pos = n;
                    return;
                }
            }
            throw zzhh.zzed();
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzbw();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzbw());
                }
                this.zzab(n3);
                return;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzbk());
                    if (this.zzbf()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzbw() == this.tag);
                this.pos = n;
                return;
            }
        }
        throw zzhh.zzed();
    }

    @Override
    public final void zzj(List<Long> list) throws IOException {
        if (list instanceof zzhv) {
            zzhv zzhv2 = (zzhv)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzbw();
                    this.zzz(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzhv2.zzp(this.zzcc());
                    }
                    break;
                }
                case 1: {
                    int n;
                    do {
                        zzhv2.zzp(this.zzbl());
                        if (this.zzbf()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzbw() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhh.zzed();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzbw();
                this.zzz(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzcc());
                }
                break;
            }
            case 1: {
                int n;
                do {
                    list.add(this.zzbl());
                    if (this.zzbf()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzbw() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhh.zzed();
            }
        }
    }

    @Override
    public final void zzk(List<Integer> list) throws IOException {
        if (list instanceof zzha) {
            zzha zzha2 = (zzha)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzbw();
                    this.zzaa(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzha2.zzbe(this.zzcb());
                    }
                    break;
                }
                case 5: {
                    int n;
                    do {
                        zzha2.zzbe(this.zzbm());
                        if (this.zzbf()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzbw() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhh.zzed();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzbw();
                this.zzaa(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzcb());
                }
                break;
            }
            case 5: {
                int n;
                do {
                    list.add(this.zzbm());
                    if (this.zzbf()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzbw() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhh.zzed();
            }
        }
    }

    @Override
    public final void zzl(List<Boolean> list) throws IOException {
        if (list instanceof zzfp) {
            zzfp zzfp2 = (zzfp)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzbw();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzfp2.addBoolean(this.zzbw() != 0);
                    }
                    this.zzab(n2);
                    return;
                }
                case 0: {
                    int n;
                    do {
                        zzfp2.addBoolean(this.zzbn());
                        if (this.zzbf()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzbw() == this.tag);
                    this.pos = n;
                    return;
                }
            }
            throw zzhh.zzed();
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzbw();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzbw() != 0);
                }
                this.zzab(n3);
                return;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzbn());
                    if (this.zzbf()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzbw() == this.tag);
                this.pos = n;
                return;
            }
        }
        throw zzhh.zzed();
    }

    @Override
    public final void readStringList(List<String> list) throws IOException {
        this.zzb(list, false);
    }

    @Override
    public final void zzm(List<String> list) throws IOException {
        this.zzb(list, true);
    }

    private final void zzb(List<String> list, boolean bl) throws IOException {
        int n;
        if ((this.tag & 7) != 2) {
            throw zzhh.zzed();
        }
        if (list instanceof zzhq && !bl) {
            int n2;
            zzhq zzhq2 = (zzhq)list;
            do {
                zzhq2.zzd(this.zzbp());
                if (this.zzbf()) {
                    return;
                }
                n2 = this.pos;
            } while (this.zzbw() == this.tag);
            this.pos = n2;
            return;
        }
        do {
            list.add(this.zzc(bl));
            if (this.zzbf()) {
                return;
            }
            n = this.pos;
        } while (this.zzbw() == this.tag);
        this.pos = n;
    }

    @Override
    public final <T> void zzb(List<T> list, zziy<T> zziy2, zzgl zzgl2) throws IOException {
        int n;
        if ((this.tag & 7) != 2) {
            throw zzhh.zzed();
        }
        int n2 = this.tag;
        do {
            list.add(this.zzc(zziy2, zzgl2));
            if (this.zzbf()) {
                return;
            }
            n = this.pos;
        } while (this.zzbw() == n2);
        this.pos = n;
    }

    @Override
    public final <T> void zzc(List<T> list, zziy<T> zziy2, zzgl zzgl2) throws IOException {
        int n;
        if ((this.tag & 7) != 3) {
            throw zzhh.zzed();
        }
        int n2 = this.tag;
        do {
            list.add(this.zze(zziy2, zzgl2));
            if (this.zzbf()) {
                return;
            }
            n = this.pos;
        } while (this.zzbw() == n2);
        this.pos = n;
    }

    @Override
    public final void zzn(List<zzfr> list) throws IOException {
        int n;
        if ((this.tag & 7) != 2) {
            throw zzhh.zzed();
        }
        do {
            list.add(this.zzbp());
            if (this.zzbf()) {
                return;
            }
            n = this.pos;
        } while (this.zzbw() == this.tag);
        this.pos = n;
    }

    @Override
    public final void zzo(List<Integer> list) throws IOException {
        if (list instanceof zzha) {
            zzha zzha2 = (zzha)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzbw();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzha2.zzbe(this.zzbw());
                    }
                    break;
                }
                case 0: {
                    int n;
                    do {
                        zzha2.zzbe(this.zzbq());
                        if (this.zzbf()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzbw() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhh.zzed();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzbw();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzbw());
                }
                break;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzbq());
                    if (this.zzbf()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzbw() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhh.zzed();
            }
        }
    }

    @Override
    public final void zzp(List<Integer> list) throws IOException {
        if (list instanceof zzha) {
            zzha zzha2 = (zzha)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzbw();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzha2.zzbe(this.zzbw());
                    }
                    break;
                }
                case 0: {
                    int n;
                    do {
                        zzha2.zzbe(this.zzbr());
                        if (this.zzbf()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzbw() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhh.zzed();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzbw();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzbw());
                }
                break;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzbr());
                    if (this.zzbf()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzbw() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhh.zzed();
            }
        }
    }

    @Override
    public final void zzq(List<Integer> list) throws IOException {
        if (list instanceof zzha) {
            zzha zzha2 = (zzha)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzbw();
                    this.zzaa(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzha2.zzbe(this.zzcb());
                    }
                    break;
                }
                case 5: {
                    int n;
                    do {
                        zzha2.zzbe(this.zzbs());
                        if (this.zzbf()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzbw() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhh.zzed();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzbw();
                this.zzaa(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzcb());
                }
                break;
            }
            case 5: {
                int n;
                do {
                    list.add(this.zzbs());
                    if (this.zzbf()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzbw() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhh.zzed();
            }
        }
    }

    @Override
    public final void zzr(List<Long> list) throws IOException {
        if (list instanceof zzhv) {
            zzhv zzhv2 = (zzhv)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzbw();
                    this.zzz(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzhv2.zzp(this.zzcc());
                    }
                    break;
                }
                case 1: {
                    int n;
                    do {
                        zzhv2.zzp(this.zzbt());
                        if (this.zzbf()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzbw() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhh.zzed();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzbw();
                this.zzz(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzcc());
                }
                break;
            }
            case 1: {
                int n;
                do {
                    list.add(this.zzbt());
                    if (this.zzbf()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzbw() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhh.zzed();
            }
        }
    }

    @Override
    public final void zzs(List<Integer> list) throws IOException {
        if (list instanceof zzha) {
            zzha zzha2 = (zzha)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzbw();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzha2.zzbe(zzga.zzan(this.zzbw()));
                    }
                    break;
                }
                case 0: {
                    int n;
                    do {
                        zzha2.zzbe(this.zzbu());
                        if (this.zzbf()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzbw() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhh.zzed();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzbw();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(zzga.zzan(this.zzbw()));
                }
                break;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzbu());
                    if (this.zzbf()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzbw() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhh.zzed();
            }
        }
    }

    @Override
    public final void zzt(List<Long> list) throws IOException {
        if (list instanceof zzhv) {
            zzhv zzhv2 = (zzhv)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzbw();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzhv2.zzp(zzga.zzd(this.zzbx()));
                    }
                    break;
                }
                case 0: {
                    int n;
                    do {
                        zzhv2.zzp(this.zzbv());
                        if (this.zzbf()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzbw() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhh.zzed();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzbw();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(zzga.zzd(this.zzbx()));
                }
                break;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzbv());
                    if (this.zzbf()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzbw() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhh.zzed();
            }
        }
    }

    @Override
    public final <K, V> void zzb(Map<K, V> map, zzia<K, V> zzia2, zzgl zzgl2) throws IOException {
        int n;
        this.zzy(2);
        int n2 = this.zzbw();
        this.zzx(n2);
        int n3 = this.limit;
        this.limit = n = this.pos + n2;
        try {
            int n4;
            Object object = zzia2.zzuu;
            Object object2 = zzia2.zzss;
            block9: while ((n4 = this.zzbg()) != Integer.MAX_VALUE) {
                try {
                    switch (n4) {
                        case 1: {
                            object = this.zzb(zzia2.zzut, null, null);
                            continue block9;
                        }
                        case 2: {
                            object2 = this.zzb(zzia2.zzuv, zzia2.zzss.getClass(), zzgl2);
                            continue block9;
                        }
                    }
                    if (this.zzbh()) continue;
                    throw new zzhh("Unable to parse map entry.");
                }
                catch (zzhi zzhi2) {
                    if (this.zzbh()) continue;
                    throw new zzhh("Unable to parse map entry.");
                }
            }
            map.put(object, object2);
            return;
        }
        finally {
            this.limit = n3;
        }
    }

    private final Object zzb(zzke zzke2, Class<?> clazz, zzgl zzgl2) throws IOException {
        switch (zzke2) {
            case zzza: {
                return this.zzbn();
            }
            case zzze: {
                return this.zzbp();
            }
            case zzyt: {
                return this.readDouble();
            }
            case zzzg: {
                return this.zzbr();
            }
            case zzyz: {
                return this.zzbm();
            }
            case zzyy: {
                return this.zzbl();
            }
            case zzyu: {
                return Float.valueOf(this.readFloat());
            }
            case zzyx: {
                return this.zzbk();
            }
            case zzyv: {
                return this.zzbj();
            }
            case zzzd: {
                return this.zzb(clazz, zzgl2);
            }
            case zzzh: {
                return this.zzbs();
            }
            case zzzi: {
                return this.zzbt();
            }
            case zzzj: {
                return this.zzbu();
            }
            case zzzk: {
                return this.zzbv();
            }
            case zzzb: {
                return this.zzc(true);
            }
            case zzzf: {
                return this.zzbq();
            }
            case zzyw: {
                return this.zzbi();
            }
        }
        throw new RuntimeException("unsupported field type.");
    }

    private final int zzbw() throws IOException {
        int n;
        int n2 = this.pos;
        if (this.limit == this.pos) {
            throw zzhh.zzdz();
        }
        if ((n = this.buffer[n2++]) >= 0) {
            this.pos = n2;
            return n;
        }
        if (this.limit - n2 < 9) {
            return (int)this.zzby();
        }
        if ((n ^= this.buffer[n2++] << 7) < 0) {
            n ^= 0xFFFFFF80;
        } else if ((n ^= this.buffer[n2++] << 14) >= 0) {
            n ^= 0x3F80;
        } else if ((n ^= this.buffer[n2++] << 21) < 0) {
            n ^= 0xFFE03F80;
        } else {
            byte by = this.buffer[n2++];
            n = n ^ by << 28 ^ 0xFE03F80;
            if (by < 0 && this.buffer[n2++] < 0 && this.buffer[n2++] < 0 && this.buffer[n2++] < 0 && this.buffer[n2++] < 0 && this.buffer[n2++] < 0) {
                throw zzhh.zzeb();
            }
        }
        this.pos = n2;
        return n;
    }

    private final long zzbx() throws IOException {
        long l;
        int n;
        int n2 = this.pos;
        if (this.limit == n2) {
            throw zzhh.zzdz();
        }
        byte[] byArray = this.buffer;
        if ((n = this.buffer[n2++]) >= 0) {
            this.pos = n2;
            return n;
        }
        if (this.limit - n2 < 9) {
            return this.zzby();
        }
        if ((n ^= byArray[n2++] << 7) < 0) {
            l = n ^ 0xFFFFFF80;
        } else if ((n ^= byArray[n2++] << 14) >= 0) {
            l = n ^ 0x3F80;
        } else if ((n ^= byArray[n2++] << 21) < 0) {
            l = n ^ 0xFFE03F80;
        } else if ((l = (long)n ^ (long)byArray[n2++] << 28) >= 0L) {
            l ^= 0xFE03F80L;
        } else if ((l ^= (long)byArray[n2++] << 35) < 0L) {
            l ^= 0xFFFFFFF80FE03F80L;
        } else if ((l ^= (long)byArray[n2++] << 42) >= 0L) {
            l ^= 0x3F80FE03F80L;
        } else if ((l ^= (long)byArray[n2++] << 49) < 0L) {
            l ^= 0xFFFE03F80FE03F80L;
        } else if ((l = l ^ (long)byArray[n2++] << 56 ^ 0xFE03F80FE03F80L) < 0L && (long)byArray[n2++] < 0L) {
            throw zzhh.zzeb();
        }
        this.pos = n2;
        return l;
    }

    private final long zzby() throws IOException {
        long l = 0L;
        for (int i = 0; i < 64; i += 7) {
            byte by = this.readByte();
            l |= (long)(by & 0x7F) << i;
            if ((by & 0x80) != 0) continue;
            return l;
        }
        throw zzhh.zzeb();
    }

    private final byte readByte() throws IOException {
        if (this.pos == this.limit) {
            throw zzhh.zzdz();
        }
        return this.buffer[this.pos++];
    }

    private final int zzbz() throws IOException {
        this.zzx(4);
        return this.zzcb();
    }

    private final long zzca() throws IOException {
        this.zzx(8);
        return this.zzcc();
    }

    private final int zzcb() {
        int n = this.pos;
        byte[] byArray = this.buffer;
        this.pos = n + 4;
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    private final long zzcc() {
        int n = this.pos;
        byte[] byArray = this.buffer;
        this.pos = n + 8;
        return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 7] & 0xFFL) << 56;
    }

    private final void zzw(int n) throws IOException {
        this.zzx(n);
        this.pos += n;
    }

    private final void zzx(int n) throws IOException {
        if (n < 0 || n > this.limit - this.pos) {
            throw zzhh.zzdz();
        }
    }

    private final void zzy(int n) throws IOException {
        if ((this.tag & 7) != n) {
            throw zzhh.zzed();
        }
    }

    private final void zzz(int n) throws IOException {
        this.zzx(n);
        if ((n & 7) != 0) {
            throw zzhh.zzef();
        }
    }

    private final void zzaa(int n) throws IOException {
        this.zzx(n);
        if ((n & 3) != 0) {
            throw zzhh.zzef();
        }
    }

    private final void zzab(int n) throws IOException {
        if (this.pos != n) {
            throw zzhh.zzdz();
        }
    }
}

