/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.places;

import com.google.android.gms.internal.places.zzfh;
import com.google.android.gms.internal.places.zzfq;
import com.google.android.gms.internal.places.zzfr;
import com.google.android.gms.internal.places.zzgg;
import com.google.android.gms.internal.places.zzgh;
import com.google.android.gms.internal.places.zzhb;
import com.google.android.gms.internal.places.zzho;
import com.google.android.gms.internal.places.zzih;
import com.google.android.gms.internal.places.zziy;
import com.google.android.gms.internal.places.zzjw;
import com.google.android.gms.internal.places.zzjy;
import com.google.android.gms.internal.places.zzkb;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class zzgf
extends zzfq {
    private static final Logger logger = Logger.getLogger(zzgf.class.getName());
    private static final boolean zzoo = zzjw.zzgs();
    zzgh zzop;

    public static zzgf zzd(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        return new zzb(byArray2, 0, n);
    }

    public static zzgf zzb(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return new zzc(byteBuffer);
        }
        if (byteBuffer.isDirect() && !byteBuffer.isReadOnly()) {
            if (zzjw.zzgt()) {
                ByteBuffer byteBuffer2 = byteBuffer;
                return new zzf(byteBuffer2);
            }
            ByteBuffer byteBuffer3 = byteBuffer;
            return new zze(byteBuffer3);
        }
        throw new IllegalArgumentException("ByteBuffer is read-only");
    }

    private zzgf() {
    }

    public abstract void zzd(int var1, int var2) throws IOException;

    public abstract void zze(int var1, int var2) throws IOException;

    public abstract void zzf(int var1, int var2) throws IOException;

    public final void zzg(int n, int n2) throws IOException {
        this.zzf(n, zzgf.zzaz(n2));
    }

    public abstract void zzh(int var1, int var2) throws IOException;

    public abstract void zzb(int var1, long var2) throws IOException;

    public final void zzc(int n, long l) throws IOException {
        this.zzb(n, zzgf.zzm(l));
    }

    public abstract void zzd(int var1, long var2) throws IOException;

    public final void zzc(int n, float f) throws IOException {
        this.zzh(n, Float.floatToRawIntBits(f));
    }

    public final void zzb(int n, double d) throws IOException {
        this.zzd(n, Double.doubleToRawLongBits(d));
    }

    public abstract void zzc(int var1, boolean var2) throws IOException;

    public abstract void zzb(int var1, String var2) throws IOException;

    public abstract void zzb(int var1, zzfr var2) throws IOException;

    public abstract void zzb(int var1, zzih var2) throws IOException;

    abstract void zzb(int var1, zzih var2, zziy var3) throws IOException;

    public abstract void zzc(int var1, zzih var2) throws IOException;

    public abstract void zzc(int var1, zzfr var2) throws IOException;

    public abstract void zzao(int var1) throws IOException;

    public abstract void zzap(int var1) throws IOException;

    public final void zzaq(int n) throws IOException {
        this.zzap(zzgf.zzaz(n));
    }

    public abstract void zzar(int var1) throws IOException;

    public abstract void zze(long var1) throws IOException;

    public final void zzf(long l) throws IOException {
        this.zze(zzgf.zzm(l));
    }

    public abstract void zzg(long var1) throws IOException;

    public final void zzd(float f) throws IOException {
        this.zzar(Float.floatToRawIntBits(f));
    }

    public final void zzb(double d) throws IOException {
        this.zzg(Double.doubleToRawLongBits(d));
    }

    public final void zzd(boolean bl) throws IOException {
        this.zzb((byte)(bl ? 1 : 0));
    }

    public abstract void zzk(String var1) throws IOException;

    public abstract void zzb(zzfr var1) throws IOException;

    public abstract void zzc(zzih var1) throws IOException;

    abstract void zzb(zzih var1, zziy var2) throws IOException;

    public abstract void zzb(byte var1) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public static int zzi(int n, int n2) {
        return zzgf.zzas(n) + zzgf.zzat(n2);
    }

    public static int zzj(int n, int n2) {
        return zzgf.zzas(n) + zzgf.zzau(n2);
    }

    public static int zzk(int n, int n2) {
        return zzgf.zzas(n) + zzgf.zzau(zzgf.zzaz(n2));
    }

    public static int zzl(int n, int n2) {
        return zzgf.zzas(n) + 4;
    }

    public static int zzm(int n, int n2) {
        return zzgf.zzas(n) + 4;
    }

    public static int zze(int n, long l) {
        return zzgf.zzas(n) + zzgf.zzi(l);
    }

    public static int zzf(int n, long l) {
        return zzgf.zzas(n) + zzgf.zzi(l);
    }

    public static int zzg(int n, long l) {
        return zzgf.zzas(n) + zzgf.zzi(zzgf.zzm(l));
    }

    public static int zzh(int n, long l) {
        return zzgf.zzas(n) + 8;
    }

    public static int zzi(int n, long l) {
        return zzgf.zzas(n) + 8;
    }

    public static int zzd(int n, float f) {
        return zzgf.zzas(n) + 4;
    }

    public static int zzc(int n, double d) {
        return zzgf.zzas(n) + 8;
    }

    public static int zzd(int n, boolean bl) {
        return zzgf.zzas(n) + 1;
    }

    public static int zzn(int n, int n2) {
        return zzgf.zzas(n) + zzgf.zzat(n2);
    }

    public static int zzc(int n, String string) {
        return zzgf.zzas(n) + zzgf.zzl(string);
    }

    public static int zzd(int n, zzfr zzfr2) {
        int n2 = zzfr2.size();
        return zzgf.zzas(n) + (zzgf.zzau(n2) + n2);
    }

    public static int zzb(int n, zzho zzho2) {
        int n2 = zzho2.zzdg();
        return zzgf.zzas(n) + (zzgf.zzau(n2) + n2);
    }

    public static int zzd(int n, zzih zzih2) {
        return zzgf.zzas(n) + zzgf.zzd(zzih2);
    }

    static int zzc(int n, zzih zzih2, zziy zziy2) {
        return zzgf.zzas(n) + zzgf.zzc(zzih2, zziy2);
    }

    public static int zze(int n, zzih zzih2) {
        return (zzgf.zzas(1) << 1) + zzgf.zzj(2, n) + zzgf.zzd(3, zzih2);
    }

    public static int zze(int n, zzfr zzfr2) {
        return (zzgf.zzas(1) << 1) + zzgf.zzj(2, n) + zzgf.zzd(3, zzfr2);
    }

    public static int zzc(int n, zzho zzho2) {
        return (zzgf.zzas(1) << 1) + zzgf.zzj(2, n) + zzgf.zzb(3, zzho2);
    }

    public static int zzas(int n) {
        return zzgf.zzau(n << 3);
    }

    public static int zzat(int n) {
        if (n >= 0) {
            return zzgf.zzau(n);
        }
        return 10;
    }

    public static int zzau(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int zzav(int n) {
        return zzgf.zzau(zzgf.zzaz(n));
    }

    public static int zzaw(int n) {
        return 4;
    }

    public static int zzax(int n) {
        return 4;
    }

    public static int zzh(long l) {
        return zzgf.zzi(l);
    }

    public static int zzi(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l < 0L) {
            return 10;
        }
        int n = 2;
        if ((l & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            l >>>= 28;
        }
        if ((l & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            l >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static int zzj(long l) {
        return zzgf.zzi(zzgf.zzm(l));
    }

    public static int zzk(long l) {
        return 8;
    }

    public static int zzl(long l) {
        return 8;
    }

    public static int zze(float f) {
        return 4;
    }

    public static int zzc(double d) {
        return 8;
    }

    public static int zze(boolean bl) {
        return 1;
    }

    public static int zzay(int n) {
        return zzgf.zzat(n);
    }

    public static int zzl(String string) {
        int n;
        try {
            n = zzjy.zzb(string);
        }
        catch (zzkb zzkb2) {
            n = string.getBytes(zzhb.UTF_8).length;
        }
        int n2 = n;
        return zzgf.zzau(n2) + n2;
    }

    public static int zzb(zzho zzho2) {
        int n = zzho2.zzdg();
        return zzgf.zzau(n) + n;
    }

    public static int zzc(zzfr zzfr2) {
        int n = zzfr2.size();
        return zzgf.zzau(n) + n;
    }

    public static int zze(byte[] byArray) {
        int n = byArray.length;
        return zzgf.zzau(n) + n;
    }

    public static int zzd(zzih zzih2) {
        int n = zzih2.zzdg();
        return zzgf.zzau(n) + n;
    }

    static int zzc(zzih zzih2, zziy zziy2) {
        zziy zziy3 = zziy2;
        zzfh zzfh2 = (zzfh)zzih2;
        int n = zzfh2.zzay();
        if (n == -1) {
            n = zziy3.zzn(zzfh2);
            zzfh2.zzv(n);
        }
        int n2 = n;
        return zzgf.zzau(n2) + n2;
    }

    private static int zzaz(int n) {
        return n << 1 ^ n >> 31;
    }

    private static long zzm(long l) {
        return l << 1 ^ l >> 63;
    }

    public abstract void flush() throws IOException;

    public abstract int zzcs();

    abstract void zzg(byte[] var1, int var2, int var3) throws IOException;

    final void zzb(String string, zzkb zzkb2) throws IOException {
        logger.logp(Level.WARNING, "com.google.protobuf.CodedOutputStream", "inefficientWriteStringNoTag", "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", zzkb2);
        byte[] byArray = string.getBytes(zzhb.UTF_8);
        try {
            this.zzap(byArray.length);
            this.zzb(byArray, 0, byArray.length);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new zzd(indexOutOfBoundsException);
        }
        catch (zzd zzd2) {
            throw zzd2;
        }
    }

    @Deprecated
    static int zzd(int n, zzih zzih2, zziy zziy2) {
        zziy zziy3;
        int n2 = zzgf.zzas(n) << 1;
        zziy zziy4 = zziy3 = zziy2;
        zzfh zzfh2 = (zzfh)zzih2;
        int n3 = zzfh2.zzay();
        if (n3 == -1) {
            n3 = zziy4.zzn(zzfh2);
            zzfh2.zzv(n3);
        }
        return n2 + n3;
    }

    @Deprecated
    public static int zze(zzih zzih2) {
        return zzih2.zzdg();
    }

    @Deprecated
    public static int zzba(int n) {
        return zzgf.zzau(n);
    }

    /* synthetic */ zzgf(zzgg zzgg2) {
        this();
    }

    static final class zzf
    extends zzgf {
        private final ByteBuffer zzos;
        private final ByteBuffer zzot;
        private final long zzou;
        private final long zzov;
        private final long zzow;
        private final long zzox;
        private long zzoy;

        zzf(ByteBuffer byteBuffer) {
            super(null);
            this.zzos = byteBuffer;
            this.zzot = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzou = zzjw.zzc(byteBuffer);
            this.zzov = this.zzou + (long)byteBuffer.position();
            this.zzow = this.zzou + (long)byteBuffer.limit();
            this.zzox = this.zzow - 10L;
            this.zzoy = this.zzov;
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzgf)this).zzap(n << 3 | n3);
        }

        @Override
        public final void zze(int n, int n2) throws IOException {
            ((zzgf)this).zzd(n, 0);
            ((zzgf)this).zzao(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzgf)this).zzd(n, 0);
            ((zzgf)this).zzap(n2);
        }

        @Override
        public final void zzh(int n, int n2) throws IOException {
            ((zzgf)this).zzd(n, 5);
            ((zzgf)this).zzar(n2);
        }

        @Override
        public final void zzb(int n, long l) throws IOException {
            ((zzgf)this).zzd(n, 0);
            ((zzgf)this).zze(l);
        }

        @Override
        public final void zzd(int n, long l) throws IOException {
            ((zzgf)this).zzd(n, 1);
            ((zzgf)this).zzg(l);
        }

        @Override
        public final void zzc(int n, boolean bl) throws IOException {
            ((zzgf)this).zzd(n, 0);
            ((zzgf)this).zzb((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzb(int n, String string) throws IOException {
            ((zzgf)this).zzd(n, 2);
            ((zzgf)this).zzk(string);
        }

        @Override
        public final void zzb(int n, zzfr zzfr2) throws IOException {
            ((zzgf)this).zzd(n, 2);
            ((zzgf)this).zzb(zzfr2);
        }

        @Override
        public final void zzb(int n, zzih zzih2) throws IOException {
            ((zzgf)this).zzd(n, 2);
            ((zzgf)this).zzc(zzih2);
        }

        @Override
        final void zzb(int n, zzih zzih2, zziy zziy2) throws IOException {
            ((zzgf)this).zzd(n, 2);
            ((zzgf)this).zzb(zzih2, zziy2);
        }

        @Override
        public final void zzc(int n, zzih zzih2) throws IOException {
            ((zzgf)this).zzd(1, 3);
            ((zzgf)this).zzf(2, n);
            ((zzgf)this).zzb(3, zzih2);
            ((zzgf)this).zzd(1, 4);
        }

        @Override
        public final void zzc(int n, zzfr zzfr2) throws IOException {
            ((zzgf)this).zzd(1, 3);
            ((zzgf)this).zzf(2, n);
            ((zzgf)this).zzb(3, zzfr2);
            ((zzgf)this).zzd(1, 4);
        }

        @Override
        public final void zzc(zzih zzih2) throws IOException {
            ((zzgf)this).zzap(zzih2.zzdg());
            zzih2.zzc(this);
        }

        @Override
        final void zzb(zzih zzih2, zziy zziy2) throws IOException {
            zziy zziy3 = zziy2;
            zzfh zzfh2 = (zzfh)zzih2;
            int n = zzfh2.zzay();
            if (n == -1) {
                n = zziy3.zzn(zzfh2);
                zzfh2.zzv(n);
            }
            ((zzgf)this).zzap(n);
            zziy2.zzb(zzih2, this.zzop);
        }

        @Override
        public final void zzb(byte by) throws IOException {
            if (this.zzoy >= this.zzow) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.zzoy, this.zzow, 1));
            }
            zzjw.zzb(this.zzoy++, by);
        }

        @Override
        public final void zzb(zzfr zzfr2) throws IOException {
            ((zzgf)this).zzap(zzfr2.size());
            zzfr2.zzb(this);
        }

        @Override
        public final void zzg(byte[] byArray, int n, int n2) throws IOException {
            ((zzgf)this).zzap(n2);
            ((zzgf)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzao(int n) throws IOException {
            if (n >= 0) {
                ((zzgf)this).zzap(n);
                return;
            }
            ((zzgf)this).zze(n);
        }

        @Override
        public final void zzap(int n) throws IOException {
            if (this.zzoy <= this.zzox) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzjw.zzb(this.zzoy++, (byte)n);
                        return;
                    }
                    zzjw.zzb(this.zzoy++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            while (this.zzoy < this.zzow) {
                if ((n & 0xFFFFFF80) == 0) {
                    zzjw.zzb(this.zzoy++, (byte)n);
                    return;
                }
                zzjw.zzb(this.zzoy++, (byte)(n & 0x7F | 0x80));
                n >>>= 7;
            }
            throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.zzoy, this.zzow, 1));
        }

        @Override
        public final void zzar(int n) throws IOException {
            long l = this.zzoy;
            zzf zzf2 = this;
            this.zzot.putInt((int)(l - zzf2.zzou), n);
            this.zzoy += 4L;
        }

        @Override
        public final void zze(long l) throws IOException {
            if (this.zzoy <= this.zzox) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzjw.zzb(this.zzoy++, (byte)l);
                        return;
                    }
                    zzjw.zzb(this.zzoy++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            while (this.zzoy < this.zzow) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    zzjw.zzb(this.zzoy++, (byte)l);
                    return;
                }
                zzjw.zzb(this.zzoy++, (byte)((int)l & 0x7F | 0x80));
                l >>>= 7;
            }
            throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.zzoy, this.zzow, 1));
        }

        @Override
        public final void zzg(long l) throws IOException {
            long l2 = this.zzoy;
            zzf zzf2 = this;
            this.zzot.putLong((int)(l2 - zzf2.zzou), l);
            this.zzoy += 8L;
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null || n < 0 || n2 < 0 || byArray.length - n2 < n || this.zzow - (long)n2 < this.zzoy) {
                if (byArray == null) {
                    throw new NullPointerException("value");
                }
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.zzoy, this.zzow, n2));
            }
            zzjw.zzb(byArray, n, this.zzoy, n2);
            this.zzoy += (long)n2;
        }

        @Override
        public final void zzb(byte[] byArray, int n, int n2) throws IOException {
            ((zzgf)this).write(byArray, n, n2);
        }

        @Override
        public final void zzk(String string) throws IOException {
            long l = this.zzoy;
            try {
                int n = zzf.zzau(string.length() * 3);
                int n2 = zzf.zzau(string.length());
                if (n2 == n) {
                    long l2 = this.zzoy;
                    zzf zzf2 = this;
                    int n3 = (int)(l2 - zzf2.zzou) + n2;
                    this.zzot.position(n3);
                    zzjy.zzb(string, this.zzot);
                    int n4 = this.zzot.position() - n3;
                    ((zzgf)this).zzap(n4);
                    this.zzoy += (long)n4;
                    return;
                }
                int n5 = zzjy.zzb(string);
                ((zzgf)this).zzap(n5);
                this.zzn(this.zzoy);
                zzjy.zzb(string, this.zzot);
                this.zzoy += (long)n5;
                return;
            }
            catch (zzkb zzkb2) {
                this.zzoy = l;
                this.zzn(this.zzoy);
                this.zzb(string, zzkb2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzd(illegalArgumentException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(indexOutOfBoundsException);
            }
        }

        @Override
        public final void flush() {
            long l = this.zzoy;
            zzf zzf2 = this;
            this.zzos.position((int)(l - zzf2.zzou));
        }

        @Override
        public final int zzcs() {
            return (int)(this.zzow - this.zzoy);
        }

        private final void zzn(long l) {
            long l2 = l;
            zzf zzf2 = this;
            this.zzot.position((int)(l2 - zzf2.zzou));
        }
    }

    static final class zze
    extends zzgf {
        private final ByteBuffer zzos;
        private final ByteBuffer zzot;
        private final int zzor;

        zze(ByteBuffer byteBuffer) {
            super(null);
            this.zzos = byteBuffer;
            this.zzot = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzor = byteBuffer.position();
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzgf)this).zzap(n << 3 | n3);
        }

        @Override
        public final void zze(int n, int n2) throws IOException {
            ((zzgf)this).zzd(n, 0);
            ((zzgf)this).zzao(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzgf)this).zzd(n, 0);
            ((zzgf)this).zzap(n2);
        }

        @Override
        public final void zzh(int n, int n2) throws IOException {
            ((zzgf)this).zzd(n, 5);
            ((zzgf)this).zzar(n2);
        }

        @Override
        public final void zzb(int n, long l) throws IOException {
            ((zzgf)this).zzd(n, 0);
            ((zzgf)this).zze(l);
        }

        @Override
        public final void zzd(int n, long l) throws IOException {
            ((zzgf)this).zzd(n, 1);
            ((zzgf)this).zzg(l);
        }

        @Override
        public final void zzc(int n, boolean bl) throws IOException {
            ((zzgf)this).zzd(n, 0);
            ((zzgf)this).zzb((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzb(int n, String string) throws IOException {
            ((zzgf)this).zzd(n, 2);
            ((zzgf)this).zzk(string);
        }

        @Override
        public final void zzb(int n, zzfr zzfr2) throws IOException {
            ((zzgf)this).zzd(n, 2);
            ((zzgf)this).zzb(zzfr2);
        }

        @Override
        public final void zzb(int n, zzih zzih2) throws IOException {
            ((zzgf)this).zzd(n, 2);
            ((zzgf)this).zzc(zzih2);
        }

        @Override
        final void zzb(int n, zzih zzih2, zziy zziy2) throws IOException {
            ((zzgf)this).zzd(n, 2);
            ((zzgf)this).zzb(zzih2, zziy2);
        }

        @Override
        public final void zzc(int n, zzih zzih2) throws IOException {
            ((zzgf)this).zzd(1, 3);
            ((zzgf)this).zzf(2, n);
            ((zzgf)this).zzb(3, zzih2);
            ((zzgf)this).zzd(1, 4);
        }

        @Override
        public final void zzc(int n, zzfr zzfr2) throws IOException {
            ((zzgf)this).zzd(1, 3);
            ((zzgf)this).zzf(2, n);
            ((zzgf)this).zzb(3, zzfr2);
            ((zzgf)this).zzd(1, 4);
        }

        @Override
        public final void zzc(zzih zzih2) throws IOException {
            ((zzgf)this).zzap(zzih2.zzdg());
            zzih2.zzc(this);
        }

        @Override
        final void zzb(zzih zzih2, zziy zziy2) throws IOException {
            zziy zziy3 = zziy2;
            zzfh zzfh2 = (zzfh)zzih2;
            int n = zzfh2.zzay();
            if (n == -1) {
                n = zziy3.zzn(zzfh2);
                zzfh2.zzv(n);
            }
            ((zzgf)this).zzap(n);
            zziy2.zzb(zzih2, this.zzop);
        }

        @Override
        public final void zzb(byte by) throws IOException {
            try {
                this.zzot.put(by);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void zzb(zzfr zzfr2) throws IOException {
            ((zzgf)this).zzap(zzfr2.size());
            zzfr2.zzb(this);
        }

        @Override
        public final void zzg(byte[] byArray, int n, int n2) throws IOException {
            ((zzgf)this).zzap(n2);
            ((zzgf)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzao(int n) throws IOException {
            if (n >= 0) {
                ((zzgf)this).zzap(n);
                return;
            }
            ((zzgf)this).zze(n);
        }

        @Override
        public final void zzap(int n) throws IOException {
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.zzot.put((byte)n);
                        return;
                    }
                    this.zzot.put((byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void zzar(int n) throws IOException {
            try {
                this.zzot.putInt(n);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void zze(long l) throws IOException {
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.zzot.put((byte)l);
                        return;
                    }
                    this.zzot.put((byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void zzg(long l) throws IOException {
            try {
                this.zzot.putLong(l);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.zzot.put(byArray, n, n2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(indexOutOfBoundsException);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void zzb(byte[] byArray, int n, int n2) throws IOException {
            ((zzgf)this).write(byArray, n, n2);
        }

        @Override
        public final void zzk(String string) throws IOException {
            int n = this.zzot.position();
            try {
                int n2 = zze.zzau(string.length() * 3);
                int n3 = zze.zzau(string.length());
                if (n3 == n2) {
                    int n4 = this.zzot.position() + n3;
                    this.zzot.position(n4);
                    this.zzm(string);
                    int n5 = this.zzot.position();
                    this.zzot.position(n);
                    ((zzgf)this).zzap(n5 - n4);
                    this.zzot.position(n5);
                    return;
                }
                int n6 = zzjy.zzb(string);
                ((zzgf)this).zzap(n6);
                this.zzm(string);
                return;
            }
            catch (zzkb zzkb2) {
                this.zzot.position(n);
                this.zzb(string, zzkb2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzd(illegalArgumentException);
            }
        }

        @Override
        public final void flush() {
            this.zzos.position(this.zzot.position());
        }

        @Override
        public final int zzcs() {
            return this.zzot.remaining();
        }

        private final void zzm(String string) throws IOException {
            try {
                zzjy.zzb(string, this.zzot);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(indexOutOfBoundsException);
            }
        }
    }

    static final class zzc
    extends zzb {
        private final ByteBuffer zzoq;
        private int zzor;

        zzc(ByteBuffer byteBuffer) {
            super(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            this.zzoq = byteBuffer;
            this.zzor = byteBuffer.position();
        }

        @Override
        public final void flush() {
            this.zzoq.position(this.zzor + this.zzcu());
        }
    }

    static class zzb
    extends zzgf {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        zzb(byte[] byArray, int n, int n2) {
            super(null);
            if (byArray == null) {
                throw new NullPointerException("buffer");
            }
            if ((n | n2 | byArray.length - (n + n2)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", byArray.length, n, n2));
            }
            this.buffer = byArray;
            this.offset = n;
            this.position = n;
            this.limit = n + n2;
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzgf)this).zzap(n << 3 | n3);
        }

        @Override
        public final void zze(int n, int n2) throws IOException {
            ((zzgf)this).zzd(n, 0);
            ((zzgf)this).zzao(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzgf)this).zzd(n, 0);
            ((zzgf)this).zzap(n2);
        }

        @Override
        public final void zzh(int n, int n2) throws IOException {
            ((zzgf)this).zzd(n, 5);
            ((zzgf)this).zzar(n2);
        }

        @Override
        public final void zzb(int n, long l) throws IOException {
            ((zzgf)this).zzd(n, 0);
            ((zzgf)this).zze(l);
        }

        @Override
        public final void zzd(int n, long l) throws IOException {
            ((zzgf)this).zzd(n, 1);
            ((zzgf)this).zzg(l);
        }

        @Override
        public final void zzc(int n, boolean bl) throws IOException {
            ((zzgf)this).zzd(n, 0);
            ((zzgf)this).zzb((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzb(int n, String string) throws IOException {
            ((zzgf)this).zzd(n, 2);
            ((zzgf)this).zzk(string);
        }

        @Override
        public final void zzb(int n, zzfr zzfr2) throws IOException {
            ((zzgf)this).zzd(n, 2);
            ((zzgf)this).zzb(zzfr2);
        }

        @Override
        public final void zzb(zzfr zzfr2) throws IOException {
            ((zzgf)this).zzap(zzfr2.size());
            zzfr2.zzb(this);
        }

        @Override
        public final void zzg(byte[] byArray, int n, int n2) throws IOException {
            ((zzgf)this).zzap(n2);
            ((zzgf)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzb(int n, zzih zzih2) throws IOException {
            ((zzgf)this).zzd(n, 2);
            ((zzgf)this).zzc(zzih2);
        }

        @Override
        final void zzb(int n, zzih zzih2, zziy zziy2) throws IOException {
            ((zzgf)this).zzd(n, 2);
            zziy zziy3 = zziy2;
            zzfh zzfh2 = (zzfh)zzih2;
            int n2 = zzfh2.zzay();
            if (n2 == -1) {
                n2 = zziy3.zzn(zzfh2);
                zzfh2.zzv(n2);
            }
            ((zzgf)this).zzap(n2);
            zziy2.zzb(zzih2, this.zzop);
        }

        @Override
        public final void zzc(int n, zzih zzih2) throws IOException {
            ((zzgf)this).zzd(1, 3);
            ((zzgf)this).zzf(2, n);
            ((zzgf)this).zzb(3, zzih2);
            ((zzgf)this).zzd(1, 4);
        }

        @Override
        public final void zzc(int n, zzfr zzfr2) throws IOException {
            ((zzgf)this).zzd(1, 3);
            ((zzgf)this).zzf(2, n);
            ((zzgf)this).zzb(3, zzfr2);
            ((zzgf)this).zzd(1, 4);
        }

        @Override
        public final void zzc(zzih zzih2) throws IOException {
            ((zzgf)this).zzap(zzih2.zzdg());
            zzih2.zzc(this);
        }

        @Override
        final void zzb(zzih zzih2, zziy zziy2) throws IOException {
            zziy zziy3 = zziy2;
            zzfh zzfh2 = (zzfh)zzih2;
            int n = zzfh2.zzay();
            if (n == -1) {
                n = zziy3.zzn(zzfh2);
                zzfh2.zzv(n);
            }
            ((zzgf)this).zzap(n);
            zziy2.zzb(zzih2, this.zzop);
        }

        @Override
        public final void zzb(byte by) throws IOException {
            try {
                this.buffer[this.position++] = by;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzao(int n) throws IOException {
            if (n >= 0) {
                ((zzgf)this).zzap(n);
                return;
            }
            ((zzgf)this).zze(n);
        }

        @Override
        public final void zzap(int n) throws IOException {
            if (zzoo && ((zzgf)this).zzcs() >= 10) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzjw.zzb(this.buffer, (long)this.position++, (byte)n);
                        return;
                    }
                    zzjw.zzb(this.buffer, (long)this.position++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)n;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                    n >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzar(int n) throws IOException {
            try {
                this.buffer[this.position++] = (byte)n;
                this.buffer[this.position++] = (byte)(n >> 8);
                this.buffer[this.position++] = (byte)(n >> 16);
                this.buffer[this.position++] = n >> 24;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zze(long l) throws IOException {
            if (zzoo && ((zzgf)this).zzcs() >= 10) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzjw.zzb(this.buffer, (long)this.position++, (byte)l);
                        return;
                    }
                    zzjw.zzb(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)l;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                    l >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzg(long l) throws IOException {
            try {
                this.buffer[this.position++] = (byte)l;
                this.buffer[this.position++] = (byte)(l >> 8);
                this.buffer[this.position++] = (byte)(l >> 16);
                this.buffer[this.position++] = (byte)(l >> 24);
                this.buffer[this.position++] = (byte)(l >> 32);
                this.buffer[this.position++] = (byte)(l >> 40);
                this.buffer[this.position++] = (byte)(l >> 48);
                this.buffer[this.position++] = (byte)(l >> 56);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzb(byte[] byArray, int n, int n2) throws IOException {
            ((zzgf)this).write(byArray, n, n2);
        }

        @Override
        public final void zzk(String string) throws IOException {
            int n = this.position;
            try {
                int n2 = zzb.zzau(string.length() * 3);
                int n3 = zzb.zzau(string.length());
                if (n3 == n2) {
                    this.position = n + n3;
                    int n4 = zzjy.zzb(string, this.buffer, this.position, ((zzgf)this).zzcs());
                    this.position = n;
                    int n5 = n4 - n - n3;
                    ((zzgf)this).zzap(n5);
                    this.position = n4;
                    return;
                }
                int n6 = zzjy.zzb(string);
                ((zzgf)this).zzap(n6);
                this.position = zzjy.zzb(string, this.buffer, this.position, ((zzgf)this).zzcs());
                return;
            }
            catch (zzkb zzkb2) {
                this.position = n;
                this.zzb(string, zzkb2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public final int zzcs() {
            return this.limit - this.position;
        }

        public final int zzcu() {
            return this.position - this.offset;
        }
    }

    public static final class zzd
    extends IOException {
        zzd() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }

        zzd(String string) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        zzd(Throwable throwable) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.", throwable);
        }

        zzd(String string, Throwable throwable) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2), throwable);
        }
    }
}

